/* ---------------------------------------------------------- 
%   (C)1992 Institute for New Generation Computer Technology 
%       (Read COPYRIGHT for detailed information.) 
----------------------------------------------------------- */
#include <stdio.h>
#include "node.h"
#include "group.h"
#include "hash.h"
#include "symbol.h"

extern group* root_obj;
extern node* selected_node;

header* create_node(int id,header* parent,header* next,header* prev)
{
  node* nnp;
  nnp = new node[1];
  nnp->Parent(parent);
  nnp->Next(next);
  nnp->Previous(prev);
  nnp->Id(id);
  nnp->Value((header*)0);
  nnp->Split();
  return (header*)nnp;
}

group::group() 
{
#ifdef DEBUG
  fprintf(stderr,"this (%x) group::group()\n",(unsigned int)this);
#endif 
  type = GROUP_OBJ;
  sym_id = sym_group;
  no_of_obj = 0;
  parent = (header*)0;
  first_object = (header*)0;
  last_object = (header*)0;
  before = (header*)0;
}

 void group::Close()
{
#ifdef DEBUG
  fprintf(stderr," this (%x) group::Close()\n",(unsigned int)this);
#endif 
  ref_c--;
  if (ref_c == 0) {
    for (node* wp = (node*)first_object;wp != (node*)0;) {
      node* dp;
      dp = wp;
      wp = (node*)wp->Next();
      dp->Close();
    }
    free(this);
  }
}

header*  group::Search_and_Create(char* n)
{
#ifdef DEBUG
  fprintf(stderr," this (%x) header* group::Search_and_Create(char* %s)\n",
	  (unsigned int)this,n);
#endif 
  return  Search_and_Create(hash_table.wordId(n));
}

header*  group::Search_and_Create(int id)
{
#ifdef DEBUG
  fprintf(stderr," this (%x) header* group::Search_and_Create(int %d(%s))\n",
	  (unsigned int)this,id,hash_table.idWord(id));
#endif 
  node* first;
  node* last;
  node* nnp;
  nnp = (node*)0;
  first = (node*)first_object;
  last = (node*)last_object;
  if (before != (header*)0) {
    int bid = ((node*)before)->Id();
    if (bid == id) return before;
  }
  if (first_object == (header*)0){
    nnp = (node*)create_node(id,(header*)this,(header*)0,(header*)0);
    first_object = (header*)nnp;
    last_object = (header*)nnp;
    no_of_obj++;
    before = (header*)nnp;
    return before;
#ifdef DEBUG
    fprintf(stderr,"ret (0x%x)\n",(unsigned int)nnp);
#endif
  }
  int firstid = first->Id();
  int lastid = last->Id();
  if (firstid < id){
    nnp = (node*)create_node(id,(header*)this,first,(header*)0);
    first->Previous((header*)nnp);
    first_object = (header*)nnp;
    no_of_obj++;
    before = (header*)nnp;
    return before;
#ifdef DEBUG
    fprintf(stderr,"ret (0x%x)\n",(unsigned int)nnp);
#endif
  }
  if (lastid > id){
    nnp = (node*)create_node(id,(header*)this,(header*)0,last_object);
    last->Next(nnp);
    last_object = (header*)nnp;
    no_of_obj++;
#ifdef DEBUG
    fprintf(stderr,"ret (0x%x)\n",(unsigned int)nnp);
#endif
    before = (header*)nnp;
    return before;
  }
  node* wp;
  int center = (lastid+firstid)/2;
  int cid = 0;
  if (center > id) {
    wp = last;
    for (;wp != (node*)0;wp = (node*)(wp->Previous())) {
      cid = wp->Id();
      if (cid >= id) break;
    }
    nnp = wp;
    if (cid > id){
      node* next = (node*)(wp->Next());
      nnp = (node*)create_node(id,(header*)this,(header*)next,(header*)wp);
      wp->Next(nnp);
      if (next != (node*)0) {
	next->Previous(nnp);
      }
      no_of_obj++;
    }
  }else{
    wp = first;
    for (;wp != (node*)0;wp = (node*)(wp->Next())) {
      cid = wp->Id();
      if (cid <= id) break;
    }
    nnp = wp;
    if (cid < id) {
      node* prev = (node*)(wp->Previous());
      nnp = (node*)create_node(id,(header*)this,(header*)wp,(header*)prev);
      wp->Previous(nnp);
      if (prev != (node*)0) {
	prev->Next(nnp);
      }
      no_of_obj++;
    }
  }
#ifdef DEBUG
  fprintf(stderr,"ret (0x%x)\n",(unsigned int)nnp);
#endif
  before = (header*)nnp;
  return before;
}

header*  group::First()
{
#ifdef DEBUG
  fprintf(stderr," this (%x) header* group::First()\n",(unsigned int)this);
#endif 
  return first_object;
}

header*  group::Last()
{
#ifdef DEBUG
  fprintf(stderr," this (%x) header* group::Last()\n",(unsigned int)this);
#endif 
  return last_object;
}

header*  group::Parent()
{
#ifdef DEBUG
  fprintf(stderr," this (%x) header* group::Parent()\n",(unsigned int)this);
#endif 
  return parent;
}

void  group::First(header* f)
{
#ifdef DEBUG
  fprintf(stderr," this (%x) void group::First(header* %x)\n",(unsigned int)this,(unsigned int)f);
#endif 
  first_object = f;
}

void  group::Last(header* l)
{
#ifdef DEBUG
  fprintf(stderr," this (%x) void group::Last(header* %x)\n",(unsigned int)this,(unsigned int)l);
#endif 
  last_object = l;
}

void  group::Parent(header* p)
{
#ifdef DEBUG
  fprintf(stderr," this (%x) void group::Parent(header* %x)\n",(unsigned int)this,(unsigned int)p);
#endif
  parent = p;
}

int     group::NoOfObjects()
{
#ifdef DEBUG
  fprintf(stderr," this (%x) int group::NoOfObjects()\n",(unsigned int)this);
#endif
  return no_of_obj;
#ifdef DEBUG
  fprintf(stderr,"return %d\n",no_of_obj);
#endif
}

void  group::Copy(header* obj)
// {}
// 롼ԥ󥰤ƤΡɥ֥ȤΥԡԤʤ
// {}
{
#ifdef DEBUG
  fprintf(stderr," this (%x) void group::Copy(header* %x)\n",(unsigned int)this,(unsigned int)obj);
#endif
  object_location->Split();
  object_rotation->Split();
  first_object = NULL;
  last_object =  NULL;
  before = NULL;
  node* wp = (node*)((group*)obj)->First();
  for (;wp !=(node*)0;wp = (node*)(wp->Next())) {
    if (first_object == (header*)0) {
      first_object = ::copy_object((header*)wp);
      last_object = first_object;
      ((node*)last_object)->Parent(this);
      last_object->Next((header*)0);
    } else{
      last_object->Next((header*)(::copy_object(wp)));
      last_object = last_object->Next();
      ((node*)last_object)->Parent(this);
      last_object->Next(NULL);
    }
  }
}

void group::DrawStateAll(DrawStatus t)
/* Execute routines for drawall,wireall,hideall */
{
  dstate = t;
  node* wp;
  for (wp = (node*)first_object;wp != NULL;wp = (node*)(wp->Next())) {
    header* w;
    w = wp->Value();
    if(w == NULL) break;                         /* A safety device */
    if (wp->IsGroup()) ((group*)w)->DrawStateAll(t);
    else w->DrawState(t);
  }
}

 void  group::Draw()
/* Draw routine for group object */
{
#ifdef DEBUG    
  fprintf(stderr," this (%x)  void group::Draw()\n",(unsigned int)this);
#endif
#ifndef _DISABLE_GL_
  PushScale();
  PushTranslation();
  PushRotation();
  node* wp;
  wp = (node*)first_object;
  for (;wp != (node*)0;wp = (node*)(wp->Next())) {
    header* node_value = wp->Value();
    if (node_value == NULL) continue; 
#ifdef DEBUG    
    fprintf(stderr,"Draw(node[%s])",wp->Name());
    header* wp_v;
    wp_v = wp->Value();
    if (wp_v != (header*)0) {
      wp_v->Print();
    }else{
      fprintf(stderr," not initialize");
    }
    fprintf(stderr,"\n");
#endif
    if (dstate == ObjectHidding) {
      if (parent == selected_node) break;
      if ((wp->IsGroup()) == TRUE ) node_value->Draw();
      else if (wp == selected_node) node_value->Draw();
    }else
      node_value->Draw();
  }
  PopRotation();
  PopTranslation();
  PopScale();
#endif
}

void group::Scale(double s)
{
  scale = s;
}

