/* ---------------------------------------------------------- 
%   (C)1992 Institute for New Generation Computer Technology 
%       (Read COPYRIGHT for detailed information.) 
----------------------------------------------------------- */
/* -*- C++ -*- */
#ifndef _color_obj_h_
#define _color_obj_h_
#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#ifndef _DISABLE_GL_
#include <gl/gl.h>
#include <gl/device.h>
#include <gl/sphere.h>
#endif
#ifndef _header_h_
#include "header.h"
#endif

/* ޥƥꥢ륪֥Ȥ뤿Υ֥ */

/* Begin Class Definition color_entry */
class material : public header{
  int                 color_id;
  unsigned short      pr_red;
  unsigned short      pr_green;
  unsigned short      pr_blue;
  float               alpha;   
  float               tc_red;   
  float               tc_green;
  float               tc_blue;
  float               shine;
  float               speculer[3];
public:
/* Function Defined At color_obj.c */
  material();		
  short int PrRed();                /* return Red value of primitive color */
  short int PrGreen();              /* return Green value of primitive color */
  short int PrBlue();               /* return Blue value of primitive color */
  void RgbSet(float r,float g,float b);  /* set value of true color */
  void Speculer(float r,float g,float b);  /* set value of true color */
  void Shiness(float a);  /* set value of true color */
  inline float Shiness();
  int IsEqualRgb(float r,float g,float b); /* compare */
  void Close();
  void Alpha(float a);
  float Alpha();
  void Bind();
  int ColorID();
  void ColorID(int c);
  inline float Red();
  inline float Green();
  inline float Blue();
  inline void Red(float r);
  inline void Green(float g);
  inline void Blue(float b);
  inline float SRed();
  inline float SGreen();
  inline float SBlue();
  inline void SRed(float r);
  inline void SGreen(float g);
  inline void SBlue(float b);
#ifdef _UN_USE_YACC_
#include "accept.h"
#include "reduce.h"
#endif
};

inline float material::Shiness()
{
  return shine;
}
inline float material::Red()
{
  return tc_red;
}
inline float material::Green()
{
  return tc_green;
}
inline float material::Blue()
{
  return tc_blue;
}
inline void material::Red(float r)
{
  tc_red = r;
  float w_red = (tc_red/shine)*255;
  pr_red =  (unsigned short)(w_red);
}
inline void material::Green(float g)
{
  tc_green = g;
  float w_green = (tc_green/shine)*255;
  pr_green =  (unsigned short)(w_green);
}
inline void material::Blue(float b)
{
  tc_blue = b;
  float w_blue = (tc_blue/shine)*255;
  pr_blue =  (unsigned short)(w_blue);
}

inline float material::SRed()
{
  return speculer[0];
}
inline float material::SGreen()
{
  return speculer[1];
}
inline float material::SBlue()
{
  return speculer[2];
}
inline void material::SRed(float r)
{
  speculer[0] = r;
}
inline void material::SGreen(float g)
{
  speculer[1] = g;
}
inline void material::SBlue(float b)
{
  speculer[2] = b;
}
/* End Class Definition color_entry */

extern void draw_color_bind(material* col);
extern void check_material_and_bind(header* obj,char* errmsgstr);

#endif/* _color_obj_h_*/

