#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <limits.h>

#include "defs.h"

main(argc,argv)
int argc;
char *argv[];
{
  FILE *fp, *fopen();
  char linebuffer[LINEBUFFERMAX];
  char results[LINEMAX][LINEWIDTH];
  int i,flag,lines,keylength;

  if(argc < 3) {
    fprintf(stderr,"Usage: dbpick file key\n");
    exit(0);
  }

  flag = OFF;
  if(argv[1][0]=='-') 
    fp = stdin;
  else
    fp = fopen(argv[1], "r");
  keylength = strlen(argv[2]);
  fprintf(stderr,"key=%s(%d)\n",argv[2],keylength);

  lines = 0;
  while(fgets(linebuffer, LINEBUFFERMAX, fp) != NULL) {
    strcpy(results[lines],linebuffer);
    lines++;
    if(mygrep(linebuffer, argv[2], keylength)==EXIST) flag = ON;
    if(strncmp(linebuffer, "///", 3)==0) {
      if(flag == ON) {
	for(i=0;i<lines;i++) {
	  printf("%s",results[i]);
	}
	flag = OFF;
      }
      lines = 0;
    }
  }
  fclose(fp);

}

int mygrep(body, key, length)
char body[LINEBUFFERMAX], key[];
int length;
{
  int i,j,k,n;
  int skip[UCHAR_MAX + 1];
  char c, tail;

  n = strlen(body);
  if(n==0)  return(NO);
  if(length == 0) return(NO);
  tail = key[length-1];
  if(length == 1) {
    for(i=0;i<n;i++) 
      if(body[i] == tail) return(EXIST);
  } else {
    for(i=0;i<=UCHAR_MAX;i++) skip[i] = length;
    for(i=0;i<length-1;i++) skip[key[i]] = length-1-i;
    while(i<n) {
      c = body[i];
      if(c == tail) {
	j=length-1; k=i;
	while(key[--j] == body[--k])
	  if(j==0) return(EXIST);
      }
      i += skip[c];
    }
  }
  return(NO);
}

/* end of file */
