#include <stdio.h>
#include <varargs.h>
#include <Xm/Form.h>
#include <Xm/Frame.h>
#include <Xm/Text.h>
#include <Xm/Label.h>

static Widget textW;

void CreateScrolledText(Widget parent, Widget mae)
{
  Widget frame, form, label;
  XFontStruct *font;
  XmFontList fontlist;
  Arg args[14];
  int i = 0;

  frame = XtVaCreateManagedWidget("frame", xmFrameWidgetClass, parent,
				  XmNtopAttachment,   XmATTACH_WIDGET,
				  XmNtopWidget, mae,
				  XmNleftAttachment,  XmATTACH_FORM,
				  XmNrightAttachment, XmATTACH_FORM,
				  NULL);
  form  = XtVaCreateManagedWidget("form",  xmFormWidgetClass,  frame,  NULL);
  label = XtVaCreateManagedWidget("Message:", xmLabelWidgetClass,
				  form,
				  XmNtopAttachment,  XmATTACH_FORM,
				  XmNleftAttachment, XmATTACH_FORM,
				  NULL);
  
  font = XLoadQueryFont(XtDisplay(frame),
  "-adobe-courier-medium-r-normal--12-120-75-75-m-70-iso8859-1");
  fontlist = XmFontListCreate(font, "charset2");

  XtSetArg(args[i], XmNrows, 10);                        i++;
  XtSetArg(args[i], XmNfontList, fontlist);              i++;
  XtSetArg(args[i], XmNeditable, False);                 i++;
  XtSetArg(args[i], XmNeditMode, XmMULTI_LINE_EDIT);     i++;
  XtSetArg(args[i], XmNwordWrap, True);                  i++;
  XtSetArg(args[i], XmNscrollHorizontal, False);         i++;
  XtSetArg(args[i], XmNblinkRate, 0);                    i++;
  XtSetArg(args[i], XmNautoShowCursorPosition, True);    i++;
  XtSetArg(args[i], XmNcursorPositionVisible, False);    i++;
  XtSetArg(args[i], XmNtopAttachment, XmATTACH_WIDGET);  i++;
  XtSetArg(args[i], XmNleftAttachment, XmATTACH_FORM);   i++;
  XtSetArg(args[i], XmNrightAttachment, XmATTACH_FORM);  i++;
  XtSetArg(args[i], XmNtopWidget, label); i++;
  textW = XmCreateScrolledText(form, "textW", args, i);
  XtManageChild(textW);
}

/*VARARGS*/
void wprintf(va_alist)
va_dcl
{
  char msgbuf[BUFSIZ];
  char *fmt;
  static XmTextPosition wpr_position;
  va_list args;

  va_start(args);
  fmt = va_arg(args, char *);
#ifdef NO_VPRINTF
  (void)vprintf(msgbuf, fmt, args);
#else
  {
    FILE foo;
    foo._cnt  = BUFSIZ;
    foo._base = foo._ptr = msgbuf;
    foo._flag = _IOWRT; /*+_IOSTRG;*/
    (void) _doprnt(fmt, args, &foo);
    *foo._ptr = 0;
  }
#endif
  va_end(args);

  XmTextInsert(textW, wpr_position, msgbuf);
  wpr_position += strlen(msgbuf);
  XtVaSetValues(textW, XmNcursorPosition, wpr_position, NULL);
  XmTextShowPosition(textW, wpr_position);
}
