%{
/**
 ** yacc program for qXote
 **/
#define YYMAXDEPTH 300
#define yylex  yyylex
#define yytext yyytext

extern void createObjectA(char *);
extern void createObjectB(char *);
extern void createObjectC(char *, char *);
extern void createObjectF(char *, char *);
extern void createObjectH(char *, char *, char *);
extern void createElement1(char *);
extern void createElement2(char *);
static char predicate[80] = {0};
static char tmp[256] = {0};
static int ElementFlag = 0;
static int nameFlag = 0;
static int TypeAFlag = 0;
static int TypeBFlag = 0;
static int TypeCFlag = 0;
static int TypeEFlag = 0;
static int TypeFFlag = 0;
static int TypeHFlag = 0;
%}
/*   */
%token NOW
%token FROM
%token NEXT
%token STAGE
%token NEXT_STAGE
%token NAME
%token NAMES
%token ELEMENT1
%token ELEMENT2
%token TO
%token WITH
%token RESULT
%token RESULT1
%token RESULT2
%token PATH
%token PATH1
%token PATH2
%token PLACE
%token INPUT
%token LOCATION
%token TIME
%token STATUS
%token ENZYME
%token LONG_NAME
%token UPPER
%token LOWER
%token Q_STRING
%token EQ
%token START
%token END
%token COMMA
%token NL
/*    */
%token STATE
%token PATHWAY
%token TYPE_A        /* BEGIN_, DUPLICATE, EXPRESS */
%token TYPE_C        /* RECEIVE, INCREASE */
%token ACTIVATE
%token BIND_ELEMENT
/* %token PRODUCE */
%token RESULTS
%token LIST
%token INFECT
%token BIND          /* TypeH */
%token FORM
%token COMPOUND
%token BECOME
%token SIGNAL
%token RELEASE
%token INFILTRATE
%token CROSS_LINK
%token EXOCYTOSIS
%token DEVELOPE
%token INVOLUTE
%token DIFFERENTIATE
%token BLOOD_GLUCOSE
%token SYNTHESIZE
%token ENERGIZE
%token ACCEPT
%token ARRIVE
/*%token ERROR*/
%%
answer_list  : /* empty */
             | answer
             | answer COMMA answer_list
             | answer NL answer_list
             ;
answer       : UPPER EQ o_term
/*           | error NL */
             ;
o_term       : LOWER 
             | Q_STRING
             | b_term START attr_list END
             ;
attr_list    : attribute
             | attribute COMMA attr_list
             ;
attribute    : a_label EQ o_term
                   {
		     /* fprintf(stderr,"a_label[%s] = o_term[%s]\n",$2,$3); */
		     if(nameFlag == 1) {
		       if(TypeAFlag == 1) {
			 if(TypeFFlag == 2){
			   createObjectF(tmp, (char *)$3);
			   TypeFFlag = 0;
			 }else{
			   sprintf(tmp,"%s\n%s", predicate, $3);
			   createObjectA( tmp );
			   TypeAFlag = 0;
			 }
		       }else if(TypeBFlag == 1) {
			 createObjectB( (char *)$3 );
			 TypeBFlag = 0;
		       }else if(TypeCFlag == 1) {
			 createObjectC( predicate, (char *)$3 );
			 TypeCFlag = 0;
		       }else if(TypeEFlag == 1) {
			 createObjectC( predicate, (char *)$3 );
			 TypeEFlag = 0;
		       }else if(TypeFFlag == 1) {
			 strcpy(tmp, (char *)$1 );
			 TypeFFlag = 2;
		       }else if(TypeHFlag == 1) {
			 strcpy( tmp, (const char *)$3 );
		       }
		       nameFlag = 0;
		     } else if(nameFlag == 2) {
		       createObjectH( predicate, tmp, (char *)$3 );
		       TypeHFlag = 0;
		       nameFlag = 0;
		     } else  if(nameFlag == 3){
		       if(ElementFlag ==1) {
			 fprintf(stderr,"create element1:%s\n",$3);
			 createElement1((char *)$3);
			 TypeEFlag = 2;
		       }else if(ElementFlag == 2){
			 fprintf(stderr,"create element2:%s\n",$3);
			 createElement2((char *)$3);
			 TypeEFlag = 0;
			 nameFlag = 0;
		       }
		     }
		   }
             ;
a_label      : NOW
             | FROM
             | NEXT
             | STAGE
             | NEXT_STAGE
             | NAME
                   {
		     nameFlag = 1;
		   }
             | NAMES
                   {
		     nameFlag = 3;
		   }
             | ELEMENT1
                   {
		     if(TypeEFlag == 1) {
		       ElementFlag = 1;
		     }
		   }
             | ELEMENT2
                   {
		     if(TypeEFlag == 2) {
		       ElementFlag = 2;
		     }
		   }
             | TO
                   {
		     if(TypeHFlag ==1) {
		       nameFlag = 2;
		     }
		   }
             | WITH
             | RESULT
             | RESULT1
/*
                   {
		     fprintf(stderr,"RESULT1\n");
		   }
*/
             | RESULT2
/*
                   {
		     fprintf(stderr,"RESULT2\n");
		   }
*/
             | PATH
             | PATH1
             | PATH2
             | PLACE
             | INPUT
             | LOCATION
             | ENZYME
             | TIME
             | STATUS
             | LONG_NAME
/*           | ERROR
                   {
		     fprintf(stderr, "UNKNOWN STRINGS(a_term):%s\n", $$);
		   } */
             ;
b_term       : STATE
             | ARRIVE
             | PATHWAY
             | TYPE_A                /* Type A */
                   { 
		     TypeAFlag = 1;
		     strcpy(predicate, (const char*)$$);
		   }
             | ACTIVATE              /* Type B */
                   {
		     TypeBFlag = 1;
		   }
             | TYPE_C                /* Type C */
                   { 
		     TypeCFlag = 1;
		     strcpy(predicate, (const char*)$$);
		   }
             | BIND_ELEMENT          /* Type F */
                   {
		     TypeFFlag = 1;
		     strcpy(predicate, (const char*)$$);
		   }
             | SYNTHESIZE            /* Type E */
                   {
		     /* fprintf(stderr,"Type E: synthesize\n"); */
		     TypeEFlag = 1;
		     strcpy(predicate, (const char*)$$);
		   }
             | RESULTS
             | LIST
                   {
		     fprintf(stderr,"List apeared, %d\n", TypeEFlag);
		   }
             | INFECT
             | BIND                  /* Type H */
                   {
		     TypeHFlag = 1;
		     strcpy(predicate, (const char*)$$);
		   }
             | FORM
             | COMPOUND
             | BECOME
             | SIGNAL
             | RELEASE
             | INFILTRATE
             | CROSS_LINK
             | EXOCYTOSIS
             | DEVELOPE
             | INVOLUTE
             | DIFFERENTIATE
             | BLOOD_GLUCOSE
/*           | ERROR
                   {
		     fprintf(stderr, "UNKNOWN STRINGS(b_term):%s\n", $$);
		   } */
             ;
%%
#include "lex.yy.c"
