/* -*-C++-*- */
// questionBox.c
// Original made by H.TANAKA
//
#include <stdio.h>
#include <assert.h>
#include <sys/stat.h>
#include <Xm/Text.h>
#include <Xm/ScrolledW.h>
#include <Xm/PushB.h>
#include <Xm/ArrowBG.h>
#include <Xm/Label.h>
#include <Xm/BulletinB.h>
#include <Xm/Form.h>
#include <Xm/Frame.h>
#include <Xm/Separator.h>
#include <Xm/RowColumn.h>
#include "TextWidget.h"
#include "newclass.h"

#define TMP_FILE "/tmp/.pathway"
#define INIT_MESSAGE "Pathway version 000 Copyright(C) 1994 ICOT\n"
#define QUERY_BOX_WIDTH 370
#define QUERY_BOX_COLUMN 34

#ifdef __STDC__
#define _P(x) x
#else
#define _P(x) ()
#define volatile
#endif

extern char *result;
extern "C" {
  void CreateScrolledText(Widget, Widget);
  void wprintf();
  extern int start_query _P((char *q));
  extern int load_program _P((char *));
  extern int get_answer _P((void));
  extern void end_query _P((void));
}
extern FILE *yyin;
extern int yyparse();
extern void AllCB(Widget w,XtPointer cliant_data,
		  XmPushButtonCallbackStruct *cbs);
extern line table;
extern int startSet;

#define QQsize   5     /* Query Queue max */
#define QQlength 4000  /* Query max */
#define AQsize   5     /* Answer Queue max */
#define AQlength 4000  /* Answer max */
#define RQsize   5     /* Result Queue max */
#define RQlength 10000 /* Result max */

static Widget questionbd,exepb,clearpb,prevpb,nextpb;
static char qqbuf[QQsize][QQlength]; // Query Queue Buffer
static char aqbuf[QQsize][QQlength]; // Answer Queue Buffer
static char rqbuf[QQsize][QQlength]; // Result Queue Buffer
static int  qnext,qdisplay;
static TextWithLabel *queryW;
static TextWithLabel *answer;
static TextWithLabel *mqResult;
static TextWithLabel *query2;

int executionStub(char *qstr, char *astr, char *rstr)
{
  /* Send Query */
  //  fprintf(stderr,"%s\n",qstr);
  int r = start_query (qstr);
  if (r < 0) {
    wprintf ("Failed: %s\n", result);
    strcpy(rstr, ", No Result");
    strcpy(astr, "No");
    end_query ();
    return(-1);
  }
  // Get Answer
  if(get_answer ()){
    strcpy(rstr, result);
    strcpy(astr, "yes");
  }else{
    strcpy(rstr, ", No Result");
    strcpy(astr, "No");
    end_query ();
    return(-1);
  }
  end_query ();
  return(1);
}


void clearCB(Widget w, Widget tx, caddr_t call_data)
{
  assert(tx != NULL);      // Check widget existing
  XmTextSetString(tx, "");
}

void prevCB(Widget w, XtPointer cliant_data, XmPushButtonCallbackStruct *cbs)
{
    char strings[RQlength];

    if (qdisplay == 0) qdisplay = QQsize-1;
    else qdisplay--;

    strcpy(strings,qqbuf[qdisplay]);
    queryW->ValueSet(strings);

    strcpy(strings,aqbuf[qdisplay]);
    answer->ValueSet(strings);

    strcpy(strings,rqbuf[qdisplay]);
    mqResult->ValueSet(strings);
}

void nextCB(Widget w, XtPointer cliant_data, XmPushButtonCallbackStruct *cbs)
{
    char strings[RQlength];

    if (qdisplay < QQsize-1) qdisplay++;
    else qdisplay = 0;

    strcpy(strings,qqbuf[qdisplay]);
    queryW->ValueSet(strings);

    strcpy(strings,aqbuf[qdisplay]);
    answer->ValueSet(strings);

    strcpy(strings,rqbuf[qdisplay]);
    mqResult->ValueSet(strings);
}

void exeCB(Widget w, XtPointer cliant_data, XmPushButtonCallbackStruct *cbs)
{
  FILE *tmp_fp;
  char *astrings = new char[AQlength];
  char *rstrings = new char[RQlength];
  memset(astrings, '\0', AQlength);
  memset(rstrings, '\0', RQlength);

  if((tmp_fp = fopen(TMP_FILE,"w")) == NULL){
    wprintf("Fatal: Can't create a temporally file.\n");
    return;
  }

  strcpy(qqbuf[qnext], XmTextGetString(query2->Text()));

  // Send Query
  int i = executionStub(qqbuf[qnext],astrings,rstrings);

  queryW->ValueSet(qqbuf[qnext]);
  answer->ValueSet(astrings);   strcpy(aqbuf[qnext],astrings);

  char *tmp = rindex(rstrings,',');
  mqResult->ValueSet(tmp+1); strcpy(rqbuf[qnext],tmp+1);
  query2->ValueSet("");

  if(i>0){
    fputs(rstrings, tmp_fp);
    fclose(tmp_fp);
    chmod(TMP_FILE,S_IRWXU|S_IRWXG|S_IRWXO);
    freopen(TMP_FILE, "r", tmp_fp);
    yyin = tmp_fp;

//------------------------------------------------- clear old Widget
    line *loop = table.Head();
    while(loop != NULL){
      loop->clear();
      loop = loop->Next();
    }
    startSet = 0;
//-------------------------------------------------
    yyparse();
  }

  if (qnext < QQsize-1) {qnext++;qdisplay=qnext-1;}
  else {qnext = 0;qdisplay = QQsize-1;}

  fclose(tmp_fp);
  yyin = stdin;

  delete astrings;
  delete rstrings;
}

void questionBox(Widget top1)
{
    XFontStruct *font;
    XmFontList fontlist;
//   -adobe-courier-bold-o-normal--17-120-100-100-m-100-iso8859-1

    // Initialize buffer for history
    for(int i=0; i<QQsize; ++i){
      memset(qqbuf[i], '\0', QQlength);
      memset(aqbuf[i], '\0', QQlength);
      memset(rqbuf[i], '\0', QQlength);
    }

    Widget questionFr = XtVaCreateWidget("QuestionBox", xmFrameWidgetClass,
					 top1,
					 NULL);
    questionbd = XtVaCreateWidget("QuestionBox", xmFormWidgetClass, questionFr,
				  XmNwidth, 400,
				  NULL);

    font = XLoadQueryFont(XtDisplay(questionbd),
    "-adobe-courier-medium-r-normal--12-120-75-75-m-70-iso8859-1");
    fontlist = XmFontListCreate(font, "charset1");

    queryW = new TextWithLabel(questionbd, "[Query] ");
    queryW->horizontal();
    XtVaSetValues(queryW->headWidget(),
		  XmNwidth, QUERY_BOX_WIDTH,
		  XmNtopAttachment,   XmATTACH_FORM,
		  XmNleftAttachment,  XmATTACH_FORM,
		  NULL);
    XtVaSetValues(queryW->Text(),
		  XmNcolumns, QUERY_BOX_COLUMN,
		  XmNfontList, fontlist,
		  XmNcursorPositionVisible, False,
		  XmNeditable, False,
		  NULL);
    XmTextSetString(queryW->Text(),"None");
    queryW->manage();

    answer = new TextWithLabel(questionbd, "[Answer]");
    answer->horizontal();
    XtVaSetValues(answer->headWidget(),
		  XmNwidth, QUERY_BOX_WIDTH,
		  XmNtopAttachment,   XmATTACH_WIDGET,
		  XmNtopWidget,       queryW->headWidget(),
		  XmNleftAttachment,  XmATTACH_FORM,
		  NULL);
    XtVaSetValues(answer->Text(),
		  XmNcolumns, QUERY_BOX_COLUMN,
		  XmNfontList, fontlist,
		  XmNcursorPositionVisible, False,
		  XmNeditable, False,
		  NULL);
    answer->manage();

    mqResult = new TextWithLabel(questionbd, "[Result]");
    mqResult->horizontal();
    XtVaSetValues(mqResult->headWidget(),
		  XmNwidth, QUERY_BOX_WIDTH,
		  XmNtopAttachment,   XmATTACH_WIDGET,
		  XmNtopWidget,       answer->headWidget(),
		  XmNleftAttachment,  XmATTACH_FORM,
		  NULL);
    XtVaSetValues(mqResult->Text(),
		  XmNcolumns, QUERY_BOX_COLUMN,
		  XmNfontList, fontlist,
		  XmNcursorPositionVisible, False,
		  XmNeditable, False,
		  NULL);
    mqResult->manage();

    query2 = new TextWithLabel(questionbd, " Query  ");
    query2->horizontal();
    XtVaSetValues(query2->headWidget(),
		  XmNwidth, QUERY_BOX_WIDTH,
		  XmNtopAttachment,   XmATTACH_WIDGET,
		  XmNtopWidget,       mqResult->headWidget(),
		  XmNleftAttachment, XmATTACH_FORM,
		  NULL);
    XtVaSetValues(query2->Text(),
		  XmNcolumns, QUERY_BOX_COLUMN,
		  XmNfontList, fontlist,
		  NULL);
    query2->manage();

    // Dialog
    font = XLoadQueryFont(XtDisplay(questionbd),
    "-adobe-helvetica-bold-r-normal--17-120-100-100-p-92-iso8859-1");
    fontlist = XmFontListCreate(font, "charset1");

    clearpb = XtVaCreateManagedWidget("clearpb",xmPushButtonWidgetClass,
				      questionbd,
				      XmNfontList, fontlist,
				  XmNlabelString,XmStringCreateSimple("clear"),
				  XmNtopAttachment, XmATTACH_WIDGET,
				  XmNtopWidget, query2->headWidget(),
				  XmNrightAttachment, XmATTACH_FORM,
				      NULL);
    nextpb =
      XtVaCreateManagedWidget("nextpb",xmArrowButtonGadgetClass,
			      questionbd,
			      XmNarrowDirection,   XmARROW_DOWN,
			      XmNtopAttachment,    XmATTACH_OPPOSITE_WIDGET,
			      XmNtopWidget,        mqResult->headWidget(),
			      XmNbottomAttachment, XmATTACH_OPPOSITE_WIDGET,
			      XmNbottomWidget,     mqResult->headWidget(),
			      XmNleftAttachment,   XmATTACH_WIDGET,
			      XmNleftWidget,       mqResult->headWidget(),
			      XmNrightAttachment,  XmATTACH_FORM,
			      NULL);
    prevpb = 
      XtVaCreateManagedWidget("prevpb",xmArrowButtonGadgetClass,
			      questionbd,
			      XmNarrowDirection,   XmARROW_UP,
			      XmNtopAttachment,    XmATTACH_OPPOSITE_WIDGET,
			      XmNtopWidget,        queryW->headWidget(),
			      XmNbottomAttachment, XmATTACH_OPPOSITE_WIDGET,
			      XmNbottomWidget,     queryW->headWidget(),
			      XmNleftAttachment,   XmATTACH_WIDGET,
			      XmNleftWidget,       queryW->headWidget(),
			      XmNrightAttachment,  XmATTACH_FORM,
			      NULL);
    exepb=XtVaCreateManagedWidget("exepb",xmPushButtonWidgetClass,questionbd, 
				XmNlabelString,XmStringCreateSimple("Display"),
				  XmNfontList, fontlist,
				  XmNtopAttachment, XmATTACH_WIDGET,
				  XmNtopWidget, query2->headWidget(),
				  XmNrightAttachment, XmATTACH_WIDGET,
				  XmNrightWidget, clearpb,
				  NULL);

    Widget allpb;
    allpb=XtVaCreateManagedWidget("allpb",xmPushButtonWidgetClass,questionbd, 
				  XmNlabelString,
				  XmStringCreateSimple("Display All"),
				  XmNfontList, fontlist,
				  XmNtopAttachment, XmATTACH_WIDGET,
				  XmNtopWidget, query2->headWidget(),
				  XmNleftAttachment, XmATTACH_FORM,
				  NULL);

    XtManageChild(questionbd);    // Manage parent widget
    XtManageChild(questionFr);    // Manage parent widget
    XtAddCallback(allpb, XmNactivateCallback, (XtCallbackProc)AllCB, NULL);
    XtAddCallback(exepb, XmNactivateCallback, (XtCallbackProc)exeCB, NULL);
    XtAddCallback(clearpb, XmNactivateCallback, 
		  (XtCallbackProc)clearCB, query2->Text());
    XtAddCallback(prevpb, XmNactivateCallback, (XtCallbackProc)prevCB, NULL);
    XtAddCallback(nextpb, XmNactivateCallback, (XtCallbackProc)nextCB, NULL);

    CreateScrolledText(questionbd, exepb);
    wprintf(INIT_MESSAGE);
/*
    Widget label = XtVaCreateManagedWidget("Message:", xmLabelWidgetClass,
					   questionbd,
					   XmNtopAttachment, XmATTACH_WIDGET,
					   XmNtopWidget, exepb,
					   XmNleftAttachment, XmATTACH_FORM,
					   NULL);
    Widget scrolledW = 
      XtVaCreateManagedWidget("S", xmScrolledWindowWidgetClass,
			      questionbd,
			      XmNtopAttachment, XmATTACH_WIDGET,
			      XmNleftAttachment, XmATTACH_FORM,
			      XmNrightAttachment, XmATTACH_FORM,
			      XmNbottomAttachment, XmATTACH_FORM,
			      XmNtopWidget, label,
			      XmNscrollingPolicy, XmAPPLICATION_DEFINED,
			      XmNvisualPolicy, XmVARIABLE,
			      XmNscrollBarDisplayPolicy, XmSTATIC,
			      NULL);
    Widget message =
      XtVaCreateManagedWidget("messsage", xmTextWidgetClass, scrolledW, NULL);
*/
}
