/* -*-C++-*- */
///////////////////////////////////////////////////////////////
// newclass.c : define protcols for new class
// '94.6.16 Thr
///////////////////////////////////////////////////////////////

#include <stdio.h>
#include <string.h>
#include <Xm/Label.h>
#include <Xm/PushB.h>
#include <Xm/RowColumn.h>
#include <Xm/Form.h>
#include <Xm/DrawnB.h>
#include <Xm/Separator.h>
#include "newclass.h"

extern const char **cmdTable;

//extern Widget base;
Pixmap pixmap1, pixmap2;

from::from(char* string, Widget parent) : MotifHead(string)
{
  name = strdup(string);
  with = new char[128];

  command = 0;
  memset(with, 0, 128);

  _w = XtVaCreateManagedWidget(_name, xmFormWidgetClass, parent,
			       XmNfractionBase , 5,
//			       XmNrubberPositioning, True,
//			       XmNisAligned, True,
//			       XmNentryAlignment, XmALIGNMENT_CENTER,
			       XmNleftOffset, 10,
//			       XmNorientation, XmVERTICAL, 
			       NULL);

  row = XtVaCreateManagedWidget(name, xmFormWidgetClass, _w,
				XmNfractionBase , 5,
				XmNleftAttachment, XmATTACH_FORM,
				XmNrightAttachment, XmATTACH_FORM,
				NULL);

  Pixel fg, bg;
  XtVaGetValues(_w, XmNforeground, &fg, XmNbackground, &bg, NULL);

  // Upper Box
  pixmap1 = XmGetPixmap(XtScreen(_w), "allow1", fg, bg);
  XmString tmp = XmStringCreateSimple(" ");
  allowB = XtVaCreateManagedWidget(name, xmDrawnButtonWidgetClass, row,
				   XmNalignment, XmALIGNMENT_CENTER,
				   XmNshadowThickness, 0,
				   XmNlabelType, XmPIXMAP,
				   XmNlabelPixmap, pixmap1,
				   XmNleftAttachment, XmATTACH_POSITION,
				   XmNleftPosition, 2,
				   XmNrightAttachment, XmATTACH_POSITION,
				   XmNrightPosition, 3,
				   NULL);
  labelRight = XtVaCreateManagedWidget(name, xmPushButtonWidgetClass, row,
				       XmNlabelString, tmp,
				       XmNleftAttachment, XmATTACH_WIDGET,
				       XmNleftWidget, allowB,
				       NULL);
  labelLeft = XtVaCreateManagedWidget(name, xmPushButtonWidgetClass, row,
				      XmNlabelString, tmp,
				      XmNrightAttachment, XmATTACH_WIDGET,
				      XmNrightWidget, allowB,
				      XmNshadowThickness, 0,
				      NULL);
  XmStringFree(tmp);

  XmString nameX = XmStringCreateSimple(string);
  nodeB = XtVaCreateManagedWidget(name, xmPushButtonWidgetClass, _w,
				  XmNlabelString, nameX,
				  XmNtopAttachment, XmATTACH_WIDGET,
				  XmNtopWidget, row,
				  XmNleftAttachment, XmATTACH_POSITION,
				  XmNleftPosition, 1,
				  XmNrightAttachment, XmATTACH_POSITION,
				  XmNrightPosition, 4,
//				  XmNleftAttachment, XmATTACH_OPPOSITE_WIDGET,
//				  XmNrightAttachment,XmATTACH_OPPOSITE_WIDGET,
//				  XmNleftWidget, row,
//				  XmNrightWidget, row,
				  NULL);

//  Widget line =XtVaCreateManagedWidget(name, xmSeparatorWidgetClass, _w,
//				       XmNorientation, XmHORIZONTAL,
//				       XmNseparatorType, XmSINGLE_LINE,
//				       XmNtopAttachment,XmATTACH_WIDGET,
//				       XmNtopWidget, nodeB,
//				       NULL);

  XtAddCallback(nodeB, XmNactivateCallback, 
		(XtCallbackProc)ClickCB, NULL);

  XmStringFree(nameX);

  XtManageChild(allowB);
}

from::~from(void)
{
  XtDestroyWidget(row);
  XtDestroyWidget(labelLeft);
  XtDestroyWidget(labelRight);
  XtDestroyWidget(allowB);
  XtDestroyWidget(nodeB);
  delete name;
  delete with;
}


void from::Label(char *id, int num)
{
  // insert CR code with name
  char *tmp = new char[256];
  memset(tmp,0,256);
  if(num >= 2 && num <=15 || num == 23 || num == 20) {
    sprintf(tmp,"%s", name);
    XmString nameX = XmStringCreateLtoR(id,"charset");
    if(num != 2) XtVaSetValues(labelRight, XmNlabelString, nameX, NULL);
    if(num==23){
      XmString withX = XmStringCreateLtoR(with,"charset");
      XtVaSetValues(labelRight,  XmNlabelString, withX, NULL);
      XtVaSetValues(labelLeft, XmNlabelString, nameX, NULL);
      XmStringFree(withX);
    }
    else if(num==20){
      XtVaSetValues(labelLeft, XmNlabelString, nameX, NULL);
    }
    XmStringFree(nameX);
  } else sprintf(tmp,"%s\n%s", id, name);
  XtVaSetValues(labelRight, XmNshadowThickness, 0, NULL);

  // Use XmStringCreateLtoR for CR code
  XmString nameX = XmStringCreateLtoR(tmp, "charset");
  XtVaSetValues(nodeB, XmNlabelString, nameX, NULL);

  XmStringFree(nameX);
  delete tmp;
}

char* from::Label(void)
{
  XmString nameX;
  XtVaGetValues(nodeB, XmNlabelString, &nameX, NULL);
  char *name;
  XmStringGetLtoR(nameX, "charset", &name);

  XmStringFree(nameX);
  return name;
}

void from::ID(int id)
{
  command = id;
}

char* from::Name(void)
{
  return name;
}

void from::With(char* A)
{
  //  with = strdup(A);
  strcpy(with, A);
  fprintf(stderr, "%s\n", with);
}

line::line(void)
{
  counter = 0;
  node = NULL;
  parent = NULL;
  next = NULL;
  head = NULL;
  tail = NULL;
}

line::~line(void)
{
  delete node;
  delete parent;
  delete next;
  delete head;
  delete tail;
}

line* line:: Parent(void)
{
  return parent;
}

line* line:: Next(void)
{
  return next;
}

void line::Parent(line* A)
{
  parent = A;
}

void line::Next(line* A)
{
  next = A;
}


from* line::Node(void)
{
  return node;
}

void line::Node(from* A)
{
  node = A;
}


void line::append(from* name)
{
  static int i = 0;
  line *newnode;
  from *newfrom = name;
  if(head){
    newnode = new line;
//    newfrom = new from(name);
    newnode->Node(newfrom);
    newnode->Parent(tail);
    newnode->Counter(i);
    //    newnode->Next(NULL);
    tail->Next(newnode);
    tail = newnode;
  } else {
    i = 0;
    head = new line;
//    newfrom = new from(name);
    head->Node(newfrom);
    //    node = new from(name);
    //    parent = new line;
    //    next = new line;
    //    tail = new line;
    tail = head;
  }
  i++;
}

void line::clear(void)
{
  counter = 0;
  delete node;
  head = NULL;
  tail = NULL;
}

void line::print(void)
{
  line *loop = head;
  while(loop != NULL){
    //fprintf(stderr,"%d\n", loop);
    fprintf(stderr,"%d: %s\t%s\n", 
	    loop->Counter(),loop->Node()->Label(), loop->Node()->Name());
    loop = loop->Next();
  }
  fprintf(stderr,"Print complete\n");
}
