/* Micro Quixote                 */
/* Copyright (C) 1993, 1994 ICOT */
/* Written by gniibe             */
/* $Id: unify.c,v 1.2 1994/09/19 02:11:21 m-gniibe Exp $ */

/* unify routine */

#include <stdio.h>
#include "obstack.h"
#include "mq.h"
#include "internal.h"
#include "extern.h"

int binding_changed;
UnwindProtect up;

/* function prototype for debugging */
static void unwind_protect_variable _P((MQ_Var));
static void unwind_variable _P((MQ_Var, MQ_VTermAddrList));

void init_unify ()
{
  ;
}

static
void unwind_protect_variable (v)
     MQ_Var v;
{
  UnwindProtect up1;

  up1 = (UnwindProtect) obstack_alloc (mm_exec, sizeof (UnwindProtect_Rec));
  up1->next  = up;
  up1->var   = v;
  up1->vterm_addr_list = NULL;
  up = up1;
}

void
unwind_protect_variable_in_cnstrs (v, vterm_addr_list)
     MQ_Var v;
     MQ_VTermAddrList vterm_addr_list;
{
  UnwindProtect up1;

  up1 = (UnwindProtect) obstack_alloc (mm_exec, sizeof (UnwindProtect_Rec));
  up1->next  = up;
  up1->var   = v;
  up1->vterm_addr_list = vterm_addr_list;
  up = up1;
}

static
void unwind_variable (var, vterm_addr_list)
     MQ_Var var;
     MQ_VTermAddrList vterm_addr_list;
{
  MQ_VTermAddrList val;
  MQ_VTerm value, orig;

  if (vterm_addr_list)
    var->vterm_addr_list = vterm_addr_list;
  else
    {
      value = var->value;
      if (value)
	{
	  var->value = NULL;
	  for (val = var->vterm_addr_list; val; val = val->next)
	    {
#ifdef DEBUG
	      orig = *val->vterm_addr;
	      if (orig != value)
		fatal ("unwind_variable.\n");
#endif
	      *val->vterm_addr = (MQ_VTerm)var;
	    }
	}
      else
	var->var_list = var->var_list->next;
    }
}

void unwind_variables (up_back)
     UnwindProtect up_back;
{
  for (; up != up_back; up = up->next)
#ifdef DEBUG
    if (up == NULL)
      fatal ("unwind_variables.\n");
    else
#endif
      unwind_variable (up->var, up->vterm_addr_list);
}

static
int equal_var (v1, v2)
     MQ_Var v1, v2;
{
  UnwindProtect up1;
  int result;

  up1 = up;
  bind (v1, (MQ_VTerm)mq_name);
  if (v2->value == (MQ_VTerm)mq_name)
    result = TRUE;
  else
    result = FALSE;
  unwind_variables (up1);
  return result;
}

int equal (vt1, vt2)
     MQ_VTerm vt1, vt2;
{
  MQ_Var v1, v2;
  MQ_Obj o1, o2;
  int i;

  if (vt1 == vt2)
    return TRUE;

  if (vt1->type == TT_Var)
    {
      v1 = (MQ_Var)vt1;
      if (vt2->type == TT_Var)
	{
	  v2 = (MQ_Var)vt2;
	  return equal_var (v1, v2);
	}
      return FALSE;
    }
  else
    if (vt2->type == TT_Var)
      return FALSE;
    else
      {
	if (vt1->type != TT_Obj)
	  fatal ("equal.\n");
	if (vt2->type != TT_Obj)
	  fatal ("equal.\n");

	o1 = (MQ_Obj)vt1;
	o2 = (MQ_Obj)vt2;
	if ((o1->atom != o2->atom) || (o1->arity != o2->arity))
	  return FALSE;

	for (i=0; i < o1->arity; i++)
	  if (o1->attr[i].label != o2->attr[i].label)
	    return FALSE;

	for (i=0; i < o1->arity; i++)
	  if (equal (o1->attr[i].vterm, o2->attr[i].vterm) == FALSE)
	    return FALSE;
	return TRUE;
      }
}

void bind (var, vt)
     MQ_Var var;
     MQ_VTerm vt;
{
  MQ_VTermAddrList val;
  MQ_VTerm orig;
  MQ_VarList vl;

  if (var->value)
    fatal ("bind.\n");

  unwind_protect_variable (var);
  var->value = vt;
  binding_changed = TRUE;

  for (val = var->vterm_addr_list; val; val = val->next)
    {
#ifdef DEBUG
      orig = *val->vterm_addr;
      if (orig != (MQ_VTerm)var)
	fatal ("bind.\n");
#endif
      *val->vterm_addr = vt;
    }

  for (vl = var->var_list;vl; vl = vl->next)
    if (vl->var->value == NULL)
      bind (vl->var, vt);
}

int unify (vt1_p, vt2_p)
     MQ_VTerm *vt1_p, *vt2_p;
{
  MQ_Var v1, v2;
  MQ_Obj o1, o2;
  int i;
  struct obstack *mm_old;

  if (*vt1_p == *vt2_p)
    return SUCCESS;

  if ((*vt1_p)->type == TT_Var)
    {
      v1 = *(MQ_Var *)vt1_p;
      if ((*vt2_p)->type == TT_Var)
	{
	  v2 = *(MQ_Var *)vt2_p;
	  if (v1->value || v2->value)
	    fatal ("unify.\n");
	  unwind_protect_variable (v1);
	  unwind_protect_variable (v2);
	  binding_changed = TRUE;
	  mm_old = mm_current;
	  mm_current = mm_exec;
	  v1->var_list = make_var_list (v2, v1->var_list);
	  v2->var_list = make_var_list (v1, v2->var_list);
	  mm_current = mm_old;
	}
      else
	bind (v1, *vt2_p);
      /* SUCCESS */
    }
  else
    if ((*vt2_p)->type == TT_Var)
      {
	v2 = *(MQ_Var *)vt2_p;
	bind (v2, *vt1_p);
	/* SUCCESS */
      }
    else
      {
	if ((*vt1_p)->type != TT_Obj)
	  fatal ("unify.\n");
	if ((*vt2_p)->type != TT_Obj)
	  fatal ("unify.\n");

	o1 = *(MQ_Obj *)vt1_p;
	o2 = *(MQ_Obj *)vt2_p;
	if ((o1->atom != o2->atom) || (o1->arity != o2->arity))
	  return FAILURE;

	for (i=0; i < o1->arity; i++)
	  if (o1->attr[i].label != o2->attr[i].label)
	    return FAILURE;

	for (i=0; i < o1->arity; i++)
	  if (unify (&o1->attr[i].vterm, &o2->attr[i].vterm) == FAILURE)
	    return FAILURE;
      }
  return SUCCESS;
}
