/* Micro Quixote                 */
/* Copyright (C) 1993, 1994 ICOT */
/* Written by gniibe             */
/* $Id: tree.c,v 1.2 1994/09/19 02:11:01 m-gniibe Exp $ */

/* allocation routines for objects in the parse tree */

#include <stdio.h>
#include "obstack.h"
#include "mq.h"
#include "internal.h"
#include "tree.h"
#include "extern.h"

static struct obstack parse_tree_obstack;
static struct obstack *mm_parse_tree;
static unsigned char *parse_tree_first_obj;

MQT_Constraints current_cnstrs;
MQT_Obj mqTO_True;

static MQT_Var *variable_pool;
#define VAR_POOL_SIZE 13

/* function prototype for debugging */
static int hash _P((unsigned char *));
static MQT_Var makeT_new_variable _P((void));

void
init_tree ()
{
  mm_parse_tree = &parse_tree_obstack;
  obstack_begin (mm_parse_tree, 0);
  mqTO_True = makeT_object (mqA_True, NULL);
  parse_tree_first_obj = (unsigned char *)obstack_alloc (mm_parse_tree, 0);
  variable_pool = NULL;
}

void
free_parse_tree ()
{
  obstack_free (mm_parse_tree, parse_tree_first_obj);
  parse_tree_first_obj = (unsigned char *)obstack_alloc (mm_parse_tree, 0);
  variable_pool = NULL;
}

static int
hash (ptr)
     unsigned char *ptr;
{
  unsigned char c;
  unsigned int hash = 0;

  while ((c = *ptr++))
    hash = (hash<<3) + (hash>>28) + (c&0x7f);
  return hash % VAR_POOL_SIZE;
}

static MQT_Var
makeT_new_variable ()
{
  MQT_Var new;

  new = (MQT_Var) obstack_alloc (mm_parse_tree, sizeof (MQT_Var_Rec));
  new->type = TT_Var;
  new->next = NULL;
  new->next_bucket = NULL;
  new->var = NULL;
  return new;
}

MQT_Var
makeT_variable (string)
     unsigned char *string;
{
  MQT_Var p, new;
  int val;

  if (variable_pool == NULL)
    {
      int i;

      variable_pool = (MQT_Var *)
	obstack_alloc (mm_parse_tree, sizeof (MQT_Var)*VAR_POOL_SIZE);
      for (i=0; i < VAR_POOL_SIZE; i++)
	variable_pool[i] = NULL;
    }

  val = hash (string);
  for (p = variable_pool[val]; p; p = p->next_bucket)
    if (!strcmp (string, p->name))
      return p;

  new = makeT_new_variable ();
  new->next_bucket = variable_pool[val];
  variable_pool[val] = new;
  new->name = (unsigned char *)obstack_alloc (mm_parse_tree, strlen(string)+1);
  strcpy (new->name, string);

  return new;
}

MQ_VarNameList
get_all_variables ()
{
  int i;
  MQT_Var t_var, tv;
  MQ_VarNameList current = NULL;

  if (variable_pool == NULL)
    return NULL;

  for (i=0; i<VAR_POOL_SIZE; i++)
    {
      t_var = variable_pool[i];
      if (t_var == NULL)
	continue;
      for (tv = t_var; tv; tv=tv->next_bucket)
	{
	  MQ_NameVar name_var;

	  name_var = make_name_var (0, tv->name);
	  current = make_var_name_list (tv->var, name_var, current);
	}
    }
  return current;
}

MQT_Constraints
makeT_constraints (rel, t1, t2, op, next)
     Rel rel;
     MQT_Term t1, t2;
     MQ_Atom op;
     MQT_Constraints next;
{
  MQT_Constraints new;

  new = (MQT_Constraints)
    obstack_alloc (mm_parse_tree, sizeof (MQT_Constraints_Rec));
  new->rel = rel;
  new->term1 = t1;
  new->term2 = t2;
  new->op = op;
  new->next = next;
  return new;
}

MQT_AttrList
makeT_attr_list (attr_rel, label, vterm, atl)
     AttrRel attr_rel;
     MQ_Atom label;
     MQT_VTerm vterm;
     MQT_AttrList atl;
{
  MQT_Var var;
  MQT_AttrList new, top;

  new = (MQT_AttrList)obstack_alloc (mm_parse_tree, sizeof (MQT_AttrList_Rec));
  new->label = label;
  if ((attr_rel != Equal) || (vterm->type == TT_Dot))
    {
      var = makeT_new_variable ();
      current_cnstrs = makeT_constraints ((Rel)attr_rel, (MQT_Term)var,
					  (MQT_Term)vterm, NULL,
					  current_cnstrs);
      new->vterm = (MQT_VTerm)var;
    }
  else
    new->vterm = vterm;

  if ((atl == NULL) || ((unsigned int) label < (unsigned int) atl->label))
    {
      top = new;
      new->next = atl;
    }
  else
    {
      top = atl;
      while (1)
	{
	  if ((atl->next == NULL)
	      || ((unsigned int) label > (unsigned int) atl->next->label))
	    {
	      new->next = atl->next;
	      atl->next = new;
	      break;
	    }
	  else if ((unsigned int) label == (unsigned int) atl->next->label)
	    {
	      error ("same label in attribute. (ignored)\n");
	      return atl;
	    }
	  atl = atl->next;
	}
    }
  return top;
}

MQT_Obj
makeT_object (atom, attr_list)
     MQ_Atom atom;
     MQT_AttrList attr_list;
{
  MQT_Obj new;

  new = (MQT_Obj)obstack_alloc (mm_parse_tree, sizeof (MQT_Obj_Rec));
  new->type = TT_Obj;
  new->atom = atom;
  new->attr_list = attr_list;
  return new;
}

MQT_Dot
makeT_dot (term, label)
     MQT_Term term;
     MQ_Atom  label;
{
  MQT_Dot new;
  MQT_Var var;

  new = (MQT_Dot)obstack_alloc (mm_parse_tree, sizeof (MQT_Dot_Rec));
  new->type = TT_Dot;
  if (term->type == TT_Dot)
    {
      var = makeT_new_variable ();
      current_cnstrs = makeT_constraints (Congruent, (MQT_Term)var,
					  term, NULL, current_cnstrs);
      new->vterm = (MQT_VTerm) var;
    }
  else
    new->vterm = (MQT_VTerm)term;
  new->label = label;
  return new;
}

MQT_VTermList
makeT_vterm_list (vterm, next)
     MQT_VTerm vterm;
     MQT_VTermList next;
{
  MQT_VTermList new;

  new = (MQT_VTermList)obstack_alloc (mm_parse_tree,
				      sizeof (MQT_VTermList_Rec));
  new->next = next;
  new->vterm = vterm;
  return new;
}

MQT_AtomList
makeT_atom_list (atom, next)
     MQ_Atom atom;
     MQT_AtomList next;
{
  MQT_AtomList new;

  new = (MQT_AtomList)obstack_alloc (mm_parse_tree, sizeof (MQT_AtomList_Rec));
  new->atom = atom;
  new->next = next;
  return new;
}
