/* Micro Quixote           */
/* Copyright (C) 1993 ICOT */
/* Written by gniibe       */
/* $Id: subrel.c,v 1.2 1994/09/19 02:10:07 m-gniibe Exp $ */

/* subsumption relation handling routines */

#include <stdio.h>
#include "obstack.h"
#include "mq.h"
#include "internal.h"
#include "extern.h"

MQ_SubRel subrel_list;

static struct obstack subrel_obstack;
static struct obstack *mm_subrel;
static unsigned char *subrel_first_obj;
static unsigned char *subrel_last_obj;
static MQ_SubRel subrel_list_last;

void init_subrel ()
{
  mm_subrel = &subrel_obstack;
  obstack_begin (mm_subrel, 0);
  subrel_first_obj = (unsigned char *)obstack_alloc (mm_subrel, 0);
  subrel_list = NULL;
}

void begin_temp_alloc_subrel ()
{
  subrel_list_last = subrel_list;
  subrel_last_obj = (unsigned char *)obstack_alloc (mm_subrel, 0);
}

void end_temp_alloc_subrel ()
{
  obstack_free (mm_subrel, subrel_last_obj);
  subrel_list = subrel_list_last;
}

void free_subrel ()
{
  obstack_free (mm_subrel, subrel_first_obj);
  subrel_first_obj = (unsigned char *)obstack_alloc (mm_subrel, 0);
  subrel_list = NULL;
}

MQ_SubRel make_subrel (a1, a2, next)
     MQ_Atom a1, a2;
     MQ_SubRel next;
{
  MQ_SubRel new;

  new = (MQ_SubRel)obstack_alloc (mm_subrel, sizeof (MQ_SubRel_Rec));
  new->a1 = a1;
  new->a2 = a2;
  new->next = next;
  return new;
}
