/* Micro Quixote                 */
/* Copyright (C) 1993, 1994 ICOT */
/* Written by gniibe             */
/* $Id: rule.c,v 1.2 1994/09/19 02:09:57 m-gniibe Exp $ */

/* rule handling routines */

#include <stdio.h>
#include "obstack.h"
#include "mq.h"
#include "internal.h"
#include "extern.h"

MQ_RuleList rule_list, rule_list_last;
MQ_Rule mQ_variable_head_rule;
MQ_Rule mQ_void_rule;
MQ_RuleList mQ_void_rule_list;
MQ_Atom mqA_True;
MQ_Obj mqO_True;
MQ_NameVar mq_name;

static MQ_RuleList rule_list_last_last;
struct obstack *mm_rule;
static struct obstack rule_obstack;
static unsigned char *rule_first_obj, *rule_last_obj;
static int temp_alloc_rule;

void
init_rule ()
{
  mm_rule = &rule_obstack;
  obstack_begin (mm_rule, 0);

  init_constraints ();

  mqA_True = make_atom ((unsigned char *)"&true", mm_rule);
  mm_current = mm_rule;
  mqO_True = make_object (mqA_True, 0);
  temp_alloc_rule = FALSE;
  mQ_void_rule = make_rule ();
  mQ_void_rule_list = make_rule_list (mQ_void_rule, NULL, 0);
  mQ_void_rule->head = (MQ_VTerm)mqO_True;
  mqA_True->rule_list = mQ_void_rule_list;
  mq_name = make_name_var (1, NULL);
  mQ_variable_head_rule = NULL;

  rule_list = rule_list_last = mQ_void_rule_list;
  rule_first_obj = (unsigned char *)obstack_alloc (mm_rule, 0);
  mq_goal_true = make_goal ();
  mq_goal_true->goal_vterm = (MQ_VTerm)mqO_True;
}

void
begin_temp_alloc_rule ()
{
  temp_alloc_rule = TRUE;
  rule_list_last_last = rule_list_last;
  rule_last_obj = (unsigned char *)obstack_alloc (mm_rule, 0);
}

void
end_temp_alloc_rule ()
{
  temp_alloc_rule = FALSE;
  obstack_free (mm_rule, rule_last_obj);
  rule_list_last = rule_list_last_last;
  remove_temp_rule ();
}

void
free_rule ()
{
  obstack_free (mm_rule, rule_first_obj);
  rule_first_obj = (unsigned char *)obstack_alloc (mm_rule, 0);
  mQ_void_rule_list->next = NULL;
  mQ_variable_head_rule = NULL;
  rule_list = rule_list_last = mQ_void_rule_list;
}

MQ_Rule
make_rule ()
{
  MQ_Rule new;

  new = (MQ_Rule)obstack_alloc (mm_rule, sizeof (MQ_Rule_Rec));
  new->next = NULL;
  new->is_temp = temp_alloc_rule;
  new->head = NULL;
  new->body = NULL;
  new->head_cnstrs = new->body_cnstrs = mQ_void_cnstrs;
  new->var_list = NULL;
  return new;
}

MQ_RuleList
make_rule_list (rule, next, arity)
     MQ_Rule rule;
     MQ_RuleList next;
     int arity;
{
  MQ_RuleList new;

  new = (MQ_RuleList)obstack_alloc (mm_rule, sizeof (MQ_RuleList_Rec));
  new->next = next;
  new->is_temp = temp_alloc_rule;
  new->arity = arity;
  new->rule = new->last_rule = rule;
  return new;
}
