/* Micro Quixote                */
/* Copyright (C) 1993,1994 ICOT */
/* Written by gniibe            */
/* $Id: parse.y,v 1.3 1994/11/14 07:34:01 m-gniibe Exp $ */

/* Parser for the language `Micro Quixote' */

%{
#include <stdio.h>
#include "obstack.h"
#include "mq.h"
#include "internal.h"
#include "tree.h"
#include "extern.h"
#include "emit.h"

static MQT_Constraints head_cnstrs;
MQ_Query query;
int mq_as_library;
int end_of_file;
int error_recovering;
int reading_object;
MQT_Obj input_object;
%}
%start quixote
%pure_parser
%union { 
  int i;
  AttrRel       ar;
  Rel           sr;
  MQ_Atom       atom;
  MQT_AtomList  atom_list;

  MQT_Obj       obj;
  MQT_Dot       dot;
  MQT_Var       variable;

  MQT_Term      term;
  MQT_VTerm     vterm;

  MQT_VTermList	vterm_list;

  MQT_AttrList    attr_list;
  MQT_Constraints cnstrs;
}

%token ERROR_TOKEN

%token CLEAR LOAD QUERY QUIT SET SHOW
%token LEX_TRUE
%token PROGRAM RULE SUBSUMPTION END

%token PROGRAM_MODE QUERY_ONCE_MODE QUERY_MODE

%token <atom>     ATOM
%token <variable> VARIABLE

%token DOT
%token TERMINATER
%token SOLVE COMMITS CONSTRAINED

%token <sr>  SUBREL
%token <ar>  ATTRREL

%type <atom_list> atom_list
%type <vterm_list> body a_term_list
%type <attr_list> attribute_list
%type <vterm> vterm a_term
%type <term> term
%type <obj>  object

%type <dot>  dot_term
%{
extern int yylex _P((YYSTYPE *));
%}
%%

quixote:
	/* empty */
		{ end_of_file = TRUE; YYACCEPT; }
	| command
		{
		  set_mode_for_lex (MODE_COMMAND);
		  YYACCEPT;
		}
	| program
		{ YYACCEPT; }
	| query
		{ YYACCEPT; }
	| object
		{
		  if (!reading_object)
		    YYABORT;
		  input_object = $1;
		  YYACCEPT;
		}
	| error '.'
		{
		  free_parse_tree ();
		  yyerrok;
		  error_recovering = 0;
		  set_mode_for_lex (MODE_COMMAND);
		  YYABORT;
		}
	;

program:
	PROGRAM TERMINATER
		{
		  current_cnstrs = NULL;
		  set_mode_for_lex (MODE_PROGRAM);
		}
	| PROGRAM_MODE SUBSUMPTION TERMINATER
		{ set_mode_for_lex (MODE_PROGRAM); }
	| PROGRAM_MODE RULE TERMINATER
		/* these two are just for backward compatibility */
		{ set_mode_for_lex (MODE_PROGRAM); }
	| PROGRAM_MODE rule
		{
		  free_parse_tree ();
		  current_cnstrs = NULL;
		  set_mode_for_lex (MODE_PROGRAM);
		}
	| PROGRAM_MODE subsumption
		{
		  free_parse_tree ();
		  current_cnstrs = NULL;
		  set_mode_for_lex (MODE_PROGRAM);
		}
	| PROGRAM_MODE END 
		{
		  generate_lattice ();
		  set_mode_for_lex (MODE_EXPECT_PRD);
		}
	  '.'
		{ set_mode_for_lex (MODE_COMMAND); }
	| PROGRAM_MODE error TERMINATER
		{
		  yyerrok;
		  error_recovering = 0;
		  current_cnstrs = NULL;
		  set_mode_for_lex (MODE_PROGRAM);
		  YYABORT;
		}

subsumption:
	ATOM SUBREL ATOM TERMINATER
		{ emit_subrel ($2, $1, $3); }
	| ATOM SUBREL '{' atom_list '}' TERMINATER
		{
		  MQT_AtomList al;

		  for (al = $4; al; al = al->next)
		    emit_subrel ($2, $1, al->atom);
		}
	;

rule:	clause
	;

clause: a_term TERMINATER
		{ emit_rule ($1, current_cnstrs, NULL, NULL); }
	| a_term COMMITS
		{ head_cnstrs = current_cnstrs; current_cnstrs = NULL; }
	  body TERMINATER
		{ emit_rule ($1, head_cnstrs, $4, current_cnstrs); }
	;

body:
	a_term_list
	| a_term_list CONSTRAINED '{' constraint_list '}'
	;

a_term_list:
	a_term
		{ $$ = makeT_vterm_list ($1, NULL); }
	| a_term_list ',' a_term
		{ $$ = makeT_vterm_list ($3, $1); }
	;

a_term:
	vterm
		{ $$ = $1; }
	| vterm '/' '[' attribute_list ']'
		{
		  MQT_AttrList atl;

		  for (atl = $4; atl; atl = atl->next)
		    {
		      MQT_Dot dot;

		      dot = makeT_dot ((MQT_Term)$1, atl->label);
		      current_cnstrs
			= makeT_constraints (Congruent, (MQT_Term)dot,
					     (MQT_Term)atl->vterm, NULL,
					     current_cnstrs);
		    }
		  $$ = $1;
		}
	| vterm '|' '{' constraint_list '}'
		{ $$ = $1; }
	| vterm '/' '[' attribute_list ']' '|' '{' constraint_list '}'
		{
		  MQT_AttrList atl;

		  for (atl = $4; atl; atl = atl->next)
		    {
		      MQT_Dot dot;

		      dot = makeT_dot ((MQT_Term)$1, atl->label);
		      current_cnstrs
			= makeT_constraints (Congruent, (MQT_Term)dot,
					     (MQT_Term)atl->vterm, NULL,
					     current_cnstrs);
		    }
		  $$ = $1;
		}
	;

attribute_list:
	ATOM ATTRREL term
		{ $$ = makeT_attr_list ($2, $1, (MQT_VTerm)$3, NULL); }
	| attribute_list ',' ATOM ATTRREL term
		{ $$ = makeT_attr_list ($4, $3, (MQT_VTerm)$5, $1); }

constraint_list:
	term SUBREL term
		{
		  MQ_Atom op;

		  if ($2 == ExternalCnstr)
		    op = external_cnstr_op;
		  else
		    op = NULL;
		  current_cnstrs
		    = makeT_constraints ($2, $1, $3, op, current_cnstrs);
		}
	| constraint_list ',' term SUBREL term
		{
		  MQ_Atom op;

		  if ($4 == ExternalCnstr)
		    op = external_cnstr_op;
		  else
		    op = NULL;
		  current_cnstrs =
		    makeT_constraints ($4, $3, $5, op, current_cnstrs);
		}
	;

vterm:
	object
		{ $$ = (MQT_VTerm) $1; }
	| VARIABLE
		{ $$ = (MQT_VTerm) $1; }
	;

term:
	object
		{ $$ = (MQT_Term) $1; }
	| dot_term
		{ $$ = (MQT_Term) $1; }
	| VARIABLE
		{ $$ = (MQT_Term) $1; }
	;

object:
	ATOM
		{ $$ = makeT_object ($1, NULL); }
	| ATOM '[' attribute_list ']'
		{ $$ = makeT_object ($1, $3); }
	| LEX_TRUE
		{ $$ = mqTO_True; }
	;

dot_term:
	term DOT ATOM
		{ $$ = makeT_dot ($1, $3); }
	;

atom_list:
	ATOM
		{ $$ = makeT_atom_list ($1, NULL); }
	| atom_list ',' ATOM
		{ $$ = makeT_atom_list ($3, $1); }
	;

query:
	SOLVE
		{
		  current_cnstrs = NULL;
		  set_mode_for_lex (MODE_QUERY_ONCE);
		}
	| QUERY_ONCE_MODE body '.'
		{
		  begin_exec ();
		  emit_body ($2, current_cnstrs, &query);
		  free_parse_tree ();
		  if (mq_as_library)
		    YYACCEPT;
		  do_query ();
		  end_exec ();
		  set_mode_for_lex (MODE_COMMAND);
		}
	| QUERY_ONCE_MODE error '.'
		{
		  free_parse_tree ();
		  yyerrok;
		  error_recovering = 0;
		  end_exec ();
		  if (temporary)
		    end_tmp ();
		  set_mode_for_lex (MODE_COMMAND);
		  YYABORT;
		}
	| QUERY TERMINATER
		{
		  current_cnstrs = NULL;
		  set_mode_for_lex (MODE_QUERY);
		}
	| QUERY_MODE body '.'
		{
		  begin_exec ();
		  emit_body ($2, current_cnstrs, &query);
		  free_parse_tree ();
		  do_query ();
		  end_exec ();
		  set_mode_for_lex (MODE_QUERY);
		}
	| QUERY_MODE END '.'
		{
		  set_mode_for_lex (MODE_COMMAND);
		}
	| QUERY_MODE error '.'
		{
		  free_parse_tree ();
		  yyerrok;
		  error_recovering = 0;
		  end_exec ();
		  if (temporary)
		    end_tmp ();
		  set_mode_for_lex (MODE_QUERY);
		  YYABORT;
		}

command:
	set_command
	| load_command
	| clear_command
	| show_command
	| quit_command
	;

set_command:
	SET  TERMINATER
		{ cmd_set (NULL, NULL); }
	| SET ATOM  TERMINATER
		{ cmd_set ($2, NULL); }
	| SET ATOM ATOM  TERMINATER
		{ cmd_set ($2, $3); }
	;

load_command:
	LOAD ATOM  TERMINATER
		{ cmd_load ($2); }
	;

clear_command:
	CLEAR  TERMINATER
		{ cmd_clear (NULL); }
	| CLEAR ATOM  TERMINATER
		{ cmd_clear ($2); }
	;

show_command:
	SHOW  TERMINATER
		{ cmd_show (NULL); }
	| SHOW ATOM  TERMINATER
		{ cmd_show ($2); }
	;

quit_command:
	QUIT  TERMINATER
		{ cmd_quit (); }
	;
%%
int
yyerror (message)
     char *message;
{
  error_recovering = 1;
  if (interactive)
    fprintf (stderr, " %s\n", message);
  else
    fprintf (stderr, "%d: %s\n", lineno, message);
  return 0;
}
