/* Micro Quixote                 */
/* Copyright (C) 1993, 1994 ICOT */
/* Written by gniibe             */
/* $Id: mq.c,v 1.3 1994/11/14 07:31:16 m-gniibe Exp $ */

/* main routine */

#include <stdio.h>

#ifdef THINK_C
#include <console.h>
#include <unix.h>
#else
#include <unistd.h>
#endif

#include "mq.h"
#include "internal.h"
#include "tree.h"
#include "extern.h"

int
main (argc, argv)
     int argc;
     char *argv[];
{
  int i;

#ifdef THINK_C
  argc = ccommand (&argv);	/* simulate command-line arguments */
#endif

  initialize (FALSE);

  for (i=1; i<argc; i++)
    {
      if (!strcmp (argv[i], "-i"))
	force_interactive = TRUE;
      else if (!strcmp (argv[i], "-quit"))
	exit (0);
      else if (!strcmp (argv[i], "-nolookup"))
	mq_opt_lookup = 0;
      else if (!strcmp (argv[i], "-noassumption"))
	mq_opt_proc_mode = PROC_SINGLE;
      else if (!strcmp (argv[i], "-debug"))
	mq_opt_answer_print = 1;
      else
	{
	  push_file (argv[i]);
	  end_of_file = FALSE;
	  while (1)
	    {
	      yyparse ();
	      if (end_of_file)
		if (pop_file () == 0)
		  break;
		else
		  end_of_file = FALSE;
	    }
	}
    }

  end_of_file = FALSE;
  set_input_file (stdin);
  if (force_interactive)
    init_interactive (TRUE);
  else
    init_interactive (interactive_orig);

  while (1)
    {
      output_prompt_at_bol ();
      yyparse ();
      if (end_of_file)
	if (pop_file () == 0)
	  break;
	else
	  end_of_file = FALSE;
    }

  return 0;
}
