/* Micro Quixote                 */
/* Copyright (C) 1993, 1994 ICOT */
/* Written by gniibe             */
/* $Id: internal.h,v 1.2 1994/09/19 02:07:33 m-gniibe Exp $ */

/* structure definition of internal objects */

typedef enum Rel { Supersumes=-1, Congruent, Subsumes,
		   ExternalExpr, ExternalCnstr,
		   DotCongruent,
		   DotCongruentVar, DotCongruentObj,
		   SubsumesVarVar, SubsumesVarObj, SubsumesObjVar
		 } Rel;

typedef enum TermType { TT_Var, TT_Dot, TT_Obj, TT_NameVar } TermType;

typedef enum GoalType { GT_General, GT_Through, GT_Once, GT_Done,
			GT_Attribute } GoalType;

/* Allocated in mm_exec, or mm_rule */

typedef struct MQ_Atom_Rec {
  struct MQ_Atom_Rec *next_bucket;
  struct MQ_RuleList_Rec *rule_list;
  int lattice_index;
  unsigned char name[1];
} MQ_Atom_Rec, *MQ_Atom;

typedef struct MQ_Attr_Rec {
  struct MQ_Atom_Rec *label;
  union MQ_VTerm_Rec *vterm;
} MQ_Attr_Rec, *MQ_Attr;

typedef struct MQ_Obj_Rec {
  TermType type;

  struct MQ_Atom_Rec *atom;
  int arity;
  MQ_Attr_Rec attr[1];
} MQ_Obj_Rec, *MQ_Obj;

#define PROTECTED ((union MQ_VTerm_Rec *)-1)
typedef struct MQ_Var_Rec {
  TermType type;

  union MQ_VTerm_Rec *value;	/* this helps me debug :-) */
  struct MQ_VTermAddrList_Rec *vterm_addr_list;
  struct MQ_VarList_Rec *var_list;
} MQ_Var_Rec, *MQ_Var;

typedef struct MQ_VarList_Rec {
  struct MQ_VarList_Rec *next;
  struct MQ_Var_Rec *var;
} MQ_VarList_Rec, *MQ_VarList;

typedef struct MQ_NameVar_Rec {
  TermType type;

  int number;
  char name[1];
} MQ_NameVar_Rec, *MQ_NameVar;

typedef struct MQ_Dot_Rec {
  TermType type;

  union MQ_VTerm_Rec *vterm;
  struct MQ_Atom_Rec *label;
} MQ_Dot_Rec, *MQ_Dot;

typedef union MQ_VTerm_Rec {
  TermType type;
  MQ_NameVar_Rec name_var;
  MQ_Var_Rec var;
  MQ_Obj_Rec obj;
} MQ_VTerm_Rec, *MQ_VTerm;

typedef struct MQ_VTermList_Rec {
  struct MQ_VTermList_Rec *next;
  union MQ_VTerm_Rec *vterm;
} MQ_VTermList_Rec, *MQ_VTermList;

typedef union MQ_Term_Rec {
  TermType type;
  MQ_Dot_Rec dot;
  MQ_NameVar_Rec name_var;
  MQ_Var_Rec var;
  MQ_Obj_Rec obj;
} MQ_Term_Rec, *MQ_Term;

/* Allocated in mm_rule */

typedef struct MQ_Rule_Rec {
  struct MQ_Rule_Rec *next;

  int is_temp;
  union MQ_VTerm_Rec *head;
  struct MQ_Constraints_Rec *head_cnstrs;
  struct MQ_VTermList_Rec *body;
  struct MQ_Constraints_Rec *body_cnstrs;
  struct MQ_VarList_Rec *var_list;
} MQ_Rule_Rec, *MQ_Rule;

typedef struct MQ_RuleList_Rec {
  struct MQ_RuleList_Rec *next;
  int arity;
  int is_temp;
  struct MQ_Rule_Rec *rule, *last_rule;
} MQ_RuleList_Rec, *MQ_RuleList;

/* allocated under the control of subsumption routine */
/* allocated in mm_subrel */
typedef struct MQ_SubRel_Rec {
  struct MQ_SubRel_Rec *next;
  struct MQ_Atom_Rec *a1, *a2;
} MQ_SubRel_Rec, *MQ_SubRel;

/* allocated in mm_exec */
typedef struct IJ_List_Rec {
  struct IJ_List_Rec *next;
  int i, j;
} IJ_List_Rec, *IJ_List;

typedef struct MQ_AtomList_Rec {
  struct MQ_AtomList_Rec *next;
  struct MQ_Atom_Rec *atom;
} MQ_AtomList_Rec, *MQ_AtomList;

typedef struct MQ_AtomSet_Rec {
  struct MQ_AtomSet_Rec *next_bucket;
  struct MQ_AtomList_Rec *atom_list;
} MQ_AtomSet_Rec, *MQ_AtomSet;

typedef struct MQ_AtomAtomSet_Rec {
  struct MQ_AtomAtomSet_Rec *next;
  struct MQ_Atom_Rec *atom;
  struct MQ_AtomList_Rec *atom_list;
} MQ_AtomAtomSet_Rec, *MQ_AtomAtomSet;

/* Allocated in mm_cnstrs, mm_rule, or mm_exec */

typedef struct MQ_Constraint_Rec {
  Rel rel;
  union MQ_Term_Rec *term;
  union MQ_VTerm_Rec *vterm;

  /* for garbage collection */
  int mark;
} MQ_Constraint_Rec, *MQ_Constraint;

typedef struct MQ_Constraints_Rec {
  struct MQ_Constraints_Rec *next;
  struct MQ_Constraint_Rec *cnstr;

  struct MQ_Constraints_Rec *prev;
  struct MQ_VarList_Rec *l_var_list, *r_var_list;
} MQ_Constraints_Rec, *MQ_Constraints;

/* Allocated in mm_exec */

typedef struct MQ_CnstrsAsmpts_Rec {
  struct MQ_Constraints_Rec *dot_cnstrs, *dot_asmpts, *dot_hchcks, *dot_bchcks;
  struct MQ_Constraints_Rec *sub_cnstrs, *sub_asmpts, *sub_hchcks, *sub_bchcks;
  struct MQ_Constraints_Rec *ext_cnstrs, *ext_asmpts, *ext_hchcks, *ext_bchcks;
} MQ_CnstrsAsmpts_Rec, *MQ_CnstrsAsmpts;

/* Allocated in mm_exec */

typedef struct MQ_Lookup_Rec {
  int entry;

  union MQ_VTerm_Rec *head;
  struct MQ_VTermList_Rec *body;
  struct MQ_Constraints_Rec *head_cnstrs, *body_cnstrs;
} MQ_Lookup_Rec, *MQ_Lookup;

typedef struct MQ_VarNameList_Rec {
  struct MQ_VarNameList_Rec *next;
  struct MQ_NameVar_Rec *name_var;
  union MQ_VTerm_Rec *vterm;
} MQ_VarNameList_Rec, *MQ_VarNameList;

typedef struct MQ_VTermAddrList_Rec {
  struct MQ_VTermAddrList_Rec *next;
  union MQ_VTerm_Rec **vterm_addr;
} MQ_VTermAddrList_Rec, *MQ_VTermAddrList;

typedef enum RuleApply { RA_VariableHeadRule,
			 RA_AllRule, RA_ObjRule } RuleApply;

typedef struct MQ_Goal_Rec {
  GoalType type;
  RuleApply apply;
  struct MQ_Goal_Rec *prev, *next, *subgoal, *parent;

  unsigned char *keep_clean;
  struct UnwindProtect_Rec *up;
  struct MQ_CnstrsAsmpts_Rec *cnstrs_asmpts;
  struct MQ_Lookup_Rec *lookup;

  union MQ_VTerm_Rec *goal_vterm;

  struct MQ_Rule_Rec *rule;
  struct MQ_RuleList_Rec *rule_list;

  union MQ_VTerm_Rec *head;
  struct MQ_Constraints_Rec *head_cnstrs, *body_cnstrs;

  struct MQ_VTermList_Rec *var_list;
} MQ_Goal_Rec, *MQ_Goal;

typedef struct MQ_Query_Rec {
  struct MQ_Goal_Rec *goal;
  struct MQ_VTermList_Rec *body;
  struct MQ_VarList_Rec *var_list;
  struct MQ_VarNameList_Rec *var_name_list;
} MQ_Query_Rec, *MQ_Query;

/* Allocated in mm_unwind */

typedef struct UnwindProtect_Rec {
  struct UnwindProtect_Rec *next;
  struct MQ_Var_Rec *var;
  struct MQ_VTermAddrList_Rec *vterm_addr_list;
} UnwindProtect_Rec, *UnwindProtect;

extern MQ_Obj make_object _P((MQ_Atom, int));
extern MQ_Var make_variable _P((void));
extern MQ_VarList make_var_list _P((MQ_Var, MQ_VarList));
extern MQ_NameVar make_name_var _P((int, unsigned char *));
extern MQ_Dot make_dot _P((MQ_Atom));
extern MQ_VTermList make_vterm_list _P((MQ_VTermList));
extern IJ_List make_ij_list _P((int, int, IJ_List));
extern MQ_VarNameList make_var_name_list _P((MQ_Var, MQ_NameVar, MQ_VarNameList));
extern MQ_VTermAddrList make_vterm_addr_list _P((MQ_VTerm *, MQ_VTermAddrList));
extern MQ_Goal make_goal _P((void));
extern MQ_Query make_query _P((void));
