/* Micro Quixote                 */
/* Copyright (C) 1993, 1994 ICOT */
/* Written by gniibe             */
/* $Id: internal.c,v 1.2 1994/09/19 02:07:23 m-gniibe Exp $ */

/* internal objects allocation routines */

#include <stdio.h>
#include <stdlib.h>
#include "obstack.h"
#include "mq.h"
#include "internal.h"
#include "extern.h"

MQ_Obj
make_object (atom, arity)
     MQ_Atom atom;
     int arity;
{
  MQ_Obj new;
  int i;

  new = (MQ_Obj)obstack_alloc (mm_current, sizeof (MQ_Obj_Rec)
			       + sizeof (MQ_Attr_Rec)*(arity -1));
  new->type = TT_Obj;
  new->atom = atom;
  new->arity = arity;
  for (i=0; i < arity; i++)
    new->attr[i].label = NULL, new->attr[i].vterm = NULL;
  return new;
}

MQ_Var
make_variable ()
{
  MQ_Var new;

  new = (MQ_Var) obstack_alloc (mm_current, sizeof (MQ_Var_Rec));
  new->type = TT_Var;
  new->value = NULL;
  new->vterm_addr_list = NULL;
  new->var_list = NULL;
  return new;
}

MQ_VarList
make_var_list (var, next)
     MQ_Var var;
     MQ_VarList next;
{
  MQ_VarList new;

  new = (MQ_VarList) obstack_alloc (mm_current, sizeof (MQ_VarList_Rec));
  new->next = next;
  new->var = var;
  return new;
}

/* NameVar is allocated in mm_exec or mm_lookup */
MQ_NameVar
make_name_var (number, string)
     int number;
     unsigned char *string;
{
  MQ_NameVar new;
  int len;

  if (number)
    new = (MQ_NameVar)obstack_alloc (mm_current, sizeof (MQ_NameVar_Rec));
  else
    {
      if (string == NULL)
	fatal ("don't give me NULL in make_name_var\n");

      len = strlen(string);
      new = (MQ_NameVar)obstack_alloc (mm_current,
				       sizeof (MQ_NameVar_Rec)+len);
      strcpy (new->name, string);
    }
  new->type = TT_NameVar;
  new->number = number;
  return new;
}

MQ_Dot
make_dot (label)
     MQ_Atom label;
{
  MQ_Dot new;

  new = (MQ_Dot) obstack_alloc (mm_current, sizeof (MQ_Dot_Rec));
  new->type = TT_Dot;
  new->vterm = NULL;
  new->label = label;
  return new;
}

MQ_VTermList
make_vterm_list (next)
     MQ_VTermList next;
{
  MQ_VTermList new;

  new = (MQ_VTermList) obstack_alloc (mm_current, sizeof (MQ_VTermList_Rec));
  new->vterm = NULL;
  new->next = next;
  return new;
}

IJ_List
make_ij_list (i, j, next)
     int i, j;
     IJ_List next;
{
  IJ_List new;

  new = (IJ_List) obstack_alloc (mm_exec, sizeof (IJ_List_Rec));
  new->next = next;
  new->i = i;
  new->j = j;
  return new;
}

MQ_VarNameList
make_var_name_list (var, name_var, next)
     MQ_Var var;
     MQ_NameVar name_var;
     MQ_VarNameList next;
{
  MQ_VarNameList new;

  new = (MQ_VarNameList) obstack_alloc (mm_exec, sizeof (MQ_VarNameList_Rec));
  new->name_var = name_var;
  new->next = next;
  new->vterm = (MQ_VTerm)var;
  if (var)			/* executing == 1 here */
    var->vterm_addr_list
      = make_vterm_addr_list (&new->vterm, var->vterm_addr_list);
  return new;
}

MQ_VTermAddrList
make_vterm_addr_list (vterm_p, next)
     MQ_VTerm *vterm_p;
     MQ_VTermAddrList next;
{
  MQ_VTermAddrList new;

  new = (MQ_VTermAddrList) obstack_alloc (mm_exec,
					  sizeof (MQ_VTermAddrList_Rec));
  new->vterm_addr = vterm_p;
  new->next = next;
  return new;
}

MQ_Goal
make_goal ()
{
  MQ_Goal new;

  new = (MQ_Goal) obstack_alloc (mm_exec, sizeof(MQ_Goal_Rec));
  new->type = GT_General;
  new->apply = RA_ObjRule;
  new->prev = new->next = new->subgoal = new->parent = NULL;
  new->keep_clean = NULL;
  new->up = NULL;
  new->cnstrs_asmpts = NULL;
  new->lookup = NULL;
  new->goal_vterm = NULL;
  new->rule = NULL;
  new->rule_list = NULL;
  new->head = NULL;
  new->head_cnstrs = new->body_cnstrs = mQ_void_cnstrs;
  new->var_list = NULL;
  return new;
}

MQ_Query
make_query ()
{
  MQ_Query new;

  new = (MQ_Query) obstack_alloc (mm_exec, sizeof (MQ_Query_Rec));
  new->goal = NULL;
  new->body = NULL;
  new->var_list = NULL;
  new->var_name_list = NULL;
  return new;
}

void *
xmalloc (size)
     unsigned int size;
{
  void *ptr;

  ptr = malloc (size);
  if (ptr)
    return ptr;
  fatal ("memory exhausted.\n");
}

void *
xrealloc (ptr, size)
     void *ptr;
     unsigned int size;
{
  void *ptr1;

  ptr1 = realloc (ptr, size);
  if (ptr)
    return ptr;
  fatal ("memory exhausted.\n");
}

void
xfree (ptr)
     void *ptr;
{
  if (!debug_memory)
    free (ptr);
}
