/* Micro Quixote                 */
/* Copyright (C) 1993, 1994 ICOT */
/* Written by gniibe             */
/* $Id: emit.c,v 1.2 1994/09/19 02:06:21 m-gniibe Exp $ */

/* `emit' routines */

#include <stdio.h>
#include "obstack.h"
#include "mq.h"
#include "internal.h"
#include "tree.h"
#include "extern.h"

/* function prototype for debugging */
static void emit_var _P((MQT_Var, MQ_VTerm *, MQ_VarList *));
static void emit_dot _P((MQT_Dot, MQ_Dot *, MQ_VarList *));
static void emit_vterm _P((MQT_VTerm, MQ_VTerm *, MQ_VarList *));
static void emit_term _P((MQT_Term, MQ_Term *, MQ_VarList *));
static void emit_attr_list _P((MQT_AttrList, MQ_Obj, MQ_VarList *));
static void emit_constraints _P((MQT_Constraints, MQ_Constraints *, MQ_VarList *));
static void emit_vterm_list _P((MQT_VTermList, MQ_VTermList *, MQ_VarList *));
static int check_subrel _P((MQ_Atom, MQ_Atom, MQ_SubRel));

void
emit_obj (t_obj, obj_p, var_list_p)
     MQT_Obj t_obj;
     MQ_Obj *obj_p;
     MQ_VarList *var_list_p;
{     
  MQ_Obj obj;
  int arity;
  MQT_AttrList t_atl;

  if (t_obj == mqTO_True)
    {
      *obj_p = mqO_True;
      return;
    }

  t_atl = t_obj->attr_list;
  for (arity = 0; t_atl; t_atl = t_atl->next)
    arity++;

  obj = make_object (t_obj->atom, arity);
  t_atl = t_obj->attr_list;
  emit_attr_list (t_atl, obj, var_list_p);
  *obj_p = obj;
}

static void
emit_var (tv, var_p, var_list_p)
     MQT_Var tv;
     MQ_VTerm *var_p;
     MQ_VarList *var_list_p;
{
  MQ_Var var;

  if ((var = tv->var) == NULL)
    {
      tv->var = var = make_variable ();
      *var_list_p = make_var_list (var, *var_list_p);
    }
  if (executing)
    var->vterm_addr_list
      = make_vterm_addr_list (var_p, var->vterm_addr_list);

  *var_p = (MQ_VTerm)tv->var;
}

static void
emit_dot (t_dot, dot_p, var_list_p)
     MQT_Dot t_dot;
     MQ_Dot *dot_p;
     MQ_VarList *var_list_p;
{
  *dot_p = make_dot (t_dot->label);
  emit_vterm (t_dot->vterm, &(*dot_p)->vterm, var_list_p);
}

static void
emit_vterm (t_vterm, vterm_p, var_list_p)
     MQT_VTerm t_vterm;
     MQ_VTerm *vterm_p;
     MQ_VarList *var_list_p;
{
  switch (t_vterm->type)
    {
    case TT_Var:
      emit_var ((MQT_Var)t_vterm, vterm_p, var_list_p);
      break;
    case TT_Obj:
      emit_obj ((MQT_Obj)t_vterm, (MQ_Obj *)vterm_p, var_list_p);
      break;
    default:
      fatal ("emit_vterm\n");
      break;
    }
}

static void
emit_term (t_term, term_p, var_list_p)
     MQT_Term t_term;
     MQ_Term *term_p;
     MQ_VarList *var_list_p;
{
  switch (t_term->type)
    {
    case TT_Var:
      emit_var ((MQT_Var)t_term, (MQ_VTerm *)term_p, var_list_p);
      break;
    case TT_Obj:
      emit_obj ((MQT_Obj)t_term, (MQ_Obj *)term_p, var_list_p);
      break;
    case TT_Dot:
      emit_dot ((MQT_Dot)t_term, (MQ_Dot *)term_p, var_list_p);
      break;
    default:
      fatal ("emit_term\n");
      break;
    }
}

static void
emit_attr_list (atl, obj, var_list_p)
     MQT_AttrList atl;
     MQ_Obj obj;
     MQ_VarList *var_list_p;
{
  int i;

  for (i=0; atl; atl = atl->next, i++)
    {
      obj->attr[i].label = atl->label;
      emit_vterm ((MQT_VTerm)atl->vterm, &obj->attr[i].vterm, var_list_p);
    }
}

static void
emit_constraints (t_cnstrs, cnstrs_p, var_list_p)
     MQT_Constraints t_cnstrs;
     MQ_Constraints *cnstrs_p;
     MQ_VarList *var_list_p;
{
  MQ_Constraints cnstrs = *cnstrs_p;
  MQ_Constraint cnstr;

  while (t_cnstrs)
    {
      Rel rel;
      MQ_Var var, var1;

      switch (t_cnstrs->term1->type)
	{
	case TT_Dot:
	  switch (t_cnstrs->term2->type)
	    {
	    case TT_Dot:
	      rel = t_cnstrs->rel;
	      var = make_variable ();
	      var1 = make_variable ();
	      *var_list_p = make_var_list (var, *var_list_p);
	      *var_list_p = make_var_list (var1, *var_list_p);
	      cnstr = make_cnstr (DotCongruent, NULL, (MQ_VTerm)var);
	      cnstrs = make_cnstrs (cnstr, cnstrs);
	      emit_term (t_cnstrs->term1, &cnstr->term, var_list_p);
	      cnstr = make_cnstr (DotCongruent, NULL, (MQ_VTerm)var1);
	      cnstrs = make_cnstrs (cnstr, cnstrs);
	      emit_term (t_cnstrs->term2, &cnstr->term, var_list_p);
	      switch (rel)
		{
		case Subsumes:
		case Congruent:
		case ExternalExpr:
		  cnstr = make_cnstr (rel, (MQ_Term)var, (MQ_VTerm)var1);
		  break;
		case Supersumes:
		  cnstr = make_cnstr (Subsumes, (MQ_Term)var1, (MQ_VTerm)var);
		  break;
		case ExternalCnstr:
		  {
		    MQ_Obj obj;

		    obj = make_object (t_cnstrs->op, 2);
		    obj->attr[0].label = NULL;
		    obj->attr[0].vterm = (MQ_VTerm)var;
		    if (executing)
		      var->vterm_addr_list
			= make_vterm_addr_list (&obj->attr[0].vterm,
						var->vterm_addr_list);
		    obj->attr[1].label = NULL;
		    obj->attr[1].vterm = (MQ_VTerm)var1;
		    if (executing)
		      var1->vterm_addr_list
			= make_vterm_addr_list (&obj->attr[1].vterm,
						var1->vterm_addr_list);
		    cnstr = make_cnstr (ExternalCnstr, (MQ_Term)mqO_True,
					(MQ_VTerm)obj);
		  }
		  break;

		default:
		  fatal ("emit_constraints\n");
		  break;
		}
	      cnstrs = make_cnstrs (cnstr, cnstrs);
	      break;

	    case TT_Obj:
	    case TT_Var:
	      rel = t_cnstrs->rel;
	      switch (rel)
		{
		case Congruent:
		  cnstr = make_cnstr (DotCongruent, NULL, NULL);
		  cnstrs = make_cnstrs (cnstr, cnstrs);
		  emit_term (t_cnstrs->term1, &cnstr->term, var_list_p);
		  emit_vterm ((MQT_VTerm)t_cnstrs->term2,
			      &cnstr->vterm, var_list_p);
		  break;
		case ExternalExpr:
		case Subsumes:
		  var = make_variable ();
		  *var_list_p = make_var_list (var, *var_list_p);
		  cnstr = make_cnstr (DotCongruent, NULL, (MQ_VTerm)var);
		  cnstrs = make_cnstrs (cnstr, cnstrs);
		  emit_term (t_cnstrs->term1, &cnstr->term, var_list_p);
		  cnstr = make_cnstr (rel, (MQ_Term)var, NULL);
		  emit_vterm ((MQT_VTerm)t_cnstrs->term2,
			      &cnstr->vterm, var_list_p);
		  cnstrs = make_cnstrs (cnstr, cnstrs);
		  break;
		case Supersumes:
		  var = make_variable ();
		  *var_list_p = make_var_list (var, *var_list_p);
		  cnstr = make_cnstr (DotCongruent, NULL, (MQ_VTerm)var);
		  cnstrs = make_cnstrs (cnstr, cnstrs);
		  emit_term (t_cnstrs->term1, &cnstr->term, var_list_p);
		  cnstr = make_cnstr (Subsumes, NULL, (MQ_VTerm)var);
		  emit_term (t_cnstrs->term2, &cnstr->term, var_list_p);
		  cnstrs = make_cnstrs (cnstr, cnstrs);
		  break;
		case ExternalCnstr:
		  {
		    MQ_Obj obj;

		    var = make_variable ();
		    *var_list_p = make_var_list (var, *var_list_p);
		    cnstr = make_cnstr (DotCongruent, NULL, (MQ_VTerm)var);
		    cnstrs = make_cnstrs (cnstr, cnstrs);
		    emit_term (t_cnstrs->term1, &cnstr->term, var_list_p);
		    obj = make_object (t_cnstrs->op, 2);
		    obj->attr[0].label = NULL;
		    obj->attr[0].vterm = (MQ_VTerm)var;
		    if (executing)
		      var->vterm_addr_list
			= make_vterm_addr_list (&obj->attr[0].vterm,
						var->vterm_addr_list);
		    obj->attr[1].label = NULL;
		    emit_vterm ((MQT_VTerm)t_cnstrs->term2,
				&obj->attr[1].vterm, var_list_p);
		    cnstr = make_cnstr (ExternalCnstr, (MQ_Term)mqO_True,
					(MQ_VTerm)obj);
		    cnstrs = make_cnstrs (cnstr, cnstrs);
		  }
		  break;

		default:
		  fatal ("emit_constraints\n");
		  break;
		}
	      break;
	    case TT_NameVar:
	    default:
	      fatal ("emit_constraints\n");
	      break;
	    }
	  break;

	case TT_Obj:
	case TT_Var:
	  switch (t_cnstrs->term2->type)
	    {
	    case TT_Dot:
	      rel = t_cnstrs->rel;
	      var = make_variable ();
	      *var_list_p = make_var_list (var, *var_list_p);
	      cnstr = make_cnstr (DotCongruent, NULL, (MQ_VTerm)var);
	      cnstrs = make_cnstrs (cnstr, cnstrs);
	      emit_term (t_cnstrs->term2, &cnstr->term, var_list_p);
	      switch (rel)
		{
		case Congruent:
		case Subsumes:
		case ExternalExpr:
		  cnstr = make_cnstr (rel, NULL, (MQ_VTerm)var);
		  emit_term (t_cnstrs->term1, &cnstr->term, var_list_p);
		  break;
		case Supersumes:
		  cnstr = make_cnstr (Subsumes, (MQ_Term)var, NULL);
		  emit_vterm ((MQT_VTerm)t_cnstrs->term1,
			      &cnstr->vterm, var_list_p);
		  break;
		case ExternalCnstr:
		  {
		    MQ_Obj obj;

		    obj = make_object (t_cnstrs->op, 2);
		    obj->attr[0].label = NULL;
		    emit_vterm ((MQT_VTerm)t_cnstrs->term1,
				&obj->attr[0].vterm, var_list_p);
		    obj->attr[1].label = NULL;
		    obj->attr[1].vterm = (MQ_VTerm)var;
		    if (executing)
		      var->vterm_addr_list
			= make_vterm_addr_list (&obj->attr[1].vterm,
						var->vterm_addr_list);
		    cnstr = make_cnstr (ExternalCnstr, (MQ_Term)mqO_True,
					(MQ_VTerm)obj);
		  }
		  break;

		default:
		  fatal ("emit_constraints\n");
		  break;
		}
	      cnstrs = make_cnstrs (cnstr, cnstrs);
	      break;

	    case TT_Obj:
	    case TT_Var:
	      rel = t_cnstrs->rel;
	      switch (rel)
		{
		case Congruent:
		case Subsumes:
		case ExternalExpr:
		  cnstr = make_cnstr (rel, NULL, NULL);
		  emit_term (t_cnstrs->term1, &cnstr->term, var_list_p);
		  emit_vterm ((MQT_VTerm)t_cnstrs->term2,
			      &cnstr->vterm, var_list_p);
		  break;
		case Supersumes:
		  cnstr = make_cnstr (Subsumes, NULL, NULL);
		  emit_term (t_cnstrs->term2, &cnstr->term, var_list_p);
		  emit_vterm ((MQT_VTerm)t_cnstrs->term1,
			      &cnstr->vterm, var_list_p);
		  break;
		case ExternalCnstr:
		  {
		    MQ_Obj obj;

		    obj = make_object (t_cnstrs->op, 2);
		    obj->attr[0].label = NULL;
		    emit_vterm ((MQT_VTerm)t_cnstrs->term1,
				&obj->attr[0].vterm, var_list_p);
		    obj->attr[1].label = NULL;
		    emit_vterm ((MQT_VTerm)t_cnstrs->term2,
				&obj->attr[1].vterm, var_list_p);
		    cnstr = make_cnstr (ExternalCnstr, (MQ_Term)mqO_True,
					(MQ_VTerm)obj);
		  }
		  break;

		default:
		  fatal ("emit_constraints\n");
		  break;
		}
	      cnstrs = make_cnstrs (cnstr, cnstrs);
	      break;
	    case TT_NameVar:
	    default:
	      fatal ("emit_constraint\n");
	      break;
	    }
	  break;
	case TT_NameVar:
	default:
	  fatal ("emit_constraint\n");
	  break;
	}
      t_cnstrs = t_cnstrs->next;
    }
  *cnstrs_p = cnstrs;
}

static void
emit_vterm_list (t_vtl, vtl_p, var_list_p)
     MQT_VTermList t_vtl;
     MQ_VTermList *vtl_p;
     MQ_VarList *var_list_p;
{
  MQ_VTermList vtl = NULL;

  while (t_vtl)
    {
      vtl = make_vterm_list (vtl);
      emit_vterm (t_vtl->vterm, &vtl->vterm, var_list_p);
      t_vtl = t_vtl->next;
    }
  *vtl_p = vtl;
}

void
emit_rule (t_head, head_t_cnstrs, t_body, body_t_cnstrs)
     MQT_VTerm t_head;
     MQT_VTermList t_body;
     MQT_Constraints head_t_cnstrs, body_t_cnstrs;
{
  MQ_Rule rule;
  MQ_Obj obj;
  MQ_RuleList rl, rl1;
  int arity;

  rule = make_rule ();
  rl = make_rule_list (rule, NULL, 0);
  rule_list_last->next = rl;
  rule_list_last = rl;

  emit_vterm (t_head, &rule->head, &rule->var_list);
  emit_vterm_list (t_body, &rule->body, &rule->var_list);
  emit_constraints (head_t_cnstrs, &rule->head_cnstrs, &rule->var_list);
  emit_constraints (body_t_cnstrs, &rule->body_cnstrs, &rule->var_list);

  if (rule->head->type != TT_Obj) /* TT_Var */
    {
      rule->next = mQ_variable_head_rule;
      mQ_variable_head_rule = rule;
    }
  else
    {
      obj = (MQ_Obj) rule->head;
      arity = obj->arity;
      rl = obj->atom->rule_list;

      if (rl)
	{
	  rl1 = NULL;
	  while (rl)
	    {
	      if (rl->arity >= arity)
		break;
	      rl1 = rl;
	      rl = rl->next;
	    }
	  if (rl && (rl->arity == arity))
	    rl->last_rule = rl->last_rule->next = rule;
	  else
	    if (rl1)
	      rl1->next = make_rule_list (rule, rl1->next, arity);
	  else
	    obj->atom->rule_list = make_rule_list (rule, rl, arity);
	}
      else
	obj->atom->rule_list = make_rule_list (rule, NULL, arity);
    }
}

void
emit_body (t_body, t_body_cnstrs, query_p)
     MQT_VTermList t_body;
     MQT_Constraints t_body_cnstrs;
     MQ_Query *query_p;
{
  MQ_Query query;
  MQ_Goal first_subgoal, subgoal, last_subgoal;
  MQ_VTermList vl;

  if (executing == 0)
    fatal ("executing == 0 in emit_body\n");

  query = make_query ();
  query->goal = make_goal ();
  query->goal->rule = mQ_void_rule;

  emit_vterm_list (t_body, &query->body, &query->var_list);
  emit_constraints (t_body_cnstrs,&query->goal->body_cnstrs,&query->var_list);

  first_subgoal = subgoal = NULL;
  for (vl = query->body; vl; vl = vl->next)
    {
      last_subgoal = subgoal;
      subgoal = make_goal ();
      subgoal->goal_vterm = vl->vterm;
      if (vl->vterm->type == TT_Var)
	{
	  ((MQ_Var)vl->vterm)->vterm_addr_list /* executing == 1 here */
	    = make_vterm_addr_list (&subgoal->goal_vterm,
				    ((MQ_Var)vl->vterm)->vterm_addr_list);
	}

      if (last_subgoal)
	last_subgoal->next = subgoal;
      else
	first_subgoal = subgoal;
    }
  query->goal->subgoal = first_subgoal;
  query->var_name_list = get_all_variables ();
  *query_p = query;
}

void
emit_subrel (op, a1, a2)
     Rel op;
     MQ_Atom a1, a2;
{
  switch (op)
    {
    case Subsumes:
      if (check_subrel (a1, a2, subrel_list) == SUCCESS)
	subrel_list = make_subrel (a1, a2, subrel_list);
      break;
    case Supersumes:
      if (check_subrel (a2, a1, subrel_list) == SUCCESS)
	subrel_list = make_subrel (a2, a1, subrel_list);
      break;
    default:
      error ("valid operators for subsumption relation are >= or =<.\n");
      break;
    }
}

static int
check_subrel (a1, a2, subrel_list)
     MQ_Atom a1, a2;
     MQ_SubRel subrel_list;
{
  MQ_SubRel sl;

  for (sl=subrel_list; sl; sl=sl->next)
    if ((sl->a1 == a1) && (sl->a2 == a2))
      {
	error ("subsumption already exists. (ignored)\n");
	return FAILURE;
      }
    else if ((sl->a1 == a2) && (sl->a2 == a1))
      {
	error ("contradiction in subsumption(s). (ignored).\n");
	return FAILURE;
      }

  return SUCCESS;
}
