/* Micro Quixote           */
/* Copyright (C) 1993 ICOT */
/* Written by gniibe       */
/* $Id: atom.c,v 1.2 1994/09/19 02:04:48 m-gniibe Exp $ */

/* atom handling routine */

#include <stdio.h>
#include "obstack.h"
#include "mq.h"
#include "internal.h"
#include "extern.h"

/* function prototype for debugging */
static int hash _P((unsigned char *));
static void remove_temp_rule_sub _P((MQ_RuleList));

static struct obstack atom_obstack;
struct obstack *mm_atom;
unsigned char *atom_first_obj;

#define ATOM_POOL_SIZE 511
static MQ_Atom atom_pool[ATOM_POOL_SIZE];

void init_atom ()
{
  int i;

  mm_atom = &atom_obstack;
  obstack_begin (mm_atom, 0);
  for (i=0; i < ATOM_POOL_SIZE; i++)
    atom_pool[i] = NULL;
}

void free_atom ()
{
  int i;
  MQ_Atom a, prev;

  for (i=0; i < ATOM_POOL_SIZE; i++)
    {
      prev = NULL;
      a=atom_pool[i];
      for (atom_pool[i]=NULL; a; a=a->next_bucket)
	if (a->lattice_index < -1 || a->lattice_index == 0
	    || a->lattice_index == 1)
	  {
	    if (prev)
	      prev->next_bucket = a;
	    else
	      atom_pool[i] = a;
	    prev = a;
	  }
      if (prev)
	prev->next_bucket = NULL;
    }
  obstack_free (mm_atom, atom_first_obj);
  atom_first_obj = (unsigned char *)obstack_alloc (mm_atom, 0);
}

MQ_Atom make_atom (string, mm)
     unsigned char *string;
     struct obstack *mm;
{
  MQ_Atom new;

  if (string == NULL)
    fatal ("don't give me NULL in make_atom\n");

  new = (MQ_Atom)obstack_alloc (mm, sizeof (MQ_Atom_Rec)+strlen(string));
  new->next_bucket = NULL;
  new->rule_list = NULL;
  new->lattice_index = -1;
  strcpy (new->name, string);
  return new;
}

static
int hash (ptr)
     unsigned char *ptr;
{
  unsigned char c;
  unsigned int hash = 0;

  while ((c = *ptr++))
    hash = (hash<<3) + (hash>>28) + (c&0x7f);
  return hash % ATOM_POOL_SIZE;
}

MQ_Atom intern_atom (string)
     unsigned char *string;
{
  MQ_Atom p, new;
  int val;

  val = hash (string);
  for (p = atom_pool[val]; p; p = p->next_bucket)
    if (!strcmp (string, p->name))
      return p;

  new = make_atom (string, mm_atom);
  new->next_bucket = atom_pool[val];
  atom_pool[val] = new;
  return new;
}

MQ_Atom system_atom (string)
     unsigned char *string;
{
  MQ_Atom new;

  new = intern_atom (string);
  new->lattice_index = -2;
  return new;
}

static
void remove_temp_rule_sub (rule_list)
     MQ_RuleList rule_list;
{
  MQ_Rule r, prev;

  prev = NULL;
  for (r=rule_list->rule; r; r=r->next)
    {
      if (r->is_temp == TRUE)
	break;
      prev = r;
    }
  if (prev == NULL)
    fatal ("something wrong in remove_temp_rule_sub\n");
  prev->next = NULL;
  rule_list->last_rule = prev;
}

void remove_temp_rule ()
{
  int i;
  MQ_Atom at;
  MQ_RuleList rl, rl1;

  for (i=0; i < ATOM_POOL_SIZE; i++)
    for (at = atom_pool[i]; at; at=at->next_bucket)
      {
	rl = at->rule_list;
	while (rl)
	  if (rl->is_temp == TRUE)
	    rl = rl->next;
	  else
	    {
	      remove_temp_rule_sub (rl);
	      break;
	    }
	at->rule_list = rl;
	if (rl)
	  while (rl)
	    {
	      if (rl->next)
		{
		  for (rl1=rl->next; rl1; rl1=rl1->next)
		    if (rl1->is_temp == FALSE)
		      {
			remove_temp_rule_sub (rl);
			break;
		      }
		  rl->next = rl1;
		}
	      rl = rl->next;
	    }
      }
}

void remove_rule ()
{
  int i;
  MQ_Atom at;

  for (i=0; i < ATOM_POOL_SIZE; i++)
    for (at = atom_pool[i]; at; at=at->next_bucket)
      at->rule_list = NULL;
}
