/* Micro Quixote           */
/* Copyright (C) 1994 ICOT */
/* Written by gniibe       */
/* $Id: api.c,v 1.2 1994/11/14 08:38:51 m-gniibe Exp $ */

/* Application Programming Interface of Micro Quixote */

#include <stdio.h>
#include <sys/types.h>
#include <sys/mman.h>

#include "mq.h"
#include "internal.h"
#include "tree.h"
#include "extern.h"

char *result;
char *stream_output;

int
initialize (library_p)
     int library_p;
{
  interactive = FALSE;
  temporary = 0;
  init_options ();
  init_atom ();
  init_lex ();
  init_subrel ();
  init_lookup ();
  init_unify ();
  init_exec ();
  init_rule ();
  init_tree ();
  init_lattice ();
  init_command ();		/* must be last */

  number_of_errors = 0;
  show_version ();

  interactive_orig = isatty (0);
  mq_as_library = library_p;

  if (library_p)
    {
      char *filename = tempnam (NULL, "mq");
      if (filename == NULL)
	return -1;
      if ((output = fopen (filename, "w+")) == NULL)
	return -1;
      unlink (filename);
      free (filename);

      stream_output = mmap (NULL, 32768, PROT_READ | PROT_WRITE, MAP_PRIVATE |MAP_AUTOGROW,
			    fileno (output), 0);
      if (stream_output < 0)
	return -1;
    }
  else
    output = stdout;

  return 0;
}

int
load_program (filename)
     char *filename;
{
  push_file (filename);

  while (1)
    {
      if (yyparse ())
	{
	  result = "something wrong in loading program.";
	  return -1;
	}
      if (end_of_file)
	if (pop_file () == 0)
	  break;
	else
	  end_of_file = FALSE;
    }
  return 0;
}

void
end_query ()
{
  end_exec ();

  set_mode_for_lex (MODE_COMMAND);
}
