/* -*-C++-*- */
#include <stdio.h>
#include <Xm/Xm.h>
#include <Xm/MainW.h>
#include <Xm/DrawingA.h>
#include <Xm/RowColumn.h>
#include <Xm/Form.h>
#include <Xm/Frame.h>
#include <Xm/ScrolledW.h>
#include <Xm/PushB.h>
#include "TextWidget.h"
#include "newclass.h"

#ifdef __STDC__
#define _P(x) x
#else
#define _P(x) ()
#define volatile
#endif
#define FALSE   0
#define TRUE    1
#define MQ_PROG "mq-008/src/pathwayDemo.qxt"

void parse(void);
void drawingAreaCallback(void);
void makeBitMaps(void);

void FileCB(Widget, int);
void EditCB(void);
void HelpCB(void);
void questionBox(Widget);

extern result;
extern "C" {
  void wprintf();
  extern int initialize _P((int));
  extern int load_program _P((char *));
}

Widget topLevel, base, textMessage, startButton;
line table;
Display *dpy;

String fallBacks[] = {
  "pathway*fontlist: \
   -adobe-courier-bold-r-normal--17-120-100-100-m-100-iso8859-1=courier17r", \
   NULL
};

static void x_error(Display *display, XErrorEvent *err_event)
{
  char buf[BUFSIZ];
  XGetErrorText(display, err_event->error_code, buf, sizeof buf);
  wprintf("X Error: <%s>\n", buf);
}

static void xt_error(char *message)
{
  wprintf("Xt Error: %s\n", message);
}

main(int argc, char **argv)
{
  Widget drawingA, pb;
  XtAppContext app;
  XGCValues gcv;
  GC gc;

  makeBitMaps();  // create original bitmaps

  Widget topLevel = XtVaAppInitialize(&app,"Pathway",NULL,0,&argc,argv,
				      fallBacks, NULL);
  dpy = XtDisplay(topLevel);
  // main window contains a MenuBar
  Widget mainW = XtVaCreateWidget("mainW",xmMainWindowWidgetClass, topLevel, 
				  XmNx, 0,
				  XmNy, 0,
				  XmNwidth,  820,
				  XmNheight, 984,
				  NULL);
  // Create a simple MenuBar
  XmString file = XmStringCreateSimple("File");
  XmString edit = XmStringCreateSimple("Edit");
  XmString help = XmStringCreateSimple("Help");
  Widget menuBar = XmVaCreateSimpleMenuBar(mainW, "menubar",
					   XmVaCASCADEBUTTON, file, 'F',
					   XmVaCASCADEBUTTON, edit, 'E',
					   XmVaCASCADEBUTTON, help, 'H',
					   NULL);
  XmStringFree(file);
  XmStringFree(edit);
  // don't free "help" compound string yet

  // Tell the menubar which button is the help menu
  Widget tmpWidget;
  if(tmpWidget = XtNameToWidget(menuBar, "button_2"))
    XtVaSetValues(menuBar, XmNmenuHelpWidget, tmpWidget, NULL);

  // First menu is the File menu -- callback is FileCB()
  XmString openFile = XmStringCreateSimple("Open");
  XmString quit = XmStringCreateSimple("Quit");
  XmVaCreateSimplePulldownMenu(menuBar, "filemenu", 
			       0, (XtCallbackProc)FileCB,
			       XmVaPUSHBUTTON, openFile, 'O', NULL, NULL,
			       XmVaSEPARATOR,
//			       1, (XtCallbackProc)FileCB,
			       XmVaPUSHBUTTON, quit, 'Q', NULL, NULL,
			       NULL);
  XmStringFree(openFile);
  XmStringFree(quit);

  // Second menu is the Edit menu -- callback is EditCB()
  XmString cut = XmStringCreateSimple("Cut");
  XmString copy = XmStringCreateSimple("Copy");
  XmString paste = XmStringCreateSimple("Paste");
  Widget editMenu = 
    XmVaCreateSimplePulldownMenu(menuBar, "editmenu", 1, 
				 (XtCallbackProc)EditCB,
				 XmVaPUSHBUTTON, cut,   'X', NULL, NULL,
				 XmVaPUSHBUTTON, copy,  'C', NULL, NULL,
				 XmVaPUSHBUTTON, paste, 'V', NULL, NULL,
				 NULL);
  XmStringFree(cut);
  XmStringFree(copy);
  XmStringFree(paste);

//  if(tmpWidget = XtNameToWidget(editMenu, "button_0"))
//    XtVaSetValues(tmpWidget, XmNset, True, NULL);

  // Third menu is the Help menu -- callback is HelpCB()
  XmVaCreateSimplePulldownMenu(menuBar, "help_menu", 2, (XtCallbackProc)HelpCB,
			       XmVaPUSHBUTTON, help, 'H', NULL, NULL,
			       NULL);
  XmStringFree(help);
  XtManageChild(menuBar);


  Widget baseRow = 
    XtVaCreateWidget("baseRow", xmRowColumnWidgetClass, mainW,
		     XmNwidth,  820,
		     XmNorientation, XmHORIZONTAL,
		     NULL);
  Widget baseFrame =
    XtVaCreateWidget("baseFrame", xmFrameWidgetClass, baseRow, NULL);

  Widget baseWidget=
    XtVaCreateWidget("baseWidget",xmScrolledWindowWidgetClass, baseFrame,
		     XmNwidth,  400,
		     XmNscrollingPolicy, XmAUTOMATIC,
		     NULL);

  base = XtVaCreateWidget("baseForm",xmFormWidgetClass, baseWidget,
			  XmNfractionBase, 5,
			  NULL);

  Colormap cmap;
  XColor color, unused;
  Pixel bgColor, topShadow, bottomShadow, fg_ret, selectColor;
  XtVaGetValues(base, XmNcolormap, &cmap, NULL);
  startButton = XtVaCreateWidget("START",xmPushButtonWidgetClass, base,
					XmNleftAttachment, XmATTACH_FORM,
					XmNleftOffset, 10,
					NULL);

  XtAddCallback(startButton, XmNactivateCallback, 
		(XtCallbackProc)ClickCB, NULL);
  XtManageChild(startButton);

  //  parse();             // parse quxote outputs
  //  table.print();
  XtManageChild(base);
  XtManageChild(baseWidget);
  XtManageChild(baseFrame);
  questionBox(baseRow);    // Draw a questionBox
  XtManageChild(baseRow);
  XtManageChild(mainW);

  XtAppSetErrorHandler(app, xt_error);   // catch Xt errors
  XtAppSetWarningHandler(app, xt_error);
  //  XSetErrorHandler(x_error);             // and Xlib errors


  // Initialize for Quixote
  initialize (TRUE);
  // Load Quixote Program
  if (load_program (MQ_PROG) < 0)
    {               // ^-- MQ program name
      fprintf (stderr, "Failed: %s\n", result);
      exit (1);
    }

  XtRealizeWidget(topLevel);
  XtAppMainLoop(app);
}
