/* -*-C++-*- */
#include <stdio.h>
#include <string.h>
#include <Xm/Form.h>
#include <Xm/PushB.h>
#include "newclass.h"
#include "cmdTable.h"

#define NODE "now"
#define NODE_NUM 3
#define LINE "state"
#define NAME "name"
#define WITH "with"
#define TO   "to"

extern line table;
extern Widget startButton, base;  
static Widget tmpWidget, MaxWidthWidget;
Dimension MaxWidth = 0;
int startSet = 0;

// ******** Get Form Widget width for MAX WIDTH
inline void WidthControl(Widget widget){
  Dimension width;
  XtVaGetValues(widget, XmNwidth, &width, NULL);
  if(width > MaxWidth) MaxWidth = width;
  //  fprintf(stderr,"MaxWidth=%d,\twidth=%d\n", MaxWidth, width);
  MaxWidthWidget = widget;
}
// ********

void parse(void)
{

  int i = 0;
  int id = 0;
  while(getchar() != EOF) i++;
  rewind(stdin);

  char* record =    new char[i+10];
  char* subrecord = new char[i+10];

  for(int j = 0; j< i; ++j) record[j] = getchar();

  int lineStart = 0;
  while(*record != '\0'){
    if(*record == ' ') record++;                // skip space
    else if(*record == '[') {                   // List begin
      record++;
    } else if(!strncmp(record, NODE, NODE_NUM)) {      // node
      record += NODE_NUM + 1;
      strcpy(subrecord, record);
      char *dummy = strtok(subrecord, "[");
      for(int i=0; i<NUMBER_OF_CMD; ++i){
	// fprintf(stderr,"%d dummy=[%s], table=[%s]\n",i,dummy, record);
	if(!strcmp(dummy, cmdTable[i])) {
	  id = i;
	  break;
	}
      }
      record += strlen(dummy);
    } else if(!strncmp(record, LINE, 5)) {      // line
      lineStart = 1;
      record += 5;
    } else if(!strncmp(record, NAME, 4) && lineStart == 1) {      // name
      record += 4;
      lineStart = 0;
      char* tmp  = new char[80];
      char* with = new char[80];
      memset(tmp,  0, 80);
      memset(with, 0, 80);
      int i = 0;
      while(*record != ']') {
	if(*record == ',') {
	  record++;
	  // wait !! ID table
	  if(id == 23 && !strncmp(record, TO, 2)){
	    record += 2;
	    int j = 0;
	    while(*record != ','){
	      if(*record != '=' && *record != ' ') {
		with[j] = *record;
		j++;
	      }
	      record++;
	    }
	  }
	  break;
	}
	else if(*record != '=' && *record != ' ') {
	  tmp[i] = *record;
	  i++;
	}
	record++;
      }
      from* newFrom = new from(tmp, base);
      newFrom->ID(id);
      if(id == 23) newFrom->With(with);
      newFrom->Label((char*)cmdTable[id], id);

      static int j = 0;
      // Type A
      if(id==0 || id ==1 || id == 21) {
	XtVaSetValues(newFrom->headWidget(), 
		      XmNtopAttachment, XmATTACH_WIDGET,
		      XmNtopWidget, j? tmpWidget : startButton,
		      XmNleftAttachment, XmATTACH_FORM,
		      NULL);
	newFrom->ManageButton(newFrom->NodeB());
	tmpWidget = newFrom->headWidget();
	j++;
      }
      else if(id >=3 && id <= 15) { // Type B
	Pixel fg, bg;
	XtVaGetValues(newFrom->AllowB(), XmNforeground, &fg, 
		      XmNbackground, &bg, NULL);
	Pixmap pixmap = XmGetPixmap(XtScreen(newFrom->AllowB()), "allow2",
				    fg, bg);
	XtVaSetValues(newFrom->AllowB(), XmNlabelPixmap, pixmap, NULL);
	newFrom->UnmanageButton(newFrom->LabelLeft());
      }
      else if(id == 20) { // Type F
	Pixel fg, bg;
	XtVaGetValues(newFrom->AllowB(), XmNforeground, &fg, 
		      XmNbackground, &bg, NULL);
	Pixmap pixmap = XmGetPixmap(XtScreen(newFrom->AllowB()), "allow2",
				    fg, bg);
	XtVaSetValues(newFrom->AllowB(), XmNlabelPixmap, pixmap, NULL);
	newFrom->UnmanageButton(newFrom->LabelRight());
      }
      else if(id == 23) { // Type H
	Pixel fg, bg;
	XtVaGetValues(newFrom->AllowB(), XmNforeground, &fg, 
		      XmNbackground, &bg, NULL);
	Pixmap pixmap = XmGetPixmap(XtScreen(newFrom->AllowB()), "bind",
				    fg, bg);
	XtVaSetValues(newFrom->AllowB(), XmNlabelPixmap, pixmap, NULL);
	XtVaSetValues(newFrom->LabelRight(), 
		      XmNshadowThickness, 2,
		      NULL);
      }
      else if(id == 2) { // Type B
	Pixel fg, bg;
	XtVaGetValues(newFrom->AllowB(), XmNforeground, &fg, 
		      XmNbackground, &bg, NULL);
	Pixmap pixmap = XmGetPixmap(XtScreen(newFrom->AllowB()), "activate",
				    fg, bg);
	XtVaSetValues(newFrom->AllowB(), XmNlabelPixmap, pixmap, NULL);
      }
      else{
	newFrom->UnmanageButton(newFrom->LabelLeft());
	newFrom->UnmanageButton(newFrom->LabelRight());
      }

      // Display default predicates
      if( (id > 1 && id < 21) || (id > 21 && id < 24)) newFrom->unmanage();
      table.append(newFrom);
      delete tmp;
      delete with;
    } else {
      record++;
    }
  }
  fprintf(stderr, "Read complete\n");
}

void createObjectA(char *name)
{
  from* newFrom = new from(name, base);

  // Use XmStringCreateLtoR for CR code
  XmString nameX = XmStringCreateLtoR(name, "charset");
  XtVaSetValues(newFrom->NodeB(), XmNlabelString, nameX, NULL);
  XmStringFree(nameX);

  XtVaSetValues(newFrom->LabelRight(), XmNshadowThickness, 0, NULL);
  /* Set Basic Poshition on base */
  XtVaSetValues(newFrom->headWidget(), 
		XmNtopAttachment, XmATTACH_WIDGET,
		XmNtopWidget, startSet? tmpWidget : startButton,
		XmNleftAttachment, XmATTACH_FORM,
		NULL);
  newFrom->ManageButton(newFrom->NodeB());

  WidthControl(newFrom->headWidget());

  /* Save current Widget for next node */
  tmpWidget = newFrom->headWidget();
  startSet++;
  table.append(newFrom);
}

void createObjectB(char *name)
{
  from* newFrom = new from(name, base);
  Pixel fg, bg;

  XmString nameX = XmStringCreateLtoR(name, "charset");
  XtVaSetValues(newFrom->NodeB(), XmNlabelString, nameX, NULL);
  XmStringFree(nameX);

  /* Set Basic Poshition on base */
  XtVaSetValues(newFrom->headWidget(), 
		XmNtopAttachment, XmATTACH_WIDGET,
		XmNtopWidget, startSet? tmpWidget : startButton,
		XmNleftAttachment, XmATTACH_FORM,
		NULL);

  XtVaSetValues(newFrom->LabelRight(), XmNshadowThickness, 0, NULL);
  XtVaGetValues(newFrom->AllowB(), XmNforeground, &fg, 
		XmNbackground, &bg, NULL);
  Pixmap pixmap = XmGetPixmap(XtScreen(newFrom->AllowB()), "activate",
			      fg, bg);
  XtVaSetValues(newFrom->AllowB(), XmNlabelPixmap, pixmap, NULL);
  newFrom->unmanage();
  WidthControl(newFrom->headWidget());
  /* Save current Widget for next node */
//  tmpWidget = newFrom->headWidget();
//  startSet++;
  table.append(newFrom);
}

void createObjectC(char *predicate, char *name)
{
  from* newFrom = new from(predicate, base);
  Pixel fg, bg;

  XmString nameX = XmStringCreateLtoR(predicate,"charset");
  XtVaSetValues(newFrom->LabelRight(), 
		XmNlabelString,     nameX,
		XmNshadowThickness, 0, NULL);
  XmStringFree(nameX);
  XmString nameX2 = XmStringCreateLtoR(name, "charset");
  XtVaSetValues(newFrom->NodeB(), XmNlabelString, nameX2, NULL);
  XmStringFree(nameX2);

  /* Set Basic Poshition on base */
  XtVaSetValues(newFrom->headWidget(), 
		XmNtopAttachment, XmATTACH_WIDGET,
		XmNtopWidget, startSet? tmpWidget : startButton,
		XmNleftAttachment, XmATTACH_FORM,
		NULL);

  XtVaGetValues(newFrom->AllowB(), XmNforeground, &fg, 
		XmNbackground, &bg, NULL);
  Pixmap pixmap = XmGetPixmap(XtScreen(newFrom->AllowB()), "allow2", fg, bg);
  XtVaSetValues(newFrom->AllowB(), XmNlabelPixmap, pixmap, NULL);
  newFrom->UnmanageButton(newFrom->LabelLeft());
  newFrom->unmanage();
  WidthControl(newFrom->headWidget());
  /* Save current Widget for next node */
//  tmpWidget = newFrom->headWidget();
//  startSet++;
  table.append(newFrom);
}

void createObjectF(char *predicate, char *name)
{
  from* newFrom = new from(predicate, base);
  newFrom->With("bind_element");
  Pixel fg, bg;
 
  fprintf(stderr,"createF:[%s]\t[%s]\n", predicate, name);


  XmString nameX = XmStringCreateLtoR(predicate,"charset");
  XtVaSetValues(newFrom->LabelRight(), XmNlabelString, nameX,
		XmNshadowThickness, 0, NULL);
  XtVaSetValues(newFrom->LabelLeft(),  XmNlabelString, nameX, NULL);
  XmStringFree(nameX);

  // Use XmStringCreateLtoR for CR code
  XmString nameX2 = XmStringCreateLtoR(name, "charset");
  XtVaSetValues(newFrom->NodeB(), XmNlabelString, nameX2, NULL);
  XmStringFree(nameX2);

  /* Set Basic Poshition on base */
  XtVaSetValues(newFrom->headWidget(), 
		XmNtopAttachment, XmATTACH_WIDGET,
		XmNtopWidget, startSet? tmpWidget : startButton,
		XmNleftAttachment, XmATTACH_FORM,
		NULL);

  XtVaGetValues(newFrom->AllowB(), XmNforeground, &fg, 
		XmNbackground, &bg, NULL);
  Pixmap pixmap = XmGetPixmap(XtScreen(newFrom->AllowB()), "allow2", fg, bg);
  XtVaSetValues(newFrom->AllowB(), XmNlabelPixmap, pixmap, NULL);
  newFrom->UnmanageButton(newFrom->LabelRight());
  newFrom->unmanage();
  WidthControl(newFrom->headWidget());
  /* Save current Widget for next node */
  //  tmpWidget = newFrom->headWidget();
  //  startSet++;
  table.append(newFrom);
}

void createObjectH(char *predicate, char *name, char *with)
{
  from* newFrom = new from(predicate, base);
  newFrom->With(with);
  Pixel fg, bg;

  XmString nameX = XmStringCreateLtoR(predicate,"charset");
  XmString withX = XmStringCreateLtoR(with,"charset");
  XtVaSetValues(newFrom->LabelRight(),  XmNlabelString, withX, NULL);
  XtVaSetValues(newFrom->LabelLeft(),
		XmNlabelString,     nameX,
		XmNshadowThickness, 0,
		NULL);
  XmStringFree(withX);
  XmStringFree(nameX);

  // Use XmStringCreateLtoR for CR code
  XmString nameBX = XmStringCreateLtoR(name, "charset");
  XtVaSetValues(newFrom->NodeB(), XmNlabelString, nameBX, NULL);
  XmStringFree(nameBX);

  /* Set Basic Poshition on base */
  XtVaSetValues(newFrom->headWidget(), 
		XmNtopAttachment, XmATTACH_WIDGET,
		XmNtopWidget, startSet? tmpWidget : startButton,
		XmNleftAttachment, XmATTACH_FORM,
		NULL);

  XtVaGetValues(newFrom->AllowB(), XmNforeground, &fg, 
		XmNbackground, &bg, NULL);
  Pixmap pixmap = XmGetPixmap(XtScreen(newFrom->AllowB()), "bind", fg, bg);
  XtVaSetValues(newFrom->AllowB(), XmNlabelPixmap, pixmap, NULL);
  XtVaSetValues(newFrom->LabelRight(), XmNshadowThickness, 2, NULL);
  newFrom->unmanage();
  WidthControl(newFrom->headWidget());
  /* Save current Widget for next node */
//  tmpWidget = newFrom->headWidget();
//  startSet++;
  table.append(newFrom);
}

/*********************************
 Create Left side object
*********************************/
void createElement1(char *name)
{
  from* newFrom = new from(name, base);

  // Use XmStringCreateLtoR for CR code
  XmString nameX = XmStringCreateLtoR(name, "charset");
  XtVaSetValues(newFrom->NodeB(), XmNlabelString, nameX, NULL);
  XmStringFree(nameX);

  XtVaSetValues(newFrom->LabelRight(), XmNshadowThickness, 0, NULL);
  XtVaSetValues(newFrom->headWidget(), 
		XmNtopAttachment, XmATTACH_WIDGET,
		XmNtopWidget, startSet? tmpWidget : startButton,
		XmNleftAttachment, XmATTACH_FORM,
		NULL);
  newFrom->unmanage();

  WidthControl(newFrom->headWidget());
//  tmpWidget = newFrom->headWidget();
//  startSet++;
  table.append(newFrom);
}

/*********************************
 Create Right side object
*********************************/
void createElement2(char *name)
{

  fprintf(stderr,"createElement2: tmpWidget = [%s]\n", XtName(tmpWidget));

  from* newFrom = new from(name, base);

  // Use XmStringCreateLtoR for CR code
  XmString nameX = XmStringCreateLtoR(name, "charset");
  XtVaSetValues(newFrom->NodeB(), XmNlabelString, nameX, NULL);
  XmStringFree(nameX);

  XtVaSetValues(newFrom->LabelRight(), XmNshadowThickness, 0, NULL);
  XtVaSetValues(newFrom->headWidget(), 
		XmNtopAttachment,  XmATTACH_OPPOSITE_WIDGET,
		XmNtopWidget,      tmpWidget,
		XmNbottomAttachment,  XmATTACH_OPPOSITE_WIDGET,
		XmNbottomWidget,      tmpWidget,
		XmNleftAttachment, XmATTACH_WIDGET,
		XmNleftWidget, tmpWidget,
		NULL);
  newFrom->unmanage();

//  tmpWidget = newFrom->headWidget();
  table.append(newFrom);
}
