/* -*-C++-*- */
///////////////////////////////////////////////////////////////
// callbacks.c : define callback
// '94.6.16 Thr
///////////////////////////////////////////////////////////////

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <Xm/Form.h>
#include <Xm/PanedW.h>
#include <Xm/RowColumn.h>
#include <Xm/DialogS.h>
#include <Xm/PushB.h>
#include <Xm/PushBG.h>
#include <Xm/DrawnB.h>
#include <Xm/Text.h>
#include <Xm/FileSB.h>
#include "newclass.h"
//#include "bind.h"

extern line table;
extern Display *dpy;

extern Widget topLevel, textMessage, base, startButton;
extern Dimension MaxWidth;
static int callCount = 0;
static Colormap subcmap;
static Pixel subBG;

Widget GetTopShell(Widget w)
{
  while(w && !XtIsWMShell(w)) w = XtParent(w);
  return w;
}

void DestroyShell(Widget w, Widget shell)
{
  XtDestroyWidget(shell);
}

void ClickCB(Widget w,XtPointer cliant_data,
	     XmPushButtonCallbackStruct *cbs)
{
  static Widget w2;
  Colormap cmap;
  XColor color, unused;
  Pixel bgColor, topShadow, bottomShadow, fg_ret, selectColor;

  // Get the Color map and background color
  XtVaGetValues(w, 
		XmNcolormap, &cmap,
		XmNbackground, &bgColor, NULL);
  if(callCount == 0) {
    subcmap = cmap;
    subBG = bgColor;
    w2 = w;
  }

  XmString nameX;
  XtVaGetValues(w, XmNlabelString, &nameX, NULL);
  char *label;
  XmStringGetLtoR(nameX, "charset", &label);
  char *name = XtName(w);

  static int startID=-1;
  static int endID=-1;
  fprintf(stderr,"Name=[%s]\n", name);
  if(!strcmp(name,"START")) {
    startID = 0;
    return;
  }

  line *loop = table.Head();
  if(startID != -1){
    for(int i=0; i<=startID; ++i) loop = loop->Next();
  }
  while(loop != NULL){
    if(strcmp(label, loop->Node()->Label()) == 0 &&
       strcmp(name , loop->Node()->Name()) == 0) {
      if(startID==-1) startID = loop->Counter();
      else endID = loop->Counter();
      break;
    }
    loop = loop->Next();
  }
  if(endID != -1){
    // Create New Window
    Widget newWindow = 
      XtVaCreatePopupShell("Detailed Pathway",
			   xmDialogShellWidgetClass, GetTopShell(w), 
			   XmNdeleteResponse, XmDESTROY,
			   XmNx, 0,
			   XmNy, 0,
			   NULL);
    // Create a PanedWindow to message the stuff in this dialog
    Widget pane =
      XtVaCreateWidget("pane", xmPanedWindowWidgetClass, newWindow,
		       XmNsashWidth,  1,
		       XmNsashHeight, 1,
		       NULL);
    // Create a FormWidget for some Buttons
    Widget form =
      XtVaCreateWidget("form", xmFormWidgetClass, pane,
//		       XmNwidth,  512,
//		       XmNheight, 512,
		       NULL);
    Pixel fg, bg;
    XtVaGetValues(form, XmNforeground, &fg, XmNbackground, &bg, NULL);


    loop = table.Head();
    for(int i=0; i< startID; ++i) loop = loop->Next();

    Widget tmp = loop->Node()->headWidget();
    loop = loop->Next();

    unsigned short height = 0, tmpHeight=0;
//    for(i=0; i<endID-startID-2; ++i) {
    for(i=0; i<endID-startID-1; ++i) {
      Widget mae;
      from* newFrom = new from(loop->Node()->Name(), form);
      
      if(!strcmp(loop->Node()->With(), "bind_element")) {
	fprintf(stderr, "Name:%s Label:%s Start:%d End:%d\n",
		loop->Node()->Name(),loop->Node()->With(), startID, endID);

	newFrom->With(loop->Node()->With());
	bindExpress *bind = new bindExpress(form, 0, height);
	bind->Name1(loop->Node()->Name());
	loop = loop->Next();

	char *rightName;
	if((rightName = strchr(loop->Node()->Name(), '\n')) != NULL) {
	  bind->Box(rightName+1);
	}
	else bind->Box(loop->Node()->Name());
	fprintf(stderr, "rightName:[%s]\t[%s]\n", rightName,loop->Node()->Name());

      }else{

	// Copy Objects --- START ---
	Pixmap pixmap;
	XtVaGetValues(loop->Node()->AllowB(), XmNlabelPixmap, &pixmap, NULL);
	XtVaSetValues(newFrom->AllowB(), XmNlabelPixmap, pixmap, NULL);
	
	Dimension thickness;
	XmString right, left, node;
	XtVaGetValues(loop->Node()->LabelRight(),
		      XmNlabelString, &right,
		      XmNshadowThickness, &thickness,
		      NULL);
	XtVaSetValues(newFrom->LabelRight(),
		      XmNlabelString, right,
		      XmNshadowThickness, thickness,
		      NULL);
	XtVaGetValues(loop->Node()->LabelLeft(),  XmNlabelString, &left, NULL);
	XtVaSetValues(newFrom->LabelLeft(),       XmNlabelString, left, NULL);
	XtVaGetValues(loop->Node()->NodeB(), XmNlabelString, &node, NULL);
	XtVaSetValues(newFrom->NodeB(),      XmNlabelString, node, NULL);
	XmStringFree(right);
	XmStringFree(left);
	XmStringFree(node);
	// Copy Objects --- END ---


	XtVaSetValues(newFrom->headWidget(), 
		      XmNtopAttachment, i? XmATTACH_WIDGET : XmATTACH_FORM,
		      XmNtopWidget, mae,
		      XmNleftAttachment, XmATTACH_FORM,
		      XmNleftOffset, 120,
		      NULL);

	newFrom->manage();
      }
      XtVaGetValues(loop->Node()->headWidget(), XmNheight, &tmpHeight, NULL);
      height += tmpHeight;
      mae = newFrom->headWidget();
      loop = loop->Next();
    }

    // make a bind_element object
    /*
    bindExpress *bind = new bindExpress(form, 0, height);
    bind->Name1(loop->Node()->Name());
    loop = loop->Next();
    bind->Box(loop->Node()->Name());
    */

    XtManageChild(form);

    // create another form
    form = XtVaCreateWidget("form", xmFormWidgetClass, pane,
			    XmNfractionBase, 5,
			    NULL);
    Widget closeButton =
      XtVaCreateManagedWidget("Done", xmPushButtonGadgetClass, form,
			      XmNtopAttachment,    XmATTACH_FORM,
			      XmNbottomAttachment, XmATTACH_FORM,
			      XmNleftAttachment,   XmATTACH_POSITION,
			      XmNleftPosition,     2,
			      XmNrightAttachment,  XmATTACH_POSITION,
			      XmNrightPosition,    3,
			      NULL);
    XtAddCallback(closeButton, XmNactivateCallback, 
		  (XtCallbackProc)DestroyShell, newWindow);
    XtManageChild(form);
    Dimension h;
    XtVaGetValues(closeButton, XmNheight, &h, NULL);
    XtVaSetValues(form, XmNpaneMaximum, h, XmNpaneMinimum, h, NULL);
    XtManageChild(pane);

    XtPopup(newWindow, XtGrabNone);
    

    startID = endID = -1;
  }

  //  fprintf(stderr,"%s: pushed %d times\n", name, cbs->click_count);
  // convert the color to a pixel value from the given cilormap.
/*
  if(callCount == 0){
    XAllocNamedColor(XtDisplay(w), cmap, "red", &color, &unused);
    bgColor = color.pixel;
    // Let Motif calculate the new colors based on that one color
    XmGetColors(XtScreen(w), cmap, bgColor, &fg_ret, &topShadow, &bottomShadow,
		&selectColor);
    // Set the colors accordingly
    XtVaSetValues(w, 
		  XmNbackground, bgColor,
		  XmNtopShadowColor, topShadow,
		  XmNbottomShadowColor, bottomShadow,
		  XmNselectColor, selectColor,
		  XmNarmColor, selectColor,
		  XmNborderColor, fg_ret,
		  NULL);
  }else{
    // Let Motif calculate the new colors based on that one color
    XmGetColors(XtScreen(w2), subcmap, bgColor, &fg_ret, &topShadow, 
		&bottomShadow, &selectColor);
    // Set the colors accordingly
    XtVaSetValues(w2, 
		  XmNbackground, bgColor,
		  XmNtopShadowColor, topShadow,
		  XmNbottomShadowColor, bottomShadow,
		  XmNselectColor, selectColor,
		  XmNarmColor, selectColor,
		  XmNborderColor, fg_ret,
		  NULL);
  }
*/

  XtFree(label);
  XtFree(name);
  XmStringFree(nameX);
//  if(callCount == 0) callCount = 1;
//  else callCount = 0;
}

void AllCB(Widget w, XtPointer cliant_data, XmPushButtonCallbackStruct *cbs)
{
  line *loop = table.Head();
  Widget tmpWidget;
  int j = 0;
  while(loop != NULL){
    //    fprintf(stderr,"MaxWidth : [%d]\n", MaxWidth);
    XtVaSetValues(loop->Node()->headWidget(),
		  XmNwidth, MaxWidth,
		  XmNtopAttachment, XmATTACH_WIDGET,
		  XmNtopWidget, j? tmpWidget : startButton,
		  NULL);
    loop->Node()->manage();
    tmpWidget = loop->Node()->headWidget();
    loop = loop->Next();
    j++;
  }
}

void LoadFile(Widget dialog, XtPointer clientData, 
	      XmFileSelectionBoxCallbackStruct *cbs)
{

}

// Any item the user selects from the file menu calls this function.
// It will either be "New" (itemNo==0) or "Quit" (itemNo==1).
void FileCB(Widget w, int itemNo)
{
  static Widget fileDialog;    // Make it static for reuse

  if(itemNo == 1) {            // the "Quit" item
    XtDestroyWidget(GetTopShell(base));
    exit(1);
  }

  if(!fileDialog){
    fileDialog = XmCreateFileSelectionDialog(base, "fileSel", NULL, 0);
    XtAddCallback(fileDialog, XmNokCallback, (XtCallbackProc)LoadFile,NULL);
    XtAddCallback(fileDialog, XmNcancelCallback,
		  (XtCallbackProc)XtUnmanageChild, NULL);
  }
  XtManageChild(fileDialog);
  XtPopup(XtParent(fileDialog), XtGrabNone);
}

void EditCB(void)
{
  
}

void HelpCB(void)
{
  
}
