#include <Xm/Xm.h>

#define allow_width 16
#define allow_height 16
static char allow_bits[] = {
   0xe0, 0x03, 0xe0, 0x03, 0xe0, 0x03, 0xe0, 0x03,
   0xe0, 0x03, 0xe0, 0x03, 0xe0, 0x03, 0xe0, 0x03,
   0xfc, 0x1f, 0xf8, 0x0f, 0xf0, 0x07, 0xe0, 0x03,
   0xc0, 0x01, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00
};

#define allow2_width 16
#define allow2_height 16

static char allow2_bits[] = {
   0x80, 0x01, 0x80, 0x01, 0x80, 0x01, 0x80, 0x01, 
   0x80, 0x01, 0x80, 0x01, 0x80, 0x01, 0x80, 0x01,
   0x90, 0x09, 0x90, 0x09, 0xa0, 0x05, 0xe0, 0x07,
   0xc0, 0x03, 0xc0, 0x03, 0x80, 0x01, 0x80, 0x01};

#define bind_width 32
#define bind_height 32
static char bind_bits[] = {
   0x18, 0x00, 0x00, 0x00, 0x18, 0x00, 0x00, 0x00, 0x18, 0x00, 0x00, 0x00,
   0x18, 0x00, 0x00, 0x00, 0x18, 0x00, 0x00, 0x00, 0x18, 0x00, 0x00, 0x00,
   0x18, 0x00, 0x00, 0x00, 0x18, 0x00, 0x00, 0x00, 0x18, 0x00, 0x00, 0x00,
   0x18, 0x30, 0x00, 0x00, 0x18, 0x0c, 0x00, 0x00, 0x98, 0x07, 0x00, 0x00,
   0xf8, 0xff, 0xff, 0xff, 0xf8, 0xff, 0xff, 0xff, 0x98, 0x07, 0x00, 0x00,
   0x18, 0x0c, 0x00, 0x00, 0x18, 0x30, 0x00, 0x00, 0x18, 0x00, 0x00, 0x00,
   0x18, 0x00, 0x00, 0x00, 0x18, 0x00, 0x00, 0x00, 0x18, 0x00, 0x00, 0x00,
   0x18, 0x00, 0x00, 0x00, 0x18, 0x00, 0x00, 0x00, 0x99, 0x00, 0x00, 0x00,
   0x99, 0x00, 0x00, 0x00, 0x5a, 0x00, 0x00, 0x00, 0x7e, 0x00, 0x00, 0x00,
   0x3c, 0x00, 0x00, 0x00, 0x3c, 0x00, 0x00, 0x00, 0x3c, 0x00, 0x00, 0x00,
   0x18, 0x00, 0x00, 0x00, 0x18, 0x00, 0x00, 0x00};

#define allow3_width 32
#define allow3_height 32
static char allow3_bits[] = {
   0x00, 0x00, 0x00, 0x40, 0x00, 0x00, 0x00, 0xe0, 0x00, 0x00, 0x00, 0x70,
   0x00, 0x00, 0x00, 0x38, 0x00, 0x00, 0x00, 0x1c, 0x00, 0x00, 0x00, 0x0e,
   0x00, 0x00, 0x00, 0x07, 0x00, 0x00, 0x80, 0x03, 0x00, 0x00, 0xc0, 0x01,
   0x00, 0x00, 0xe0, 0x00, 0x00, 0x00, 0x70, 0x00, 0x00, 0x00, 0x38, 0x00,
   0x00, 0x00, 0x1c, 0x00, 0x00, 0x00, 0x0e, 0x00, 0x00, 0x00, 0x07, 0x00,
   0x00, 0x80, 0x03, 0x00, 0x00, 0xc0, 0x01, 0x00, 0x00, 0xe0, 0x00, 0x00,
   0x00, 0x70, 0x00, 0x00, 0x00, 0x38, 0x00, 0x00, 0x00, 0x1c, 0x00, 0x00,
   0x00, 0x0e, 0x00, 0x00, 0x10, 0x07, 0x00, 0x00, 0x90, 0x03, 0x00, 0x00,
   0xd8, 0x01, 0x00, 0x00, 0xf8, 0x00, 0x00, 0x00, 0x7c, 0x00, 0x00, 0x00,
   0xfc, 0x03, 0x00, 0x00, 0xfe, 0x00, 0x00, 0x00, 0x3e, 0x00, 0x00, 0x00,
   0x0f, 0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00};

#define activate_width 16
#define activate_height 16
static char activate_bits[] = {
   0xc0, 0x03, 0xc0, 0x03, 0xc0, 0x03, 0xc0, 0x03,
   0xc8, 0x13, 0xc8, 0x13, 0xd0, 0x0b, 0xd0, 0x0b, 0xf0, 0x0f, 0xe0, 0x07,
   0xe0, 0x07, 0xc0, 0x03, 0xc0, 0x03, 0xc0, 0x03, 0x80, 0x01, 0x80, 0x01};

static XImage ximage, ximage2, ximage3, bindImage, activate;

void makeBitMaps(void)
{
  ximage.width  = allow_width;
  ximage.height = allow_height;
  ximage.data   = allow_bits;
  ximage.xoffset = 0;
  ximage.format = (int)XYBitmap;
  ximage.byte_order = (int)MSBFirst;
  ximage.bitmap_pad = 8;
  ximage.bitmap_bit_order = (int)LSBFirst;
  ximage.bitmap_unit = 8;
  ximage.depth = 1;
  ximage.bytes_per_line = 2;
  ximage.obdata = NULL;
  XmInstallImage(&ximage, "allow1");

  ximage2.width  = allow_width;
  ximage2.height = allow_height;
  ximage2.data   = allow2_bits;
  ximage2.xoffset = 0;
  ximage2.format = (int)XYBitmap;
  ximage2.byte_order = (int)MSBFirst;
  ximage2.bitmap_pad = 8;
  ximage2.bitmap_bit_order = (int)LSBFirst;
  ximage2.bitmap_unit = 8;
  ximage2.depth = 1;
  ximage2.bytes_per_line = 2;
  ximage2.obdata = NULL;
  XmInstallImage(&ximage2, "allow2");

  ximage3.width  = allow3_width;
  ximage3.height = allow3_height;
  ximage3.data   = allow3_bits;
  ximage3.xoffset = 0;
  ximage3.format = (int)XYBitmap;
  ximage3.byte_order = (int)MSBFirst;
  ximage3.bitmap_pad = 8;
  ximage3.bitmap_bit_order = (int)LSBFirst;
  ximage3.bitmap_unit = 8;
  ximage3.depth = 1;
  ximage3.bytes_per_line = 2;
  ximage3.obdata = NULL;
  XmInstallImage(&ximage3, "allow3");

  bindImage.width  = bind_width;
  bindImage.height = bind_height;
  bindImage.data   = bind_bits;
  bindImage.xoffset = 0;
  bindImage.format = (int)XYBitmap;
  bindImage.byte_order = (int)MSBFirst;
  bindImage.bitmap_pad = 8;
  bindImage.bitmap_bit_order = (int)LSBFirst;
  bindImage.bitmap_unit = 8;
  bindImage.depth = 1;
  bindImage.bytes_per_line = 4;
  bindImage.obdata = NULL;
  XmInstallImage(&bindImage, "bind");

  activate.width  = activate_width;
  activate.height = activate_height;
  activate.data   = activate_bits;
  activate.xoffset = 0;
  activate.format = (int)XYBitmap;
  activate.byte_order = (int)MSBFirst;
  activate.bitmap_pad = 8;
  activate.bitmap_bit_order = (int)LSBFirst;
  activate.bitmap_unit = 8;
  activate.depth = 1;
  activate.bytes_per_line = 2;
  activate.obdata = NULL;
  XmInstallImage(&activate, "activate");
}


