/* -*-C++-*- */
///////////////////////////////////////////////////////////////
// TextWidget.h : using TextWidget
// '94.6.3 Fri
///////////////////////////////////////////////////////////////

#ifndef TEXTWIDGET_H
#define TEXTWIDGET_H

#include <Xm/Text.h>
#include "motifhead.h"

class TextWithLabel : public MotifHead{
private:
  static void SelectItemCB(Widget w, caddr_t *cliant_data, caddr_t *callData);
  friend class WithScale;

protected:
  Widget row;
  Widget label;
  Widget text;

public:
  TextWithLabel(Widget, char*);
  inline Widget Text(void){return text;}
  inline Widget Row(void){return row;}
  virtual void LabelChange(char *);
  virtual inline void horizontal(void)
    {XtVaSetValues(row, XmNorientation, XmHORIZONTAL, NULL);}
//  virtual void ValueSet(char *);
  virtual inline void ValueSet(char *value)
    {XmTextSetString(text, value);}
  
};

class ThreeText : public TextWithLabel{
protected:
  Widget text2;
  Widget text3;

public:
  ThreeText(Widget, char*);
  virtual inline void ValueSet2(char *value)
    {XtVaSetValues(text2, XmNvalue, value, NULL);}
  virtual inline void ValueSet3(char *value)
    {XtVaSetValues(text3, XmNvalue, value, NULL);}
};

class WithScale : public TextWithLabel{
private:
  friend class TextWithLabel;
  static void ChangeCB(Widget, caddr_t, XmScaleCallbackStruct *);

protected:
  Widget scale;
  int max;
  int min;

public:
  WithScale(Widget, char *);
  void MaxValue(int);
  void MinValue(int);
  void ValueSet(char *value);

};

#endif
