/* -*-C++-*- */
///////////////////////////////////////////////////////////////
// TextWidget.c : using TextWidget
// '94.6.3 Fri
///////////////////////////////////////////////////////////////

#include <stdio.h>
#include <stdlib.h>
#include <Xm/Xm.h>
#include <Xm/RowColumn.h>
#include <Xm/Frame.h>
#include <Xm/Label.h>
//#include <Xm/Text.h>
#include <Xm/Scale.h>
#include "TextWidget.h"

TextWithLabel::TextWithLabel(Widget parent,char* name) : MotifHead(name)
{
  _w    = XtVaCreateManagedWidget(_name, xmFrameWidgetClass,parent,
				  XmNshadowType, XmSHADOW_ETCHED_IN,NULL);
  row   = XtVaCreateManagedWidget("itemRow",xmRowColumnWidgetClass, _w, 
				  XmNorientation, XmVERTICAL, NULL);
  label = XtVaCreateManagedWidget(name, xmLabelWidgetClass,
				  row, NULL);
  text  = XmCreateText(row,"itemText", NULL, 0);
  XtManageChild(text);

  XtAddCallback(text, XmNactivateCallback,
		&TextWithLabel::SelectItemCB,(XtPointer)this);
}

void TextWithLabel::LabelChange(char *newLabel)
{
  XmString str = XmStringCreateSimple(newLabel);
  XtVaSetValues(label, XmNlabelString, str, NULL);
  XmStringFree(str);
}

/*
void TextWithLabel::ValueSet(char *newLabel)
{
  XmString str = XmStringCreateSimple(newLabel);
  XtVaSetValues(text, XmNvalue, str, NULL);
  XmStringFree(str);
}
*/

void TextWithLabel::SelectItemCB(Widget w,
				 caddr_t *cliant_data, caddr_t *callData)
{
  
}

ThreeText::ThreeText(Widget parent,char* name) : TextWithLabel(parent,name)
{
  Arg args[5];
  XtSetArg(args[0], XmNwidth,90);
  text2 = XmCreateText(row,"Text2", args, 1);
  text3 = XmCreateText(row,"Text3", args, 1);

  XtManageChild(text2);
  XtManageChild(text3);

}

WithScale::WithScale(Widget parent, char* name) : TextWithLabel(parent, name)
{
  max = 100;
  min = 0;

  scale = XtVaCreateWidget("scale",xmScaleWidgetClass, row, 
			   XmNorientation, XmHORIZONTAL,
			   XmNmaximum, max,
			   XmNminimum, min,
			   XmNshowValue, True,
			   XmNwidth, 100, NULL);

  XtManageChild(scale);

  XtAddCallback(scale,XmNvalueChangedCallback,(XtCallbackProc)ChangeCB,NULL);
  XtAddCallback(scale,XmNdragCallback, (XtCallbackProc)ChangeCB, NULL);
}

void WithScale::MaxValue(int value)
{
  if(value <= min) return;
  XtVaSetValues(scale, XmNmaximum, value, NULL);
  max = value;
}

void WithScale::MinValue(int value)
{
  if(value >= max) return;
  XtVaSetValues(scale, XmNminimum, value, NULL);
  min = value;
}

void WithScale::ValueSet(char *value)
{
  XmTextSetString(text, value);
  XmScaleSetValue(scale, atoi(value));
}

void WithScale::ChangeCB(Widget w, caddr_t cliant, XmScaleCallbackStruct *cbs)
{
  printf("cbs->value: %d\n", cbs->value);
  char string[10];
  sprintf(string,"%d", cbs->value);
//  XmTextSetString(text, string);
//  delete string;
}
