/* -*-C++-*- */
///////////////////////////////////////////////////////////////
// DrawWidget.c : using DrawingArea Widget
// '94.7.8 Fri
///////////////////////////////////////////////////////////////

#include <Xm/DrawingA.h>
#include <Xm/PushBG.h>
#include <Xm/RowColumn.h>

#define WIDTH 400
#define HEIGHT 300

Pixmap pixmap; // used to redraw the Drawing Area

void drawingAreaCallback(Widget widget, XtPointer data, 
			 XmDrawingAreaCallbackStruct *cbs)
{
  static Position x, y;
  XEvent *event = cbs->event;
  Display *dpy = event->xany.display;

  if(cbs->reason == XmCR_INPUT) {
    if(event->xany.type == ButtonPress){
      x = event->xbutton.x;
      y = event->xbutton.y;
    }else if(event->xany.type == ButtonRelease){
      GC gc;
      XtVaGetValues(widget, XmNuserData, &gc, NULL);
      XDrawLine(dpy, cbs->window, gc, x, y,
		event->xbutton.x, event->xbutton.y);
      // draw into the pixmap as well for redrawing later
      XDrawLine(dpy, pixmap, gc, x, y,
		event->xbutton.x, event->xbutton.y);
      x = event->xbutton.x;
      y = event->xbutton.y;
    }
  }
  if(cbs->reason == XmCR_EXPOSE || cbs->reason == XmCR_ACTIVATE){
    GC gc;
    if(cbs->reason == XmCR_ACTIVATE)  // clear button pushed
      widget = XtParent(widget);      // get the DrawingArea widget's
    XtVaGetValues(widget, XmNuserData, &gc, NULL);
    if(cbs->reason == XmCR_ACTIVATE){ // clear button pushed
      XSetForeground(dpy, gc, WhitePixelOfScreen(XtScreen(widget)));
      XFillRectangle(dpy, pixmap, gc, 0,0, WIDTH, HEIGHT);
      XSetForeground(dpy, gc, BlackPixelOfScreen(XtScreen(widget)));
    }
    XCopyArea(dpy, pixmap, event->xany.window, gc,
	      0, 0, WIDTH, HEIGHT, 0, 0);
  }
}

main(int argc, char** argv)
{
  XtAppContext app;
  GC gc;

  Widget topLevel = XtVaAppInitialize(&app,"Test",NULL,0,&argc,argv,NULL,
				      XmNwidth,  WIDTH,
				      XmNheight, HEIGHT,
				      NULL);
  Widget drawingA = XtVaCreateWidget("drawingA", xmDrawingAreaWidgetClass,
				     topLevel, NULL);
  XtAddCallback(drawingA, XmNinputCallback, drawingAreaCallback, NULL);
  XtAddCallback(drawingA, XmNexposeCallback, drawingAreaCallback, NULL);

  gc = XCreateGC(XtDisplay(drawingA), RootWindowOfScreen(XtScreen(drawingA)),
		 0, NULL);
  XtVaSetValues(drawingA, XmNuserData, gc, NULL);

  XSetForeground(XtDisplay(drawingA), gc, 
		 WhitePixelOfScreen(XtScreen(drawingA)));
  // create a pixmap the same size as the Drawing Area
  pixmap = XCreatePixmap(XtDisplay(drawingA),
			 RootWindowOfScreen(XtScreen(drawingA)), WIDTH,HEIGHT,
			 DefaultDepthOfScreen(XtScreen(drawingA)));
  // clear pixmap with white
  XFillRectangle(XtDisplay(drawingA), pixmap, gc, 0,0,WIDTH, HEIGHT);
  // drawing is now drawn into with "black";change the gc for future
  XSetForeground(XtDisplay(drawingA), gc,
		 BlackPixelOfScreen(XtScreen(drawingA)));


  // add a pushbutton
  Widget pb = XtVaCreateManagedWidget("Clear", xmPushButtonGadgetClass,
				      drawingA, NULL);
  XtAddCallback(pb, XmNactivateCallback, drawingAreaCallback, NULL);

  XtManageChild(drawingA);
  XtRealizeWidget(topLevel);
  XtAppMainLoop(app);
}
