/* -*-C++-*- */
///////////////////////////////////////////////////////////////
// ButtonWidget.c : using PushButton Widget(DrawnButton)
// '94.6.3 Fri
///////////////////////////////////////////////////////////////

#include <Xm/Xm.h>
#include <Xm/RowColumn.h>
#include <Xm/Label.h>
#include <Xm/DrawnB.h>
#include "ButtonWidget.h"

CircleButton::CircleButton(Widget parent,char* name) : MotifHead(name)
{
  _w = XtVaCreateWidget(_name,xmRowColumnWidgetClass, _w, 
			 XmNorientation, XmVERTICAL, NULL);
  label = XtVaCreateManagedWidget(name, xmLabelWidgetClass,
					  _w, NULL);
  Pixel fg, bg;
  XtVaGetValues(_w, XmNforeground, &fg,
		    XmNbackground, &bg,
		    NULL);


  button = 


  XtManageChild(label);


  XtAddCallback(text, XmNactivateCallback,
		&TextWithLabel::SelectItemCB,(XtPointer)this);
}

void TextWithLabel::LabelChange(char *newLabel)
{
  XmString str = XmStringCreateSimple(newLabel);
  XtVaSetValues(label, XmNlabelString, str, NULL);
  XmStringFree(str);
}

void TextWithLabel::SelectItemCB(Widget w,
				 caddr_t *cliant_data, caddr_t *callData)
{
  
}

ThreeText::ThreeText(Widget parent,char* name) : TextWithLabel(parent,name)
{
  Arg args[5];
  XtSetArg(args[0], XmNwidth,90);
  text2 = XmCreateText(row,"Text2", args, 1);
  text3 = XmCreateText(row,"Text3", args, 1);

  XtManageChild(text2);
  XtManageChild(text3);

}

WithScale::WithScale(Widget parent, char* name) : TextWithLabel(parent, name)
{
  scale = XtVaCreateWidget("scale",xmScaleWidgetClass, row, 
			   XmNorientation, XmHORIZONTAL,
			   XmNwidth, 100, NULL);


  XtUnmanageChild(text);
  XtManageChild(scale);
  XtManageChild(text);
}
