#include <stdio.h>
#include <stddef.h>
#include <stdlib.h>

#define AM (1.0/IM1)
#define EPS 1.2e-7
#define IA1 40014
#define IA2 40692
#define IM1 2147483563
#define IM2 2147483399
#define IMM1 (IM1-1)
#define IQ1 53668
#define IQ2 52774
#define IR1 12211
#define IR2 3791
#define M 7
#define NDIV (1+IMM1/NTAB)
#define NSTACK 50
#define NTAB 32
#define RNMX (1.0-EPS)
#define SWAP(a,b) itmp = (a); (a) = (b); (b) = itmp;

float xrandom(long *idum)
{
    int i;
    long j;

    static long idum2 = 123456789;
    static long iy = 0;
    static long iv[NTAB];

    float tmp;
    
    if(*idum <= 0){
	if(-(*idum) < 1){
	    *idum = 1;
	}
	else{
	    *idum = -(*idum);
	}
	idum2 = (*idum);
	for(i = NTAB+7; i >= 0; i--){
	    j = (*idum)/IQ1;
	    *idum = IA1*(*idum - j*IQ1) - j*IR1;
	    if(*idum < 0){
		*idum += IM1;
	    }
	    if(i < NTAB){
		iv[i] = *idum;
	    }
	}
	iy = iv[0];
    }
    j = (*idum)/IQ1;
    *idum = IA1*(*idum - j*IQ1) - j*IR1;
    if(*idum < 0){
	*idum +=  IM1;
    }
    j = idum2/IQ2;
    idum2 = IA2*(idum2 - j*IQ2) - j*IR2;
    if(idum2 < 0){
	idum2 += IM2;
    }
    i = iy/NDIV;
    iy = iv[i] - idum2;
    iv[i] = *idum;
    if(iy < 1){
	iy += IMM1;
    }
    if((tmp = AM*iy) > RNMX){
	return RNMX;
    }
    else{
	return tmp;
    }
}


void xindex(unsigned long n, float arr[], unsigned long indx[])
{
    unsigned long indxt, itmp;
    unsigned long i, j, k;
    unsigned long ir = n;
    unsigned long l = 1;

    int *istack;
    int jstack = 0;

    float a;
    
    int *ivector(long, long);
    void free_ivector(int *, long, long);

    void HMMGene_error(char *);

    istack = ivector(1, NSTACK);
    for (j = 1; j <= n; j++){
	indx[j] = j;
    }
    for(;;){
	if(ir-l < M){
	    for(j = l+1; j <= ir; j++){
		indxt = indx[j];
		a = arr[indxt];
		for(i = j-1; i >= 1; i--){
		    if(arr[indx[i]] <= a){
			break;
		    }
		    indx[i+1] = indx[i];
		}
		indx[i+1] = indxt;
	    }
	    if(jstack == 0){
		break;
	    }
	    ir = istack[jstack--];
	    l = istack[jstack--];
	}
	else{
	    k = (l + ir) >> 1;
	    SWAP(indx[k], indx[l+1]);
	    if(arr[indx[l+1]] > arr[indx[ir]]){
		SWAP(indx[l+1],indx[ir])
		}
	    if(arr[indx[l]] > arr[indx[ir]]){
		SWAP(indx[l],indx[ir])
		}
	    if(arr[indx[l+1]] > arr[indx[l]]){
		SWAP(indx[l+1],indx[l])
		}
	    i = l+1;
	    j = ir;
	    indxt = indx[l];
	    a = arr[indxt];
	    for(;;){
		do i++; while(arr[indx[i]] < a);
		do j--; while(arr[indx[j]] > a);
		if(j < i){
		    break;
		}
		SWAP(indx[i], indx[j])
		}
	    indx[l] = indx[j];
	    indx[j] = indxt;
	    jstack += 2;
	    if(jstack > NSTACK){
		HMMGene_error("NSTACK too small in xindex.");
	    }
	    if(ir-i+1 >= j-l){
		istack[jstack] = ir;
		istack[jstack-1] = i;
		ir = j-1;
	    }
	    else{
		istack[jstack] = j-1;
		istack[jstack-1] = l;
		l = i;
	    }
	}
    }
    free_ivector(istack, 1, NSTACK);
}



void HMMGene_error(char error_text[])
{
    fprintf(stderr, "HMMGene: run-time error...\n");
    fprintf(stderr, "%s\n",error_text);
    fprintf(stderr, "...now exiting to program...\n");
    exit(1);
}

unsigned char *cvector(long nl, long nh)
{
    unsigned char *v;

    v = (unsigned char *)malloc((size_t)
				((nh-nl+1+1)*sizeof(unsigned char)));
    if(!v){
	HMMGene_error("allocation failure in cvector()");
    }

    return v-nl+1;
}

void free_cvector(unsigned char *v, long nl, long nh)
{
    free((char *) (v+nl-1));
}

double **dmatrix(long nrl, long nrh, long ncl, long nch)
{
    long i;
    long nrow = nrh-nrl+1;
    long ncol = nch-ncl+1;
    double **m;

    m = (double **) malloc((size_t)((nrow+1)*sizeof(double*)));
    if(!m){
	HMMGene_error("allocation failure 1 in matrix()");
    }
    m += 1;
    m -= nrl;

    m[nrl] = (double *) malloc((size_t)((nrow*ncol+1)*sizeof(double)));
    if(!m[nrl]){
	HMMGene_error("allocation failure 2 in matrix()");
    }
    m[nrl] += 1;
    m[nrl] -= ncl;

    for(i = nrl+1; i <= nrh; i++){
	m[i] = m[i-1]+ncol;
    }

    return m;
}

void free_dmatrix(double **m, long nrl, long nrh, long ncl, long nch)
{
    free((char *) (m[nrl]+ncl-1));
    free((char *) (m+nrl-1));
}

double *dvector(long nl, long nh)
{
    double *v;

    v = (double *)malloc((size_t)((nh-nl+1+1)*sizeof(double)));
    if(!v){
	HMMGene_error("allocation failure in dvector()");
    }

    return v-nl+1;
}

void free_dvector(double *v, long nl, long nh)
{
    free((char *) (v+nl-1));
}

int **imatrix(long nrl, long nrh, long ncl, long nch)
{
    long i;
    long nrow = nrh-nrl+1;
    long ncol = nch-ncl+1;
    int **m;

    m = (int **) malloc((size_t)((nrow+1)*sizeof(int*)));
    if(!m){
	HMMGene_error("allocation failure 1 in matrix()");
    }
    m += 1;
    m -= nrl;


    m[nrl] = (int *) malloc((size_t)((nrow*ncol+1)*sizeof(int)));
    if(!m[nrl]){
	HMMGene_error("allocation failure 2 in matrix()");
    }
    m[nrl] += 1;
    m[nrl] -= ncl;

    for(i = nrl+1; i <= nrh; i++){
	m[i] = m[i-1]+ncol;
    }

    return m;
}

void free_imatrix(int **m, long nrl, long nrh, long ncl, long nch)
{
    free((char *) (m[nrl]+ncl-1));
    free((char *) (m+nrl-1));
}

int *ivector(long nl, long nh)
{
    int *v;

    v = (int *)malloc((size_t) ((nh-nl+1+1)*sizeof(int)));
    if(!v){
	HMMGene_error("allocation failure in ivector()");
    }

    return v-nl+1;
}

void free_ivector(int *v, long nl, long nh)
{
    free((char *) (v+nl-1));
}

unsigned long *lvector(long nl, long nh)
{
    unsigned long *v;

    v = (unsigned long *)malloc((size_t) ((nh-nl+1+1)*sizeof(long)));
    if(!v){
	HMMGene_error("allocation failure in lvector()");
    }

    return v-nl+1;
}

void free_lvector(unsigned long *v, long nl, long nh)
{
    free((char *) (v+nl-1));
}

float *vector(long nl, long nh)
{
    float *v;

    v = (float *)malloc((size_t) ((nh-nl+1+1)*sizeof(float)));
    if(!v){
	HMMGene_error("allocation failure in vector()");
    }

    return v-nl+1;
}

void free_vector(float *v, long nl, long nh)
{
    free((char *) (v+nl-1));
}

char **cmatrix(long nrl, long nrh, long ncl, long nch)
{
    long i;
    long nrow = nrh-nrl+1;
    long ncol = nch-ncl+1;
    char **m;
    
    m = (char **) malloc((size_t)((nrow+1)*sizeof(char*)));
    if(!m){
	HMMGene_error("allocation failure 1 in matrix()");
    }
    m += 1;
    m -= nrl;
    
    m[nrl] = (char *) malloc((size_t)((nrow*ncol+1)*sizeof(char)));
    if(!m[nrl]){
	HMMGene_error("allocation failure 2 in matrix()");
    }
    m[nrl] += 1;
    m[nrl] -= ncl;
    
    for(i = nrl+1; i <= nrh; i++){
	m[i] = m[i-1]+ncol;
    }
    
    return m;
}

void free_cmatrix(char **m, long nrl, long nrh, long ncl, long nch)
{
    free((char *) (m[nrl]+ncl-1));
    free((char *) (m+nrl-1));
}


