#include <stdlib.h>
#include <math.h>
#include <stdio.h>

#include "hmm-gene.h"
#include "hmm.h"
#include "ga.h"


main(int argc, char *argv[])
{
    int i, j, k, l;
    int t, id;
    int num_learning_seq = 0;
    int num_recognition_seq = 0;
    int length = 0;
    SEQ *seq4learning;
    SEQ *seq4recognition;
    char key_in[TINY_SIZE];
    char buf[TINY_SIZE];
    char *sw1 = "off";
    char *sw2 = "off";
    FILE *file_ptr;

    int count_num_seq(char *, int *);
    int read_seq(char *, int, SEQ **);
    int release_seq(int, SEQ *);
    int seq_length(int, SEQ *, int *);
    int print_vector(double *, int);
    int print_matrix(double **, int, int);

    HMM_CND hmm_cnd;
    int num_state = -1;
    int *tuple;
    int **connect;
    double **a_ij;
    double *pi_i;
    TPL_TBL *b_ij;
    double *score;
    double av;

    float fdum;
    int idum;

    int read_hmm_cnd(char *, HMM_CND *);
    int *ivector(long, long);
    int **imatrix(long, long, long, long);
    void free_ivector(int *, long, long);
    void free_imatrix(int **, long, long, long, long);
    int alloc_parameter1(int, int *, TPL_TBL **, double ***, double **,
			 double **, int);
    int free_parameter1(int, int *, TPL_TBL *, double **, double *,
			double *, int);

    int baum_welch(int, SEQ *, int, int, int *, int **, HMM_CND, 
		   double ***, double **, TPL_TBL **, double **);
    int viterbi(char *, int, int, int *, int **, double **, double *, 
		TPL_TBL *, double *, int **);

    double rtime, ctime;
    double timer_getrtime(), timer_getutime(), timer_getstime();


    /* $B3X=,MQ(BDNA$BG[Ns72?t(B($B%U%!%$%kL>(B:./learn.seq)$B$r?t$($k!%(B */
#ifdef DEBUG
    fprintf(stderr, "--- counting number of sequences for learning...\n");
#endif
    if(count_num_seq("./learn.seq", &num_learning_seq) != 0){
	fprintf(stderr, "error occures in count_num_seq()...\n");
	exit(-1);
    }
#ifdef DEBUG
    fprintf(stderr, "--- number of sequences for learning = %d\n",
	    num_learning_seq);
#endif


    /* $B3X=,MQ(BDNA$BG[Ns72(B($B%U%!%$%kL>(B:./learn.seq)$B$rFI$_9~$`(B
       ($B%a%b%j$N3NJ]$b9T$J$&(B)$B!%(B */
    /* $B$D$$$G$K(BDNA$BG[Ns72$K(BATCG$B0J30$NJ8;z$,4^$^$l$F$$$k$+$r%A%'%C%/$9$k!%(B */
#ifdef DEBUG
    fprintf(stderr, "--- reading sequences for learning...\n");
#endif
    if(read_seq("./learn.seq", num_learning_seq, &seq4learning) != 0){
	fprintf(stderr, "error occures in read_seq()...\n");
	release_seq(num_learning_seq, seq4learning);
	exit(-1);
    }
#ifdef DEBUG
    for(i = 1; i <= num_learning_seq; i++){
	fprintf(stderr, "--- name = %s\n", (seq4learning + i)->a_name);
	fprintf(stderr, "    seq. = %s\n", (seq4learning + i)->a_seq);
    }
#endif


    /* $B3X=,MQ(BDNA$BG[Ns72$NG[NsD9$rD4$Y$k!%(B */
#ifdef DEBUG
    fprintf(stderr, "--- checking length of sequences for learning...\n");
#endif
    if(seq_length(num_learning_seq, seq4learning, &length) != 0){
	fprintf(stderr, "error occures in seq_length()...\n");
	release_seq(num_learning_seq, seq4learning);
	exit(-1);
    }
#ifdef DEBUG
    fprintf(stderr, "--- length of sequences for learning = %d\n", length);
#endif


    /* HMM$B>r7o%U%!%$%k$rFI$_9~$`!%(B */
#ifdef DEBUG
    fprintf(stderr, "--- reading conditions of HMM...\n");
#endif
    if(read_hmm_cnd("./hmm.cnd", &hmm_cnd) != 0){
	fprintf(stderr, "error occures in read_hmm_cnd()...\n");
	release_seq(num_learning_seq, seq4learning);
	exit(-1);
    }
#ifdef DEBUG
    fprintf(stderr, "    tolerance = %f\n", hmm_cnd.eps);
    fprintf(stderr, "    max. iteration = %d\n", hmm_cnd.max_itr);
#endif

    /* $B$I$N(BHMM$B$r;HMQ$9$k$N$+$r;XDj$9$k(B
       (HMMGene$B$N7k2L%U%!%$%k$rFI$_9~$`(B)$B!%(B */
    while(num_state < 0){
	fprintf(stderr, "input file name of result of HMMGene...\n");
	fflush(stderr);
	scanf("%s", key_in);
	while((file_ptr = fopen(key_in, "r")) == NULL){
	    fprintf(stderr, "no such file...\n");
	    fflush(stderr);
	    scanf("%s", key_in);
	}
	fprintf(stderr, "input generation...?\n");
	fflush(stderr);
	scanf("%d", &t);
	fprintf(stderr, "input individual...?\n");
	fflush(stderr);
	scanf("%d", &id);
	fprintf(stderr, "--- reading result file...\n");
	fprintf(stderr, "    t= %d\tid= %d\n", t, id);
	fflush(stderr);
	for(; fscanf(file_ptr, "%s", buf) != EOF; ){
	    if(strcmp(buf, "generation=") == 0){
		fscanf(file_ptr, "%d", &i);
		if(t == i){
		    sw1 = "on";
		}
		else{
		    sw1 = "off";
		}
	    }
	    else if((strcmp(sw1, "on") == 0) && (strcmp(buf, "id=") == 0)){
		fscanf(file_ptr, "%d", &i);
		fscanf(file_ptr, "%s", buf);
		if((id == i) && (strcmp(buf, "...(after") == 0)){
		    sw2 = "on";
		}
		else{
		    sw2 = "off";
		}
	    }
	    else if((strcmp(sw1, "on") == 0) && (strcmp(sw2, "on") == 0)){
		if(strcmp(buf, "states=") == 0){
		    fscanf(file_ptr, "%d", &num_state);
		    
		    /* $B%a%b%j3NJ](B */
		    tuple = ivector((long)1, (long)num_state);
		    for(i = 1; i <= num_state; i++){
			tuple[i] = TPL_LEN;
		    }
		    connect = imatrix((long)1, (long)num_state, 
				      (long)1, (long)num_state);
		    if(alloc_parameter1(num_state, tuple, &b_ij, &a_ij, &pi_i, 
					&score, num_learning_seq) != 0){
			fprintf(stderr, 
				"error occures in alloc_parameter1()...\n");
			free_parameter1(num_state, tuple, b_ij, a_ij, pi_i, 
					score, num_learning_seq);
			free_ivector(tuple, (long)1, (long)num_state);
			free_imatrix(connect, (long)1, (long)num_state, 
				     (long)1, (long)num_state);
			release_seq(num_learning_seq, seq4learning);
			exit(-1);
		    }
		}
		else if(strcmp(buf, "connectivity...") == 0){
		    for(i = 1; i <= num_state; i++){
			for(j = 1; j <= num_state; j++){
			    fscanf(file_ptr, "%d", &idum);
			    connect[i][j] = idum;
			}
		    }
		}
		else if(strcmp(buf, "a_ij") == 0){
		    fscanf(file_ptr, "%s", buf);
		    fscanf(file_ptr, "%s", buf);
		    for(i = 1; i <= num_state; i++){
			for(j = 1; j <= num_state; j++){
			    fscanf(file_ptr, "%f", &fdum);
			    a_ij[i][j] = (double)fdum;
			}
		    }
		}
		else if(strcmp(buf, "b_ij") == 0){
		    fscanf(file_ptr, "%s", buf);
		    fscanf(file_ptr, "%s", buf);
		    for(i = 1; i <= num_state; i++){
			fscanf(file_ptr, "%s", buf);
			fscanf(file_ptr, "%s", buf);
			idum = (int) pow((double)NUCL, (double)(tuple[i]));
			for(j = 1; j <= idum; j++){
			    fscanf(file_ptr, "%s", buf);
			    for(k = 1; k <= strlen(buf); k++){
				((b_ij + i)->tuple)[j][k] = buf[k-1];
			    }
			    fscanf(file_ptr, "%f", &fdum);
			    ((b_ij + i)->frq)[j] = (double)fdum;
			}
		    }
		}
		else if(strcmp(buf, "pi_i") == 0){
		    fscanf(file_ptr, "%s", buf);
		    fscanf(file_ptr, "%s", buf);
		    for(i = 1; i <= num_state; i++){
			fscanf(file_ptr, "%f", &fdum);
			pi_i[i] = (double)fdum;
		    }
		    break;
		}
	    }
	}
	fclose(file_ptr);

	if(num_state < 0){
	    fprintf(stderr, "no such kind of HMM...\n");
	    fflush(stderr);
	}
    }
#ifdef DEBUG
    fprintf(stderr, "--- initial state of HMM...\n");
    fprintf(stderr, "    connection = ...\n");
    for(i = 1; i <= num_state; i++){
	fprintf(stderr, "\t");
	for(j = 1; j <= num_state; j++){
	    fprintf(stderr, "%d ", connect[i][j]);
	}
	fprintf(stderr, "\n");
    }
    fprintf(stderr, "    a_ij = ...\n");
    for(i = 1; i <= num_state; i++){
	fprintf(stderr, "\t");
	for(j = 1; j <= num_state; j++){
	    fprintf(stderr, "%e ", a_ij[i][j]);
	}
	fprintf(stderr, "\n");
    }
    fprintf(stderr, "    b_ij = ...\n");
    for(i = 1; i <= num_state; i++){
	idum = (int) pow((double)NUCL, (double)(tuple[i]));
	fprintf(stderr, "\tstate=%d  freq.=...\n", i);
	for(j = 1; j <= idum; j++){
	    fprintf(stderr, "\t");
	    for(k = 1; k <= tuple[i]; k++){
		fprintf(stderr, "%c", ((b_ij + i)->tuple)[j][k]);
	    }
	    fprintf(stderr, "\t%e\n", ((b_ij + i)->frq)[j]);
	}
    }
    fprintf(stderr, "    pi_i = ...\n");
    fprintf(stderr, "\t");
    for(i = 1; i <= num_state; i++){
	fprintf(stderr, "%e ", pi_i[i]);
    }
    fprintf(stderr, "\n");
#endif


    /* Timer$B$N(Bstart$B!%(B */
    timer_start();


    /* HMM$B3X=,$K$h$k%Q%i%a!<%??dDj!%(B */
#ifdef DEBUG
    fprintf(stderr, "--- performing Baum-Welch algorithm...\n");
#endif
    if(baum_welch(num_learning_seq, seq4learning, length,
		  num_state, tuple, connect,
		  hmm_cnd, &a_ij, &pi_i, &b_ij, &score) != 0){
	fprintf(stderr, "error occures in baum_welch()...\n");
	free_parameter1(num_state, tuple, b_ij, a_ij, pi_i, 
			score, num_learning_seq);
	free_ivector(tuple, (long)1, (long)num_state);
	free_imatrix(connect, (long)1, (long)num_state, 
		     (long)1, (long)num_state);
	release_seq(num_learning_seq, seq4learning);
	exit(-1);
    }
    for(i = 1; i <= num_learning_seq; i++){
	(seq4learning + i)->prob = score[i];
    }
    /* $B=PNO(B */
    fprintf(stdout, "--- HMM after training...\n");
    fprintf(stdout, "    connection = ...\n");
    for(i = 1; i <= num_state; i++){
	fprintf(stdout, "\t");
	for(j = 1; j <= num_state; j++){
	    fprintf(stdout, "%d ", connect[i][j]);
	}
	fprintf(stdout, "\n");
    }
    fflush(stdout);
    fprintf(stdout, "    a_ij = ...\n");
    for(i = 1; i <= num_state; i++){
	fprintf(stdout, "\t");
	for(j = 1; j <= num_state; j++){
	    fprintf(stdout, "%e ", a_ij[i][j]);
	}
	fprintf(stdout, "\n");
    }
    fflush(stdout);
    fprintf(stdout, "    b_ij = ...\n");
    for(i = 1; i <= num_state; i++){
	idum = (int) pow((double)NUCL, (double)(tuple[i]));
	fprintf(stdout, "\tstate=%d  freq.=...\n", i);
	for(j = 1; j <= idum; j++){
	    fprintf(stdout, "\t");
	    for(k = 1; k <= tuple[i]; k++){
		fprintf(stdout, "%c", ((b_ij + i)->tuple)[j][k]);
	    }
	    fprintf(stdout, "\t%e\n", ((b_ij + i)->frq)[j]);
	}
    }
    fflush(stdout);
    fprintf(stdout, "    pi_i = ...\n");
    fprintf(stdout, "\t");
    for(i = 1; i <= num_state; i++){
	fprintf(stdout, "%e ", pi_i[i]);
    }
    fprintf(stdout, "\n---\n");
    fflush(stdout);
    fdum = 0.0;
    fprintf(stdout, "    log likelihood of training sequences = ...\n");
    for(i = 1; i <= num_learning_seq; i++){
	fdum += (seq4learning + i)->prob;
	fprintf(stdout, "    %s  %e\n", (seq4learning + i)->a_name, 
		(seq4learning + i)->prob);
    }
    av = fdum / (double)num_learning_seq;
    fprintf(stdout, "    av. of log likelihood= %e\n---\n", av);
    fflush(stdout);


    /* $BG'<1MQ(BDNA$BG[Ns72?t(B($B%U%!%$%kL>(B:./recog.seq)$B$r?t$($k!%(B */
#ifdef DEBUG
    fprintf(stderr, 
	    "--- counting number of sequences for recognition...\n");
#endif
    if(count_num_seq("./recog.seq", &num_recognition_seq) != 0){
	fprintf(stderr, "error occures in count_num_seq()...\n");
	free_parameter1(num_state, tuple, b_ij, a_ij, pi_i, 
			score, num_learning_seq);
	free_ivector(tuple, (long)1, (long)num_state);
	free_imatrix(connect, (long)1, (long)num_state, 
		     (long)1, (long)num_state);
	release_seq(num_learning_seq, seq4learning);
	exit(-1);
    }
#ifdef DEBUG
    fprintf(stderr, "--- number of sequences for recognition = %d\n",
	    num_recognition_seq);
#endif


    /* $BG'<1MQ(BDNA$BG[Ns72(B($B%U%!%$%kL>(B:./recog.seq)$B$rFI$_9~$`(B
       ($B%a%b%j$N3NJ]$b9T$J$&(B)$B!%(B */
    /* $B$D$$$G$K(BDNA$BG[Ns72$K(BATCG$B0J30$NJ8;z$,4^$^$l$F$$$k$+$r(B
       $B%A%'%C%/$9$k!%(B */
#ifdef DEBUG
    fprintf(stderr, "--- reading sequences for recognition...\n");
#endif
    if(read_seq("./recog.seq", num_recognition_seq, &seq4recognition) != 0){
	fprintf(stderr, "error occures in read_seq()...\n");
	free_parameter1(num_state, tuple, b_ij, a_ij, pi_i, 
			score, num_learning_seq);
	free_ivector(tuple, (long)1, (long)num_state);
	free_imatrix(connect, (long)1, (long)num_state, 
		     (long)1, (long)num_state);
	release_seq(num_learning_seq, seq4learning);
	release_seq(num_recognition_seq, seq4recognition);
	exit(-1);
    }
#ifdef DEBUG
    for(i = 1; i <= num_recognition_seq; i++){
	fprintf(stderr, "    name = %s\n", (seq4recognition + i)->a_name);
	fprintf(stderr, "    seq. = %s\n", (seq4recognition + i)->a_seq);
    }
#endif


    /* $B:GE,2=$5$l$?(BHMM$B$rMQ$$$F!$G'<1MQ(BDNA$B1v4pG[Ns72$rI>2A$9$k(B
       (Viterbi$B%"%k%4%j%:%`(B)$B!%(B */
#ifdef DEBUG
    fprintf(stderr, "--- recognize sequences for recognition using Viterbi algorithm...\n");
#endif
    for(i = 1; i <= num_recognition_seq; i++){
	l = strlen((seq4recognition + i)->a_seq);
	if(viterbi((char *)((seq4recognition + i)->a_seq), l, num_state, 
		   tuple, connect, a_ij, pi_i, b_ij, 
		   &((seq4recognition + i)->prob),
		   &((seq4recognition + i)->path)) != 0){
	    fprintf(stderr, "error occures in viterbi()...\n");
	    free_parameter1(num_state, tuple, b_ij, a_ij, pi_i, 
			    score, num_learning_seq);
	    free_ivector(tuple, (long)1, (long)num_state);
	    free_imatrix(connect, (long)1, (long)num_state, 
			 (long)1, (long)num_state);
	    release_seq(num_learning_seq, seq4learning);
	    release_seq(num_recognition_seq, seq4recognition);
	    exit(-1);
	}
    }


    /* $B=PNO(B */
    fprintf(stdout, 
	    "log likelihood and opt. path of test sequences = ...\n");
    for(i = 1; i <= num_recognition_seq; i++){
	l = strlen((seq4recognition + i)->a_seq);
	fprintf(stdout, "%s = %e\n", (seq4recognition + i)->a_name, 
	       (seq4recognition + i)->prob);
	fprintf(stdout, "%s:", (seq4recognition + i)->a_name);
	fprintf(stdout, "->");
	for(j = 1; j <= l; j++){
	    fprintf(stdout, "%d->", ((seq4recognition + i)->path)[j]);
	}
	fprintf(stdout, "\n");
    }
    fflush(stdout);


    /* Timer$B$N(Bstop$B!%(B */
    timer_stop();
    rtime = timer_getrtime();
    ctime = timer_getutime() + timer_getstime();
    fprintf(stderr, "real time(sec) = %f\n", rtime);
    fprintf(stderr, "cpu time(sec) = %f\n", ctime);
    fflush(stderr);
    fprintf(stdout, "real time(sec) = %f\n", rtime);
    fprintf(stdout, "cpu time(sec) = %f\n", ctime);
    fflush(stdout);


    /* $B%a%b%j$N2rJ|(B */
    free_parameter1(num_state, tuple, b_ij, a_ij, pi_i, score, 
		    num_learning_seq);
    free_ivector(tuple, (long)1, (long)num_state);
    free_imatrix(connect, (long)1, (long)num_state, (long)1, (long)num_state);
    release_seq(num_learning_seq, seq4learning);
    release_seq(num_recognition_seq, seq4recognition);


#ifdef DEBUG
    fprintf(stderr, "--- normal end, see you...\n");
#endif

    exit(0);
}

