#include <stdlib.h>
#include <math.h>
#include <stdio.h>

#include "hmm-gene.h"
#include "ga.h"
#include "hmm.h"


int backward(int num_seq, SEQ *seq_str, int seq_length4hmm, int num_state, 
	     int *tuple, int **connect, HMM_CND hmm_cnd, double ***a_ij, 
	     double **pi_i, TPL_TBL **b_ij, HMM_LEARN_PARAM **param_str,
	     double **dum_scale)
{
    int i, j, k, l;
    double freq;
    double sum;

    int frequency(char *, int, int, TPL_TBL **, int, double *);


    /* $B%5%s%W%kG[Ns?t$N%k!<%W(B */
    for(i = 1; i <= num_seq; i++){

	/* $B&B(B_i(k,T)$B$r=i4|2=$9$k!%(B */
	for(j = 1; j <= num_state; j++){
	    ((*param_str + i)->beta_ij)[j][seq_length4hmm] = 
		dum_scale[i][seq_length4hmm];
	}


	/* $B&B(B_i(k,T)$B$r=i4|2=$9$k!%(B
           ($B:G=*>uBV$G$O>uBV(Bnum_state$B$K$$$k$b$N$H$9$k(B)*/
	/*
	for(j = 1; j < num_state; j++){
	    ((*param_str + i)->beta_ij)[j][seq_length4hmm] = 0.0;
	}
	((*param_str + i)->beta_ij)[num_state][seq_length4hmm] =
	    dum_scale[i][seq_length4hmm] * (double)num_state;
	*/


	/* $B%5%s%W%kG[NsD9$5$N%k!<%W(B */
	for(j = seq_length4hmm - 1; j >= 1; j--){

	    /* $B>uBV?t$N%k!<%W(B */
	    for(k = 1; k <= num_state; k++){
		sum = 0.0;
		for(l = 1; l <= num_state; l++){

		    frequency((char *)((seq_str + i)->a_seq), j+1, 
			      tuple[l], b_ij, l, &freq);
		    sum += ((*param_str + i)->beta_ij)[l][j+1] * 
			(*a_ij)[k][l] * freq;

		}

		/* $B&B(B_i(k,j)$B$r;;=P$9$k!%(B */
		((*param_str + i)->beta_ij)[k][j] = 
		    sum * dum_scale[i][j];;
	    }
	}

#ifdef DEBUG
	fprintf(stderr, "beta_n(i,j) of seq. %s...\n",
		(seq_str + i)->a_name);
	for(j = 1; j <= num_state; j++){
	    for(k = 1; k <= seq_length4hmm; k++){
		fprintf(stderr, "%e ", ((*param_str + i)->beta_ij)[j][k]);
	    }
	    fprintf(stderr, "\n");
	}
#endif

    }

    return(0);
}


