#include <stdlib.h>
#include <math.h>
#include <stdio.h>
#include <string.h>
#include <strings.h>

#include "hmm-gene.h"


int count_num_seq(char *file_name, int *num)
{
    FILE *file_ptr;
    char buf[LONG_SIZE];

    if((file_ptr = fopen(file_name, "r")) == NULL){
	fprintf(stderr, "can not open file %s.\n", file_name);
	return(-1);
    }
    for(; fgets(buf, LONG_SIZE-1, file_ptr) != NULL; ){
	/* $B%3%a%s%HJ80J30$G:G=i$H:G8e$N(B:$B$N0LCV$,F1$89T$rFI$_9~$`!%(B */
	if((buf[0] != '#') && (strlen(buf) > 1) && 
	   (index(buf, ':') != NULL) && 
	   (index(buf, ':') == rindex(buf, ':'))){
	    (*num)++;
	}
    }
    fclose(file_ptr);

    return(0);
}


int read_seq(char *file_name, int num, SEQ **seq_ptr)
{
    FILE *file_ptr;
    char buf[LONG_SIZE];
    char *str;
    int i, j;

    unsigned char *cvector(long, long);
    int *ivector(long, long);

    /* $B9=B$BN$NG[Ns$O(B1$BHV$+$i(Bnum$BHV$^$G$H$k!%(B */
    if((*seq_ptr = (SEQ *) calloc (num+1, sizeof(SEQ))) == NULL){
	fprintf(stderr, "not enought memory...\n");
	return(-1);
    }


    if((file_ptr = fopen(file_name, "r")) == NULL){
	fprintf(stderr, "can not open file %s.\n", file_name);
	return(-1);
    }
    for(i = 0; fgets(buf, LONG_SIZE-1, file_ptr) != NULL; ){
	/* $B%3%a%s%HJ80J30$G:G=i$H:G8e$N(B:$B$N0LCV$,F1$89T$rFI$_9~$`!%(B */
	if((buf[0] != '#') && (strlen(buf) > 1) && 
	   (index(buf, ':') != NULL) && 
	   (index(buf, ':') == rindex(buf, ':'))){
	    i++;

	    /* $BG[NsL>$rFI$_9~$`!%(B */
	    str = (char *) strtok(buf, ":");
	    ((*seq_ptr + i)->a_name) = cvector((long)0, 
					       (long)(strlen(str)-1));
	    strcpy((char *)((*seq_ptr + i)->a_name), str);

	    /* $BG[Ns$rFI$_9~$`!%(B */
	    str = (char *) strtok(NULL, "\n");
	    ((*seq_ptr + i)->a_seq) = cvector((long)0,
					      (long)(strlen(str)-1));
	    strcpy((char *)((*seq_ptr + i)->a_seq), str);

	    /* $BG[Ns$N%A%'%C%/!%(B */
	    for(j = 0; j < strlen((char *)((*seq_ptr + i)->a_seq)); j++){
		if((((*seq_ptr + i)->a_seq)[j] != 'A') &&
		   (((*seq_ptr + i)->a_seq)[j] != 'T') &&
		   (((*seq_ptr + i)->a_seq)[j] != 'C') &&
		   (((*seq_ptr + i)->a_seq)[j] != 'G')){
		    fprintf(stderr, "invalid chracter is found in %s.\n", 
			    (*seq_ptr + i)->a_name);
		    return(-1);
		}
	    }

	    /* $B:GE,%Q%9$N%a%b%j3NJ]!%(B */
	    ((*seq_ptr + i)->path) = 
		ivector((long)1, 
			(long)(strlen((char *)((*seq_ptr + i)->a_seq))));

	}
    }
    fclose(file_ptr);

    return(0);
}


int seq_length(int num, SEQ *seq_ptr, int *length)
{
    int i, dum;

    /* $BA4$F$N3X=,MQG[Ns$OF1$8D9$5$G$J$1$l$P$J$i$J$$!%(B */

    (*length) = strlen((char *)((seq_ptr + 1)->a_seq));
    for(i = 2; i <= num; i++){
	dum = strlen((char *)((seq_ptr + i)->a_seq));
	if((*length) != dum){
	    fprintf(stderr, "invalid length of sequence...\n");
	    return(-1);
	}
    }


    return(0);
}


int release_seq(int num, SEQ *seq_ptr)
{
    int i, l1, l2;

    void free_cvector(unsigned char *, long, long);
    void free_ivector(int *, long, long);

    if(seq_ptr != NULL){

	/* $B9=B$BN$NG[Ns$O(B1$BHV$+$i(Bnum$BHV$^$G$H$k!%(B */
	for(i = 1; i <= num; i++){
	    if((seq_ptr + i)->a_name != NULL){
		l1 = strlen((char *)((seq_ptr + i)->a_name));
		free_cvector((seq_ptr + i)->a_name, (long)0, (long)(l1-1));
	    }
	    if((seq_ptr + i)->a_seq != NULL){
		l2 = strlen((char *)((seq_ptr + i)->a_seq));
		free_cvector((seq_ptr + i)->a_seq, (long)0, (long)(l2-1));
	    }
	    if((seq_ptr + i)->path != NULL){
		l2 = strlen((char *)((seq_ptr + i)->a_seq));
		free_ivector((seq_ptr + i)->path, (long)1, (long)l2);
	    }
	}

    }
    free(seq_ptr);

    return(0);
}

