#include <stdlib.h>
#include <math.h>
#include <stdio.h>

#include "hmm-gene.h"
#include "ga.h"


int scaling1(int t, GA_CND *ga_cnd, INDIVIDUAL **individual_ptr)
{
    int i;
    float fdum;
    double sum, av, sd;
    float *score;
    unsigned long *indxx;

    float xrandom(long *);
    int is_zero(double);
    void xindex(unsigned long, float *, unsigned long *);
    float *vector(long, long);
    unsigned long *lvector(long, long);
    void free_vector(float *, long, long);
    void free_lvector(unsigned long *, long, long);


    /* $B%a%b%j3NJ](B */
    score = vector((long)1, (long)ga_cnd->population);
    indxx = lvector((long)1, (long)ga_cnd->population);

    /* $B>uBV?t$NJ?6Q(B */
    sum = 0.0;
    for(i = 1; i <= ga_cnd->population; i++){
	sum += (double)(((*individual_ptr) + i)->state);
    }
    av = sum / (double)ga_cnd->population;

    /* $B>uBV?t$NI8=`JP:9(B */
    sum = 0.0;
    for(i = 1; i <= ga_cnd->population; i++){
	sum += pow((double)(((*individual_ptr) + i)->state) - av, 2.0);
    }
    sd = sqrt(sum / (double)ga_cnd->population);
#ifdef DEBUG
    fprintf(stderr, "    av. of state= %f sd. of state= %f\n", av, sd);
#endif
    fprintf(stdout, "    av. of state= %e\n", av);
    fprintf(stdout, "    sd. of state= %e\n", sd);
    fflush(stdout);

    /* $BE,1~EY$NJ?6Q(B */
    sum = 0.0;
    for(i = 1; i <= ga_cnd->population; i++){
	sum += ((*individual_ptr) + i)->raw_fitness;
    }
    av = sum / (double)ga_cnd->population;

    /* $BE,1~EY$NI8=`JP:9(B */
    sum = 0.0;
    for(i = 1; i <= ga_cnd->population; i++){
	sum += pow((((*individual_ptr) + i)->raw_fitness) - av, 2.0);
    }
    sd = sqrt(sum / (double)ga_cnd->population);
#ifdef DEBUG
    fprintf(stderr, "    av. of fitness= %f sd. of fitness= %f\n", av, sd);
#endif
    fprintf(stdout, "    av. of fitness= %e\n", av);
    fprintf(stdout, "    sd. of fitness= %e\n", sd);
    fflush(stdout);

    /* $BE,1~EY$G%=!<%H$9$k(B */
    for(i = 1; i <= ga_cnd->population; i++){
	score[i] = (float)((*individual_ptr) + i)->raw_fitness;
    }
    xindex((unsigned long)ga_cnd->population, score, indxx);

    /* $BE,1~EY$N:GBg$N8DBN(B */
#ifdef DEBUG
    fprintf(stderr, "    id(t=%d) which indicates max.fitness= %d %f\n", 
	    t, indxx[ga_cnd->population], score[indxx[ga_cnd->population]]);
#endif
    fprintf(stdout, "    id(t=%d) which indicates max.fitness= %d %e\n", 
	    t, indxx[ga_cnd->population], score[indxx[ga_cnd->population]]);
    fflush(stdout);

    /* $BE,1~EY$N:G>.$N8DBN(B */
#ifdef DEBUG
    fprintf(stderr, "    id(t=%d) which indicates min.fitness= %d %f\n", 
	    t, indxx[1], score[indxx[1]]);
#endif
    fprintf(stdout, "    id(t=%d) which indicates min.fitness= %d %e\n", 
	    t, indxx[1], score[indxx[1]]);
    fflush(stdout);

    /* $B&R@ZCG(B */
    for(i = 1; i <= ga_cnd->population; i++){
 	fdum = ((*individual_ptr) + i)->raw_fitness - 
	    (av - (ga_cnd->scale_const)*sd);
	if(fdum > 0.0){
	    ((*individual_ptr) + i)->scaled_fitness = fdum;
	}
	else{
	    ((*individual_ptr) + i)->scaled_fitness = 0.0;
	}
    }

#ifdef DEBUG
    fprintf(stderr, "    scaled fitness...\n");
    for(i = 1; i <= ga_cnd->population; i++){
	fprintf(stderr, "    id=%d scaled_fitness=%f\n",
		i, ((*individual_ptr) + i)->scaled_fitness);
    }
#endif
    fprintf(stdout, "    scaled fitness...\n");
    for(i = 1; i <= ga_cnd->population; i++){
	fprintf(stdout, "    id=%d scaled_fitness=%e\n",
		i, ((*individual_ptr) + i)->scaled_fitness);
    }
    fflush(stdout);

    /* $B%a%b%j2rJ|(B */
    free_vector(score, (long)1, (long)ga_cnd->population);
    free_lvector(indxx, (long)1, (long)ga_cnd->population);


    return(0);
}


int scaling2(int t, GA_CND *ga_cnd, INDIVIDUAL **ptr, INDIVIDUAL **dum_ptr)
{
    int i;
    float fdum;
    double sum, av, sd;
    float *score;
    unsigned long *indxx;

    float xrandom(long *);
    int is_zero(double);
    void xindex(unsigned long, float *, unsigned long *);
    float *vector(long, long);
    unsigned long *lvector(long, long);
    void free_vector(float *, long, long);
    void free_lvector(unsigned long *, long, long);


    /* $B%a%b%j3NJ](B */
    score = vector((long)1, (long)(ga_cnd->population)*2);
    indxx = lvector((long)1, (long)(ga_cnd->population)*2);

    /* $B>uBV?t$NJ?6Q(B */
    sum = 0.0;
    for(i = 1; i <= ga_cnd->population; i++){
	sum += (double)(((*ptr) + i)->state);
	sum += (double)(((*dum_ptr) + i)->state);
    }
    av = sum / ((double)(ga_cnd->population)*2.0);

    /* $B>uBV?t$NI8=`JP:9(B */
    sum = 0.0;
    for(i = 1; i <= ga_cnd->population; i++){
	sum += pow((double)(((*ptr) + i)->state) - av, 2.0);
	sum += pow((double)(((*dum_ptr) + i)->state) - av, 2.0);
    }
    sd = sqrt(sum / ((double)(ga_cnd->population)*2.0));
#ifdef DEBUG
    fprintf(stderr, "    av. of state= %f sd. of state= %f\n", av, sd);
#endif
    fprintf(stdout, "    av. of state= %e\n", av);
    fprintf(stdout, "    sd. of state= %e\n", sd);
    fflush(stdout);

    /* $BE,1~EY$NJ?6Q(B */
    sum = 0.0;
    for(i = 1; i <= ga_cnd->population; i++){
	sum += ((*ptr) + i)->raw_fitness;
	sum += ((*dum_ptr) + i)->raw_fitness;
    }
    av = sum / ((double)(ga_cnd->population)*2.0);

    /* $BE,1~EY$NI8=`JP:9(B */
    sum = 0.0;
    for(i = 1; i <= ga_cnd->population; i++){
	sum += pow((((*ptr) + i)->raw_fitness) - av, 2.0);
	sum += pow((((*dum_ptr) + i)->raw_fitness) - av, 2.0);
    }
    sd = sqrt(sum / ((double)(ga_cnd->population)*2.0));
#ifdef DEBUG
    fprintf(stderr, "    av. of fitness= %f sd. of fitness= %f\n", av, sd);
#endif
    fprintf(stdout, "    av. of fitness= %e\n", av);
    fprintf(stdout, "    sd. of fitness= %e\n", sd);
    fflush(stdout);

    /* $BE,1~EY$G%=!<%H$9$k(B */
    for(i = 1; i <= ga_cnd->population; i++){
	score[i+(ga_cnd->population)] = (float)((*ptr) + i)->raw_fitness;
	score[i] = (float)((*dum_ptr) + i)->raw_fitness;
    }
    xindex((unsigned long)((ga_cnd->population)*2), score, indxx);

    /* $BE,1~EY$N:GBg$N8DBN(B */
#ifdef DEBUG
    fprintf(stderr, "    id(t=%d) which indicates max.fitness= %d %f\n", 
	    t, indxx[(ga_cnd->population)*2], 
	    score[indxx[(ga_cnd->population)*2]]);
#endif
    fprintf(stdout, "    id(t=%d) which indicates max.fitness= %d %e\n", 
	    t, indxx[(ga_cnd->population)*2], 
	    score[indxx[(ga_cnd->population)*2]]);
    fflush(stdout);

    /* $BE,1~EY$N:G>.$N8DBN(B */
#ifdef DEBUG
    fprintf(stderr, "    id(t=%d) which indicates min.fitness= %d %f\n", 
	    t, indxx[1], score[indxx[1]]);
#endif
    fprintf(stdout, "    id(t=%d) which indicates min.fitness= %d %e\n", 
	    t, indxx[1], score[indxx[1]]);
    fflush(stdout);

    /* $B&R@ZCG(B */
    for(i = 1; i <= ga_cnd->population; i++){
 	fdum = ((*ptr) + i)->raw_fitness - 
	    (av - (ga_cnd->scale_const)*sd);
	if(fdum > 0.0){
	    ((*ptr) + i)->scaled_fitness = fdum;
	}
	else{
	    ((*ptr) + i)->scaled_fitness = 0.0;
	}

 	fdum = ((*dum_ptr) + i)->raw_fitness - 
	    (av - (ga_cnd->scale_const)*sd);
	if(fdum > 0.0){
	    ((*dum_ptr) + i)->scaled_fitness = fdum;
	}
	else{
	    ((*dum_ptr) + i)->scaled_fitness = 0.0;
	}
    }

#ifdef DEBUG
    fprintf(stderr, "    scaled fitness...\n");
    for(i = 1; i <= ga_cnd->population; i++){
	fprintf(stderr, "    id(P)=%d scaled_fitness=%f\n",
		i, ((*dum_ptr) + i)->scaled_fitness);
	fprintf(stderr, "    id(F)=%d scaled_fitness=%f\n",
		i, ((*ptr) + i)->scaled_fitness);
    }
#endif
    fprintf(stdout, "    scaled fitness...\n");
    for(i = 1; i <= ga_cnd->population; i++){
	fprintf(stdout, "    id(P)=%d scaled_fitness=%e\n",
		i, ((*dum_ptr) + i)->scaled_fitness);
	fprintf(stdout, "    id(F)=%d scaled_fitness=%e\n",
		i, ((*ptr) + i)->scaled_fitness);
    }
    fflush(stdout);

    /* $B%a%b%j2rJ|(B */
    free_vector(score, (long)1, (long)(ga_cnd->population)*2);
    free_lvector(indxx, (long)1, (long)(ga_cnd->population)*2);


    return(0);
}


