#include <stdlib.h>
#include <math.h>
#include <stdio.h>

#include "hmm-gene.h"
#include "ga.h"


int recombination(GA_CND *ga_cnd, INDIVIDUAL **individual_ptr)
{
    int i, j;
    float fdum;

    float xrandom(long *);
    int cross_over(unsigned char *, unsigned char *, int, int);
    int show_population(GA_CND *, INDIVIDUAL **);


    /* $B8DBN(Bi$B$H8DBN(B(i+1)$B$N4V$GAH49$($,5/$3$k!%(B
       ($B8DBN(Bi$B$H8DBN(B(i+1)$B$N>uBV?t$OF1$8$G$J$1$l$P$J$i$J$$!%(B) */
    for(i = 1; i <= ga_cnd->population; i+=2){

	/* $B7k9g9TNs(B */
	for(j = 1; j <= (((*individual_ptr)+i)->state)*
	    (((*individual_ptr)+i)->state); j++){

	    fdum = xrandom(&(ga_cnd->seed));

	    if(fdum <= ga_cnd->recombination){
#ifdef DEBUG
		fprintf(stderr, "--- recombination on gene_connect...\n");
		fprintf(stderr, "    id=%d&%d pos=%d rand=%f\n", 
			i, i+1, j, fdum);
#endif
		if(cross_over((((*individual_ptr)+i)->gene_connect), 
			      (((*individual_ptr)+(i+1))->gene_connect), 
			      (((*individual_ptr)+i)->state)*
			      (((*individual_ptr)+i)->state), j) != 0){
		    fprintf(stderr, "error occures in cross_over()...\n");
		    return(-1);
		}
	    }
	}

	/* $BA+0\3NN((B */
	for(j = 1; j <= (((*individual_ptr)+i)->state)*
	    (((*individual_ptr)+i)->state)*UNIT_AIJ; j++){

	    fdum = xrandom(&(ga_cnd->seed));

	    if(fdum <= ga_cnd->recombination){
#ifdef DEBUG
		fprintf(stderr, "--- recombination on gene_a0_ij...\n");
		fprintf(stderr, "    id=%d&%d pos=%d rand=%f\n", 
			i, i+1, j, fdum);
#endif
		if(cross_over((((*individual_ptr)+i)->gene_a0_ij), 
			      (((*individual_ptr)+(i+1))->gene_a0_ij), 
			      (((*individual_ptr)+i)->state)*
			      (((*individual_ptr)+i)->state)*UNIT_AIJ, 
			      j) != 0){
		    fprintf(stderr, "error occures in cross_over()...\n");
		    return(-1);
		}
	    }
	}


	/* $B>uBVJ,I[(B */
	for(j = 1; j <= (((*individual_ptr)+i)->state)*UNIT_PI; j++){

	    fdum = xrandom(&(ga_cnd->seed));

	    if(fdum <= ga_cnd->recombination){
#ifdef DEBUG
		fprintf(stderr, "--- recombination on gene_pi_i...\n");
		fprintf(stderr, "    id=%d&%d pos=%d rand=%f\n", 
			i, i+1, j, fdum);
#endif
		if(cross_over((((*individual_ptr)+i)->gene_pi_i), 
			      (((*individual_ptr)+(i+1))->gene_pi_i), 
			      (((*individual_ptr)+i)->state)*UNIT_PI, j) != 0){
		    fprintf(stderr, "error occures in cross_over()...\n");
		    return(-1);
		}
	    }
	}


	/* $B1v4pIQEY(B */
	for(j = 1; j <= (((*individual_ptr)+i)->state)*UNIT_FRQ*NUCL; j++){

	    fdum = xrandom(&(ga_cnd->seed));

	    if(fdum <= ga_cnd->recombination){
#ifdef DEBUG
		fprintf(stderr, "--- recombination on gene_freq...\n");
		fprintf(stderr, "    id=%d&%d pos=%d rand=%f\n", 
			i, i+1, j, fdum);
#endif
		if(cross_over((((*individual_ptr)+i)->gene_freq), 
			      (((*individual_ptr)+(i+1))->gene_freq), 
			      (((*individual_ptr)+i)->state)*UNIT_FRQ*NUCL, 
			      j) != 0){
		    fprintf(stderr, "error occures in cross_over()...\n");
		    return(-1);
		}
	    }
	}


    }

#ifdef DEBUG
    show_population(ga_cnd, individual_ptr);
#endif

    return(0);
}


int cross_over(unsigned char *str1, unsigned char *str2, int length, int pos)
{
    int i;
    char *sw = "off";
    unsigned char *dum_str1;
    unsigned char *dum_str2;

    unsigned char *cvector(long, long);
    void free_cvector(unsigned char *, long, long);

    dum_str1 = cvector((long)1, (long)length);
    dum_str2 = cvector((long)1, (long)length);
    copy_cvector(str1, length, dum_str1);
    copy_cvector(str2, length, dum_str2);
    for(i = 1; i <= length; i++){
	if(i == pos){
	    sw = "on";
	}

	if(strcmp(sw, "off") == 0){
	    str1[i] = dum_str1[i];
	    str2[i] = dum_str2[i];
	}
	else if(strcmp(sw, "on") == 0){
	    str1[i] = dum_str2[i];
	    str2[i] = dum_str1[i];
	}
	else{
	    fprintf(stderr, "invalid switch\n");
	    return(-1);
	}
    }
    free_cvector(dum_str1, (long)1, (long)length);
    free_cvector(dum_str2, (long)1, (long)length);

    return(0);
}

