#include <stdlib.h>
#include <math.h>
#include <stdio.h>
#include <string.h>
#include <strings.h>

#include "hmm-gene.h"
#include "ga.h"


int read_ga_cnd(char *file_name, GA_CND *ga_cnd)
{
    FILE *file_ptr;
    char buf[TINY_SIZE];
    char *str;
    float f;

    if((file_ptr = fopen(file_name, "r")) == NULL){
	fprintf(stderr, "can not open file %s.\n", file_name);
	return(-1);
    }
    for(; fgets(buf, LONG_SIZE-1, file_ptr) != NULL; ){
	/* $B%3%a%s%HJ80J30$G:G=i$,(B@$B$G(B
	   $B:G=i$H:G8e$N6uGr$N0LCV$,F1$89T$rFI$_9~$`!%(B */
	if((buf[0] != '#') && (buf[0] == '@') &&
	   (index(buf, ' ') != NULL) && 
	   (index(buf, ' ') == rindex(buf, ' '))){

	    str = (char *) strtok(buf, " ");
	    /* $B@$Be?t(B */
	    if(strcmp(str, "@num_generation=") == 0){
		str = (char *) strtok(NULL, "\n");
		sscanf(str, "%d", &(ga_cnd->generation));
		if(ga_cnd->generation <= 0){
		    fprintf(stderr, "number of generation should be positive integer.\n");
		    return(-1);
		}
	    }
	    /* $B=8CD%5%$%:(B */
	    else if(strcmp(str, "@population_size=") == 0){
		str = (char *) strtok(NULL, "\n");
		sscanf(str, "%d", &(ga_cnd->population));
		if((ga_cnd->population <= 0) || 
		   ((ga_cnd->population)%2 != 0)){
		    fprintf(stderr, "population number should be positive odd integer.\n");
		    return(-1);
		}
	    }
	    /* $BAH49$(N((B */
	    else if(strcmp(str, "@recombination=") == 0){
		str = (char *) strtok(NULL, "\n");
		sscanf(str, "%f", &f);
		ga_cnd->recombination = (double) f;
		if((ga_cnd->recombination < 0.0) || 
		   (ga_cnd->recombination > 1.0)){
		    fprintf(stderr, "recombination rate can vary from 0.0 to 1.0.\n");
		    return(-1);
		}
	    }
	    /* $BE@FMA3JQ0[N((B */
	    else if(strcmp(str, "@point_mutation=") == 0){
		str = (char *) strtok(NULL, "\n");
		sscanf(str, "%f", &f);
		ga_cnd->pmutation = (double) f;
		if((ga_cnd->pmutation < 0.0) || (ga_cnd->pmutation > 1.0)){
		    fprintf(stderr, "point mutation rate can vary from 0.0 to 1.0.\n");
		    return(-1);
		}
	    }
	    /* $BA^F~FMA3JQ0[N((B */
	    else if(strcmp(str, "@insert_mutation=") == 0){
		str = (char *) strtok(NULL, "\n");
		sscanf(str, "%f", &f);
		ga_cnd->imutation = (double) f;
		if((ga_cnd->imutation < 0.0) || (ga_cnd->imutation > 1.0)){
		    fprintf(stderr, "insert mutation rate can vary from 0.0 to 1.0.\n");
		    return(-1);
		}
	    }
	    /* $B7g<:FMA3JQ0[N((B */
	    else if(strcmp(str, "@delete_mutation=") == 0){
		str = (char *) strtok(NULL, "\n");
		sscanf(str, "%f", &f);
		ga_cnd->dmutation = (double) f;
		if((ga_cnd->dmutation < 0.0) || (ga_cnd->dmutation > 1.0)){
		    fprintf(stderr, "delete mutation rate can vary from 0.0 to 1.0.\n");
		    return(-1);
		}
	    }
	    /* HMM$B>uBV?t$N=i4|CM(B */
	    else if(strcmp(str, "@init_num_of_state=") == 0){
		str = (char *) strtok(NULL, "\n");
		sscanf(str, "%d", &(ga_cnd->state));
		if(ga_cnd->state <= 1){
		    fprintf(stderr, "number of state should be more than one.\n");
		    return(-1);
		}
	    }
	    /* $B&R@ZCG(B($B%9%1!<%j%s%0(B)$B$N78?t(B */
	    else if(strcmp(str, "@scaling_constant=") == 0){
		str = (char *) strtok(NULL, "\n");
		sscanf(str, "%f", &f);
		ga_cnd->scale_const = (double) f;
	    }
	    /* $BMp?t$N<o(B */
	    else if(strcmp(str, "@seed=") == 0){
		str = (char *) strtok(NULL, "\n");
		/*
		sscanf(str, "%d", &(ga_cnd->seed));
		*/
		ga_cnd->seed = atol(str);
		if(ga_cnd->seed >= 0){
		    fprintf(stderr, 
			    "seed should be large negative integer.\n");
		    return(-1);
		}
		if(ga_cnd->seed < L_NEGATIVE){
		    fprintf(stderr, 
			    "seed is too large negative integer.\n");
		    return(-1);
		}
	    }

	}
    }
    fclose(file_ptr);


    return(0);
}


int alloc_individual(GA_CND ga_cnd, INDIVIDUAL **individual_ptr)
{
    int i;

    unsigned char *cvector(long, long);
    double *dvector(long, long);
    double **dmatrix(long, long, long, long);
    int **imatrix(long, long, long, long);
    int *ivector(long, long);


    /* $B9=B$BN$NG[Ns$O(B1$BHV$+$i(Bga_cnd.population$BHV$^$G$H$k!%(B */
    if((*individual_ptr = 
	(INDIVIDUAL *) calloc (ga_cnd.population+1, 
			       sizeof(INDIVIDUAL))) == NULL){
	fprintf(stderr, "not enought memory...\n");
	return(-1);
    }


    for(i = 1; i <= ga_cnd.population; i++){
	/* HMM$B$N>uBV?t(B */
	(*individual_ptr + i)->state = ga_cnd.state;

	/* HMM$B$N7k9g9TNs$r3JG<$9$kG[Ns(B */
	((*individual_ptr + i)->gene_connect) = 
	    cvector((long)1, (long)(ga_cnd.state*ga_cnd.state));

	/* HMM$B$NA+0\3NN($N=i4|CM$r3JG<$9$kG[Ns(B */
	((*individual_ptr + i)->gene_a0_ij) = 
	    cvector((long)1, (long)(ga_cnd.state*ga_cnd.state*UNIT_AIJ));

	/* HMM$B$N>uBVJ,I[$N=i4|CM$r3JG<$9$kG[Ns(B */
	((*individual_ptr + i)->gene_pi_i) = 
	    cvector((long)1, (long)(ga_cnd.state*UNIT_PI));

	/* HMM$B$N3F>uBV$K$*$1$k1v4pIQEY$N=i4|CM$r3JG<$9$kG[Ns(B */
	((*individual_ptr + i)->gene_freq) = 
	    cvector((long)1, (long)(ga_cnd.state*UNIT_FRQ*NUCL));

	/* HMM$B$N7k9g9TNs$r3JG<$9$kG[Ns(B */
	(*individual_ptr + i)->connect = 
	    imatrix(1, (long)ga_cnd.state, 1, (long)ga_cnd.state);

	/* HMM$B$NA+0\3NN($N=i4|CM(B($B<B?t$KJQ49$5$l$?$b$N(B)$B$r3JG<$9$kG[Ns(B */
	(*individual_ptr + i)->a0_ij = 
	    dmatrix(1, (long)ga_cnd.state, 1, (long)ga_cnd.state);

	/* HMM$B$N=i4|>uBVJ,I[(B($B<B?t$KJQ49$5$l$?$b$N(B)$B$r3JG<$9$kG[Ns(B */
	(*individual_ptr + i)->pi_i = dvector(1, (long)ga_cnd.state);

	/* HMM$B$N3F>uBV$K$*$1$k1v4pIQEY(B(10$B?J?t$KJQ49$5$l$?$b$N(B)$B$r(B
	   $B3JG<$9$kG[Ns(B */
	(*individual_ptr + i)->freq = 
	    dvector(1, (long)ga_cnd.state*NUCL);

    }

    return(0);
}


int ga_initial(GA_CND *ga_cnd, INDIVIDUAL **individual_ptr)
{
    int i, j;
    float fdum;

    float xrandom(long *);

    for(i = 1; i <= ga_cnd->population; i++){

	/* HMM$B$N7k9g9TNs$r3JG<$9$kG[Ns$N=i4|CM$N@_Dj(B */
#ifdef DEBUG
	fprintf(stderr, "--- how about connectivity...\n");
#endif
	for(j = 1; j <= ga_cnd->state*ga_cnd->state; j++){
	    fdum = xrandom(&(ga_cnd->seed));
	    /*
#ifdef DEBUG
	    fprintf(stderr, "%f ", fdum);
#endif
            */
	    if(fdum < HALF){
		((*individual_ptr + i)->gene_connect)[j] = '0';
	    }
	    else{
		((*individual_ptr + i)->gene_connect)[j] = '1';
	    }
	}
	/*
#ifdef DEBUG
	fprintf(stderr, "\n");
#endif
        */

	/* HMM$B$NA+0\3NN($r3JG<$9$kG[Ns$N=i4|CM$N@_Dj(B */
#ifdef DEBUG
	fprintf(stderr, "--- how about trans. prob...\n");
#endif
	for(j = 1; j <= ga_cnd->state*ga_cnd->state*UNIT_AIJ; j++){
	    fdum = xrandom(&(ga_cnd->seed));
	    /*
#ifdef DEBUG
	    fprintf(stderr, "%f ", fdum);
#endif
            */
	    if(fdum < HALF){
		((*individual_ptr + i)->gene_a0_ij)[j] = '0';
	    }
	    else{
		((*individual_ptr + i)->gene_a0_ij)[j] = '1';
	    }
	}
	/*
#ifdef DEBUG
	fprintf(stderr, "\n");
#endif
        */

	/* HMM$B$N=i4|>uBVJ,I[$r3JG<$9$kG[Ns$N=i4|CM$N@_Dj(B */
#ifdef DEBUG
	fprintf(stderr, "--- how about init. dist...\n");
#endif
	for(j = 1; j <= ga_cnd->state*UNIT_PI; j++){
	    fdum = xrandom(&(ga_cnd->seed));
	    /*
#ifdef DEBUG
	    fprintf(stderr, "%f ", fdum);
#endif
            */
	    if(fdum < HALF){
		((*individual_ptr + i)->gene_pi_i)[j] = '0';
	    }
	    else{
		((*individual_ptr + i)->gene_pi_i)[j] = '1';
	    }
	}
        /*
#ifdef DEBUG
	fprintf(stderr, "\n");
#endif
        */

	/* HMM$B$N3F>uBV$K$*$1$k1v4pIQEY$r3JG<$9$kG[Ns$N=i4|CM$N@_Dj(B */
#ifdef DEBUG
	fprintf(stderr, "--- how about base freq...\n");
#endif
	for(j = 1; j <= (ga_cnd->state)*UNIT_FRQ*NUCL; j++){
	    fdum = xrandom(&(ga_cnd->seed));
	    /*
#ifdef DEBUG
	    fprintf(stderr, "%f ", fdum);
#endif
            */
	    if(fdum < HALF){
		((*individual_ptr + i)->gene_freq)[j] = '0';
	    }
	    else{
		((*individual_ptr + i)->gene_freq)[j] = '1';
	    }

	}
        /*
#ifdef DEBUG
	fprintf(stderr, "\n");
#endif
        */
    }

    return(0);
}


int free_individual(GA_CND ga_cnd, INDIVIDUAL *individual_ptr)
{
    int i;
    int num_state;

    void free_cvector(unsigned char *, long, long);
    void free_dmatrix(double **, long, long, long, long);
    void free_imatrix(int **, long, long, long, long);
    void free_ivector(int *, long, long);


    if(individual_ptr != NULL){
	for(i = 1; i <= ga_cnd.population; i++){
	    num_state = (individual_ptr + i)->state;

	    if(((individual_ptr + i)->gene_connect) != NULL){
		free_cvector((individual_ptr + i)->gene_connect, 
			     (long)1, (long)(num_state*num_state));
	    }

	    if(((individual_ptr + i)->gene_a0_ij) != NULL){
		free_cvector((individual_ptr + i)->gene_a0_ij, (long)1, 
			     (long)(num_state*num_state*UNIT_AIJ));
	    }

	    if(((individual_ptr + i)->gene_pi_i) != NULL){
		free_cvector((individual_ptr + i)->gene_pi_i, (long)1, 
			     (long)(num_state*UNIT_PI));
	    }

	    if(((individual_ptr + i)->gene_freq) != NULL){
		free_cvector((individual_ptr + i)->gene_freq, (long)1, 
			     (long)(num_state*UNIT_FRQ*NUCL));
	    }

	    if(((individual_ptr + i)->connect) != NULL){
		free_imatrix((individual_ptr + i)->connect, (long)1, 
			     (long)num_state, (long)1, (long)num_state);
	    }

	    if(((individual_ptr + i)->a0_ij) != NULL){
		free_dmatrix((individual_ptr + i)->a0_ij, (long)1, 
			     (long)num_state, (long)1, (long)num_state);
	    }

	    if(((individual_ptr + i)->pi_i) != NULL){
		free_dvector((individual_ptr + i)->pi_i, (long)1, 
			     (long)num_state);
	    }

	    if(((individual_ptr + i)->freq) != NULL){
		free_dvector((individual_ptr + i)->freq, (long)1, 
			     (long)num_state*NUCL);
	    }

	}
	free(individual_ptr);
    }


    return(0);
}


int show_population(GA_CND *ga_cnd, INDIVIDUAL **individual_ptr)
{
    int i, j;

    for(i = 1; i <= ga_cnd->population; i++){
	fprintf(stderr, "    id = %d\n", i);
	fprintf(stderr, "    num. state = %d\n", 
		((*individual_ptr) + i)->state);
	fprintf(stderr, "    connection =\n");
	for(j = 1; j <= (((*individual_ptr) + i)->state)*
	    (((*individual_ptr) + i)->state); j++){
	    if(j%((*individual_ptr) + i)->state == 1){
		fprintf(stderr, "\t");
	    }
	    fprintf(stderr, "%c ",
		    (((*individual_ptr) + i)->gene_connect)[j]);
	    if(j%((*individual_ptr) + i)->state == 0){
		fprintf(stderr, "\n");
	    }
	}
	fprintf(stderr, "    init. dist. =\n\t");
	for(j = 1; j <= (((*individual_ptr) + i)->state)*UNIT_PI; j++){
	    fprintf(stderr, "%c",
		    (((*individual_ptr) + i)->gene_pi_i)[j]);
	    if(j%UNIT_PI == 0){
		fprintf(stderr, " ");
	    }
	}
	fprintf(stderr, "\n");
	fprintf(stderr, "    init. trans. prob. =\n");
	for(j = 1; j <= (((*individual_ptr) + i)->state)*
	    (((*individual_ptr) + i)->state)*UNIT_AIJ; j++){
	    if(j%(((*individual_ptr) + i)->state*UNIT_AIJ) == 1){
		fprintf(stderr, "\t");
	    }
	    fprintf(stderr, "%c",
		    (((*individual_ptr) + i)->gene_a0_ij)[j]);
	    if(j%UNIT_AIJ == 0){
		fprintf(stderr, " ");
	    }
	    if(j%(((*individual_ptr) + i)->state*UNIT_AIJ) == 0){
		fprintf(stderr, "\n");
	    }
	}
	fprintf(stderr, "    base freq.=\n");
	for(j = 1; j <= (((*individual_ptr) + i)->state)*UNIT_FRQ*NUCL; j++){
	    if(j%(UNIT_FRQ*NUCL) == 1){
		fprintf(stderr, "\t");
	    }
	    fprintf(stderr, "%c",
		    (((*individual_ptr) + i)->gene_freq)[j]);
	    if(j%(UNIT_FRQ*NUCL) == 0){
		fprintf(stderr, "\n");
	    }
	    else if(j%UNIT_FRQ == 0){
		fprintf(stderr, " ");
	    }
	}
    }


    return(0);
}


int copying(GA_CND ga_cnd, INDIVIDUAL **ptr, INDIVIDUAL **dum_ptr){
    int i, j, k;

    unsigned char *cvector(long, long);
    double *dvector(long, long);
    double **dmatrix(long, long, long, long);
    int **imatrix(long, long, long, long);
    int *ivector(long, long);

    int show_population(GA_CND *, INDIVIDUAL **);


    /* $B9=B$BN$NG[Ns$O(B1$BHV$+$i(Bga_cnd.population$BHV$^$G$H$k!%(B */
    if((*dum_ptr = 
	(INDIVIDUAL *) calloc (ga_cnd.population+1, 
			       sizeof(INDIVIDUAL))) == NULL){
	fprintf(stderr, "not enought memory...\n");
	return(-1);
    }


    for(i = 1; i <= ga_cnd.population; i++){
	/* HMM$B$N>uBV?t(B */
	(*dum_ptr + i)->state = (*ptr + i)->state;

	/* HMM$B$N7k9g9TNs$r3JG<$9$kG[Ns(B */
	((*dum_ptr + i)->gene_connect) = 
	    cvector((long)1, 
		    (long)(((*dum_ptr + i)->state)*((*dum_ptr + i)->state)));
	for(j = 1; j <= ((*dum_ptr + i)->state)*((*dum_ptr + i)->state); j++){
	    ((*dum_ptr + i)->gene_connect)[j] = ((*ptr + i)->gene_connect)[j];
	}

	/* HMM$B$NA+0\3NN($N=i4|CM$r3JG<$9$kG[Ns(B */
	((*dum_ptr + i)->gene_a0_ij) = 
	    cvector((long)1, (long)(((*dum_ptr + i)->state)*
				    ((*dum_ptr + i)->state)*UNIT_AIJ));
	for(j = 1; j <= ((*dum_ptr + i)->state)*((*dum_ptr + i)->state)*
	    UNIT_AIJ; j++){
	    ((*dum_ptr + i)->gene_a0_ij)[j] = ((*ptr + i)->gene_a0_ij)[j];
	}

	/* HMM$B$N>uBVJ,I[$N=i4|CM$r3JG<$9$kG[Ns(B */
	((*dum_ptr + i)->gene_pi_i) = 
	    cvector((long)1, (long)(((*dum_ptr + i)->state)*UNIT_PI));
	for(j = 1; j <= ((*dum_ptr + i)->state)*UNIT_PI; j++){
	    ((*dum_ptr + i)->gene_pi_i)[j] = ((*ptr + i)->gene_pi_i)[j];
	}

	/* HMM$B$N3F>uBV$K$*$1$k1v4pIQEY$N=i4|CM$r3JG<$9$kG[Ns(B */
	((*dum_ptr + i)->gene_freq) = 
	    cvector((long)1, (long)(((*dum_ptr + i)->state)*UNIT_FRQ*NUCL));
	for(j = 1; j <= ((*dum_ptr + i)->state)*UNIT_FRQ*NUCL; j++){
	    ((*dum_ptr + i)->gene_freq)[j] = ((*ptr + i)->gene_freq)[j];
	}

	/* HMM$B$N7k9g9TNs$r3JG<$9$kG[Ns(B */
	(*dum_ptr + i)->connect = 
	    imatrix(1, (long)((*dum_ptr + i)->state), 
		    1, (long)((*dum_ptr + i)->state));
	for(j = 1; j <= ((*dum_ptr + i)->state); j++){
	    for(k = 1; k <= ((*dum_ptr + i)->state); k++){
		((*dum_ptr + i)->connect)[j][k] = ((*ptr + i)->connect)[j][k];
	    }
	}

	/* HMM$B$NA+0\3NN($N=i4|CM(B($B<B?t$KJQ49$5$l$?$b$N(B)$B$r3JG<$9$kG[Ns(B */
	(*dum_ptr + i)->a0_ij = 
	    dmatrix(1, (long)((*dum_ptr + i)->state), 
		    1, (long)((*dum_ptr + i)->state));
	for(j = 1; j <= ((*dum_ptr + i)->state); j++){
	    for(k = 1; k <= ((*dum_ptr + i)->state); k++){
		((*dum_ptr + i)->a0_ij)[j][k] = ((*ptr + i)->a0_ij)[j][k];
	    }
	}

	/* HMM$B$N=i4|>uBVJ,I[(B($B<B?t$KJQ49$5$l$?$b$N(B)$B$r3JG<$9$kG[Ns(B */
	(*dum_ptr + i)->pi_i = dvector(1, (long)((*dum_ptr + i)->state));
	for(j = 1; j <= ((*dum_ptr + i)->state); j++){
	    ((*dum_ptr + i)->pi_i)[j] = ((*ptr + i)->pi_i)[j];
	}

	/* HMM$B$N3F>uBV$K$*$1$k1v4pIQEY(B(10$B?J?t$KJQ49$5$l$?$b$N(B)$B$r(B
	   $B3JG<$9$kG[Ns(B */
	(*dum_ptr + i)->freq = 
	    dvector(1, (long)((*dum_ptr + i)->state)*NUCL);
	for(j = 1; j <= ((*dum_ptr + i)->state)*NUCL; j++){
	    ((*dum_ptr + i)->freq)[j] = ((*ptr + i)->freq)[j];
	}

	/* $BJ?6QBP?tL`EY(B */
	(*dum_ptr + i)->likelihd = (*ptr + i)->likelihd;

	/* HMM$B$N<+M3%Q%i%a!<%??t(B */
	(*dum_ptr + i)->num_p = (*ptr + i)->num_p;

	/* AIC */
	(*dum_ptr + i)->aic = (*ptr + i)->aic;

	/* $BE,1~EY(B(1/AIC) */
	(*dum_ptr + i)->raw_fitness = (*ptr + i)->raw_fitness;

	/* $BE,1~EY(B */
	(*dum_ptr + i)->scaled_fitness = (*ptr + i)->scaled_fitness;

    }


    return(0);
}


