#include <stdlib.h>
#include <math.h>
#include <stdio.h>

#include "hmm-gene.h"
#include "ga.h"


int i_mutation(INDIVIDUAL **individual_ptr, int id, int pos, GA_CND *ga_cnd)
{
    int i, j, k, l;
    double fdum;

    int state;
    int new_state;
    unsigned char *dum_gene_connect;
    unsigned char *dum_gene_a0_ij;
    unsigned char *dum_gene_pi_i;
    unsigned char *dum_gene_freq;

    float xrandom(long *);
    int copy_cvector(unsigned char *, int, unsigned char *);
    unsigned char *cvector(long, long);
    double **dmatrix(long, long, long, long);
    double *dvector(long, long);
    int **imatrix(long, long, long, long);
    int *ivector(long, long);
    void free_cvector(unsigned char *, long, long);
    void free_dmatrix(double **, long, long, long, long);
    void free_dvector(double *, long, long);
    void free_imatrix(int **, long, long, long, long);
    void free_ivector(int *, long, long);


    /* $B>uBV?t(B */
    state = ((*individual_ptr) + id)->state;
    new_state = (((*individual_ptr) + id)->state) + 1;
    ((*individual_ptr) + id)->state = new_state;


    /* HMM$B$N7k9g9TNs$r3JG<$9$kG[Ns(B */
    dum_gene_connect = cvector((long)1, (long)(state*state));
    copy_cvector(((*individual_ptr) + id)->gene_connect, state*state, 
		 dum_gene_connect);
    free_cvector(((*individual_ptr) + id)->gene_connect, 
		 (long)1, (long)(state*state));
    ((*individual_ptr) + id)->gene_connect = 
	cvector((long)1, (long)(new_state*new_state));
#ifdef DEBUG
    fprintf(stderr, "connect gene...\n");
#endif
    /* $B?7$?$K@8@.$5$l$kA4$F$N7k9g$O3NN(E*$K7hDj$9$k<jK!(B */
    k = 1;
    for(i = 1; i <= new_state; i++){
	if(i != (pos+1)){
	    for(j = 1; j <= new_state; j++){
		if(j != (pos+1)){
		    (((*individual_ptr) + id)->gene_connect)[(i-1)*new_state+j]
			= dum_gene_connect[k];
		    k++;
		}
		else{
		    /* $BA^F~$5$l$?>uBV$N7k9g9TNs$rMp?t$G7hDj(B */
		    fdum = xrandom(&(ga_cnd->seed));
#ifdef DEBUG
		    fprintf(stderr, "%f ", fdum);
#endif
		    if(fdum < HALF){
			(((*individual_ptr) + id)->
			 gene_connect)[(i-1)*new_state+j] = '0';
		    }
		    else{
			(((*individual_ptr) + id)->
			 gene_connect)[(i-1)*new_state+j] = '1';
		    }
		}
	    }
	}
	else{
	    for(j = 1; j <= new_state; j++){
		/* $BA^F~$5$l$?>uBV$N7k9g9TNs$rMp?t$G7hDj(B */
		fdum = xrandom(&(ga_cnd->seed));
#ifdef DEBUG
		fprintf(stderr, "%f ", fdum);
#endif
		if(fdum < HALF){
		    (((*individual_ptr) + id)->
		     gene_connect)[(i-1)*new_state+j] = '0';
		}
		else{
		    (((*individual_ptr) + id)->
		     gene_connect)[(i-1)*new_state+j] = '1';
		}
	    }
	}
    }
#ifdef DEBUG
	    fprintf(stderr, "\n");
#endif
    /* Iterative Duplication method $B$K4p$E$$$?<jK!(B */
    k = 1;
    for(i = 1; i <= new_state; i++){
	if(i != (pos+1)){
	    for(j = 1; j <= new_state; j++){
		if(j != (pos+1)){
		    (((*individual_ptr) + id)->gene_connect)[(i-1)*new_state+j]
			= dum_gene_connect[k];
		    k++;
		}
	    }
	}
    }
    /* $B>uBV(Bpos$B$,4XO"$7$F$$$?>uBV$H>uBV(B(pos+1)$B4V$N%k!<%W(B */
    for(i = 1; i <= new_state; i++){
	if(i != (pos+1)){
	    (((*individual_ptr) + id)->gene_connect)[pos*new_state+i] 
		= (((*individual_ptr) + id)->gene_connect)[(pos-1)*new_state+i];
	    (((*individual_ptr) + id)->gene_connect)[(i-1)*new_state+(pos+1)] 
		= (((*individual_ptr) + id)->gene_connect)[(i-1)*new_state+pos];
	}
    }
    /* $B>uBV(Bpos$B$H>uBV(B(pos+1)$B4V$N%k!<%W(B */
    (((*individual_ptr) + id)->gene_connect)[(pos-1)*new_state+(pos+1)]
	= '1';
    (((*individual_ptr) + id)->gene_connect)[pos*new_state+pos]
	= '1';
    /* $B<+8J%k!<%W(B */
    (((*individual_ptr) + id)->gene_connect)[pos*new_state+(pos+1)]
	= dum_gene_connect[(pos-1)*state+pos];

    free_cvector(dum_gene_connect, (long)1, (long)(state*state));


    /* HMM$B$NA+0\3NN($N=i4|CM$r3JG<$9$kG[Ns(B */
    dum_gene_a0_ij = cvector((long)1, (long)(state*state*UNIT_AIJ));
    copy_cvector(((*individual_ptr) + id)->gene_a0_ij, state*state*UNIT_AIJ, 
		 dum_gene_a0_ij);
    free_cvector(((*individual_ptr) + id)->gene_a0_ij, 
		 (long)1, (long)(state*state*UNIT_AIJ));
    ((*individual_ptr) + id)->gene_a0_ij = 
	cvector((long)1, (long)(new_state*new_state*UNIT_AIJ));
#ifdef DEBUG
    fprintf(stderr, "trans. prob. gene...\n");
#endif
    l = 1;
    for(i = 1; i <= new_state; i++){
	if(i != (pos+1)){
	    for(j = 1; j <= new_state; j++){
		if(j != (pos+1)){
		    for(k = 1; k <= UNIT_AIJ; k++){
			(((*individual_ptr) + id)->gene_a0_ij)
			    [(i-1)*new_state*UNIT_AIJ+(j-1)*UNIT_AIJ+k] = 
				dum_gene_a0_ij[l];
			l++;
		    }
		}
		else{
		    /* $BA^F~$5$l$?>uBV$N>uBVA+0\3NN($rMp?t$G7hDj(B */
		    for(k = 1; k <= UNIT_AIJ; k++){
			fdum = xrandom(&(ga_cnd->seed));
#ifdef DEBUG
			fprintf(stderr, "%f ", fdum);
#endif
			if(fdum < HALF){
			    (((*individual_ptr) + id)->gene_a0_ij)
				[(i-1)*new_state*UNIT_AIJ+(j-1)*UNIT_AIJ+k]
				    = '0';
			}
			else{
			    (((*individual_ptr) + id)->gene_a0_ij)
				[(i-1)*new_state*UNIT_AIJ+(j-1)*UNIT_AIJ+k] 
				    = '1';
			}
		    }
		}
	    }
	}
	else{
	    for(j = 1; j <= new_state; j++){
		/* $BA^F~$5$l$?>uBV$N>uBVA+0\3NN($rMp?t$G7hDj(B */
		for(k = 1; k <= UNIT_AIJ; k++){
		    fdum = xrandom(&(ga_cnd->seed));
#ifdef DEBUG
		    fprintf(stderr, "%f ", fdum);
#endif
		    if(fdum < HALF){
			(((*individual_ptr) + id)->gene_a0_ij)
			    [(i-1)*new_state*UNIT_AIJ+(j-1)*UNIT_AIJ+k] = '0';
		    }
		    else{
			(((*individual_ptr) + id)->gene_a0_ij)
			    [(i-1)*new_state*UNIT_AIJ+(j-1)*UNIT_AIJ+k] = '1';
		    }
		}
	    }
	}
    }
#ifdef DEBUG
	    fprintf(stderr, "\n");
#endif
    free_cvector(dum_gene_a0_ij, (long)1, (long)(state*state*UNIT_AIJ));


    /* HMM$B$N>uBVJ,I[$N=i4|CM$r3JG<$9$kG[Ns(B */
    dum_gene_pi_i = cvector((long)1, (long)(state*UNIT_PI));
    copy_cvector(((*individual_ptr) + id)->gene_pi_i, state*UNIT_PI, 
		 dum_gene_pi_i);
    free_cvector(((*individual_ptr) + id)->gene_pi_i, 
		 (long)1, (long)(state*UNIT_PI));
    ((*individual_ptr) + id)->gene_pi_i = 
	cvector((long)1, (long)(new_state*UNIT_PI));
#ifdef DEBUG
    fprintf(stderr, "pi_i gene...\n");
#endif
    j = 1;
    for(i = 1; i <= new_state*UNIT_PI; i++){
	if((i > pos*UNIT_PI) && (i <= (pos+1)*UNIT_PI)){
	    /* $BA^F~$5$l$?>uBV$K$*$1$k>uBVJ,I[$rMp?t$G7hDj(B */
	    fdum = xrandom(&(ga_cnd->seed));
#ifdef DEBUG
	    fprintf(stderr, "%f ", fdum);
#endif
	    if(fdum < HALF){
		(((*individual_ptr) + id)->gene_pi_i)[i] = '0';
	    }
	    else{
		(((*individual_ptr) + id)->gene_pi_i)[i] = '1';
	    }
	}
	else{
	    (((*individual_ptr) + id)->gene_pi_i)[i] = dum_gene_pi_i[j];
	    j++;
	}
    }
#ifdef DEBUG
	    fprintf(stderr, "\n");
#endif
    free_cvector(dum_gene_pi_i, (long)1, (long)(state*UNIT_PI));


    /* HMM$B$N3F>uBV$K$*$1$k1v4pIQEY$N=i4|CM$r3JG<$9$kG[Ns(B */
    dum_gene_freq = cvector((long)1, (long)(state*UNIT_FRQ*NUCL));
    copy_cvector(((*individual_ptr) + id)->gene_freq, state*UNIT_FRQ*NUCL, 
		 dum_gene_freq);
    free_cvector(((*individual_ptr) + id)->gene_freq, 
		 (long)1, (long)(state*UNIT_FRQ*NUCL));
    ((*individual_ptr) + id)->gene_freq = 
	cvector((long)1, (long)(new_state*UNIT_FRQ*NUCL));
#ifdef DEBUG
    fprintf(stderr, "freq. gene...\n");
#endif
    j = 1;
    for(i = 1; i <= new_state*UNIT_FRQ*NUCL; i++){
	if((i > pos*UNIT_FRQ*NUCL) && (i <= (pos+1)*UNIT_FRQ*NUCL)){
	    /* $BA^F~$5$l$?>uBV$K$*$1$k1v4pIQEY$rMp?t$G7hDj(B */
	    fdum = xrandom(&(ga_cnd->seed));
#ifdef DEBUG
	    fprintf(stderr, "%f ", fdum);
#endif
	    if(fdum < HALF){
		(((*individual_ptr) + id)->gene_freq)[i] = '0';
	    }
	    else{
		(((*individual_ptr) + id)->gene_freq)[i] = '1';
	    }
	}
	else{
	    (((*individual_ptr) + id)->gene_freq)[i] = dum_gene_freq[j];
	    j++;
	}
    }
#ifdef DEBUG
	    fprintf(stderr, "\n");
#endif
    free_cvector(dum_gene_freq, (long)1, (long)(state*UNIT_FRQ*NUCL));


    /* HMM$B$N7k9g9TNs$r3JG<$9$kG[Ns(B */
    if((((*individual_ptr) + id)->connect) != NULL){
	free_imatrix(((*individual_ptr) + id)->connect, 
		     (long)1, (long)(((*individual_ptr) + id)->state), 
		     (long)1, (long)(((*individual_ptr) + id)->state));
    }
    ((*individual_ptr) + id)->connect = 
	imatrix(1, (long)new_state, 1, (long)new_state);


    /* HMM$B$NA+0\3NN($N=i4|CM(B($B<B?t$KJQ49$5$l$?$b$N(B)$B$r3JG<$9$kG[Ns(B */
    if((((*individual_ptr) + id)->a0_ij) != NULL){
	free_dmatrix(((*individual_ptr) + id)->a0_ij, 
		     (long)1, (long)(((*individual_ptr) + id)->state), 
		     (long)1, (long)(((*individual_ptr) + id)->state));
    }
    ((*individual_ptr) + id)->a0_ij = 
	dmatrix(1, (long)new_state, 1, (long)new_state);



    /* HMM$B$N=i4|>uBVJ,I[(B($B<B?t$KJQ49$5$l$?$b$N(B)$B$r3JG<$9$kG[Ns(B */
    if((((*individual_ptr) + id)->pi_i) != NULL){
	free_dvector(((*individual_ptr) + id)->pi_i, 
		     (long)1, (((*individual_ptr) + id)->state));
    }
    ((*individual_ptr) + id)->pi_i = dvector(1, (long)new_state);
    

    /* HMM$B$N3F>uBV$K$*$1$k1v4pIQEY(B(10$B?J?t$KJQ49$5$l$?$b$N(B)$B$r(B
       $B3JG<$9$kG[Ns(B */
    if((((*individual_ptr) + id)->freq) != NULL){
	free_dvector(((*individual_ptr) + id)->freq, 
		     (long)1, (((*individual_ptr) + id)->state)*NUCL);
    }
    ((*individual_ptr) + id)->freq = dvector(1, (long)new_state*NUCL);


    return(0);
}


