#include <stdlib.h>
#include <math.h>
#include <stdio.h>

#include "hmm-gene.h"
#include "ga.h"


int d_mutation(INDIVIDUAL **individual_ptr, int id, int pos, GA_CND *ga_cnd)
{
    int i, j, k, l;

    int state;
    int new_state;
    unsigned char *dum_gene_connect;
    unsigned char *dum_gene_a0_ij;
    unsigned char *dum_gene_pi_i;
    unsigned char *dum_gene_freq;
    int *from;
    int *to;

    int copy_cvector(unsigned char *, int, unsigned char *);
    unsigned char *cvector(long, long);
    double **dmatrix(long, long, long, long);
    double *dvector(long, long);
    int **imatrix(long, long, long, long);
    int *ivector(long, long);
    void free_cvector(unsigned char *, long, long);
    void free_dmatrix(double **, long, long, long, long);
    void free_dvector(double *, long, long);
    void free_imatrix(int **, long, long, long, long);
    void free_ivector(int *, long, long);


    /* $B>uBV?t(B */
    state = ((*individual_ptr) + id)->state;
    new_state = (((*individual_ptr) + id)->state) - 1;
    ((*individual_ptr) + id)->state = new_state;


    /* $B>uBV(Bpos$B$K7k9g$7$F$$$?>uBV$O(B? */
    from = ivector((long)1, (long)new_state);
    for(i = 1; i <= new_state; i++){
	from[i] = 0;
    }
    j = 1;
    for(i = 1; i <= state; i++){
	if(i != pos){
	    if((((*individual_ptr) + id)->gene_connect)[(i-1)*state+pos] 
	       == '1'){
		from[j] = 1;
	    }
	    j++;
	}
    }


    /* $B>uBV(Bpos$B$+$i7k9g$5$l$F$$$?>uBV$O(B? */
    to = ivector((long)1, (long)new_state);
    for(i = 1; i <= new_state; i++){
	to[i] = 0;
    }
    j = 1;
    for(i = 1; i <= state; i++){
	if(i != pos){
	    if((((*individual_ptr) + id)->gene_connect)[(pos-1)*state+i] 
	       == '1'){
		to[j] = 1;
	    }
	    j++;
	}
    }
#ifdef DEBUG
    fprintf(stderr, "--- following new connection should be generated...\n");
    for(i = 1; i <= new_state; i++){
	for(j = 1; j <= new_state; j++){
	    if((from[i] == 1) && (to[j] == 1)){
		fprintf(stderr, "    %d->%d\n", i, j);
	    }
	}
    }
#endif


    /* HMM$B$N7k9g9TNs$r3JG<$9$kG[Ns(B */
    dum_gene_connect = cvector((long)1, (long)(state*state));
    copy_cvector(((*individual_ptr) + id)->gene_connect, state*state, 
		 dum_gene_connect);
    free_cvector(((*individual_ptr) + id)->gene_connect, 
		 (long)1, (long)(state*state));
    ((*individual_ptr) + id)->gene_connect = 
	cvector((long)1, (long)(new_state*new_state));
    k = 1;
    for(i = 1; i <= state; i++){
	if(i != pos){
	    for(j = 1; j <= state; j++){
		if(j != pos){
		    (((*individual_ptr) + id)->gene_connect)[k] = 
			dum_gene_connect[(i-1)*state+j];
		    k++;
		}
	    }
	}
    }
    free_cvector(dum_gene_connect, (long)1, (long)(state*state));


    /* HMM$B$NA+0\3NN($N=i4|CM$r3JG<$9$kG[Ns(B */
    dum_gene_a0_ij = cvector((long)1, (long)(state*state*UNIT_AIJ));
    copy_cvector(((*individual_ptr) + id)->gene_a0_ij, state*state*UNIT_AIJ, 
		 dum_gene_a0_ij);
    free_cvector(((*individual_ptr) + id)->gene_a0_ij, 
		 (long)1, (long)(state*state*UNIT_AIJ));
    ((*individual_ptr) + id)->gene_a0_ij = 
	cvector((long)1, (long)(new_state*new_state*UNIT_AIJ));
    l = 1;
    for(i = 1; i <= state; i++){
	if(i != pos){
	    for(j = 1; j <= state; j++){
		if(j != pos){
		    for(k = 1; k <= UNIT_AIJ; k++){
			(((*individual_ptr) + id)->gene_a0_ij)[l] = 
			    dum_gene_a0_ij[(i-1)*state*UNIT_AIJ+
					   (j-1)*UNIT_AIJ+k];
			l++;
		    }
		}
	    }
	}
    }
    free_cvector(dum_gene_a0_ij, (long)1, (long)(state*state*UNIT_AIJ));


    /* HMM$B$N>uBVJ,I[$N=i4|CM$r3JG<$9$kG[Ns(B */
    dum_gene_pi_i = cvector((long)1, (long)(state*UNIT_PI));
    copy_cvector(((*individual_ptr) + id)->gene_pi_i, state*UNIT_PI, 
		 dum_gene_pi_i);
    free_cvector(((*individual_ptr) + id)->gene_pi_i, 
		 (long)1, (long)(state*UNIT_PI));
    ((*individual_ptr) + id)->gene_pi_i = 
	cvector((long)1, (long)(new_state*UNIT_PI));
    j = 1;
    for(i = 1; i <= state*UNIT_PI; i++){
	if((i <= (pos-1)*UNIT_PI) || (i > pos*UNIT_PI)){
	    (((*individual_ptr) + id)->gene_pi_i)[j] = dum_gene_pi_i[i];
	    j++;
	}
    }
    free_cvector(dum_gene_pi_i, (long)1, (long)(state*UNIT_PI));


    /* HMM$B$N3F>uBV$K$*$1$k1v4pIQEY$N=i4|CM$r3JG<$9$kG[Ns(B */
    dum_gene_freq = cvector((long)1, (long)(state*UNIT_FRQ*NUCL));
    copy_cvector(((*individual_ptr) + id)->gene_freq, state*UNIT_FRQ*NUCL, 
		 dum_gene_freq);
    free_cvector(((*individual_ptr) + id)->gene_freq, 
		 (long)1, (long)(state*UNIT_FRQ*NUCL));
    ((*individual_ptr) + id)->gene_freq = 
	cvector((long)1, (long)(new_state*UNIT_FRQ*NUCL));
    j = 1;
    for(i = 1; i <= state*UNIT_FRQ*NUCL; i++){
	if((i <= (pos-1)*UNIT_FRQ*NUCL) || (i > pos*UNIT_FRQ*NUCL)){
	    (((*individual_ptr) + id)->gene_freq)[j] = dum_gene_freq[i];
	    j++;
	}
    }
    free_cvector(dum_gene_freq, (long)1, (long)(state*UNIT_FRQ*NUCL));


    /* HMM$B$N7k9g9TNs$r3JG<$9$kG[Ns(B */
    if((((*individual_ptr) + id)->connect) != NULL){
	free_imatrix(((*individual_ptr) + id)->connect, 
		     (long)1, (long)(((*individual_ptr) + id)->state), 
		     (long)1, (long)(((*individual_ptr) + id)->state));
    }
    ((*individual_ptr) + id)->connect = 
	imatrix(1, (long)new_state, 1, (long)new_state);


    /* HMM$B$NA+0\3NN($N=i4|CM(B($B<B?t$KJQ49$5$l$?$b$N(B)$B$r3JG<$9$kG[Ns(B */
    if((((*individual_ptr) + id)->a0_ij) != NULL){
	free_dmatrix(((*individual_ptr) + id)->a0_ij, 
		     (long)1, (long)(((*individual_ptr) + id)->state), 
		     (long)1, (long)(((*individual_ptr) + id)->state));
    }
    ((*individual_ptr) + id)->a0_ij = 
	dmatrix(1, (long)new_state, 1, (long)new_state);



    /* HMM$B$N=i4|>uBVJ,I[(B($B<B?t$KJQ49$5$l$?$b$N(B)$B$r3JG<$9$kG[Ns(B */
    if((((*individual_ptr) + id)->pi_i) != NULL){
	free_dvector(((*individual_ptr) + id)->pi_i, 
		     (long)1, (((*individual_ptr) + id)->state));
    }
    ((*individual_ptr) + id)->pi_i = dvector(1, (long)new_state);
    

    /* HMM$B$N3F>uBV$K$*$1$k1v4pIQEY(B(10$B?J?t$KJQ49$5$l$?$b$N(B)$B$r(B
       $B3JG<$9$kG[Ns(B */
    if((((*individual_ptr) + id)->freq) != NULL){
	free_dvector(((*individual_ptr) + id)->freq, 
		     (long)1, (((*individual_ptr) + id)->state)*NUCL);
    }
    ((*individual_ptr) + id)->freq = dvector(1, (long)new_state*NUCL);


    /* $B>uBV(Bpos$B$r7PM3$7$F7k9g$7$F$$$?>uBV$r7k9g$5$;$k(B */
    for(i = 1; i <= new_state; i++){
	for(j = 1; j <= new_state; j++){
	    if((from[i] == 1) && (to[j] == 1)){
		/* $B7k9g9TNs$N$_$rJQ99$9$k!%(B
		   $B$=$NB>$N%Q%i%a!<%?$O4{B8$N$b$N$rMQ$$$k!%(B */
		(((*individual_ptr) + id)->gene_connect)[(i-1)*new_state+j]
		    = '1';
	    }
	}
    }
    free_ivector(from, (long)1, (long)new_state);
    free_ivector(to, (long)1, (long)new_state);


    return(0);
}


