#include <stdlib.h>
#include <math.h>
#include <stdio.h>

#include "hmm-gene.h"
#include "ga.h"

int ga()
{
    int t;
    GA_CND ga_cnd;
    INDIVIDUAL *individual_ptr;
    INDIVIDUAL *dum_ptr;

    int read_ga_cnd(char *, GA_CND *);
    int alloc_individual(GA_CND, INDIVIDUAL **);
    int free_individual(GA_CND, INDIVIDUAL *);
    int ga_initial(GA_CND *, INDIVIDUAL **);
    int fitness(GA_CND, INDIVIDUAL **);
    int scaling1(int, GA_CND *, INDIVIDUAL **);
    int scaling2(int, GA_CND *, INDIVIDUAL **, INDIVIDUAL **);
    int selection1(GA_CND *, INDIVIDUAL **);
    int selection2(GA_CND *, INDIVIDUAL **, INDIVIDUAL **);
    int recombination(GA_CND *, INDIVIDUAL **);
    int mutation(GA_CND *, INDIVIDUAL **);

    int show_population(GA_CND *, INDIVIDUAL **);
    int copying(GA_CND, INDIVIDUAL **, INDIVIDUAL **);


    /* GA˴ؤե(./ga.cnd)ɤ߹ࡥ */
#ifdef DEBUG
    fprintf(stderr, "--- reading conditions of GA...\n");
#endif
    if(read_ga_cnd("./ga.cnd", &ga_cnd) != 0){
	fprintf(stderr, "error occures in read_ga_cnd()...\n");
	return(-1);
    }
#ifdef DEBUG
    fprintf(stderr, "    num. generation = %d\n", ga_cnd.generation);
    fprintf(stderr, "    population size = %d\n", ga_cnd.population);
    fprintf(stderr, "    recombination rate   = %f\n", ga_cnd.recombination);
    fprintf(stderr, "    point mutation rate  = %f\n", ga_cnd.pmutation);
    fprintf(stderr, "    insert mutation rate = %f\n", ga_cnd.imutation);
    fprintf(stderr, "    delete mutation rate = %f\n", ga_cnd.dmutation);
    fprintf(stderr, "    init. num. of states = %d\n", ga_cnd.state);
    fprintf(stderr, "    scaling const. = %f\n", ga_cnd.scale_const);
    fprintf(stderr, "    seed = %d\n", ga_cnd.seed);
#endif


    /* ɬץݤ롥 */
#ifdef DEBUG
    fprintf(stderr, "--- allocating memory of individuals...\n");
#endif
    if(alloc_individual(ga_cnd, &individual_ptr) != 0){
	fprintf(stderr, "error occures in alloc_individual()...\n");
	free_individual(ga_cnd, individual_ptr);
	return(-1);
    }


    /* ͤꤹ롥 */
#ifdef DEBUG
    fprintf(stderr, "--- setting initial state of individuals...\n");
#endif
    if(ga_initial(&ga_cnd, &individual_ptr) != 0){
	fprintf(stderr, "error occures in ga_initial()...\n");
	free_individual(ga_cnd, individual_ptr);
	return(-1);
    }
#ifdef DEBUG
    show_population(&ga_cnd, &individual_ptr);
#endif


    t = 0;
#ifdef DEBUG
    fprintf(stderr, "--- generation= %d ...\n", t);
#endif
    fprintf(stdout, "--- generation= %d ...\n", t);
    fflush(stdout);
    fprintf(stderr, "--- generation = %d...\n", t);
    fflush(stderr);

    /* HMMˤƸΤŬ٤ɾ롥 */
#ifdef DEBUG
    fprintf(stderr, "--- calculating fitness of each individual...\n");
#endif
    if(fitness(ga_cnd, &individual_ptr) != 0){
	fprintf(stderr, "error occures in fitness()...\n");
	free_individual(ga_cnd, individual_ptr);
	return(-1);
    }


    /* Ŭ٤򥹥󥰤롥 */
#ifdef DEBUG
    fprintf(stderr, "--- perform scaling1...\n");
#endif
    if(scaling1(t, &ga_cnd, &individual_ptr) != 0){
	fprintf(stderr, "error occures in scaling1()...\n");
	free_individual(ga_cnd, individual_ptr);
	return(-1);
    }


    /* GA(Υ롼) */
#ifdef DEBUG
    fprintf(stderr, "--- performing GA...\n");
#endif
    for(t = 1; t <= ga_cnd.generation; t++){

#ifdef DEBUG
	fprintf(stderr, "--- generation= %d ...\n", t);
#endif
	fprintf(stdout, "--- generation= %d ...\n", t);
	fflush(stdout);
	fprintf(stderr, "--- generation = %d...\n", t);
	fflush(stderr);


	/* ƽĤ򥳥ԡ */
#ifdef DEBUG
	fprintf(stderr, "--- copying current population...\n");
#endif
	if(copying(ga_cnd, &individual_ptr, &dum_ptr) != 0){
	    fprintf(stderr, "error occures in copying()...\n");
	    free_individual(ga_cnd, individual_ptr);
	    free_individual(ga_cnd, dum_ptr);
	    return(-1);
	}


	/* Ԥʤ
	   individual_ptrϻҽĤ˹롥
	   âselection1()θ˰ŪԤʤ뤿ᡤ
	   ƸΤΰŪоݤΤΤߥԡ롥
	   (mating2Τξֿ) */
#ifdef DEBUG
	fprintf(stderr, "--- perform selection1...\n");
#endif
	if(selection1(&ga_cnd, &individual_ptr) != 0){
	    fprintf(stderr, "error occures in selection1()...\n");
	    free_individual(ga_cnd, individual_ptr);
	    free_individual(ga_cnd, dum_ptr);
	    return(-1);
	}


	/* ȴԤʤ */
#ifdef DEBUG
	fprintf(stderr, "--- perform recombination...\n");
#endif
	if(recombination(&ga_cnd, &individual_ptr) != 0){
	    fprintf(stderr, "error occures in recombination()...\n");
	    free_individual(ga_cnd, individual_ptr);
	    free_individual(ga_cnd, dum_ptr);
	    return(-1);
	}


	/* ѰۤԤʤ */
#ifdef DEBUG
	fprintf(stderr, "--- perform mutation...\n");
#endif
	if(mutation(&ga_cnd, &individual_ptr) != 0){
	    fprintf(stderr, "error occures in mutation()...\n");
	    free_individual(ga_cnd, individual_ptr);
	    free_individual(ga_cnd, dum_ptr);
	    return(-1);
	}


	/* HMMˤƸΤŬ٤ɾ롥 */
#ifdef DEBUG
	fprintf(stderr, "--- calculating fitness of each individual...\n");
#endif
	if(fitness(ga_cnd, &individual_ptr) != 0){
	    fprintf(stderr, "error occures in fitness()...\n");
	    free_individual(ga_cnd, individual_ptr);
	    free_individual(ga_cnd, dum_ptr);
	    return(-1);
	}


	/* Ŭ٤򥹥󥰤롥 */
#ifdef DEBUG
	fprintf(stderr, "--- perform scaling2...\n");
#endif
	if(scaling2(t, &ga_cnd, &individual_ptr, &dum_ptr) != 0){
	    fprintf(stderr, "error occures in scaling2()...\n");
	    free_individual(ga_cnd, individual_ptr);
	    free_individual(ga_cnd, dum_ptr);
	    return(-1);
	}


	/* Ԥʤ
	   individual_ptrϼ彸Ĥ˹롥
	   âselection2()θselection1()Ԥʤ뤿ᡤ
	   ƸΤΰŪоݤΤŬ٤ԡ롥
	   (mating2Τξֿ) */
#ifdef DEBUG
	fprintf(stderr, "--- perform selection2...\n");
#endif
	if(selection2(&ga_cnd, &individual_ptr, &dum_ptr) != 0){
	    fprintf(stderr, "error occures in selection2()...\n");
	    free_individual(ga_cnd, individual_ptr);
	    free_individual(ga_cnd, dum_ptr);
	    return(-1);
	}


	/* 女ԡΥ롥 */
#ifdef DEBUG
	fprintf(stderr, "--- releasing current population...\n");
#endif
	free_individual(ga_cnd, dum_ptr);


    }


    /* ɬץ롥 */
#ifdef DEBUG
    fprintf(stderr, "--- releaseing memory of individuals...\n");
#endif
    if(free_individual(ga_cnd, individual_ptr) != 0){
	fprintf(stderr, "error occures in free_individual()...\n");
	return(-1);
    }


    return(0);
}


