/* ---------------------------------------------------------- 
%(C)1994,1995 Institute for New Generation Computer Technology 
%       (Read COPYRIGHT for detailed information.) 
----------------------------------------------------------- */
/* ---------------------------------------------------------------- */
/*          writeNumber.c                                            */
/* ---------------------------------------------------------------- */

#include <X11/Intrinsic.h>
#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/StringDefs.h>
#include <Xm/Xm.h>
#include <Xm/DrawingA.h>
#include <stdio.h>
#include "stem.h"

/*
#define DEBUG TRUE
*/
extern unsigned long MyColor();
extern Widget   da;
XFontStruct *fn; 



/* convert integer to string */
/*   ex. 1234 -> "1234"      */
/* return  figure of given number  */
int NumberToString(count,countString)
     int count;
     char *countString;
{
  static char numberTable[11] = "0123456789";
  int tempNumber1,tempNumber2;

#ifdef DEBUG
  printf("count = %d ,numberTable = %s\n",count,numberTable);
#endif

  if(count < 10)
    { /* a number of one figure */
      *countString = numberTable[count];
      countString++;
      *countString = '\0';
      return 1;
    }
  else if(count <99) 
    { /* a number of two figures */
      tempNumber1 = count/10;
      tempNumber2 = count - 10*tempNumber1;
      *countString = numberTable[tempNumber1];
      countString++;
      *countString = numberTable[tempNumber2];
      countString++;
      *countString = '\0';
      return 2;
    }
  else if(count <999)
    { /* a number of three figures */
      tempNumber1 = count/100;
      tempNumber2 = count - 100*tempNumber1;
      countString[0] = numberTable[tempNumber1];
      tempNumber1 = tempNumber2/10;
      tempNumber2 = tempNumber2 - tempNumber1*10;
      countString[1] = numberTable[tempNumber1];
      countString[2] = numberTable[tempNumber2];
      countString[3] = '\0';
      return 3;
    }
  
  else if(count <9999)
    { /* a number of four figures */
      tempNumber1 = count/1000;
      tempNumber2 = count - 1000*tempNumber1;
      countString[0] = numberTable[tempNumber1];
      tempNumber1 = tempNumber2/100;
      tempNumber2 = tempNumber2 - tempNumber1*100;
      countString[1] = numberTable[tempNumber1];
      tempNumber1 = tempNumber2/10;
      tempNumber2 = tempNumber2 - tempNumber1*10;
      countString[2] = numberTable[tempNumber1];
      countString[3] = numberTable[tempNumber2];
      countString[4] = '\0';
      return 4;
    }
  else /* over five figures */
    {
      countString = "9999";
      return 4;
    }
}


/*  draw number of columns that make base pair  */

void hyoujiPairNumber(w,select_flag)
     Widget     w;
     int        select_flag;
{
  Display *d;
  Window w0;
  GC    gc;
  int n1,n2,n1_x,n1_y,n2_x,n2_y,mojisuu1,mojisuu2,count1;
  int n1_hyouji,n2_hyouji;
  char n1String[5] , n2String[5];

  d = XtDisplay(w);
  w0 = XtWindow(w);
  gc = XCreateGC(d,w0,0,0); 

/* load font */
/*  if(!fn)
    { */
      fn = XLoadQueryFont(d,"a16");
      if(!fn)
	fn = XLoadQueryFont(d,"a14");
      if(!fn)
	fn = XLoadQueryFont(d,"9x13");
      if(!fn)
	fn = XLoadQueryFont(d,"k16");
      if(!fn)
	fn = XLoadQueryFont(d,"r16");
      if(!fn)
	fn = XLoadQueryFont(d,"fixed");
      if(!fn)
	fn = XLoadQueryFont(d,"variable");
      if(!fn)
	fn = XLoadQueryFont(d,"6x13");
      if(!fn ) {
	fprintf(stderr,"Can't find font for explanatory notes\n");
	exit(1);
      }
      
      XSetFont(d,gc,fn->fid);
/*    } */
  if(toggle_flag) /*  draw figures*/
    XSetForeground(d,gc,MyColor(d,"black"));
  else       /*  erase figures */
    XSetForeground(d,gc,MyColor(d,"white"));

  count1 = 0;

  if(!select_flag)
    { /* ORIGINAL */
      
      while(PairListForHyouji[count1][0] != MAXIMUM)
	{
	  n1 = PairListForHyouji[count1][0];
	  n2 = PairListForHyouji[count1][1];
	  n1_hyouji = PairListForHyouji[count1][3];
	  n2_hyouji = PairListForHyouji[count1][4];
	  
	  mojisuu1 = NumberToString(n1_hyouji,n1String);
	  mojisuu2 = NumberToString(n2_hyouji,n2String);
	  
	  n1_x = zahyou_table[n1][2];
	  n1_y = zahyou_table[n1][3];
	  n2_x = zahyou_table[n2][2];
	  n2_y = zahyou_table[n2][3];
#ifdef DEBUG
	  printf("base1 = %s x1 = %4d,y1= %4d\n",n1String,n1_x,n1_y);
	  printf("base2 = %s x2 = %4d,y2= %4d\n",n2String,n2_x,n2_y);
#endif
	  XDrawString(d,w0,gc,n1_x,n1_y,n1String,mojisuu1);
	  XDrawString(d,w0,gc,n2_x,n2_y,n2String,mojisuu2);
	  count1++;
	}
    }

  else if(select_flag)
    { /* SELECT */
      
      while(PairListForHyoujiS[count1][0] != MAXIMUM)
	{
	  n1 = PairListForHyoujiS[count1][0];
	  n2 = PairListForHyoujiS[count1][1];
	  n1_hyouji = PairListForHyoujiS[count1][3];
	  n2_hyouji = PairListForHyoujiS[count1][4];
	  
	  mojisuu1 = NumberToString(n1_hyouji,n1String);
	  mojisuu2 = NumberToString(n2_hyouji,n2String);
	  
	  n1_x = zahyou_table_s[n1][2];
	  n1_y = zahyou_table_s[n1][3];
	  n2_x = zahyou_table_s[n2][2];
	  n2_y = zahyou_table_s[n2][3];
#ifdef DEBUG
	  printf("base1 = %s x1 = %4d,y1= %4d\n",n1String,n1_x,n1_y);
	  printf("base2 = %s x2 = %4d,y2= %4d\n",n2String,n2_x,n2_y);
#endif
	  XDrawString(d,w0,gc,n1_x,n1_y,n1String,mojisuu1);
	  XDrawString(d,w0,gc,n2_x,n2_y,n2String,mojisuu2);
	  count1++;
	}
    }
}


/* ---------------- end of "writeNumber.c" ------------------ */
