/* ---------------------------------------------------------- 
%(C)1994,1995 Institute for New Generation Computer Technology 
%       (Read COPYRIGHT for detailed information.) 
----------------------------------------------------------- */
#define TRUE 1
#define FALSE 0
#define SINGLE  1 
#define MAXLINE 1024
#define MAXSEQS 300 /* 10000 */
#define MAXCOLUMN 1000 /* 3000 */
#define MAXPAIRS  100 /* 10000 */
#define MAXIMUM   999
#define BASES 7  /* A,U,G,C,T,other base,GAP */
#define PERCENT_D  70 /* default percent */
#define ORIGINAL 0
#define SELECT 1

#define COLORS  27
#define XSTART 30
#define YSTART 42

#define RENZOKU    3   /* default number of consecutive pairs  */
#define RENZOKU_MAX    50   /* maximum of consecutive pairs (default) */

/* internal code for nucleic acids */
#define ADE 0  /* adenine */
#define URA 1  /* uracil */
#define GUA 2  /* guanine */
#define CIT 3  /* cytosine */
#define TIM 4  /* thymine */
#define OTHER 5 /* others A,U,G,C,T  */
#define GAP 6  /* gap */

/* pairvalue */
#define A_T      3  /*  A-T */
#define G_C      2  /*  G-C */ 
#define BOTH    1  /* A-T and G-C */
#define NONE   99  /* no base pairs */
#define GAP_COLUMN     -1

/* for X-Window  */

#define SMALL      50
#define HANKEIS    150 /* radius small */
#define HANKEIL    250 /* radius large */
#define SUU        30  /* distance between circle and column number */
#define X0        50  /* x location of XArc (default) */
#define Y0        50  /* y location of XArc (default) */
#define AKI       15  /* angle of opening in circle (default) */
#define ANGLE      4  /* angle for one column (default) */ 
#define LINE_W1    8   /* line width of Arc (default) */
#define LINE_W2    2   /* width of line that bind pairs (default) */

#define  HANREI_START_X   10    /* position x of starting
                                 explanatory notes (default) */
#define  HANREI_START_Y   16    /* position y of starting
                                 explanatory notes (default) */

typedef struct {
  int nameLength;
  char *seqName;            /* for sequence name */
 int seqlength;
  char *sequenceTemp;       
  char *sequence;           /*  for sequences */
}  SEQUENCES;

/* global variables */
extern FILE *fpr;    /* file pointer */
extern char datafile[MAXLINE]; /* data file name */

extern int singleMode;  /* data is only one sequence => TRUE,
			   more than two sequences => FALSE */
extern int Percent;    /* consensus % */
extern int NoOfSeqs;   /* number of sequences */
extern int NameLength; /* length of longest sequence name */
extern int NoOfColumn; /* number of columns */
extern int Renzoku;    /* number of consecutive pairs */
extern int  file_flag; /* flag whether data file is read or not */
extern int pre_percent; /* percent value before changed by scale */
extern int seqRead;     /* flag wheather sequence is read or not */

extern SEQUENCES  sequences[MAXSEQS];

extern int  consensus[MAXCOLUMN][2]; /* dominant base and
					  its number of each column */

extern int pair_matrix_all_1[MAXCOLUMN][MAXCOLUMN]; /* pair percent */
extern int pair_matrix_all_2[MAXCOLUMN][MAXCOLUMN]; /* kind of base pair */
extern int findPair;

extern int PairList[MAXPAIRS][3]; /* list of base pairs (column1 ,column2, pairvalue) */

extern int table_made; /* flag whether consensus_table is made or not */
extern int fileChanged; /* flag whether data file is changed or not */
                 /* calc_zahyou_data() sets FALSE */
extern int percentChanged; /* flag whether percent chaged or not */
extern int renzokuChanged; /* flag whether renzoku(consecutive) changed or not */

extern int toggle_flag;

extern int  xarc0,yarc0; /* location of XArc (x,y) */
extern int  xo,yo; /* center of XArc (x,y) */
 
extern int hankei;  /* radius */
extern double aki;  /* angle of opening in circle */
extern double angle; /* angle for one column */ 
extern int zahyou_table[MAXCOLUMN][4]; /* location of each column    */
extern int NoOfHyoujiColumn;            /* (number of columns) - (number of gap column) */
extern int PairListForHyouji[MAXPAIRS][5];   /* position   of pair columns */

extern int consensus_for_hyouji[MAXCOLUMN];  /* kind of dominant base in each column except gap column */
extern int original_hyouji_table[MAXCOLUMN];  /* order  of each base when gap columns are excluded */

extern int default_hankei;  /* default size of radius */
extern int daCreated;       /* flag whether da is created or not */
extern int resized;         /* flag whether size of circle_da changed or not */

extern int hanrei_start_x;         /* position x of starting explanatory notes */
extern int hanrei_start_y;         /* position y of starting explanatory notes */

extern int GCcreated;

extern int columns[MAXPAIRS][2];  /* items selected from list */


/*  for selected sequences */

extern int NoOfSelectedSeqs;  /* number of selected sequences */
extern int selectedSeqs[MAXSEQS]; /* sequence no.i is selected -> selectedSeqs[i] = TRUE */
                           /*               not selected -> selectedSeqs[i] = NULL */
extern int Percent_s;   /* consensus  % for selected sequences */
extern int Renzoku_s; /* number of consecutive pairs for selected sequences */

extern int  consensusSelected[MAXCOLUMN][2]; /* dominant base and its number of each column */
                                      /* from selected sequences */

extern int pair_matrix_all_1_s[MAXCOLUMN][MAXCOLUMN]; /* pair percent matrix of selected sequences */
extern int pair_matrix_all_2_s[MAXCOLUMN][MAXCOLUMN]; /* kind of base pair matrix of selected sequences */

extern int PairListSelected[MAXPAIRS][3]; /* base pairs of selected sequences (column1,column2,pairvalue) */
extern int percentChangedS; /* flag whether percent is changed or not for selected sequences */
extern int renzokuChangedS; /* flag whether renzoku(consecutive) changed or not for selected sequences n*/

/* X-Window  */

extern int  xarc0_s,yarc0_s; /* location of XArc for selected sequences  */
extern int  xo_s,yo_s; /* center of XArc for selected sequences */

extern int hankei_s;  /* radius for selected sequences */
extern double aki_s;  /* oepning of circle for selected sequences */
extern double angle_s; /* angle for each column for selected sequences */ 
extern int zahyou_table_s[MAXCOLUMN][4]; /* position of pair columns  for selected sequences */

extern int NoOfHyoujiColumnS;       /* (number of columns) - (number of gap column) for selected sequences */
extern int PairListForHyoujiS[MAXPAIRS][5]; /* position   of pair columns in selected sequences */

extern int consensus_for_hyoujiS[MAXCOLUMN]; /* kind of dominant base in each column except gap column */
extern int original_hyouji_tableS[MAXCOLUMN]; /* order  of each base when gap columns are excluded */

