/* ---------------------------------------------------------- 
%(C)1994,1995 Institute for New Generation Computer Technology 
%       (Read COPYRIGHT for detailed information.) 
----------------------------------------------------------- */
/* -------------------------------------------------------------- */
/*    showSelectedSeqs.c                                          */
/*       popup circular representation of selected sequences      */
/* -------------------------------------------------------------- */

#include <X11/Intrinsic.h>
#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/StringDefs.h>
#include <X11/Shell.h>
#include <Xm/DrawingA.h>
#include <Xm/Form.h>
#include <Xm/RowColumn.h>
#include <Xm/PushB.h>
#include <Xm/MessageB.h>
#include <Xm/ScrolledW.h>
#include <Xm/ScrollBar.h>
#include <Xm/Scale.h>
#include <stdio.h>
#include "stem.h"

extern unsigned long MyColor();
extern int       dispCreated;
extern int height,width;
extern Widget select_pop,select_list_pair,select_scale_p,select_scale_r;
extern int selectedseq;

extern void dispCircleS();
extern void AddItemToListS();
extern void createCircleS();

/* called when "select_ok" button pushed */
void show_select_seqs(w1,selectedSeqs,call_data)
     Widget         w1;
     int            *selectedSeqs;
     XmAnyCallbackStruct   *call_data;
{
  Arg    args[10];
  int    n;

/* set main window's  Percent and Renzoku (consecutive) */
  Percent_s = Percent;  
  Renzoku_s = Renzoku;  
  table_made = FALSE;
  NoOfHyoujiColumnS = 0;
  
  hankei_s = HANKEIS; /* radius is fixed  */
  
  /* check consensus and make pair list within the selected sequences */
  check_consensus(SELECT);  
  make_consensus_for_hyoji(SELECT); 
  calc_zahyou_data(SELECT); 
  make_matrix_all(SELECT); 
  makePairList_s();     
  makePairListForHyouji(SELECT); 
  
  /* create popup widget */
  
  if(!select_pop)
    {  /* popup widget is not yet made,so create one and draw circle and lists */
      createCircleS(w1);
      AddItemToListS();
    }
  else   /* popup widget is already made ,so popup  */
    {
      XtPopup(select_pop,XtGrabNone);
      n=0;
      XtSetArg(args[n],XmNvalue,Percent);
      n++;
      XtSetValues(select_scale_p,args,n);
      n=0;
      XtSetArg(args[n],XmNvalue,Renzoku);
      n++;
      XtSetValues(select_scale_r,args,n); 
      XMapRaised(XtDisplay(select_pop),XtWindow(select_pop));
    }
  
  XtPopup(select_pop,XtGrabNone);
  
}



/* --------------------- end of "showSelectedSeqs.c" ----------------------------------- */
