/* ---------------------------------------------------------- 
%(C)1994,1995 Institute for New Generation Computer Technology 
%       (Read COPYRIGHT for detailed information.) 
----------------------------------------------------------- */
/* ---------------------------------------------------------------- */
/*         selectSeqs.c                                             */
/*           select sequences using mouse                           */
/* ---------------------------------------------------------------- */

#include <X11/Intrinsic.h>
#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/StringDefs.h>
#include <X11/Shell.h>
#include <Xm/DrawingA.h>
#include <Xm/Form.h>
#include <Xm/RowColumn.h>
#include <Xm/PushB.h>
#include <Xm/MessageB.h>
#include <Xm/ScrolledW.h>
#include <Xm/ScrollBar.h>
#include <stdio.h>
#include "stem.h"
/*
#define DEBUG TRUE
*/
extern unsigned long MyColor();
extern int height,width;  /* height and width of character */
extern Widget da;
/* extern Widget form; */
extern Display  *d;
extern Pixmap    pixmap_da;
extern Window    win; 

extern GC   gc_for_Num;  /* GC for scale and seqnames */
int seqBegin,seqEnd;

void selectSeqs(w1,client_data,event)
     Widget         w1;
     caddr_t        client_data;
     XEvent         *event;
{
  int xBegin,yBegin ,
      xEnd,yEnd;
  int region_x,region_y;
  int x_start,y_start;
  int x,y;
  x_start = XSTART;
  y_start = YSTART;

  region_x = NameLength*width + width*NoOfColumn;
  region_y = height*NoOfSeqs;

  switch(event->type)
    {
    case ButtonPress: /* get the position where the mouse button was pushed */
      xBegin = event->xbutton.x;
      yBegin = event->xbutton.y;
      
      if( (x_start <= xBegin && xBegin <= (x_start + region_x)) &&
	 ((y_start-height) <= yBegin && yBegin <= (y_start + region_y)) )
	{  /* mouse button was pushed within the region alignment is drawn */
	  if( (y_start - height) < yBegin && yBegin <= y_start )
	    seqBegin = 0;
	  else
	    {
	      seqBegin = (yBegin - y_start)/height +1;
/*	      printf("seqBegin = %d\n",seqBegin); */
	    }
	  if(selectedSeqs[seqBegin] == 0) 
	    { /* current sequence is newly selected */
	      selectedSeqs[seqBegin] = TRUE;
	      XSetBackground(d,gc_for_Num,MyColor(d,"gray"));
	    }
	  else
	    { /* cancel the selection of current sequence */
	      selectedSeqs[seqBegin] = FALSE;
	      XSetBackground(d,gc_for_Num,MyColor(d,"black"));
	    }
	  x = x_start;
	  y = y_start + seqBegin*height;
	  XDrawImageString(d,pixmap_da,gc_for_Num,x,y,
			   sequences[seqBegin].seqName,sequences[seqBegin].nameLength); 
	  XCopyArea(d,pixmap_da,win,gc_for_Num,x,(y-height),width*NameLength,height,x,(y-height));
	}
      break;
      
    case MotionNotify: /* pointer is moved */
      xEnd = event->xbutton.x;
      yEnd = event->xbutton.y;
      
      if((x_start <= xEnd && xEnd <= (x_start + region_x)) &&
	 ((y_start-height) <= yEnd && yEnd <= (y_start + region_y)) )  
	{ /* pointer is  within the region alignment is drawn */
	  if( (y_start - height) < yEnd && yEnd <= y_start )
	    seqEnd = 0;
	  else
	    {
	      seqEnd = (yEnd - y_start)/height +1;
	    }
/*	  printf("seqEnd = %d\n",seqEnd); */
	  if(seqEnd == seqBegin) /* pointer is not moved to the next sequence */
	    ;
	  else
	    {
	      if(selectedSeqs[seqEnd] == 0) 
		{ /* current sequence is newly selected */
		  selectedSeqs[seqEnd] = TRUE;
		  XSetBackground(d,gc_for_Num,MyColor(d,"gray"));
		}
	      else
		{ /* cancel the selection of current sequence */
		  selectedSeqs[seqEnd] = FALSE;
		  XSetBackground(d,gc_for_Num,MyColor(d,"black"));
		}
	      x = x_start;
	      y = y_start + seqEnd*height;
	      XDrawImageString(d,pixmap_da,gc_for_Num,x,y,
			       sequences[seqEnd].seqName,sequences[seqEnd].nameLength);
	      XCopyArea(d,pixmap_da,win,gc_for_Num,x,(y-height),width*NameLength,height,x,(y-height));
	      seqBegin = seqEnd;
	    }
	}
    }
#ifdef DEBUG

  for(i=0;i!=NoOfSeqs;i++)
    printf(" %d",selectedSeqs[i]);
  printf("\n");
#endif

}

/* -------------- end of "selectSeqs.c" ---------------------------- */
