/* ---------------------------------------------------------- 
%(C)1994,1995 Institute for New Generation Computer Technology 
%       (Read COPYRIGHT for detailed information.) 
----------------------------------------------------------- */
/* --------------------------------------------------------------------- */
/*               pairList.c                                              */
/* --------------------------------------------------------------------- */
#include <X11/Xlib.h>
#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <X11/Shell.h>
#include <Xm/Xm.h>
#include <Xm/Label.h>
#include <Xm/Frame.h>
#include <Xm/Form.h>
#include <Xm/RowColumn.h>
#include <Xm/List.h>
#include <Xm/PushB.h>
#include <string.h> 
#include <stdio.h>
#include "stem.h"

/*
#define DEBUG TRUE
*/
extern Pixmap  pixmap_da;
extern Widget  da,circle_form,circle_frame;
extern GC gc_da;
Widget list_pair,list_cancel;

extern int current_da_width;     
int    ItemSelected,NoOfPair;
int    dispPairs;    /* flag wheather emphasize selected base pairs or not */

char   ListString[MAXPAIRS][12];
char          *string[MAXPAIRS];

extern void pairStringToIntString();
extern int NumberToString();
extern void dispSelectedPair(); /* emphasize selected base pairs */
extern void dispSeqs();
extern void undispSelectedPair(); /* cancel selected base pairs */

void sortColumns() /* sort columns */
{
  int i,temp[2],gap,j1,j2;

#ifdef DEBUG
  printf("---- columns sort -----\n");
  for(i=0;i != ItemSelected;i++)
    printf("columns[%d] : %2d  %2d \n",i,columns[i][0],columns[i][1]);
  printf("\n");
#endif

  for(gap = ItemSelected/2 ;gap != 0 ;gap = gap/2)
    {
      for(i = gap ; i != ItemSelected; i++)
	{
	  for(j1 = i-gap;j1 >= 0 ;j1 = j1 -gap)
	    {
	      j2 = j1 + gap;
/*
#ifdef DEBUG
	      printf("ji:columns[%d][0] = %d, ",j1,columns[j1][0]);
	      printf("j2:columns[%d][0] = %d\n",j2,columns[j2][0]);
#endif
*/
	      if(columns[j1][0] <= columns[j2][0])
		break;
	      else
		{
		  temp[0] = columns[j1][0];
		  temp[1] = columns[j1][1];
		  columns[j1][0] = columns[j2][0];
		  columns[j1][1] = columns[j2][1];
		  columns[j2][0] = temp[0];
		  columns[j2][1] = temp[1];
		}
	    }
	}
    }

#ifdef DEBUG
  printf("---- columns after sort -----\n");
  for(i=0;i != ItemSelected;i++)
    printf("columns[%d] : %2d  %2d \n",i,columns[i][0],columns[i][1]);
  printf("\n");
#endif
}



/* make ListString from PairListForHyouji (convert intger to string) */
int changePairListToString()
{
  int i,No1,No2;
  char NoString1[5],NoString2[5];
  char StringPair[12];
  char *str;

  NoOfPair = 0;
  StringPair[0] = '\0';

  for(i=0;PairListForHyouji[i][0]!=MAXIMUM;i++)
    {
      No1 = PairListForHyouji[i][3];   /* column 1 */
      No2 = PairListForHyouji[i][4];   /* column 2 */

      NumberToString(No1,NoString1);   /* change integer to string */
      NumberToString(No2,NoString2);
/*
#ifdef DEBUG      
      printf("NoString1 = %s    ",NoString1);
      printf("NoString2 = %s\n",NoString2);
#endif
*/
      /* make string "(column1,column2)" */
      strcat(StringPair,"(");
      strcat(StringPair,NoString1);
      strcat(StringPair,",");
      strcat(StringPair,NoString2);
      str = strcat(StringPair,")");
      
      strcpy(ListString[i], str);

      StringPair[0] = '\0';
/*
#ifdef DEBUG      
      printf("StringPair = %s\n",str);
#endif
*/
      NoOfPair++;
    }

#ifdef DEBUG
  for(i=0;PairListForHyouji[i][0]!=MAXIMUM;i++)
    {
      printf("ListSring[%d] = %s\n",i,ListString[i]);
    }
#endif 

}


/* called when items in the list selected */
void selectL1(w,client_data,call_data)
     Widget       w;
     caddr_t          client_data;
     XmListCallbackStruct *call_data;
{
  int i;

  /* get number of items selected */
  ItemSelected = call_data->selected_item_count;

  /* set selected items to string */
  for(i=0; i != ItemSelected ; i++)
    {
      XmStringGetLtoR(call_data->selected_items[i],XmSTRING_DEFAULT_CHARSET,&string[i]);
#ifdef DEBUG
      printf("selected items[%2d]: %s\n",i,string[i]);
#endif
    }
}


/* called when "ok" button pushed */
void dispSelect(w,client_data,call_data)
     Widget       w;
     caddr_t      client_data;
     XmAnyCallbackStruct *call_data;
{
  int col1,col2,i;
  /* convert string to integer */
  if(ItemSelected)
    {
      dispPairs = TRUE;
      for(i=0;i != ItemSelected ; i++)
	{
	  pairStringToIntString(string[i],&col1,&col2);
	  columns[i][0] = col1;
	  columns[i][1] = col2;
	}

#ifdef DEBUG
      for(i=0;i != ItemSelected ; i++)
	printf("Pair[%2d]:( %d , %d )\n",i,columns[i][0],columns[i][1]);
#endif
      sortColumns();
    }

  dispSelectedPair(w,columns,call_data);
      /* emphasize selected base pairs  */
  XCopyArea(XtDisplay(da),pixmap_da,XtWindow(da),gc_da,0,0,1000,1000,0,0);
}

/* called when "cancel" button pushed */
void undispSelect(w,client_data,call_data)
     Widget       w;
     caddr_t      client_data;
     XmAnyCallbackStruct *call_data;
{
  /* cancel */
  dispPairs = FALSE;
  if(ItemSelected)   /* items selected */
    {                /* cancel emphasis */
      XmListDeselectAllItems(list_pair); /* cancel selection of items */
/*      dispSeqs(da); */
      undispSelectedPair(w,columns,call_data);
      ItemSelected = 0;
    }
  XCopyArea(XtDisplay(da),pixmap_da,XtWindow(da),gc_da,0,0,1000,1000,0,0);
}


  
/* make list widget */
void create_list(circle_form)
     Widget circle_form;
{
  Widget  scroll_w;
  Arg    args[10];
  int i,n;


/* create list widget */
  n=0;
  XtSetArg(args[n],XmNitemCount,0);
  n++;
  XtSetArg(args[n],XmNselectionPolicy,XmEXTENDED_SELECT);
  n++;
  XtSetArg(args[n],XmNscrollBarDisplayPolicy,XmSTATIC);
  n++;
  XtSetArg(args[n],XmNlistMarginHeight,5);
  n++;
  XtSetArg(args[n],XmNlistMarginWidth,5);
  n++;
  XtSetArg(args[n],XmNlistSpacing,3);
  n++;
  XtSetArg(args[n],XmNleftWidget,circle_frame);
  n++;
  XtSetArg(args[n],XmNbackground,MyColor(XtDisplay(circle_form),"wheat"));
  n++;
  list_pair = XmCreateScrolledList(circle_form,"list_pair",args,n);
  XtManageChild(list_pair);

  /* put scroll bar */
  scroll_w = XtParent(list_pair);
  n=0;
  XtSetArg(args[n],XmNwidth,96);
  n++;
  XtSetArg(args[n],XmNtopWidget,list_cancel);
  n++;
  XtSetArg(args[n],XmNtopAttachment,XmATTACH_WIDGET);
  n++;
  XtSetArg(args[n],XmNtopOffset,2);
  n++;
  XtSetArg(args[n],XmNrightAttachment,XmATTACH_FORM);
  n++;
  XtSetArg(args[n],XmNrightOffset,2);
  n++;
  XtSetArg(args[n],XmNbottomAttachment,XmATTACH_FORM);
  n++;
  XtSetArg(args[n],XmNbackground,MyColor(XtDisplay(circle_form),"wheat"));
  n++;
  XtSetValues(scroll_w,args,n); 
  
/* set callback function */
  XtAddCallback(list_pair,XmNextendedSelectionCallback,selectL1,NULL);

}


/* set items to list */
void AddItemToList()
{
  XmString    ListXString;
  int i;

/* convert pair of integer to compound string */
  changePairListToString();
/* remove all current items from list */
  XmListDeleteAllItems(list_pair);

  if(NoOfPair == 0) /* no base pairs */
    {
      ListXString = XmStringCreateLtoR("no pairs",XmSTRING_DEFAULT_CHARSET);
      XmListAddItemUnselected(list_pair,ListXString,1);
    }
  else
    {   /* add items to list */
      for(i=0;i != NoOfPair;i++)
	{
	  ListXString = XmStringCreateLtoR(ListString[i],XmSTRING_DEFAULT_CHARSET);
	  XmListAddItemUnselected(list_pair,ListXString,1);
/*	  printf("ListString[%d] = %s\n",i,ListString[i]); */
	}
    }
  XmStringFree(ListXString);
}


void createList(parent_wd)
     Widget   parent_wd;  /* parent widget */
{
  Widget list_ok,list_label,list_labelFrame; 
  XmString  x_charsetListLabel , x_charsetListOk,x_charsetListCancel;
  XmFontList fontlistPairs;
  XFontStruct  *fontPairs;
  int n;
  Arg args[10];

  ItemSelected = 0;

/* make label */
/* put frame on label */
  n=0;
  XtSetArg(args[n],XmNshadowThickness,2);
  n++;
  XtSetArg(args[n],XmNshadowType,XmSHADOW_OUT);
  n++;
  XtSetArg(args[n],XmNrightAttachment,XmATTACH_FORM);
  n++;
  XtSetArg(args[n],XmNrightOffset,2);
  n++;
  XtSetArg(args[n],XmNtopAttachment,XmATTACH_FORM);
  n++;
  XtSetArg(args[n],XmNtopOffset,2);
  n++;
  XtSetArg(args[n],XmNbackground,MyColor(XtDisplay(circle_form),"wheat"));
  n++;
  list_labelFrame = XmCreateFrame(circle_form,"list_labelFrame",args,n);
  XtManageChild(list_labelFrame); 

/* decide "Pairs" font */
  fontPairs = XLoadQueryFont(XtDisplay(circle_form),
	     "-adobe-helvetica-bold-r-normal--18-180-75-75-p-103-iso8859-1");
  if(!fontPairs) 
    fontPairs= XLoadQueryFont(XtDisplay(circle_form),"r16");
  if(!fontPairs) 
    fontPairs = XLoadQueryFont(XtDisplay(circle_form),"a16");
  if(!fontPairs)
    fontPairs = XLoadQueryFont(XtDisplay(circle_form),"r14");
  if(!fontPairs)	
    fontPairs = XLoadQueryFont(XtDisplay(circle_form),"a14");
  if(!fontPairs)
    fontPairs = XLoadQueryFont(XtDisplay(circle_form),"k14");
  if(!fontPairs)
    fontPairs = XLoadQueryFont(XtDisplay(circle_form),"9x13");
  if(!fontPairs)
    fontPairs = XLoadQueryFont(XtDisplay(circle_form),"variable");
  if(!fontPairs)
    fontPairs = XLoadQueryFont(XtDisplay(circle_form),"fixed");
  if(!fontPairs)
    fontPairs = XLoadQueryFont(XtDisplay(circle_form),"6x13");
  if(!fontPairs)
    {
      fprintf(stderr,"Can't find font for Pair list\n");
      exit(1);
    }
  fontlistPairs = XmFontListCreate(fontPairs,XmSTRING_DEFAULT_CHARSET);

  n=0;
  XtSetArg(args[n],XmNwidth,95);
  n++;
  XtSetArg(args[n],XmNheight,30);
  n++;
  x_charsetListLabel = XmStringCreateLtoR("Pairs",XmSTRING_DEFAULT_CHARSET);
  XtSetArg(args[n],XmNlabelString,x_charsetListLabel);
  n++;
  XtSetArg(args[n],XmNfontList,fontlistPairs); 
  n++;
  XtSetArg(args[n],XmNbackground,MyColor(XtDisplay(circle_form),"wheat"));
  n++;
  list_label = XmCreateLabel(list_labelFrame,"list_label",args,n);
  XtManageChild(list_label); 
  XmStringFree(x_charsetListLabel);

/* create push buttons */
  n=0;
  XtSetArg(args[n],XmNtopWidget,list_labelFrame);
  n++;
  XtSetArg(args[n],XmNtopAttachment,XmATTACH_WIDGET);
  n++;
  XtSetArg(args[n],XmNtopOffset,2);
  n++;
  XtSetArg(args[n],XmNrightAttachment,XmATTACH_FORM);
  n++;
  XtSetArg(args[n],XmNrightOffset,2);
  n++;
  XtSetArg(args[n],XmNwidth,96);
  n++;
  XtSetArg(args[n],XmNheight,30);
  n++; 
  x_charsetListOk = XmStringCreateLtoR("show",XmSTRING_DEFAULT_CHARSET);
  XtSetArg(args[n],XmNlabelString,x_charsetListOk);
  n++;
  XtSetArg(args[n],XmNbackground,MyColor(XtDisplay(circle_form),"wheat"));
  n++;
  list_ok = XmCreatePushButton(circle_form,"list_ok",args,n);

  n=0;
  XtSetArg(args[n],XmNtopWidget,list_ok);
  n++;
  XtSetArg(args[n],XmNtopAttachment,XmATTACH_WIDGET);
  n++;
  XtSetArg(args[n],XmNtopOffset,2);
  n++;
  XtSetArg(args[n],XmNrightAttachment,XmATTACH_FORM);
  n++;
  XtSetArg(args[n],XmNrightOffset,2);
  n++;
  XtSetArg(args[n],XmNwidth,96);
  n++;
  XtSetArg(args[n],XmNheight,30);
  n++; 
  x_charsetListCancel = XmStringCreateLtoR("erase",XmSTRING_DEFAULT_CHARSET);
  XtSetArg(args[n],XmNlabelString,x_charsetListCancel);
  n++;
  XtSetArg(args[n],XmNbackground,MyColor(XtDisplay(circle_form),"wheat"));
  n++;
  list_cancel = XmCreatePushButton(circle_form,"list_cancel",args,n);

  XtManageChild(list_ok); 
  XtManageChild(list_cancel); 
  XmStringFree(x_charsetListOk);
  XmStringFree(x_charsetListCancel);

  if(file_flag)
    changePairListToString(); /* convert pair of integer to compound string */
  create_list(circle_form); /* create list widget */

  /* add callback function to "ok" button */
  XtAddCallback(list_ok,XmNactivateCallback,dispSelect,NULL);
  /* add callback function to "cancel" button */
  XtAddCallback(list_cancel,XmNactivateCallback,undispSelect,NULL);
 
}


/* ------------- end of "pairList.c" ------------------------------ */
