/* ---------------------------------------------------------- 
%(C)1994,1995 Institute for New Generation Computer Technology 
%       (Read COPYRIGHT for detailed information.) 
----------------------------------------------------------- */
/* --------------------------------------------------------- */
/*      makePairMatrix.c                                     */
/* --------------------------------------------------------- */

#include   <stdio.h>
#include   <string.h>
#include   <ctype.h>
#include "stem.h"
/*
#define DEBUG TRUE 
*/


int pairCost[BASES][BASES] = /* matrix of pair cost */
{
  /* A, U, G, C, T,Others,gap */   /* A-T(U) -> 1 */
  /* 0, 1, 2, 3, 4,NONE,  gap */     /* G-C    -> 2 */
  {  0, 1, 0, 0, 1,  0 , 0  }, /* A      0 */
  {  1, 0, 0, 0, 0,  0 , 0  }, /* U      1 */
  {  0, 0, 0, 2, 0,  0 , 0  }, /* G      2 */
  {  0, 0, 2, 0, 0,  0 , 0  }, /* C      3 */
  {  1, 0, 0, 0, 0,  0 , 0  }, /* T      4 */
  {  0, 0, 0, 0, 0,  0 , 0  }, /* Others 5 */
  {  0, 0, 0, 0, 0,  0 , 0  }  /* gap    6 */
};

/* check if base of column1 and base of column2 make base pair or not */
/* yes -> return pairCost */
/* no  -> return FALSE  */
int check_pair(seqcount,column1,column2)
     int   seqcount,  /* sequence number */
           column1,
           column2;
{
  int j,h,
  base1,   /* base of column1 */
  base2,   /* base of column2 */
  pairC;
  
  char *seq_head; 
  
  seq_head = sequences[seqcount].sequence;
  for(j=0;j!=column1;j++)
    seq_head++; /* set seq_head to column1 */
  
  if(*seq_head == 'A' || *seq_head =='a') /* adenine */
    base1 = ADE;
  else if(*seq_head == 'U' || *seq_head =='u') /* uracil */
    base1 = URA;
  else if(*seq_head == 'G' || *seq_head =='g') /* guanine */
    base1 = GUA;
  else if(*seq_head == 'C' || *seq_head =='c') /* cytosine */
    base1 = CIT;
  else if(*seq_head == 'T' || *seq_head =='t') /* thymine */
    base1 = TIM;
  else if(*seq_head == '-' )                   /* gap */
    base1 = GAP;
  else                                         /* others */
    base1 = OTHER;
  /*
    printf("seqNo = %d,base1 = %c(%d) \n",i,*seq_head,base1); 
    */
  for(h=column1;h!=column2;h++)
    seq_head++; /* set seq_head to column2 */
  
  if(*seq_head == 'A' || *seq_head =='a') /* adenine */
    base2 = ADE;
  else if(*seq_head == 'U' || *seq_head =='u') /* uracil */
    base2 = URA;
  else if(*seq_head == 'G' || *seq_head =='g') /* guanine */
    base2 = GUA;
  else if(*seq_head == 'C' || *seq_head =='c') /* cytosine */
    base2 = CIT;
  else if(*seq_head == 'T' || *seq_head =='t') /* thymine */
    base2 = TIM;
  else if(*seq_head == '-' )                   /* gap */
    base2 = GAP;
  else                                         /* others */
    base2 = OTHER;
  /*
    printf("column2 = %d,base2 = %c(%d) \n",column2,*seq_head,base2); 
    */
  pairC = pairCost[base1][base2];
  
  if(pairC) /* makes base pair */
    return pairC; 
  else  /* does not make base pair */
    return FALSE;
}


/* make pair matrix */
/* pair_matrix_all_1 percentage of base pair */
/* pair_matrix_all_2 kind of base pair */

void make_matrix_all(select_flag)
     int select_flag;
{
  int column1, /* index of column 1 */
      column2, /* index of column 2 */
      at_count,
      gc_count,
      total_count,
      paircost,
      pair_percent,
      seqcount;

  if(!select_flag)
    { /* ORIGINAL */
      
      for(column1 = 0;column1 != (NoOfColumn-1);column1++)
	{
	  for(column2 = (NoOfColumn-1);column2 >= column1;column2--)
	    {
	      at_count = 0;
	      gc_count = 0;
	      total_count = 0;
	      for(seqcount = 0;seqcount != NoOfSeqs;seqcount++)
		{
		  if((paircost = check_pair(seqcount,column1,column2))!=FALSE)
		    /* column1 and column2 makes base pair in this sequence */
		    {
		      if(paircost == 1) /* adenine-thymine(urasil) pair */
			at_count++;
		      else if(paircost == 2) /* guanine-cytosine pair */
			gc_count++;
		      else
			;
		    }
		}
	      total_count = at_count + gc_count;
	      /* calculate percentage of sequence which make base pair */
	      pair_percent = total_count * 100/NoOfSeqs;
	      if(at_count == NoOfSeqs )  /* adenine-thymine(urasil) pair 100% */
		{
		  pair_matrix_all_1[column1][column2] = 100;
		  pair_matrix_all_2[column1][column2] = A_T;
		}
	      else if(gc_count == NoOfSeqs) /* guanine-cytosine pair 100% */
		{
		  pair_matrix_all_1[column1][column2] = 100;
		  pair_matrix_all_2[column1][column2] = G_C;
		}
	      else if(total_count == NoOfSeqs) /* both kind of pairs 100% */
		{
		  pair_matrix_all_1[column1][column2] = 100;
		  pair_matrix_all_2[column1][column2] = BOTH;
		}
	      else if(total_count != 0)
		{ /* base pair exists */
		  if(gc_count == 0) /* only adenine-thymine(urasil) pair */
		    {
		      pair_matrix_all_1[column1][column2] = pair_percent;
		      pair_matrix_all_2[column1][column2] = A_T;
		    }
		  else if(at_count == 0) /* only guanine-cytosine pair */
		    {
		      pair_matrix_all_1[column1][column2] = pair_percent;
		      pair_matrix_all_2[column1][column2] = G_C;
		    }
		  else  /* both kind of base pair */
		    {
		      pair_matrix_all_1[column1][column2] = pair_percent;
		      pair_matrix_all_2[column1][column2] = BOTH;
		    }
		}
	      else  /* no base pairs */
		{
		  pair_matrix_all_1[column1][column2] = 0;
		  pair_matrix_all_2[column1][column2] = NONE;
		}
	    }
	}
    }

  if(select_flag)
    { /* SELECT */
      
      for(column1 = 0;column1 != (NoOfColumn-1);column1++)
	{
	  for(column2 = (NoOfColumn-1);column2 >= column1;column2--)
	    {
	      at_count = 0;
	      gc_count = 0;
	      total_count = 0;
	      for(seqcount = 0;seqcount != NoOfSeqs;seqcount++)
		{
		  if(selectedSeqs[seqcount])
		    { /* this sequence is selected sequence */
		      if((paircost = check_pair(seqcount,column1,column2))!=FALSE)
			/* column1 and column2 makes base pair in this sequence */
			{
			  if(paircost == 1)
			    at_count++;
			  else if(paircost == 2)
			    gc_count++;
			  else
			    ;
			}
		    }
		}
	      total_count = at_count + gc_count;
	      /* calculate pair percent */
	      pair_percent = total_count * 100/NoOfSelectedSeqs;
	      if(at_count == NoOfSelectedSeqs )  /* adenine-thymine(urasil) pair 100% */
		{
		  pair_matrix_all_1_s[column1][column2] = 100;
		  pair_matrix_all_2_s[column1][column2] = A_T;
		}
	      else if(gc_count == NoOfSelectedSeqs) /* guanine-cytosine pair 100% */
		{
		  pair_matrix_all_1_s[column1][column2] = 100;
		  pair_matrix_all_2_s[column1][column2] = G_C;
		}
	      else if(total_count == NoOfSelectedSeqs) /* both kind of base pairs */
		{
		  pair_matrix_all_1_s[column1][column2] = 100;
		  pair_matrix_all_2_s[column1][column2] = BOTH;
		}
	      else if(total_count != 0)
		{ /* base pair exists */
		  if(gc_count == 0) /* only adenine-thymine(urasil) pair  */
		    {
		      pair_matrix_all_1_s[column1][column2] = pair_percent;
		      pair_matrix_all_2_s[column1][column2] = A_T;
		    }
		  else if(at_count == 0) /* only guanine-cytosine pair */
		    {
		      pair_matrix_all_1_s[column1][column2] = pair_percent;
		      pair_matrix_all_2_s[column1][column2] = G_C;
		    }
		  else  /* both kind of base pairs */
		    {
		      pair_matrix_all_1_s[column1][column2] = pair_percent;
		      pair_matrix_all_2_s[column1][column2] = BOTH;
		    }
		}
	      else  /* no base pairs */
		{
		  pair_matrix_all_1_s[column1][column2] = 0;
		  pair_matrix_all_2_s[column1][column2] = NONE;
		}
	    }
	}
    }
#ifdef DEBUG

if(select_flag)
  {
    printf("pair_matrix_all_1_s = \n");
    printf("      ");
    for(column1 = 0;column1 != (NoOfColumn-1);column1++)
      printf("%3d",column1);
    printf("\n");
    for(column2 = (NoOfColumn-1);column2 >=0 ;column2--)
      {
	printf("%4d: ",column2);
	for(column1=0;column1 != (NoOfColumn-1);column1++)
	  printf("%3d",pair_matrix_all_1_s[column1][column2]);
	printf("\n");
      }
    
    printf("pair_matrix_all_2_s = \n");
    printf("      ");
    for(column1 = 0;column1 != (NoOfColumn-1);column1++)
      printf("%3d",column1);
    printf("\n");
    for(column2 = (NoOfColumn-1);column2 >=0 ;column2--)
      {
	printf("%4d: ",column2);
	for(column1=0;column1 != (NoOfColumn-1);column1++)
	  printf("%3d",pair_matrix_all_2_s[column1][column2]);
	printf("\n");
      }
  }
#endif 
}

/* -------------------------- end of file ------------------------- */
