/* ---------------------------------------------------------- 
%(C)1994,1995 Institute for New Generation Computer Technology 
%       (Read COPYRIGHT for detailed information.) 
----------------------------------------------------------- */
/* ----------------------------------------------------------------------- */
/*    exposeHandle.c                                                       */
/*            handle the exposure events of widget "da"                    */
/* ----------------------------------------------------------------------- */

#include <X11/Intrinsic.h>
#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/StringDefs.h>
#include <X11/Shell.h>
#include <Xm/DrawingA.h>
#include <Xm/Form.h>
#include <Xm/RowColumn.h>
#include <Xm/PushB.h>
#include <Xm/MessageB.h>
#include <Xm/ScrolledW.h>
#include <Xm/ScrollBar.h>
#include <stdio.h>
#include "stem.h"

#define MAXRECTS 30  /* upper limit of exposed rectangles */

/*
#define DEBUG TRUE
*/

extern Widget da; 
extern Display  *d;
extern Window    win; 
extern GC   gc_da; 
extern GC   gc_for_Num;
extern Pixmap  pixmap_da;
static int exp_rect_count=0;


void exposeHandle(w,c_data,call_data)
     Widget         w;
     caddr_t        c_data;
     XmDrawingAreaCallbackStruct  *call_data;
{
  int       i;
  static XRectangle  exp_rect[MAXRECTS];
/*
  printf("da exposed!\n");
*/

/* exposure event reading loop */

#ifdef DEBUG
  printf("event count = %d\n",call_data->event->xexpose.count);
#endif

  /* make sure static rectangle array is not full */

  if(exp_rect_count < MAXRECTS )
    {
      exp_rect[exp_rect_count].x      = call_data->event->xexpose.x;
      exp_rect[exp_rect_count].y      = call_data->event->xexpose.y;
      exp_rect[exp_rect_count].width  = call_data->event->xexpose.width;
      exp_rect[exp_rect_count].height = call_data->event->xexpose.height;
#ifdef DEBUG
	  printf("[1]exp_rect[%d].x=%d\n",exp_rect_count,exp_rect[exp_rect_count].x);
	  printf("[1]exp_rect[%d].y=%d\n",exp_rect_count,exp_rect[exp_rect_count].y);
	  printf("[1]exp_rect[%d].width=%d\n",exp_rect_count,exp_rect[exp_rect_count].width);
	  printf("[1]exp_rect[%d].height=%d\n",exp_rect_count,exp_rect[exp_rect_count].height);
#endif
    }
  exp_rect_count++;
  
/* if expose events still exist, return */
  if(call_data->event->xexpose.count != 0)
    return; 

  if(call_data->event->xexpose.count == 0)
    {/* last event of series */
      if(exp_rect_count < MAXRECTS )
	{
	  XSetClipRectangles(d,gc_da,0,0,exp_rect,exp_rect_count,Unsorted);
	  XCopyGC(d,gc_da,GCClipMask | GCClipXOrigin |GCClipYOrigin ,gc_for_Num);
	}
      else
	{ /* too many rectangles,so redraw whole window */
	  XClearWindow(d,win);
	  XSetClipMask(d,gc_da,None);
	  XCopyGC(d,gc_da,GCClipMask | GCClipXOrigin |GCClipYOrigin ,gc_for_Num);
	}
      /* copy rectangles from pixmap */
      for(i=0;i!=exp_rect_count;i++)
	{
	  XCopyArea(d,pixmap_da,win,gc_da,
		    exp_rect[i].x,exp_rect[i].y,
		    exp_rect[i].width,exp_rect[i].height,
		    exp_rect[i].x,exp_rect[i].y);
	  XCopyArea(d,pixmap_da,win,gc_for_Num,
		    exp_rect[i].x,exp_rect[i].y,
		    exp_rect[i].width,exp_rect[i].height,
		    exp_rect[i].x,exp_rect[i].y);

#ifdef DEBUG
	  printf("[2]exp_rect[%d].x=%d\n",i,exp_rect[i].x);
	  printf("[2]exp_rect[%d].y=%d\n",i,exp_rect[i].y);
	  printf("[2]exp_rect[%d].width=%d\n",i,exp_rect[i].width);
	  printf("[2]exp_rect[%d].height=%d\n",i,exp_rect[i].height);
#endif
	}
      /* reset exposure count and ready for next event series */
      exp_rect_count = 0;
      XSetClipMask(d,gc_da,None);
      XCopyGC(d,gc_da,GCClipMask | GCClipXOrigin |GCClipYOrigin ,gc_for_Num);

    }
}


/* ---------- end of "exposeHandle.c" ---------------------------------------- */
