/* ---------------------------------------------------------- 
%(C)1994,1995 Institute for New Generation Computer Technology 
%       (Read COPYRIGHT for detailed information.) 
----------------------------------------------------------- */
/*-----------------------------------------------------------------*/
/*     createCircleNew.c                                           */
/*        make widgets and callback functions for                  */
/*                circular representation                          */
/*-----------------------------------------------------------------*/


#include <X11/Intrinsic.h>
#include <X11/Xlib.h>
#include <X11/StringDefs.h>
#include <Xm/Xm.h>
#include <X11/Shell.h>
#include <Xm/Form.h>
#include <Xm/DrawingA.h>
#include <Xm/PushB.h>
#include <Xm/Label.h>
#include <Xm/RowColumn.h>
#include <Xm/MessageB.h>
#include <Xm/Frame.h>
#include <Xm/Scale.h>
#include <sys/types.h>
#include <stdio.h>
#include   <string.h>
#include   <ctype.h>
#include  "stem.h"
/*
#define DEBUG TRUE
*/

extern Widget select_da;
extern Widget  da,list_pair;
extern XmFontList fontlist;

extern unsigned long MyColor();
extern void makePairList();
extern void makePairListForHyouji();
extern void makePairList_s();

extern void calc_zahyou_data();
extern void popUpPairList(); 
extern void createList();
extern void writeHanrei();
extern void resize();
extern void dispCircle(); /* draw circle (ORIGINAL) */
extern void dispCircleS(); /* draw circle (select mode) */
extern void AddItemToList();
extern void undispSelect();
extern void createColormap();

int initial_da_width;     /* initial da width  */
int initial_da_height;    /* initial da height */
int current_da_width;     /* current da width  */
int current_da_height;    /* current da height */

extern int hanreiHyouji;  /* flag for draw explanatory notes or not */

Widget  circle_pop,circle_form,
        circle_da,circle_frame ,hanrei_da; 
extern XColor Colors[COLORS];

GC gc_base[BASES]; 
GC gc_hanrei;

/* create GC for each bases  */
void createGCforBASES(d,w0,select_flag)
     Display *d;
     Window w0;
     int select_flag;
{
  XGCValues gv;
  int i;
  
  gv.line_width = LINE_W1;
  
  for(i=0;i!=BASES;i++)
    gc_base[i] = XCreateGC(d,w0,GCLineWidth,&gv);
  
  for(i=0;i!=BASES;i++)
    {
      switch(i)
	{
	case ADE:
	  XSetForeground(d,gc_base[i],Colors[0].pixel); 
	  break;
	case URA:
	  XSetForeground(d,gc_base[i],Colors[20].pixel); 
	  break;
	case GUA:
	  XSetForeground(d,gc_base[i],Colors[6].pixel); 
	  break;
	case CIT:
	  XSetForeground(d,gc_base[i],Colors[2].pixel); 
	  break;
	case TIM:
	  XSetForeground(d,gc_base[i],Colors[19].pixel); 
	  break;
	default: 
	  XSetForeground(d,gc_base[i],MyColor(d,"gray")); 
	}
    }
  GCcreated = TRUE;
  
}

/* called when "show pairs" button pushed    */
/* popup widgets for circular representation */ 
void call_dispCircle(w,client_data,call_data)
     Widget        w;
     caddr_t       client_data;
     XmAnyCallbackStruct    call_data;
{
  if(file_flag)
    {
      AddItemToList();      /* add items to list widget */
      XtPopup(circle_pop,XtGrabNone); 
      XMapRaised(XtDisplay(circle_pop),XtWindow(circle_pop));
      XtAddCallback(circle_da,XmNresizeCallback,resize,ORIGINAL);
    }
}

/* called when "close" button pushed           */
/* popdown widgets for circular representation */ 
void close_dispCircle(w,client_data,call_data)
     Widget        w;
     caddr_t       client_data,call_data;
{
  undispSelect(w,client_data,call_data);
  XtPopdown(circle_pop);
}

/* called when slider of "percent" scale  is moved */
void scale_callback_percent(w,select_flag,scale_struct)
     Widget w;
     int     select_flag;
     XmScaleCallbackStruct *scale_struct;
{
  
  if(scale_struct != (XmScaleCallbackStruct *)NULL)
    {
      if(select_flag == ORIGINAL)
	{
  if(Percent != scale_struct->value)
	    {/* Percent  changed */
	      pre_percent = Percent;
	      Percent = scale_struct->value;
	      percentChanged = TRUE;
	      /*	  printf("scale:percent = %d\n",Percent);
			  printf("scale:pre_percent = %d\n",pre_percent); */
	      if(file_flag)
		{ /* data file is already read */
		  make_consensus_for_hyoji(ORIGINAL); /* make consensus tabel without gap column */
		  calc_zahyou_data(ORIGINAL); /* caluculate location of each columns */
		  makePairList();             /* make pair list under new percent*/
		  makePairListForHyouji(ORIGINAL); /* make pair list for display */
		  dispCircle(w,select_flag,scale_struct);  /* draw circle */
		  AddItemToList();
		}
	    }
	}
      else if(select_flag == SELECT)
	{ /* select mode */
	  if(Percent_s != scale_struct->value)
	    {/* Percent  changed */
	      Percent_s = scale_struct->value;
	      percentChangedS = TRUE;
	      /*	  printf("scale:percentS = %d\n",Percent_s); */
	      make_consensus_for_hyoji(SELECT); /* make consensus tabel without gap column */
	      calc_zahyou_data(SELECT); /* caluculate location of each columns */
	      makePairList_s();         /* make pair list under new percent*/
	      makePairListForHyouji(SELECT); /* make pair list for display */
	      dispCircleS(select_da,gc_base,scale_struct); /* draw circle */
	      AddItemToListS();
	    }	      
	}
    }
}


/* called when slider of "consecutive" scale  is moved */
void scale_callback_renzoku(w,select_flag,scale_struct)
     Widget w;
     int select_flag;
     XmScaleCallbackStruct *scale_struct;
{
  
  if(scale_struct != (XmScaleCallbackStruct *)NULL)
    {
      if(select_flag == ORIGINAL)
	{
	  if(Renzoku != scale_struct->value)
	    {/* Renzoku (consecutive) changed */
	      Renzoku = scale_struct->value;
	      renzokuChanged = TRUE;
      /*	  printf("renzoku = %d\n",Renzoku); */
	      if(file_flag)
		{ /* file already read */
		  makePairList();     /* make pair list under new percent*/
		  makePairListForHyouji(ORIGINAL); /* make pair list for display */
		  dispCircle(w,select_flag,scale_struct);  /* draw circle */
		  AddItemToList();
		}
	    }
	}
      else if(select_flag == SELECT)
	{
	  if(Renzoku_s != scale_struct->value)
	    { /* Renzoku_s (consecutive in select mode) changed */
	      Renzoku_s = scale_struct->value;
	      renzokuChangedS = TRUE;
      /*	  printf("renzoku_s = %d\n",Renzoku_s); */
	      makePairList_s();                 /* make pair list under new percent*/
	      makePairListForHyouji(SELECT);    /* make pair list for display */
	      dispCircleS(select_da,gc_base,scale_struct); /* draw circle */
	      AddItemToListS();
	    }
	}
    }
}


void createCircle(parent)
     Widget     parent;
{
  Widget pButton_close,scale_percent,scale_renzoku;
  Dimension d_current_da_width,d_current_da_height; 
  Arg    args[20];
  int    n ;
  XmString  x_charsetClose,x_charsetPercent,x_charsetConsecutive;
            

  /* create popup shell */
  
  circle_pop = XtCreatePopupShell("circle_pop",topLevelShellWidgetClass,parent,NULL,0);
  n = 0;
  XtSetArg(args[n],XmNwidth,710);
  n++;
  XtSetArg(args[n],XmNheight,700);
  n++; 
  XtSetArg(args[n],XmNdefaultFontList,fontlist); 
  n++;
  XtSetValues(circle_pop,args,n); 

  /* create form  */
  n = 0;
  XtSetArg(args[n],XmNwidth,700);
  n++;
  XtSetArg(args[n],XmNheight,700);
  n++; 
  XtSetArg(args[n],XmNbackground,MyColor(XtDisplay(circle_pop),"wheat"));
  n++;
  circle_form = XtCreateManagedWidget("circle_form",xmFormWidgetClass,circle_pop,args,n);
  
  /* create push button "close" and add callback function */
  n = 0;
  XtSetArg(args[n],XmNwidth,70);
  n++;
  XtSetArg(args[n],XmNheight,30);
  n++; 
  XtSetArg(args[n],XmNbackground,MyColor(XtDisplay(circle_pop),"wheat"));
  n++;
  x_charsetClose = XmStringCreateLtoR("Close",XmSTRING_DEFAULT_CHARSET);
  XtSetArg(args[n],XmNlabelString,x_charsetClose);
  n++;
  XtSetArg(args[n],XmNtopAttachment,XmATTACH_FORM);
  n++;
  XtSetArg(args[n],XmNtopOffset,20);
  n++;
  XtSetArg(args[n],XmNleftAttachment,XmATTACH_FORM);
  n++;
  XtSetArg(args[n],XmNleftOffset,3);
  n++;
  pButton_close = XmCreatePushButton(circle_form,"pButton_close",args,n);
  XtManageChild(pButton_close);
  XtAddCallback(pButton_close,XmNactivateCallback,close_dispCircle,NULL);

  /* create "percent" scale and add callback function */
  n=0;
  XtSetArg(args[n],XmNvalue,Percent); /* set default Percent value */
  n++;
  XtSetArg(args[n],XmNleftWidget,pButton_close); 
  n++;
  XtSetArg(args[n],XmNwidth,120);
  n++;
  XtSetArg(args[n],XmNmaximum,100);
  n++;
  XtSetArg(args[n],XmNminimum,10);
  n++;
  XtSetArg(args[n],XmNshowValue,True);
  n++;
  XtSetArg(args[n],XmNprocessingDirection,XmMAX_ON_RIGHT);
  n++;
  XtSetArg(args[n],XmNorientation,XmHORIZONTAL);
  n++;
  XtSetArg(args[n],XmNleftAttachment,XmATTACH_WIDGET);
  n++;
  XtSetArg(args[n],XmNleftOffset,3);
  n++;
  XtSetArg(args[n],XmNtopAttachment,XmATTACH_FORM);
  n++;
  XtSetArg(args[n],XmNtopOffset,3);
  n++;
  XtSetArg(args[n],XmNbackground,MyColor(XtDisplay(circle_pop),"wheat"));
  n++;
  x_charsetPercent = XmStringCreateLtoR("percent",XmSTRING_DEFAULT_CHARSET);
  XtSetArg(args[n],XmNtitleString,x_charsetPercent);
  n++;
  scale_percent = XmCreateScale(circle_form,"scale_percent",args,n);
  XtManageChild(scale_percent);
  XmStringFree(x_charsetPercent); 
  XtAddCallback(scale_percent,XmNvalueChangedCallback,scale_callback_percent,ORIGINAL);
  
  /* create "consecutive" scale and add callback function */
  n=0;
  XtSetArg(args[n],XmNvalue,Renzoku); /* set default "consecutive" value (Renzoku) */
  n++;
  XtSetArg(args[n],XmNleftWidget,scale_percent);
  n++;
  XtSetArg(args[n],XmNwidth,100);
  n++;
  XtSetArg(args[n],XmNmaximum,10);
  n++;
  XtSetArg(args[n],XmNminimum,1);
  n++;
  XtSetArg(args[n],XmNshowValue,True);
  n++;
  XtSetArg(args[n],XmNprocessingDirection,XmMAX_ON_RIGHT);
  n++;
  XtSetArg(args[n],XmNorientation,XmHORIZONTAL);
  n++;
  XtSetArg(args[n],XmNleftAttachment,XmATTACH_WIDGET);
  n++;
  XtSetArg(args[n],XmNleftOffset,3);
  n++;
  XtSetArg(args[n],XmNtopAttachment,XmATTACH_FORM);
  n++;
  XtSetArg(args[n],XmNtopOffset,3);
  n++;
  XtSetArg(args[n],XmNbackground,MyColor(XtDisplay(circle_pop),"wheat"));
  n++;
  x_charsetConsecutive = XmStringCreateLtoR("consecutive",XmSTRING_DEFAULT_CHARSET);
  XtSetArg(args[n],XmNtitleString,x_charsetConsecutive);
  n++;
  scale_renzoku = XmCreateScale(circle_form,"scale_renzoku",args,n);
  XtManageChild(scale_renzoku);
  XmStringFree(x_charsetConsecutive); 
  XtAddCallback(scale_renzoku,XmNvalueChangedCallback,scale_callback_renzoku,ORIGINAL);
/*
#ifdef DEBUG
  printf("scales created\n");
#endif 
*/  
   createList(circle_form);  /* create list widget  */ 

  /* create drawingArea widget for circular representation */
  /* create frame widget for some decoration */

  n=0;
  XtSetArg(args[n],XmNshadowThickness,4);
  n++;
  XtSetArg(args[n],XmNshadowType,XmSHADOW_ETCHED_OUT);
  n++;
  XtSetArg(args[n],XmNwidth,600);
  n++;
  XtSetArg(args[n],XmNheight,600);
  n++;
  XtSetArg(args[n],XmNleftAttachment,XmATTACH_FORM);
  n++;
  XtSetArg(args[n],XmNrightAttachment,XmATTACH_FORM);
  n++;
  XtSetArg(args[n],XmNrightOffset,100);
  n++;
  XtSetArg(args[n],XmNtopAttachment,XmATTACH_FORM);
  n++;
  XtSetArg(args[n],XmNtopOffset,70);
  n++;
  XtSetArg(args[n],XmNbottomAttachment,XmATTACH_FORM);
  n++;
  circle_frame = XmCreateFrame(circle_form,"circle_frame",args,n);
  XtManageChild(circle_frame); 

  n=0;
  XtSetArg(args[n],XmNwidth,610);
  n++;
  XtSetArg(args[n],XmNheight,600);
  n++;
  XtSetArg(args[n],XmNbackground,MyColor(XtDisplay(circle_pop),"white"));
  n++;
  XtSetArg(args[n],XmNleftAttachment,XmATTACH_FORM);
  n++;
  XtSetArg(args[n],XmNrightAttachment,XmATTACH_FORM);
  n++;
  XtSetArg(args[n],XmNrightOffset,100);
  n++;
  XtSetArg(args[n],XmNtopAttachment,XmATTACH_FORM);
  n++;
  XtSetArg(args[n],XmNtopOffset,80);
  n++;
  XtSetArg(args[n],XmNbottomAttachment,XmATTACH_FORM);
  n++;
  circle_da = XmCreateDrawingArea(circle_frame,"circle_da",args,n);
  XtManageChild(circle_da);

  XtRealizeWidget(circle_pop);

  createColormap(circle_da);
  createGCforBASES(XtDisplay(circle_da),XtWindow(circle_da),ORIGINAL);
/*
#ifdef DEBUG
  printf("gcforbase(circle_da) created\n");
#endif 
*/

  /* get current  width and height of circle_da */
  n=0;
  XtSetArg(args[n],XtNwidth,&d_current_da_width);
  n++;
  XtSetArg(args[n],XtNheight,&d_current_da_height);
  n++;
  XtGetValues(circle_da,args,n);
  initial_da_width = (int)d_current_da_width;
  initial_da_height =(int)d_current_da_height;
  current_da_width = initial_da_width;
  current_da_height = initial_da_height;

#ifdef DEBUG
  printf("current:width = %d, height = %d\n",current_da_width,current_da_height);
#endif

/*  XtAddCallback(circle_da,XmNresizeCallback,resize,ORIGINAL); */
  XtAddCallback(circle_da,XmNexposeCallback,dispCircle,ORIGINAL); 

  /* create drawingArea widget for explanatory notes */
  n=0;
  XtSetArg(args[n],XmNleftWidget,scale_renzoku);  
  n++;
  XtSetArg(args[n],XmNmappedWhenManaged,True);
  n++;
  XtSetArg(args[n],XmNwidth,282);
  n++;
  XtSetArg(args[n],XmNheight,67);
  n++;
  XtSetArg(args[n],XmNbackground,MyColor(XtDisplay(circle_pop),"white"));
  n++;
  XtSetArg(args[n],XmNleftWidget,scale_renzoku);
  n++;
  XtSetArg(args[n],XmNleftAttachment,XmATTACH_WIDGET);
  n++;
  XtSetArg(args[n],XmNleftOffset,3);
  n++;
  XtSetArg(args[n],XmNtopAttachment,XmATTACH_FORM);
  n++;
  XtSetArg(args[n],XmNtopOffset,3);
  n++;
  hanrei_da = XmCreateDrawingArea(circle_form,"hanrei_da",args,n);
  XtManageChild(hanrei_da);

  /* create GC for explanatory note */
  gc_hanrei = XCreateGC(XtDisplay(hanrei_da),XtWindow(hanrei_da),0,0); 
  XtAddCallback(hanrei_da,XmNexposeCallback,writeHanrei,NULL); 
  hanreiHyouji = TRUE;              /* set flag for write explanatory notes on   */

}
     



/*-------------- end of "createCircleNew.c" ------------------------------*/
