/* ---------------------------------------------------------- 
%(C)1994,1995 Institute for New Generation Computer Technology 
%       (Read COPYRIGHT for detailed information.) 
----------------------------------------------------------- */
/* ----------------------------------------------------------- */
/*       check_consensus.c                                     */
/*            find consensus column                            */
/* ----------------------------------------------------------- */
#include   <stdio.h>
#include   <string.h>
#include   <ctype.h>
#include "stem.h"
/*
#define DEBUG TRUE 
*/
static int consensus_table[BASES][MAXCOLUMN]; /* count number of bases in each column */

void clear_consensus_table()  /* initialize consesus_table  */
{
  int base,maxcol;
  
  for(base=0;base != BASES;base++)
    for(maxcol=0;maxcol != MAXCOLUMN ;maxcol++)
      	    consensus_table[base][maxcol] = 0;
}

void check_consensus(select_flag)
     int select_flag; /* ORIGINAL -> 0, SELECT -> 1 */
{
  int column, /* index of column */
      seq,    /* index of sequence */
      base,   /* index of base */
      Max[2];
  char *seq_head;


  if(!table_made) /* initialize consensus_table */
    {
      clear_consensus_table();
/*      printf("consensus_table cleared\n"); */
    }
/*
  printf("consensus_table at first = \n"); 
  for(base = 0;base != BASES;base++)
    {
      printf("consensus_table[%d]:",base);
      for(column = 0;column != NoOfColumn;column++)
	{
	  printf("%2d ",consensus_table[base][column]);
	}
      printf("\n");
    }
*/
  
   /* make consensus_table  */

  if(select_flag == ORIGINAL)
    {
      for(seq = 0; seq != NoOfSeqs; seq++)
	{
	  seq_head = sequences[seq].sequence;
	  for(column = 0;column != NoOfColumn;column++)
	    {
	      if(*seq_head == 'A' || *seq_head == 'a') /* adenine */
		consensus_table[ADE][column]++;
	      else if(*seq_head == 'U' || *seq_head == 'u') /* uracil */
		consensus_table[URA][column]++;
	      else if(*seq_head == 'G' || *seq_head == 'g') /* guanine */
		consensus_table[GUA][column]++;
	      else if(*seq_head == 'C' || *seq_head == 'c') /* cytosine */
		consensus_table[CIT][column]++;
	      else if(*seq_head == 'T' || *seq_head == 't') /* thymine */
		consensus_table[TIM][column]++;
	      else if(*seq_head == '-' )                    /* gap */
		consensus_table[GAP][column]++;
	      else
		consensus_table[OTHER][column]++;  /* others  */
	      seq_head++;
	    }
	}
      
      table_made = TRUE;  /* consensus_table is made */
    }

  if(select_flag == SELECT)
    {
      for(seq = 0; seq != NoOfSeqs; seq++)
	{
	  if(selectedSeqs[seq] == TRUE)
	    { /*  this sequence is selected sequence */
	      seq_head = sequences[seq].sequence;
	      for(column = 0;column != NoOfColumn;column++)
		{
		  if(*seq_head == 'A' || *seq_head == 'a') /* adenine */
		    consensus_table[ADE][column]++;
		  else if(*seq_head == 'U' || *seq_head == 'u') /* uracil */
		    consensus_table[URA][column]++;
		  else if(*seq_head == 'G' || *seq_head == 'g') /* guanine */
		    consensus_table[GUA][column]++;
		  else if(*seq_head == 'C' || *seq_head == 'c') /* cytosine */
		    consensus_table[CIT][column]++;
		  else if(*seq_head == 'T' || *seq_head == 't') /* thymine */
		    consensus_table[TIM][column]++;
		  else if(*seq_head == '-' )                    /* gap */
		    consensus_table[GAP][column]++;
		  else
		    consensus_table[OTHER][column]++;  /* others */
		  seq_head++;
		}
	    }
	}
      
      /* table_made = TRUE; */ /* consensus_table is made */
    }

/*  
#ifdef DEBUG  */
/* check consensus_table   */ /*
  printf("consensus_table (select_flag = %d) ;  (1 => SELECT, 0 => ORIGINAL) \n",select_flag); 
  for(base = 0;base != BASES;base++)
    {
      printf("consensus_table[%d]:",base);
      for(column = 0;column != NoOfColumn;column++)
	{
	  printf("%2d ",consensus_table[base][column]);
	}
      printf("\n");
    }
#endif
*/
  /* find which base is the most consensus in each column  */
  /* ORIGINAL -> consensus */
  /* SELECT   -> consensusSelected */
  if(!select_flag)
    { /* ORIGINAL */
      for(column = 0;column != NoOfColumn;column++)
	{
	  Max[0] = 0;
	  Max[1] = 0;
	  for(base = 0;base != BASES;base++)
	    { 
	      if(consensus_table[base][column] > Max[1])
		{
		  Max[0] = base;
		  Max[1] = consensus_table[base][column];
		}
	      else if(consensus_table[base][column] <= Max[1])
		; 
	    }
	  /*
	    #ifdef DEBUG
	    printf("column %2d:Max[0] = %d,Max[1] = %3d\n",column,Max[0],Max[1]);
	    #endif	 
	    */
	  if(Max[1] == NoOfSeqs && Max[0] != OTHER)  /* all bases in this column are same */
	    {
	      consensus[column][0] = Max[0];
	      consensus[column][1] = 100;
	    }
	  else if(Max[0] != OTHER) 
	    {
	      consensus[column][0] = Max[0];
	      consensus[column][1] = Max[1] *100 / NoOfSeqs; /* percentage */
	    }
	  else     /* other than A,U,G,C,T */
	    {
	      consensus[column][0] = OTHER;
	      consensus[column][1] = 0;
	    }
	}
/*      
#ifdef DEBUG */
      /* check consensus *//*
      printf("NoOfSeqs =  %d,  ",NoOfSeqs);
      printf("consensus[%3d][2] =    \n",NoOfColumn);
      for(column = 0;column != NoOfColumn;column++)
	printf("%3d ",consensus[column][0]);
      printf("\n");
      for(column = 0;column != NoOfColumn;column++)
	printf("%3d ",consensus[column][1]);
      printf("\n");
      
#endif */
    }

  if(select_flag)
    { /* SELECT mode */
      for(column = 0;column != NoOfColumn;column++)
	{
	  Max[0] = 0;
	  Max[1] = 0;
	  for(base = 0;base != BASES;base++)
	    {   /* find which base is the most consensus in each column  */
	      if(consensus_table[base][column] > Max[1])
		{
		  Max[0] = base;
		  Max[1] = consensus_table[base][column];
		}
	      else if(consensus_table[base][column] <= Max[1])
		; 
	    }
	  /*
	    #ifdef DEBUG
	    printf("column %2d:Max[0] = %d,Max[1] = %3d\n",column,Max[0],Max[1]);
	    #endif	 
	    */
	  if(Max[1] == NoOfSelectedSeqs && Max[0] != OTHER)  /* all bases in this column are same */
	    {
	      consensusSelected[column][0] = Max[0];
	      consensusSelected[column][1] = 100;
	    }
	  else if(Max[0] != OTHER) 
	    {
	      consensusSelected[column][0] = Max[0];
	      consensusSelected[column][1] = Max[1] *100 / NoOfSelectedSeqs; /* percentage */
	    }
	  else     /* other than A,U,G,C,T */
	    {
	      consensusSelected[column][0] = OTHER;
	      consensusSelected[column][1] = 0;
	    }
	}
      
#ifdef DEBUG 
      /* check consensusSelected */
      printf("NoOfSelectedSeqs =  %d,  ",NoOfSelectedSeqs);
      printf("consensusSelected[%3d][2] =    \n",NoOfColumn);
      for(column = 0;column != NoOfColumn;column++)
	printf("%3d ",consensusSelected[column][0]);
      printf("\n");
      for(column = 0;column != NoOfColumn;column++)
	printf("%3d ",consensusSelected[column][1]);
      printf("\n");
      
#endif
    }

}

/* ------------ end of "check_consensus.c" -------------------- */
