/* ---------------------------------------------------------- 
%(C)1994,1995 Institute for New Generation Computer Technology 
%       (Read COPYRIGHT for detailed information.) 
----------------------------------------------------------- */
/* --------------------------------------------------------- */
/*  calczahyou1.c                                            */
/*     - decide radius from NoOfHyoujiColumn                 */
/*     - decide angle for one column                         */
/*     - calculate coordinates of each column                */
/* --------------------------------------------------------- */

#include <stdio.h>
#include <math.h>
#include "stem.h"
/*
#define DEBUG TRUE
*/
int hankei_No;        /* radius of circle ,on whose circumference the No. of column is wrote */
int default_hankei;   /* default value of radius */

/* decide radius */
int decideHankei(columns)
     int  columns; /* no. of displayed columns */
{
  if(columns < SMALL)
    return HANKEIS;
  else
    return HANKEIL;
}

/* calculate ange foe one column */
double decideAngle(defaultAki,Columns,select_flag)
     double defaultAki;   /* default angle of the opening in circle */
     int    Columns;      /* no. of displayed columns */
     int    select_flag;  /* ORIGINAL or SELECT */
{
  int kakudo_all,  /* angle for each column * no. of displayed columns */
      kakudo_aki,  /* angle of the opening in circle */
      angle_i;
  double angle_d,
         kakudo_all_d,
         kakudo_aki_d;
      

  double angle_small = 1/64; 
  angle_i = ANGLE;

  kakudo_all = Columns * angle_i;
  kakudo_aki = 360 - kakudo_all;
/*  printf("defaultAki=%2.2f\n",defaultAki); */
  if(kakudo_aki >= defaultAki*2)
    {
      if(!select_flag)
	aki = (double)(kakudo_aki / 2);
      else if(select_flag)
	aki_s = (double)(kakudo_aki / 2);
/*      printf("aki in decideAngle=%2.2f\n",aki); */
      return (double)angle_i;
    }
  else
    {/* (default angle * no. of columns) exceeds 360 degree */
      angle_i = angle_i-1;
      for(;angle_i>=1;angle_i--)
	{
	  kakudo_all = Columns * angle_i;
	  kakudo_aki = 360 - kakudo_all;
	  if(kakudo_aki >= defaultAki*2)
	    {
	      if(!select_flag)
		aki = (double)(kakudo_aki / 2);
	      else if(select_flag)
		aki_s = (double)(kakudo_aki / 2);
/* for debug */
/*	      printf("aki in decideAngle = %2.2f\n",aki); */

	      return (double)angle_i;
	    }
	}
      if(angle_i == 0)
	{/* angle for one column < 1 degree */
	  angle_d = 1;
	  while(angle_d != 0)
	    {
	      angle_d = angle_d - angle_small;
	      kakudo_all_d = Columns * angle_d;
	      kakudo_aki_d = 360 - kakudo_all_d;
	      if(kakudo_aki_d >= defaultAki*2)
		{
		  if(!select_flag)
		    aki = kakudo_aki_d / 2;
		  if(select_flag)
		    aki_s = kakudo_aki_d / 2;
/* for debug */		  
/*		  printf("aki in decideAngle = %2.2f\n",aki); */
		  return (double)angle_i;
		}
	    }
	  if (angle_d == 0) 
	    {
	      printf("Sorry,because of too many bases,cannot write base in each color\n");
	      exit(0);
	    }
      	}
    }
}


/* calculate angle of nth column on circle */

double calcKakudo(length,n,aki)
     int length, /* no. of displayed columns */
         n;
     double   aki; /* angle of opening of the circle */
{
  double yuukoukakudo, /* angle for each column * no. of displayed columns */
         v1,         /* angle of nth column */
         v3;         /* radian of v1 */

   yuukoukakudo = (360 - aki*2) / (double)(length);
   v1 =  yuukoukakudo * (double)n + aki + 90;

  v3 = M_PI * ( v1 / 180);
/*
#ifdef DEBUG
  printf(" column No = %d\n ",n); 
  printf(" v1 = %8.2f,v3 = %8.2f\n ",v1,v3); 
#endif
*/
  return v3;
}

/* calculate x (center of circle is (0,0)) */

int calcRelativeLenX(v,r)
     double v;
     int    r;
{
  double  cosV;

  cosV = cos(v) * r;
/*
#ifdef DEBUG
  printf(" v = %8.2f , cos(v)*r = %8.2f\n",v,cosV); 
#endif
*/
  return (int)cosV ;
}

/* calculate y (center of circle is (0,0)) */
int calcRelativeLenY(v,r)
     double v;
     int r;
{
  double  sinV;

  sinV = sin(v) * r;
/*
#ifdef DEBUG
  printf(" v = %8.2f , sin(v)*r = %8.2f\n",v,sinV); 
#endif
*/
  return (int)sinV ;
}

/* calculate (x,y) of each column (X-Window) */

int  calcZahyou(r,xo,yo,Columns,select_flag)
     int r,               /* radius */
         xo,yo,           /* center of circle */
         Columns,         /* number of columns displyed */
         select_flag;     /* ORIGINAL -> 0 , SELECT -> 1 */
{
  int xl,yl, /* (x,y) for column (center of circle is (0,0)) */
      xl_No,yl_No, /* (x,y) for figure (center of circle is (0,0)) */
      x_zahyou,y_zahyou, /* (x,y) for column ( X-window ) */
      x_zahyou_No,y_zahyou_No, /* (x,y) for figure (X-window) */
      colNo; /* counter of column */

  double v; /* angle of nth column */

  hankei_No = r+SUU;  /* radius for figure */
  
  for(colNo = 0; colNo != Columns;colNo++)
    {
      if(!select_flag)
	v = calcKakudo(Columns,colNo,aki);
      else if(select_flag)
	v = calcKakudo(Columns,colNo,aki_s);

      xl = calcRelativeLenX(v,r);
      yl = calcRelativeLenY(v,r);
      
      xl_No = calcRelativeLenX(v,hankei_No);
      yl_No = calcRelativeLenY(v,hankei_No);

      if(!select_flag)
	{ /* ORIGINAL */
	  x_zahyou = xo + xl;
	  y_zahyou = yo - yl;
	  x_zahyou_No = xo + xl_No;
	  y_zahyou_No = yo - yl_No;
	  
	  zahyou_table[colNo][0] = x_zahyou;
	  zahyou_table[colNo][1] = y_zahyou;
	  zahyou_table[colNo][2] = x_zahyou_No;
	  zahyou_table[colNo][3] = y_zahyou_No;
	}
      else
	{ /* SELECT */
	  x_zahyou = xo_s + xl;
	  y_zahyou = yo_s - yl;
	  x_zahyou_No = xo_s + xl_No;
	  y_zahyou_No = yo_s - yl_No;
	  
	  zahyou_table_s[colNo][0] = x_zahyou;
	  zahyou_table_s[colNo][1] = y_zahyou;
	  zahyou_table_s[colNo][2] = x_zahyou_No;
	  zahyou_table_s[colNo][3] = y_zahyou_No;
	}

    }
}

void calc_zahyou_data(select_flag)
     int select_flag;
  /* select_flag = TRUE -> SELECT */
  /* select_flag = FALSE -> ORIGINAL */
{
  int test; 

  if(select_flag == ORIGINAL)
    {/* ORIGINAL */
      xarc0 = X0;
      yarc0 = Y0;
      if(!resized)
	{ /* window size changed,so re-calculate  */
	  hankei  = decideHankei(NoOfHyoujiColumn);
	  default_hankei = hankei;
	}
      angle = decideAngle((double)AKI,NoOfHyoujiColumn,select_flag);
      
#ifdef DEBUG
      printf("hankei = %d,",hankei);
      printf("aki = %6.3f, ",aki);
      printf("angle = %6.3f\n",angle);
#endif  
      xo = xarc0+hankei;
      yo = yarc0+hankei;
      
      fileChanged = FALSE;
      calcZahyou(hankei,xo,yo,NoOfHyoujiColumn,select_flag);
    }

  else if(select_flag == SELECT)
    {/* SELECT */
      xarc0_s = X0;
      yarc0_s = Y0;
      angle_s = decideAngle((double)AKI,NoOfHyoujiColumnS,select_flag);
      
#ifdef DEBUG
      printf("hankei_s = %d,",hankei_s);
      printf("aki_s = %6.3f, ",aki_s);
      printf("angle_s = %6.3f\n",angle_s);
#endif  
      xo_s = xarc0_s+hankei_s;
      yo_s = yarc0_s+hankei_s;
      calcZahyou(hankei_s,xo_s,yo_s,NoOfHyoujiColumnS,select_flag);
#ifdef DEBUG 

  for(test=0;test!=NoOfHyoujiColumnS;test++)
    printf("count[%3d]: x=%3d,y=%3d\n",test,zahyou_table_s[test][0],zahyou_table_s[test][1]);
#endif 

    }

}

/* ---------- end of "calczahyou1.c" ------------------- */
