/* ---------------------------------------------------------- 
%(C)1994,1995 Institute for New Generation Computer Technology 
%       (Read COPYRIGHT for detailed information.) 
----------------------------------------------------------- */
#include "aedit.h"
#include "align.h"

#define CONSNUM 100

tree_base_ria()
{
  struct DATA0 d0;
  struct ALIGN ps;
  int i,j,k,leng;

  readSeq_tria(&ps,&d0);

  display_alignment_monitor(1,ps.SeqNum);
  d0.Cut = ps.CutT;
  for(j=0;j<ps.SeqNum;j++){
    for(i=j+1;i<ps.SeqNum;i++){

      d0.X = ps.Leng[i];
      d0.Y = ps.Leng[j];
      d0.NumX = 1;
      d0.NumY = 1;

      for(k=0;k<ps.Leng[i];k++){
	d0.CSeq1[0][k] = ps.CSeq[i][k];
	d0.Seq1[0][k] = ps.Seq[i][k];
      }
      for(k=0;k<ps.Leng[j];k++){
	d0.CSeq2[0][k] = ps.CSeq[j][k];
	d0.Seq2[0][k] = ps.Seq[j][k];
      }

      generateD_00(&d0);

      if(d0.J % 2 == 0) ps.CMatrix[i][j] = d0.Vec0[d0.I].xy;
      if(d0.J % 2 == 1) ps.CMatrix[i][j] = d0.Vec1[d0.I].xy;

    }
  }

  display_alignment_monitor(0,1);
  for(i=0;i<ps.SeqNum-1;i++){
    d0.Cut = ps.CutT;
    minimumCost(&ps,&d0);
    d0.Cut = ps.CutR;
    leng = tria(&ps,&d0);
    display_alignment_monitor(0,i+2);
  }
  writeSeq_align(&ps,&d0,leng);
}


int tria(fs,d0)
struct ALIGN *fs;
struct DATA0 *d0;
{
  int i,j,k,m,mx,my,ST,M;
  int energy,oldenergy,pos,lengx,lengy;

  for(i=0;i<fs-> Num[fs->R1];i++){
    m = fs->NumVec[fs->R1][i];
    for(j=0;j< fs->Leng[fs->R1];j++){
      fs->OSeq[m][j] = fs->Seq[m][j];
      fs->OCSeq[m][j] = fs->CSeq[m][j];
      fs->OCons[m][j] = fs->Cons[m][j];
    }
  }

  d0->NumX = 1;
  d0->NumY = fs->Num[fs->R1] - 1;

  d0->X = d0->Y = fs->Leng[fs->R1];

  oldenergy = makeEnergy(fs,d0,d0->X);

  ST = 0;  
  for(;;){
    ST++;
    for(M=0;M< fs->Num[fs->R1];M++){

      mx = fs->NumVec[fs->R1][M];
      k = 0;
      while(fs->OCSeq[mx][k] == '-'){
	fs->CSeq1_C[0][k] = '#';
	fs->Seq1_C[0][k] = fs->OSeq[mx][k];
	fs->Cons1_C[0][k] = fs->OCons[mx][k];
	k++;
      }
      while(k<d0->X){
	fs->CSeq1_C[0][k] = fs->OCSeq[mx][k];
	fs->Seq1_C[0][k] = fs->OSeq[mx][k];
	fs->Cons1_C[0][k] = fs->OCons[mx][k];
	k++;
      }
      k--;
      while(fs->OCSeq[mx][k] == '-'){
	fs->CSeq1_C[0][k] = '#';
	k--;
      }
      
      for(j=0;j<M;j++){
	my = fs->NumVec[fs->R1][j];
	k = 0;
	while(fs->OCSeq[my][k] == '-'){
	  fs->CSeq2_C[j][k] = '#';
	  fs->Seq2_C[j][k] = fs->OSeq[my][k];
	  fs->Cons2_C[j][k] = fs->OCons[my][k];
	  k++;
	}
	while(k<d0->Y){
	  fs->CSeq2_C[j][k] = fs->OCSeq[my][k];
	  fs->Seq2_C[j][k] = fs->OSeq[my][k];
	  fs->Cons2_C[j][k] = fs->OCons[my][k];
	  k++;
	}
	k--;
	while(fs->OCSeq[my][k] == '-'){
	  fs->CSeq2_C[j][k] = '#';
	  k--;
	}
      }
      for(j=M+1;j<fs->Num[fs->R1];j++){
	my = fs->NumVec[fs->R1][j];
	k = 0;
	while(fs->OCSeq[my][k] == '-'){
	  fs->CSeq2_C[j-1][k] = '#';
	  fs->Seq2_C[j-1][k] = fs->OSeq[my][k];
	  fs->Cons2_C[j-1][k] = fs->OCons[my][k];
	  k++;
	}
	while(k<d0->Y){
	  fs->CSeq2_C[j-1][k] = fs->OCSeq[my][k];
	  fs->Seq2_C[j-1][k] = fs->OSeq[my][k];
	  fs->Cons2_C[j-1][k] = fs->OCons[my][k];
	  k++;
	}
	k--;
	while(fs->OCSeq[my][k] == '-'){
	  fs->CSeq2_C[j-1][k] = '#';
	  k--;
	}
      }

      remove_allgap(fs,d0);

      lengx = d0->X;
      lengy = d0->Y;

      pos = constraint_tria(fs,d0,M,lengx,lengy); 
      d0->X = d0->Y = pos;

      mx = fs->NumVec[fs->R1][M];
      for(j=0;j<pos;j++){
	fs->OCSeq[mx][j] = fs->DCSeq[mx][j];
	fs->OSeq[mx][j] = fs->DSeq[mx][j];
	fs->OCons[mx][j] = fs->DCons[mx][j];
      }
      for(i=0;i<M;i++){
	my = fs->NumVec[fs->R1][i];
	for(j=0;j<pos;j++){
	  fs->OCSeq[my][j] = fs->DCSeq[my][j];
	  fs->OSeq[my][j] = fs->DSeq[my][j];
	  fs->OCons[my][j] = fs->DCons[my][j];
	}
      }
      for(i=M+1;i< fs->Num[fs->R1];i++){
	my = fs->NumVec[fs->R1][i];
	for(j=0;j<pos;j++){
	  fs->OCSeq[my][j] = fs->DCSeq[my][j];
	  fs->OSeq[my][j] = fs->DSeq[my][j];
	  fs->OCons[my][j] = fs->DCons[my][j];
	}

      }

    }
    
    energy = makeEnergy(fs,d0,d0->X);

    if(energy < oldenergy){
      oldenergy = energy;
      fs->Leng[fs->R1] = pos;
      for(i=0;i< fs->Num[fs->R1];i++){
	m = fs->NumVec[fs->R1][i];
	for(k=0;k< fs->Leng[fs->R1];k++){
	  fs->CSeq[m][k] = fs->OCSeq[m][k];
	  fs->Seq[m][k] = fs->OSeq[m][k];
	  fs->Cons[m][k] = fs->OCons[m][k];
	}
      }
    }
    else break;
  }
  return fs->Leng[fs->R1];
}




remove_allgap(fs,d0)
struct ALIGN *fs;
struct DATA0 *d0;
{
  int i,j,k,k1;

  j = 0;
  for(i=0;i<d0->X;i++){
    for(k=0;k<d0->NumX;k++){
      if(fs->CSeq1_C[k][i] != '-' && fs->CSeq1_C[k][i] != '#'){
	for(k1=0;k1<d0->NumY;k1++){
	  fs->CSeq1_C[k1][j] = fs->CSeq1_C[k1][i];
	  fs->Seq1_C[k1][j] = fs->Seq1_C[k1][i];
	  fs->Cons1_C[k1][j] = fs->Cons1_C[k1][i];
	}
	j++;
	break;
      }
      else {}
    }
  }
  d0->X = j;

  j = 0;
  for(i=0;i<d0->Y;i++){
    for(k=0;k<d0->NumY;k++){
      if(fs->CSeq2_C[k][i] != '-' && fs->CSeq2_C[k][i] != '#'){
	for(k1=0;k1<d0->NumY;k1++){
	  fs->CSeq2_C[k1][j] = fs->CSeq2_C[k1][i];
	  fs->Seq2_C[k1][j] = fs->Seq2_C[k1][i];
	  fs->Cons2_C[k1][j] = fs->Cons2_C[k1][i];
	}
	j++;
	break;
      }
      else {}
    }
  }
  d0->Y = j;
}


int constraint_tria(fs,d0,M,lengx,lengy)
struct ALIGN *fs;
struct DATA0 *d0;
int M,lengx,lengy;
{
  int i,j,k;
  int x1,y1,a,b,pos=0;
  int mx,my;

  char ConsNum[CONSNUM];
  int ConsPos1[CONSNUM];
  int ConsPos2[CONSNUM];
  int ConsN;

  k = 0;
  for(i=0;i<d0->X;i++){
    for(j=0;j<d0->NumX;j++){
      if(fs->Cons1_C[j][i] > 96){
	for(a=0;a<d0->Y;a++){
	  for(b=0;b<d0->NumY;b++){
	    if(fs->Cons2_C[b][a] > 96){
/*	      if(fs->Cons1_C[j][i] < fs->Cons2_C[b][a]) goto label1;*/
	      if(fs->Cons1_C[j][i] == fs->Cons2_C[b][a]){
		ConsNum[k] = fs->Cons1_C[j][i];
		ConsPos1[k] = i;
		ConsPos2[k] = a;
		k++;
		goto label1;
	      }
	      else {}
	      break;
	    }
	    else {}
	  }
	}
      }
      else {}
    }
  label1:{}
  }

  ConsN = k;
  if(ConsN > 0){
    d0->X = ConsPos1[0] + 1;
    d0->Y = ConsPos2[0] + 1;
    x1 = d0->X - 1;
    y1 = d0->Y - 1;
    for(i=0;i<d0->NumX;i++){
      for(j=0;j<x1;j++){
	d0->Seq1[i][j] = fs->Seq1_C[i][j];
	d0->CSeq1[i][j] = fs->CSeq1_C[i][j];
	fs->Cons1[i][j] = fs->Cons1_C[i][j];
      }
      d0->Seq1[i][x1] = 14;
      d0->CSeq1[i][x1] = fs->CSeq1_C[i][x1];
      fs->Cons1[i][x1] = fs->Cons1_C[i][x1];
    }
    for(i=0;i<d0->NumY;i++){
      for(j=0;j<y1;j++){
	d0->Seq2[i][j] = fs->Seq2_C[i][j];
	d0->CSeq2[i][j] = fs->CSeq2_C[i][j];
	fs->Cons2[i][j] = fs->Cons2_C[i][j];
      }
      d0->Seq2[i][y1] = 14;
      d0->CSeq2[i][y1] = fs->CSeq2_C[i][y1];
      fs->Cons2[i][y1] = fs->Cons2_C[i][y1];
    }
    generateD_00(d0);
    pos = makeAlignmentString1_tria(fs,d0,pos,M);
    pos--;
    for(k=1;k<ConsN;k++){
      d0->X = ConsPos1[k] - ConsPos1[k-1] + 1;
      d0->Y = ConsPos2[k] - ConsPos2[k-1] + 1;
      x1 = d0->X - 1;
      y1 = d0->Y - 1;
      for(i=0;i<d0->NumX;i++){
	a = ConsPos1[k-1];
	d0->Seq1[i][0] = 14;
	d0->CSeq1[i][0] = fs->CSeq1_C[i][a];
	fs->Cons1[i][0] = fs->Cons1_C[i][a];
	a++;
	for(j=1;j<x1;j++){
	  d0->Seq1[i][j] = fs->Seq1_C[i][a];
	  d0->CSeq1[i][j] = fs->CSeq1_C[i][a];
	  fs->Cons1[i][j] = fs->Cons1_C[i][a];
	  a++;
	}
	d0->Seq1[i][x1] = 14;
	d0->CSeq1[i][x1] = fs->CSeq1_C[i][a];
	fs->Cons1[i][x1] = fs->Cons1_C[i][a];
      }
      for(i=0;i<d0->NumY;i++){
	b = ConsPos2[k-1];
	d0->Seq2[i][0] = 14;
	d0->CSeq2[i][0] = fs->CSeq2_C[i][b];
	fs->Cons2[i][0] = fs->Cons2_C[i][b];
	b++;
	for(j=1;j<y1;j++){
	  d0->Seq2[i][j] = fs->Seq2_C[i][b];
	  d0->CSeq2[i][j] = fs->CSeq2_C[i][b];
	  fs->Cons2[i][j] = fs->Cons2_C[i][b];
	  b++;
	}
	d0->Seq2[i][y1] = 14;
	d0->CSeq2[i][y1] = fs->CSeq2_C[i][b];
	fs->Cons2[i][y1] = fs->Cons2_C[i][b];
      }
      generateD_00(d0);
      pos = makeAlignmentString_tria(fs,d0,pos,M);
      pos--;
    }
    d0->X = lengx - ConsPos1[ConsN-1];
    d0->Y = lengy - ConsPos2[ConsN-1];
    for(i=0;i<d0->NumX;i++){
      a = ConsPos1[ConsN-1];
      d0->Seq1[i][0] = 14;
      d0->CSeq1[i][0] = fs->CSeq1_C[i][a];
      fs->Cons1[i][0] = fs->Cons1_C[i][a];
      a++;
      for(j=1;j<d0->X;j++){
	d0->Seq1[i][j] = fs->Seq1_C[i][a];
	d0->CSeq1[i][j] = fs->CSeq1_C[i][a];
	fs->Cons1[i][j] = fs->Cons1_C[i][a];
	a++;
      }
    }
    for(i=0;i<d0->NumY;i++){
      b = ConsPos2[ConsN-1];
      d0->Seq2[i][0] = 14;
      d0->CSeq2[i][0] = fs->CSeq2_C[i][b];
      fs->Cons2[i][0] = fs->Cons2_C[i][b];
      b++;
      for(j=1;j<d0->Y;j++){
	d0->Seq2[i][j] = fs->Seq2_C[i][b];
	d0->CSeq2[i][j] = fs->CSeq2_C[i][b];
	fs->Cons2[i][j] = fs->Cons2_C[i][b];
	b++;
      }
    }
    generateD_00(d0);
    pos = makeAlignmentString_tria(fs,d0,pos,M);
  }
  else {
    for(i=0;i<d0->NumX;i++){
      for(j=0;j<d0->X;j++){
	d0->Seq1[i][j] = fs->Seq1_C[i][j];
	d0->CSeq1[i][j] = fs->CSeq1_C[i][j];
	fs->Cons1[i][j] = fs->Cons1_C[i][j];
      }
    }
    for(i=0;i<d0->NumY;i++){
      for(j=0;j<d0->Y;j++){
	d0->Seq2[i][j] = fs->Seq2_C[i][j];
	d0->CSeq2[i][j] = fs->CSeq2_C[i][j];
	fs->Cons2[i][j] = fs->Cons2_C[i][j];
      }
    }
    generateD_00(d0);
    pos = makeAlignmentString1_tria(fs,d0,pos,M);
  }

  return pos;
}


int makeAlignmentString_tria(fs,d0,pos,M)
struct ALIGN *fs;
struct DATA0 *d0;
int pos,M;
{
  int i,j,k,mx,my;
  char NextPath;
  char ASeq[SEQNUM][MAXBUFF];
  char ACSeq[SEQNUM][MAXBUFF];
  char ACons[SEQNUM][MAXBUFF];
  int Leng;

  i = 0;

  NextPath = d0->Path[d0->J][d0->I].xy;

  for(;;){
    if(NextPath == 'z'){
      mx = fs->NumVec[fs->R1][M];
      if(d0->CSeq1[0][d0->I-1] == '#' || 
	 d0->CSeq1[0][d0->I-1] == '-'){
	ACSeq[mx][i] = '-';
	ASeq[mx][i] = 26;
	ACons[mx][i] = 95;
      }
      else{
	ACSeq[mx][i] = d0->CSeq1[0][d0->I-1];
	ASeq[mx][i] = d0->Seq1[0][d0->I-1];
	ACons[mx][i] = fs->Cons1[0][d0->I-1];
      }
      for(k=0;k<M;k++){
	my = fs->NumVec[fs->R1][k];
	if(d0->CSeq2[k][d0->J-1] == '#' || 
	   d0->CSeq2[k][d0->J-1] == '-'){
	  ACSeq[my][i] = '-';
	  ASeq[my][i] = 26;
	  ACons[my][i] = 95;
	}
	else{
	  ACSeq[my][i] = d0->CSeq2[k][d0->J-1];
	  ASeq[my][i] = d0->Seq2[k][d0->J-1];
	  ACons[my][i] = fs->Cons2[k][d0->J-1];
	}
      }
      for(k=M+1;k< fs->Num[fs->R1];k++){
	my = fs->NumVec[fs->R1][k];
	if(d0->CSeq2[k-1][d0->J-1] == '#' || 
	   d0->CSeq2[k-1][d0->J-1] == '-'){
	  ACSeq[my][i] = '-';
	  ASeq[my][i] = 26;
	  ACons[my][i] = 95;
	}
	else{
	  ACSeq[my][i] = d0->CSeq2[k-1][d0->J-1];
	  ASeq[my][i] = d0->Seq2[k-1][d0->J-1];
	  ACons[my][i] = fs->Cons2[k-1][d0->J-1];
	}
      }
      d0->I--;
      d0->J--;
      NextPath = d0->Path[d0->J][d0->I].xy;
    }
    else if(NextPath == 'x'){
      mx = fs->NumVec[fs->R1][M];
      if(d0->CSeq1[0][d0->I-1] == '#' || 
	 d0->CSeq1[0][d0->I-1] == '-'){
	ACSeq[mx][i] = '-';
	ASeq[mx][i] = 26;
	ACons[mx][i] = 95;
      }
      else{
	ACSeq[mx][i] = d0->CSeq1[0][d0->I-1];
	ASeq[mx][i] = d0->Seq1[0][d0->I-1];
	ACons[mx][i] = fs->Cons1[0][d0->I-1];
      }
      for(k=0;k<M;k++) {
	my = fs->NumVec[fs->R1][k];
	ACSeq[my][i] = '-';
	ASeq[my][i] = 26;
	ACons[my][i] = 95;
      }
      for(k=M+1;k< fs->Num[fs->R1];k++) {
	my = fs->NumVec[fs->R1][k];
	ACSeq[my][i] = '-';
	ASeq[my][i] = 26;
	ACons[my][i] = 95;
      }
      d0->I--;
      NextPath = d0->Path[d0->J][d0->I].x;
    }
    else if(NextPath == 'y'){
      mx = fs->NumVec[fs->R1][M];
      ACSeq[mx][i] = '-';
      ASeq[mx][i] = 26;
      ACons[mx][i] = 95;
      for(k=0;k<M;k++){
	my = fs->NumVec[fs->R1][k];
	if(d0->CSeq2[k][d0->J-1] == '#' || 
	   d0->CSeq2[k][d0->J-1] == '-'){
	  ACSeq[my][i] = '-';
	  ASeq[my][i] = 26;
	  ACons[my][i] = 95;
	}
	else{
	  ACSeq[my][i] = d0->CSeq2[k][d0->J-1];
	  ASeq[my][i] = d0->Seq2[k][d0->J-1];
	  ACons[my][i] = fs->Cons2[k][d0->J-1];
	}
      }
      for(k=M+1;k< fs->Num[fs->R1];k++){
	my = fs->NumVec[fs->R1][k];
	if(d0->CSeq2[k-1][d0->J-1] == '#' || 
	   d0->CSeq2[k-1][d0->J-1] == '-'){
	  ACSeq[my][i] = '-';
	  ASeq[my][i] = 26;
	  ACons[my][i] = 95;
	}
	else{
	  ACSeq[my][i] = d0->CSeq2[k-1][d0->J-1];
	  ASeq[my][i] = d0->Seq2[k-1][d0->J-1];
	  ACons[my][i] = fs->Cons2[k-1][d0->J-1];
	}
      }
      d0->J--;
      NextPath = d0->Path[d0->J][d0->I].y;
    }
    else {
      printf("makeAlignmentString_tria error\n");
      exit(1);
    }

    i++;

    if(d0->I == 0 && d0->J == 0) break;

  }
  Leng = i;

  mx = fs->NumVec[fs->R1][M];
  if(ASeq[mx][Leng-1] == 14 && ACSeq[mx][Leng-1] != 'O'){
    fs->DSeq[mx][pos] = ACSeq[mx][Leng-1] - 'A';
  }
  else {
    fs->DSeq[mx][pos] = ASeq[mx][Leng-1];
  }
  fs->DCSeq[mx][pos] = ACSeq[mx][Leng-1];
  fs->DCons[mx][pos] = ACons[mx][Leng-1];
  j = pos+1;
  for(i=Leng-2;i>-1;i--){
    fs->DCSeq[mx][j] = ACSeq[mx][i];
    fs->DSeq[mx][j] = ASeq[mx][i];
    fs->DCons[mx][j] = ACons[mx][i];
    j++;
  }
  for(k=0;k<M;k++){
    my = fs->NumVec[fs->R1][k];
    if(ASeq[my][Leng-1] == 14 && ACSeq[my][Leng-1] != 'O'){
      fs->DSeq[my][pos] = ACSeq[my][Leng-1] - 'A';
    }
    else {
      fs->DSeq[my][pos] = ASeq[my][Leng-1];
    }
    fs->DCSeq[my][pos] = ACSeq[my][Leng-1];
    fs->DCons[my][pos] = ACons[my][Leng-1];
    j = pos+1;
    for(i=Leng-2;i>-1;i--){
      fs->DCSeq[my][j] = ACSeq[my][i];
      fs->DSeq[my][j] = ASeq[my][i];
      fs->DCons[my][j] = ACons[my][i];
      j++;
    }
  }
  for(k=M+1;k< fs->Num[fs->R1];k++){
    my = fs->NumVec[fs->R1][k];
    if(ASeq[my][Leng-1] == 14 && ACSeq[my][Leng-1] != 'O'){
      fs->DSeq[my][pos] = ACSeq[my][Leng-1] - 'A';
    }
    else {
      fs->DSeq[my][pos] = ASeq[my][Leng-1];
    }
    fs->DCSeq[my][pos] = ACSeq[my][Leng-1];
    fs->DCons[my][pos] = ACons[my][Leng-1];
    j = pos+1;
    for(i=Leng-2;i>-1;i--){
      fs->DCSeq[my][j] = ACSeq[my][i];
      fs->DSeq[my][j] = ASeq[my][i];
      fs->DCons[my][j] = ACons[my][i];
      j++;
    }
  }
  return j;
}


int makeAlignmentString1_tria(fs,d0,pos,M)
struct ALIGN *fs;
struct DATA0 *d0;
int pos,M;
{
  int i,j,k,mx,my;
  char NextPath;
  char ASeq[SEQNUM][MAXBUFF];
  char ACSeq[SEQNUM][MAXBUFF];
  char ACons[SEQNUM][MAXBUFF];
  int Leng;

  i = 0;

  NextPath = d0->Path[d0->J][d0->I].xy;

  for(;;){
    if(NextPath == 'z'){
      mx = fs->NumVec[fs->R1][M];
      if(d0->CSeq1[0][d0->I-1] == '#' || 
	 d0->CSeq1[0][d0->I-1] == '-'){
	ACSeq[mx][i] = '-';
	ASeq[mx][i] = 26;
	ACons[mx][i] = 95;
      }
      else{
	ACSeq[mx][i] = d0->CSeq1[0][d0->I-1];
	ASeq[mx][i] = d0->Seq1[0][d0->I-1];
	ACons[mx][i] = fs->Cons1[0][d0->I-1];
      }
      for(k=0;k<M;k++){
	my = fs->NumVec[fs->R1][k];
	if(d0->CSeq2[k][d0->J-1] == '#' || 
	   d0->CSeq2[k][d0->J-1] == '-'){
	  ACSeq[my][i] = '-';
	  ASeq[my][i] = 26;
	  ACons[my][i] = 95;
	}
	else{
	  ACSeq[my][i] = d0->CSeq2[k][d0->J-1];
	  ASeq[my][i] = d0->Seq2[k][d0->J-1];
	  ACons[my][i] = fs->Cons2[k][d0->J-1];
	}
      }
      for(k=M+1;k< fs->Num[fs->R1];k++){
	my = fs->NumVec[fs->R1][k];
	if(d0->CSeq2[k-1][d0->J-1] == '#' || 
	   d0->CSeq2[k-1][d0->J-1] == '-'){
	  ACSeq[my][i] = '-';
	  ASeq[my][i] = 26;
	  ACons[my][i] = 95;
	}
	else{
	  ACSeq[my][i] = d0->CSeq2[k-1][d0->J-1];
	  ASeq[my][i] = d0->Seq2[k-1][d0->J-1];
	  ACons[my][i] = fs->Cons2[k-1][d0->J-1];
	}
      }
      d0->I--;
      d0->J--;
      NextPath = d0->Path[d0->J][d0->I].xy;
    }
    else if(NextPath == 'x'){
      mx = fs->NumVec[fs->R1][M];
      if(d0->CSeq1[0][d0->I-1] == '#' || 
	 d0->CSeq1[0][d0->I-1] == '-'){
	ACSeq[mx][i] = '-';
	ASeq[mx][i] = 26;
	ACons[mx][i] = 95;
      }
      else{
	ACSeq[mx][i] = d0->CSeq1[0][d0->I-1];
	ASeq[mx][i] = d0->Seq1[0][d0->I-1];
	ACons[mx][i] = fs->Cons1[0][d0->I-1];
      }
      for(k=0;k<M;k++) {
	my = fs->NumVec[fs->R1][k];
	ACSeq[my][i] = '-';
	ASeq[my][i] = 26;
	ACons[my][i] = 95;
      }
      for(k=M+1;k< fs->Num[fs->R1];k++) {
	my = fs->NumVec[fs->R1][k];
	ACSeq[my][i] = '-';
	ASeq[my][i] = 26;
	ACons[my][i] = 95;
      }
      d0->I--;
      NextPath = d0->Path[d0->J][d0->I].x;
    }
    else if(NextPath == 'y'){
      mx = fs->NumVec[fs->R1][M];
      ACSeq[mx][i] = '-';
      ASeq[mx][i] = 26;
      ACons[mx][i] = 95;
      for(k=0;k<M;k++){
	my = fs->NumVec[fs->R1][k];
	if(d0->CSeq2[k][d0->J-1] == '#' || 
	   d0->CSeq2[k][d0->J-1] == '-'){
	  ACSeq[my][i] = '-';
	  ASeq[my][i] = 26;
	  ACons[my][i] = 95;
	}
	else{
	  ACSeq[my][i] = d0->CSeq2[k][d0->J-1];
	  ASeq[my][i] = d0->Seq2[k][d0->J-1];
	  ACons[my][i] = fs->Cons2[k][d0->J-1];
	}
      }
      for(k=M+1;k< fs->Num[fs->R1];k++){
	my = fs->NumVec[fs->R1][k];
	if(d0->CSeq2[k-1][d0->J-1] == '#' || 
	   d0->CSeq2[k-1][d0->J-1] == '-'){
	  ACSeq[my][i] = '-';
	  ASeq[my][i] = 26;
	  ACons[my][i] = 95;
	}
	else{
	  ACSeq[my][i] = d0->CSeq2[k-1][d0->J-1];
	  ASeq[my][i] = d0->Seq2[k-1][d0->J-1];
	  ACons[my][i] = fs->Cons2[k-1][d0->J-1];
	}
      }
      d0->J--;
      NextPath = d0->Path[d0->J][d0->I].y;
    }
    else {
      printf("makeAlignmentString1_tria error\n");
      exit(1);
    }

    i++;

    if(d0->I == 0 && d0->J == 0) break;

  }
  Leng = i;

  mx = fs->NumVec[fs->R1][M];
  j = pos;
  for(i=Leng-1;i>-1;i--){
    fs->DCSeq[mx][j] = ACSeq[mx][i];
    fs->DSeq[mx][j] = ASeq[mx][i];
    fs->DCons[mx][j] = ACons[mx][i];
    j++;
  }
  for(k=0;k<M;k++){
    my = fs->NumVec[fs->R1][k];
    j = pos;
    for(i=Leng-1;i>-1;i--){
      fs->DCSeq[my][j] = ACSeq[my][i];
      fs->DSeq[my][j] = ASeq[my][i];
      fs->DCons[my][j] = ACons[my][i];
      j++;
    }
  }
  for(k=M+1;k< fs->Num[fs->R1];k++){
    my = fs->NumVec[fs->R1][k];
    j = pos;
    for(i=Leng-1;i>-1;i--){
      fs->DCSeq[my][j] = ACSeq[my][i];
      fs->DSeq[my][j] = ASeq[my][i];
      fs->DCons[my][j] = ACons[my][i];
      j++;
    }
  }
  return j;
}


int makeEnergy(fs,d0,X)
struct ALIGN *fs;
struct DATA0 *d0;
int X;
{
  int i,j,k,K,m,mx,my;
  int energy=0;

  for(i=0;i< fs->Num[fs->R1];i++){
    m = fs->NumVec[fs->R1][i];
    j = 0;
    while(fs->OCSeq[m][j] == '-'){
      fs->OCSeq[m][j] = '#';
      j++;
    }
   j = X - 1;
    while(fs->OCSeq[m][j] == '-'){
      fs->OCSeq[m][j] = '#';
      j--;
    }
  }

  for(i=0;i< fs->Num[fs->R1];i++){
    mx = fs->NumVec[fs->R1][i];
    for(j=i+1;j< fs->Num[fs->R1];j++){
      my = fs->NumVec[fs->R1][j];
      for(k=0;k< X;k++){
	if((fs->OCSeq[mx][k] == '-' || fs->OCSeq[mx][k] == '#') 
	   && (fs->OCSeq[my][k] == '-' || fs->OCSeq[my][k] == '#')) {}
	else if(fs->OCSeq[mx][k] == '#' || fs->OCSeq[my][k] == '#') energy += d0->S;
	else if(fs->OCSeq[mx][k] == '-'){
	  K = k;
	  for(;;){
	    K--;
	    if(fs->OCSeq[mx][K] != '-'){
	      energy += d0->U + d0->V;
	      break;
	    }
	    else if(fs->OCSeq[my][K] != '-'){
	      energy += d0->V;
	      break;
	    }
	    else {}
	  }
	}
	else if(fs->OCSeq[my][k] == '-'){
	  K = k;
	  for(;;){
	    K--;
	    if(fs->OCSeq[my][K] != '-'){
	      energy += d0->U + d0->V;
	      break;
	    }
	    else if(fs->OCSeq[mx][K] != '-'){
	      energy += d0->V;
	      break;
	    }
	    else {}
	  }
	}
	else{
	  energy += Dmatrix[fs->OSeq[mx][k]][fs->OSeq[my][k]];
	}
      }
    }
  }
  for(i=0;i< fs->Num[fs->R1];i++){
    m = fs->NumVec[fs->R1][i];
    j = 0;
    while(fs->OCSeq[m][j] == '#'){
      fs->OCSeq[m][j] = '-';
      j++;
    }
    j = X - 1;
    while(fs->OCSeq[m][j] == '#'){
      fs->OCSeq[m][j] = '-';
      j--;
    }
  }

  return energy;
}


readSeq_tria(fs,d0)
struct ALIGN *fs;
struct DATA0 *d0;
{
  int  i,j,num;

  for(num=0;num<Info.alignnum;num++){
    j=0;
    for(i=send_left;i<send_right+1;i++){
      if(Info.codeAlign[num][i]==26 || Info.codeAlign[num][i]==27) {}
      else {
	fs->Seq[num][j]=Info.codeAlign[num][i];
	fs->CSeq[num][j]=Info.codeAlign[num][i] + 'A';
	fs->Cons[num][j]=Calc_constraint[num][i];
	j++;
      }
    }
    fs->Leng[num] = j;
    fs->Num[num] = 1;
    fs->NumVec[num][0] = num;
  }  
  fs->SeqNum = num;

  if(left_flag == TRUE){
    for(i=0;i<fs->SeqNum;i++){
      fs->Seq[i][0]=14;
    }      
  }
  if(right_flag == TRUE){
    for(i=0;i<fs->SeqNum;i++){
      fs->Seq[i][fs->Leng[i]-1]=14;
    }      
  }

  d0->U = UU_n;
  d0->V = VV_n;
  d0->S = SS_n;
  fs->CutR = cut;
  fs->CutT = cut-10;
  if(fs->CutT < 0) fs->CutT = 0;

}
