/* ---------------------------------------------------------- 
%(C)1994,1995 Institute for New Generation Computer Technology 
%       (Read COPYRIGHT for detailed information.) 
----------------------------------------------------------- */
#include "aedit.h"

#define LENG_RF 1000
#define NUM_RF 100

struct sort1 {
  char Seq[NUM_RF][LENG_RF];
  char CSeq[NUM_RF][LENG_RF];
  
  int Leng[NUM_RF];
  int Num[NUM_RF];
  int NumVec[NUM_RF][NUM_RF];
  int SeqNum;
/*  int R1,R2; */
  int CMatrix[NUM_RF][NUM_RF];
  int U,V,S;
};

extern int UU_s;
extern int VV_s;
extern int SS_s;

sorter_now(sort_num)
int *sort_num;
{
  struct sort1 ps;
  int i,j,k;

  readSeq_now(&ps);

  makeEnergy_now(&ps);

  for(i=0;i<ps.SeqNum-1;i++){
    minimumCost_now(&ps);
  }
  
/*  writeSeq(&ps); */
  for(i=0;i<Info.alignnum;i++){
    sort_num[i] = ps.NumVec[0][i];
  }
}


minimumCost_now(fs)
struct sort1 *fs;
{
  int i,j,k,m,cost=100000000;
  int newcost,oldcost;
  int R1,R2;
  int NumX,NumY;

  for(j = 0;j < fs->SeqNum;j++){
    for(i = j+1;i < fs->SeqNum;i++){
      newcost = fs->CMatrix[i][j];
      if(newcost < cost){
	cost = newcost;
	R1 = j;
	R2 = i;
      }
    }
  }

  NumX = fs->Num[R2];
  NumY = fs->Num[R1];

  for(j = 0;j < R1;j++){
    oldcost = fs->CMatrix[R1][j];
    fs->CMatrix[R1][j] = ( fs->CMatrix[R2][j] + oldcost ) / 2;
  }
  for(i = R1 + 1;i < R2;i++){
    oldcost = fs->CMatrix[i][R1];
    fs->CMatrix[i][R1] = ( fs->CMatrix[R2][i] + oldcost ) / 2;
  }
  for(i = R2 + 1;i < fs->SeqNum;i++){
    oldcost = fs->CMatrix[i][R1];
    fs->CMatrix[i][R1] = ( fs->CMatrix[i][R2] + oldcost ) / 2;
  }

  for(i = 0;i < R2;i++){
    fs->CMatrix[R2][i] = 100000000;
  }

  for(i = R2 + 1;i < fs->SeqNum;i++){
    fs->CMatrix[i][R2] = 100000000;
  }

  fs->Num[R1] = NumX + NumY;
  fs->Num[R2] = 0;

  j = NumY;
  for(i=0;i<NumX;i++){
    fs->NumVec[R1][j] = fs->NumVec[R2][i];
    j++;
  }
}


readSeq_now(fs)
struct sort1 *fs;
{
  int  i,j,num;

  for(num=0;num<Info.alignnum;num++){
    j=0;
    for(i=Info.dataStartIndex;i<Info.dataEndIndex+1;i++){
      if(Info.codeAlign[num][i]==26) {
	fs->Seq[num][j]=100;
	fs->CSeq[num][j]='-';
      }
      else if(Info.codeAlign[num][i]==27) {
	fs->Seq[num][j]=100;
	fs->CSeq[num][j]='#';
      }
      else {
	fs->Seq[num][j]=Info.codeAlign[num][i];
	fs->CSeq[num][j]=Info.codeAlign[num][i] + 'A';
      }
      j++;
    }
    fs->Leng[num] = j;
    fs->Num[num] = 1;
    fs->NumVec[num][0] = num;
  }  
  fs->SeqNum = num;

  fs->U = UU_s;
  fs->V = VV_s;
  fs->S = SS_s;
}

/*
writeSeq_now(fs)
struct sort1 *fs;
{
  int  i,j,num,num1;

  for(num=0;num<Info.alignnum;num++){
    num1 = fs->NumVec[0][num];
    j=0;
    for(i=Info.dataStartIndex;i<Info.dataEndIndex;i++){
      if(fs->Seq[num1][j] == 100) Info.codeAlign[num][i]=26;
      else Info.codeAlign[num][i] = fs->Seq[num1][j];
      j++;
    }
  }  
}
*/


makeEnergy_now(fs)
struct sort1 *fs;
{
  int i,j,k,K;
  int energy;

  for(i = 0;i< fs->SeqNum;i++){
    j = 0;
    while(fs->CSeq[i][j] == '-'){
      fs->CSeq[i][j] = '#';
      j++;
    }
    j = fs->Leng[0]-1;
    while(fs->CSeq[i][j] == '-'){
      fs->CSeq[i][j] = '#';
      j--;
    }
  }

  for(i = 0;i < fs->SeqNum;i++){
    for(j = i+1;j < fs->SeqNum;j++){
      energy = 0;
      for(k = 0;k < fs->Leng[0];k++){
	if((fs->CSeq[i][k] == '-' || fs->CSeq[i][k] == '#') 
	   && (fs->CSeq[j][k] == '-' || fs->CSeq[j][k] == '#')) {}
	else if(fs->CSeq[i][k] == '#' || 
		fs->CSeq[j][k] == '#') energy += fs->S;
	else if(fs->CSeq[i][k] == '-'){
	  K = k;
	  for(;;){
	    K--;
	    if(fs->CSeq[i][K] != '-'){
	      energy += fs->U + fs->V;
	      break;
	    }
	    else if(fs->CSeq[j][K] != '-'){
	      energy += fs->V;
	      break;
	    }
	    else {}
	  }
	}
	else if(fs->CSeq[j][k] == '-'){
	  K = k;
	  for(;;){
	    K--;
	    if(fs->CSeq[j][K] != '-'){
	      energy += fs->U + fs->V;
	      break;
	    }
	    else if(fs->CSeq[i][K] != '-'){
	      energy += fs->V;
	      break;
	    }
	    else {}
	  }
	}
	else{
	  energy += Dmatrix[fs->Seq[i][k]][fs->Seq[j][k]];
	}
      }
      fs->CMatrix[j][i] = energy;
    }
  }
}
