/* ---------------------------------------------------------- 
%(C)1994,1995 Institute for New Generation Computer Technology 
%       (Read COPYRIGHT for detailed information.) 
----------------------------------------------------------- */
/*   key.c
**
**   Handles Keyboard events.
*/

#include  <X11/Xlib.h>
#include  <X11/Xutil.h>
#include  <X11/keysym.h>
#include  <X11/Intrinsic.h>
#include  "aedit.h"
Bool Shift_flag = False;

set_Shift_flag(da,event)
Widget  da;
XKeyEvent  *event;
{
   int     i, length;
   int     theKeyBufferMaxLen=64;
   char    theKeyBuffer[65];
   KeySym  theKeySym;
   XComposeStatus status;

   XLookupString(event, theKeyBuffer, theKeyBufferMaxLen, &theKeySym, &status );
   if (theKeySym == XK_Shift_L || theKeySym == XK_Shift_R) Shift_flag = True;
   /*fprintf(stderr, "set:%d\n", Shift_flag);*/
}     


reset_Shift_flag(da,event)
Widget  da;
XKeyEvent  *event;
{
   int     i, length;
   int     theKeyBufferMaxLen=64;
   char    theKeyBuffer[65];
   KeySym  theKeySym;
   XComposeStatus status;

   XLookupString(event, theKeyBuffer, theKeyBufferMaxLen, &theKeySym, &status );
   if (theKeySym == XK_Shift_L || theKeySym == XK_Shift_R) Shift_flag = False; 
   /*fprintf(stderr, "reset:%d\n", Shift_flag);*/
}     


/*
**   processKeyPress handles the keyboard inout for 
**   the example X programs.
*    return 1 if modified.
*/
/* Normal Text Mode */
processKeyPress1(da,event)
Widget  da;
XKeyEvent  *event;
{
   int     i, length;
   int     theKeyBufferMaxLen=64;
   char    theKeyBuffer[65];
   KeySym  theKeySym;
   XComposeStatus status;
   int     modify = False;
   int     shift, alt;
   int     dir;    /* insert direction LEFT or RIGHT */

   length = XLookupString(event,
                theKeyBuffer,
                theKeyBufferMaxLen,
                &theKeySym,
                &status );

   shift = False;   alt = False;
   dir=RIGHT;
   if(isKeyPressed(XK_Shift_L))  {dir=LEFT;   shift=True; }
   if(isKeyPressed(XK_Shift_R))  {dir=RIGHT;  shift=True; }
   if(isKeyPressed(XK_Alt_L) || isKeyPressed(XK_Alt_R))  alt=True;

/*   printf("shift=%d,dir=%s\n",shift, dir==RIGHT?"right":"left"); */

   if(event->state & ControlMask )  {  /* Control Key */
      switch(theKeySym) {
      case XK_D: case XK_d:     /* Delete */
         modify = delActivChar1(dir);      break;
      case XK_A: case XK_a:     /* cursor left edge */
         activLeftEdge();     break;
      case XK_E: case XK_e:     /* cursor right edge */
         activRightEdge();    break;
      case XK_F: case XK_f:     
         shiftRightActiv(1);  break;
      case XK_B: case XK_b:     
         shiftLeftActiv(1);   break;
      case XK_N: case XK_n:     
         shiftDownActiv();    break;
      case XK_P: case XK_p:     
         shiftUpActiv();      break;
      case XK_L: case XK_l:     
         adjustPage();        break;
      case XK_less:
         activFirst();        break;
      case XK_greater:
         activLast();         break;
      }
   }
   else if( length > 0   &&  
            ((theKeyBuffer[0] == ' '  ||  theKeyBuffer[0] == '-' ) ||
             (theKeyBuffer[0] >= 'A'  &&  theKeyBuffer[0] <= 'z' ))) {
/*      printf("ASCII key was hit: [%s]\n",theKeyBuffer); */

      if(!isupper(theKeyBuffer[0]) && !islower(theKeyBuffer[0])  &&
         theKeyBuffer[0] != '-'  &&  theKeyBuffer[0] != ' ' )
         return modify;

      if(EditMode==INSERT) {
         /* insert gap at ActiveIndex */
         modify = insertChar(dir,theKeyBuffer[0]);
      }
      else if(EditMode == OVER_WRITE) {
          if(isupper(theKeyBuffer[0])) {
             Info.codeAlign[ActiveAlign][ActiveIndex] = theKeyBuffer[0]-'A';
          }
          else if(islower(theKeyBuffer[0])) {
             Info.codeAlign[ActiveAlign][ActiveIndex] = theKeyBuffer[0]-'a';
          }
          else if(theKeyBuffer[0]=='-'  || theKeyBuffer[0] == ' ' ) {
             Info.codeAlign[ActiveAlign][ActiveIndex] = GAP_INNER_CODE;
          }
          disp_align_one(ActiveAlign,ActiveIndex,PerLine-ActiveCol+1);
          shiftRightActiv(1);    /* move active point(cursor) forward */
          modify=1;     /* return 1 when modified */
      }
      else {
         return modify;
      }
   }
   else {
      switch(theKeySym) {
      case XK_Home:   
         activFirst();        break;
      case XK_Prior:   
         scrollColumnLeft(PerLine-3);  break;
      case XK_Next:   
         scrollColumnRight(PerLine-3); break;
      case XK_Delete:   
/*         modify = delActivChar1(dir);      break; */
      case XK_BackSpace:
         if(alt) {
             removeAllGap();   modify=True;
         }
         else {
             modify = delBeforeChar1(dir);
         }
         break;
      case XK_Tab:       
         jumpBlockActiv(dir);  break;
      case XK_Up:       
      case XK_KP_8:       
         shiftUpActiv();       break;
      case XK_Down:       
      case XK_KP_2:       
         shiftDownActiv();     break;
      case XK_Right:      
      case XK_KP_6:       
         if(alt  &&  EditMode != VIEW)  {
             modify = skipBlockRight();  
         }
         else
             shiftRightActiv(1);    
         break;
      case XK_Left:       
      case XK_KP_4:       
         if(alt  &&  EditMode != VIEW) {
            modify = skipBlockLeft(); 
            modify=1;
         }
         else
            shiftLeftActiv(1);     
         break;
      }
   }
   return modify;
}




/*  Alignment Editor Mode.
 *  We are also called when VIEW mode.
 */
processKeyPress2(da,event)
Widget  da;
XKeyEvent  *event;
{
   int     i, length;
   int     theKeyBufferMaxLen=64;
   char    theKeyBuffer[65];
   KeySym  theKeySym;
   XComposeStatus status;
   int     modify = False;
   int     shift;  /* XK_Shift_L or XK_Shift_R is pressed ? */
   int     dir;    /* insert direction LEFT or RIGHT */
   int     alt;    /* Alt key is pressed ? */

   if (EditMode == CONSTRAINT) return modify;

   length = XLookupString(event,
                theKeyBuffer,
                theKeyBufferMaxLen,
                &theKeySym,
                &status );
   shift = False;   alt = False;
   dir=RIGHT;
   if(isKeyPressed(XK_Shift_L))  {dir=LEFT;   shift=True; }
   if(isKeyPressed(XK_Shift_R))  {dir=RIGHT;  shift=True; }
   if(isKeyPressed(XK_Alt_L) || isKeyPressed(XK_Alt_R))  alt=True;

/*   printf("shift=%d,dir=%s\n",shift, dir==RIGHT?"right":"left"); */

   if(event->state & ControlMask )  {  /* Control Key */
      switch(theKeySym) {
      case XK_D: case XK_d:     /* Delete */
         if(EditMode==VIEW)   return modify;
         modify = delActivChar2(dir);      break;
      case XK_A: case XK_a:     /* cursor left edge */
         activLeftEdge();     break;
      case XK_E: case XK_e:     /* cursor right edge */
         activRightEdge();    break;
      case XK_F: case XK_f:     
         shiftRightActiv(1);  break;
      case XK_B: case XK_b:     
         shiftLeftActiv(1);   break;
      case XK_N: case XK_n:     
         shiftDownActiv();    break;
      case XK_P: case XK_p:     
         shiftUpActiv();      break;
      case XK_L: case XK_l:     
         adjustPage();        break;
      case XK_less:
         activFirst();        break;
      case XK_greater:
         activLast();         break;
      }
   }
   else if( length > 0   &&  
            (theKeyBuffer[0] == ' '  ||  theKeyBuffer[0] == '-' )) {
      if(EditMode==VIEW)   return modify;
/*      printf("ASCII key was hit: [%s]\n",theKeyBuffer);  */

      /* insert gap at ActiveIndex */
      modify = insertChar(dir,GAP_INNER_CODE);
   }
   else {
      switch(theKeySym) {
      case XK_Home:   
         activFirst();        break;
      case XK_Prior:   
         scrollColumnLeft(PerLine-3);  break;
      case XK_Next:   
         scrollColumnRight(PerLine-3); break;
      case XK_Delete:    
/***
         if(EditMode==VIEW)   return modify;
         modify = delActivChar2(dir);   break;
***/
      case XK_BackSpace:
         if(EditMode==VIEW)   return modify;

         if(alt) {
             removeAllGap();   modify=True;
         }
         else {
             modify = delBeforeChar2(dir);
         }
         break;
      case XK_Tab:       
         jumpBlockActiv(dir);  break;
      case XK_Up:             
      case XK_KP_8:       
         shiftUpActiv();       break;
      case XK_Down:       
      case XK_KP_2:       
         shiftDownActiv();     break;
      case XK_Right:      
      case XK_KP_6:       
         if(alt  &&  EditMode != VIEW)  {
             modify = skipBlockRight();  
         }
         else
             shiftRightActiv(1);    
         break;
      case XK_Left:       
      case XK_KP_4:       
         if(alt  &&  EditMode != VIEW) {
            modify = skipBlockLeft(); 
         }
         else
            shiftLeftActiv(1);     
         break;
      }
   }
   return modify;
}


isKeyPressed(sym)
KeySym  sym;
{
  static char key_vec[32];
  KeyCode  code;
  int  keybit;
  unsigned int  byteindex, bitindex;

  code = XKeysymToKeycode(TheDisplay,sym);
  if(code==NoSymbol)  return 0;

  byteindex = code/8;
  bitindex = code & 7;
  XQueryKeymap(TheDisplay,key_vec);
  return (1 & (key_vec[byteindex]>>bitindex));
}

