/* ---------------------------------------------------------- 
%(C)1994,1995 Institute for New Generation Computer Technology 
%       (Read COPYRIGHT for detailed information.) 
----------------------------------------------------------- */
/* font_menu.c 
 * treat edit mode menu items commands.
 */

#include <stdio.h>
#include <X11/IntrinsicP.h>
#include <X11/Shell.h>
#include <X11/cursorfont.h>
#include <Xm/PushB.h>
#include <Xm/PushBG.h>
#include <Xm/DialogS.h>
#include <Xm/BulletinB.h>
#include <Xm/List.h>

#include "aedit.h"
#include "menu.h"


#define MAX_FONTS  200
#define ENGLISH    0
#define JAPANESE   1

static char FontName[400], SelectedFontName[400];
extern Widget menu_top;


/***
Widget GetTopShell(w)
Widget w;
{
  while(w && !XtIsShell(w))   w=XtParent(w);
  return w;
}
***/

/* called when ok button is pushed */
static void okCB(w,dialog,call_data)
Widget   w, dialog;
caddr_t  call_data;
{
  int  i;
  XFontStruct *fs;
	extern void	set_font_aal();

  if(strcmp(FontName,SelectedFontName) != 0 ) {
      /* alloc new font */
      fs = XLoadQueryFont(TheDisplay,SelectedFontName);
      if(fs) {
         XFreeFont(TheDisplay,FontStruct);
         FontStruct = fs;
         strcpy(FontName,SelectedFontName);
         XSetFont(TheDisplay,TextGC,FontStruct->fid);
         XSetFont(TheDisplay,FixedColumnGC,FontStruct->fid);
         XSetFont(TheDisplay,WhiteGC,FontStruct->fid);
         XSetFont(TheDisplay,BlackGC,FontStruct->fid);
      }
      else 
         fprintf(stderr,"font %s load error\n",SelectedFontName);
       
      /* change font */
      for(i=0; i<MAXCODE; ++i)  {
          XSetFont(TheDisplay,AminoCharGC[i],FontStruct->fid);
      }
      fontParams();
      ActiveCol =  ActiveIndex - Info.dispStartIndex;
      ActiveXo = LeftMargin + ActiveCol*BoxW;
      ActiveYo = TopMargin + (ActiveAlign+2)*BoxH; 

/* (begin) */
#ifdef	TEMPORARY_SCROLL
	set_da_height();
#endif
/* (end) */

      disp_name();  /* display alignment name */
      fprintf(stderr, "font_menu\n");
      disp(TRUE);   /* display alignment, column#,identical column */
  }

	set_font_aal();
}


static void cancelCB(w,dialog,call_data)
Widget   w, dialog;
caddr_t  call_data;
{
   XtPopdown(dialog);
}


/* called when list item selected */
static void listCB(w,client_data,call_data)
Widget   w;
caddr_t  client_data;
XmListCallbackStruct *call_data;
{
  char *value;
  if(XmStringGetLtoR(call_data->item, XmSTRING_DEFAULT_CHARSET,
                     &value))
     fprintf(stderr, "font %s is selected\n",value);
  strcpy(SelectedFontName,value);
  XtFree(value);
}


/* called when "ok" button of dialog is pushed */

/* load font name and insert the list of w(selection dialog) */
static setFontList(list,flag)
Widget  list;
int     flag; 
{
   XmString items[MAX_FONTS];
   char **fontlist;
   XFontStruct  *fs;
   int  i, nfonts, count;
   XmString xms;
   Cursor cs;

   fprintf(stderr, "here1");
   /* define cursor */
/***
   cs = XCreateFontCursor(TheDisplay,XC_watch);
   XDefineCursor(TheDisplay,TheRoot,cs);
***/
   fontlist = XListFontsWithInfo(TheDisplay,"*",MAX_FONTS,&nfonts,&fs);
   if(fontlist==NULL)   {
       XtVaSetValues(list,
       XmNitems,NULL,
       XmNitemCount,0,
       NULL);
       return;
   }
   fprintf(stderr, "here2");
   count = 0;
   for(i=0; i<nfonts; ++i) {
      if (*fontlist[i] == '-')
	 continue;
      items[count++] = XmStringCreateLtoR(fontlist[i],
                              XmSTRING_DEFAULT_CHARSET);
   }

   fprintf(stderr, "nfonts=%d,flag=%d,count=%d\n",nfonts,flag,count);

   XtVaSetValues(list,
       XmNitems,items,
       XmNitemCount,count,
       XmNvisibleItemCount,8,
       NULL);

   fprintf(stderr, "here3");
   XFreeFontInfo(fontlist,fs,nfonts);
   for(i=0; i<count; ++i)  XmStringFree(items[i]); 
/***
   XUndefineCursor(TheDisplay,TheRoot);
**/
   fprintf(stderr, "here4");
}



/* called when font menu of menubar is selected */
void english_cb(w,client_data,cbs)
Widget   w;
int     client_data;  /* not used */
XmAnyCallbackStruct *cbs;
{
  int i,x,y,dummy;
  static Widget dialog=NULL;
  Widget bb,list,ok,cancel;
  extern Widget  menu_top;
  Arg    args[2];
  XButtonEvent *ev;

  ev = (XButtonEvent *)cbs->event;
  if(!dialog) {
     XtSetArg(args[0],XmNallowShellResize,True);
     dialog = XtCreatePopupShell("font_dialog",overrideShellWidgetClass,
                                 menu_top,args,1);

     bb=XmCreateBulletinBoard(dialog,"font_bb",NULL,0);  XtManageChild(bb);
     list=XmCreateScrolledList(bb,"font_list",NULL,0);  XtManageChild(list);
     XtVaSetValues(list,XmNselectionPolicy,XmSINGLE_SELECT,NULL);
     setFontList(list,ENGLISH);
     XtAddCallback(list,XmNbrowseSelectionCallback,listCB,NULL);
     XtAddCallback(list,XmNsingleSelectionCallback,listCB,NULL);

     ok=XmCreatePushButton(bb,"font_ok",NULL,0);  XtManageChild(ok);
     XtAddCallback(ok,XmNactivateCallback,okCB,dialog);
     cancel=XmCreatePushButton(bb,"font_cancel",NULL,0); XtManageChild(cancel);
     XtAddCallback(cancel,XmNactivateCallback,cancelCB,dialog);
  }
  XtVaSetValues(dialog,XmNx,ev->x_root,XmNy,ev->y_root,NULL);
  XtManageChild(dialog);
  XtPopup(dialog,XtGrabNone);
}



/* called when font menu of menubar is selected */
static void japanese_cb(w,client_data,cbs)
Widget   w;
int     client_data;  /* not used */
XmAnyCallbackStruct *cbs;
{
  int i,x,y,dummy;
  static Widget dialog=NULL;
  Widget bb,list,ok,cancel;
  extern Widget  menu_top;
  Arg    args[2];
  XButtonEvent *ev;

  ev = (XButtonEvent *)cbs->event;
  if(!dialog) {
     XtSetArg(args[0],XmNallowShellResize,True);
     dialog = XtCreatePopupShell("font_dialog",overrideShellWidgetClass,
                                 menu_top,args,1);

     bb=XmCreateBulletinBoard(dialog,"font_bb",NULL,0);  XtManageChild(bb);
     list=XmCreateScrolledList(bb,"font_list",NULL,0);  XtManageChild(list);
     XtVaSetValues(list,XmNselectionPolicy,XmSINGLE_SELECT,NULL);
     setFontList(list,JAPANESE);
     XtAddCallback(list,XmNbrowseSelectionCallback,listCB,NULL);
     XtAddCallback(list,XmNsingleSelectionCallback,listCB,NULL);

     ok=XmCreatePushButton(bb,"font_ok",NULL,0);  XtManageChild(ok);
     XtAddCallback(ok,XmNactivateCallback,okCB,dialog);
     cancel=XmCreatePushButton(bb,"font_cancel",NULL,0); XtManageChild(cancel);
     XtAddCallback(cancel,XmNactivateCallback,cancelCB,dialog);
  }
  XtVaSetValues(dialog,XmNx,ev->x_root,XmNy,ev->y_root,NULL);
  XtManageChild(dialog);
  XtPopup(dialog,XtGrabNone);

}

MENUITEM font_menu[] = {
   { "English(8byte)", &xmPushButtonGadgetClass, 'E', NULL, NULL,
      english_cb, (caddr_t)NULL, NULL, True},
/*
   { "Japanese(16byte)", &xmPushButtonGadgetClass, 'J', NULL, NULL,
      japanese_cb, (caddr_t)NULL, NULL, True},
*/
   {NULL}
};


